/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.emf.facet.infra.query.ui.actions;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.common.ui.internal.util.WorkbenchUtils;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.editor.presentation.QueryEditor;
import org.eclipse.emf.facet.infra.query.ui.wizards.CreateQueryWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/**
 * @deprecated use the new eFacet2 metamodel in org.eclipse.emf.facet.efacet2.metamodel
 *             and the new APIs in org.eclipse.emf.facet.efacet.ui
 */
@Deprecated
public class CreateQueryAction implements IActionDelegate {

	private ISelection fSelection;

	public CreateQueryAction() {
		// nothing
	}

	public void run(final IAction action) {
		if (this.fSelection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) this.fSelection;
			Object selected = structuredSelection.getFirstElement();
			ModelQuerySet modelQuerySet = null;
			EClass eClass = null;
			if (selected instanceof ModelQuerySet) {
				modelQuerySet = (ModelQuerySet) selected;
			} else if (selected instanceof EClass) {
				eClass = (EClass) selected;
			} else if (selected instanceof EObject) {
				EObject eObject = (EObject) selected;
				eClass = eObject.eClass();
			}

			Resource resourceToEdit = null;
			EditingDomain editingDomain = null;
			// if using the action on an open query set editor, edit the
			// editor's resource instead of modifying the underlying file
			if (modelQuerySet != null) {
				IWorkbenchPart activePart = WorkbenchUtils.getActivePart();
				if (activePart instanceof QueryEditor) {
					QueryEditor queryEditor = (QueryEditor) activePart;
					ResourceSet resourceSet = queryEditor.getEditingDomain().getResourceSet();
					if (resourceSet.getResources().contains(modelQuerySet.eResource())) {
						resourceToEdit = modelQuerySet.eResource();
						editingDomain = queryEditor.getEditingDomain();
					}
				}
			}

			CreateQueryWizard createQueryWizard = new CreateQueryWizard(modelQuerySet, eClass,
					resourceToEdit, editingDomain);
			WizardDialog wizardDialog = new WizardDialog(null, createQueryWizard);
			wizardDialog.open();
		}
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
		this.fSelection = selection;
	}
}
