/*******************************************************************************
 * Copyright (c) 2010, 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *    Nicolas Bros (Mia-Software) - Bug 332437 - NatTable : pluggable cell editors
 *    Nicolas Guyomar (Mia-Software) - Bug 331442 - To be able to add and remove lines (model elements) from the table
 *    Nicolas Bros (Mia-Software) - Bug 331520 - view query result in NatTable
 *    Nicolas Bros (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Bros (Mia-Software) - Bug 332438 - NatTable : table type
 *    Nicolas Bros (Mia-Software) - Bug 331675 - NatTable : copy cells as text 
 *    Nicolas Bros (Mia-Software) - Bug 331900 - customizable NatTable
 *    Nicolas Bros (Mia-Software) - Bug 332010 - view Facet customizations on NatTable
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Nicolas Guyomar (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333414 - The user must be able to save the column order
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation 
 *    Nicolas Guyomar (Mia-Software) - Bug 340738 - Utility method to create a coherent tableInstance
 *    Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.view;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.INatTableUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.IWorkbenchPartProvider;
import org.eclipse.emf.facet.widgets.nattable.NatTableWidgetUtils;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Activator;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class NatTableView extends ViewPart implements IEditingDomainProvider,
		IWorkbenchPartProvider, ISelectionProvider {

	/** The ID of the view as specified by the extension */
	public static final String ID = "org.eclipse.emf.facet.widgets.nattable.workbench.view.NatTableView"; //$NON-NLS-1$

	private INatTableWidget natTableWidget;
	private EditingDomain editingDomain;
	private Composite partControlParent;
	private MenuManager menuMgr;
	private static int secondaryID = 0;

	public NatTableView() {
	}

	public static void openOn(final List<EObject> elements, final EditingDomain editingDomain,
			final String description, final TableConfiguration tableConfiguration,
			final EObject context, final Object parameter)
			throws UnsatisfiedConfigurationConstraint {
		TableInstance tableInstance = NatTableWidgetUtils.createTableInstance(elements,
				description, tableConfiguration, context, parameter);
		openOn(tableInstance, editingDomain);
	}

	public static void openOnQueryResult(final List<ModelQueryResult> result,
			final EditingDomain editingDomain, final TableConfiguration tableConfiguration,
			final EObject context, final Object parameter)
			throws UnsatisfiedConfigurationConstraint {
		QueryTableInstance queryTableInstance = NatTableWidgetUtils.createQueryTableInstance(
				result, tableConfiguration, context, parameter);
		openOn(queryTableInstance, editingDomain);
	}

	private static void openOn(final TableInstance tableInstance, final EditingDomain editingDomain)
			throws UnsatisfiedConfigurationConstraint {

		if (!INatTableUtils.INSTANCE.checkInput(tableInstance)) {
			throw new UnsatisfiedConfigurationConstraint();
		}

		final IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getActivePage();
		try {
			IViewPart viewPart = activePage.showView(NatTableView.ID, "" //$NON-NLS-1$
					+ (NatTableView.secondaryID++), IWorkbenchPage.VIEW_ACTIVATE);
			if (viewPart instanceof NatTableView) {
				NatTableView natTableView = (NatTableView) viewPart;
				natTableView.setEditingDomain(editingDomain);
				natTableView.setInput(tableInstance);
			}
		} catch (PartInitException e) {
			Logger.logError(e, Activator.getDefault());
		}

	}

	private void setInput(final TableInstance tableInstanceValue) {
		Collection<ISelectionChangedListener> initialListeners = null;
		if (this.natTableWidget != null) {
			initialListeners = this.natTableWidget.getSelectionChangedListeners();
			this.natTableWidget.getComposite().dispose();
		}
		this.natTableWidget = INatTableWidgetFactory.INSTANCE.createNatTableWidget(
				this.partControlParent, this, tableInstanceValue, this.menuMgr);
		if (initialListeners != null) {
			for (ISelectionChangedListener listener : initialListeners) {
				this.natTableWidget.addSelectionChangedListener(listener);
			}
		}
		if (tableInstanceValue != null) {
			if (!INatTableUtils.INSTANCE.checkInput(tableInstanceValue)) {
				throw new IllegalArgumentException("Input not accepted by tableConfiguration"); //$NON-NLS-1$
			}
		}
		this.partControlParent.layout();
	}

	@Override
	public void createPartControl(final Composite parent) {
		this.partControlParent = parent;
		this.menuMgr = new MenuManager("#PopUp", NatTableView.ID); //$NON-NLS-1$
		this.menuMgr.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		this.menuMgr.setRemoveAllWhenShown(true);

		setInput(null);
		getSite().registerContextMenu(this.menuMgr, this.natTableWidget);
		parent.setLayout(new FillLayout());
		getSite().setSelectionProvider(this.natTableWidget);
		parent.layout();
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	@Override
	public void setFocus() {
		if (this.natTableWidget != null && !this.natTableWidget.getComposite().isDisposed()) {
			this.natTableWidget.getComposite().setFocus();
		}
	}

	@SuppressWarnings("rawtypes")
	// We cannot change the method signature because of the override
	@Override
	public Object getAdapter(final Class adapter) {
		if (adapter == INatTableWidgetProvider.class) {
			return new INatTableWidgetProvider() {
				public INatTableWidget getNatTableWidget() {
					return NatTableView.this.natTableWidget;
				}
			};
		}
		return null;
	}

	/**
	 * Return the editing table contained in the tableInput
	 */
	public EditingDomain getEditingDomain() {
		return this.editingDomain;
	}

	protected void setEditingDomain(final EditingDomain editingDomainValue) {
		this.editingDomain = editingDomainValue;
	}

	public IWorkbenchPart getPart() {
		return this;
	}

	public void addSelectionChangedListener(final ISelectionChangedListener listener) {
		this.natTableWidget.addSelectionChangedListener(listener);
	}

	public ISelection getSelection() {
		return this.natTableWidget.getSelection();
	}

	public void removeSelectionChangedListener(final ISelectionChangedListener listener) {
		this.natTableWidget.removeSelectionChangedListener(listener);
	}

	public void setSelection(final ISelection selection) {
		this.natTableWidget.setSelection(selection);
	}
}