/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.layer;

import java.util.Collection;
import java.util.Properties;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.data.IDataProvider;
import net.sourceforge.nattable.edit.command.UpdateDataCommandHandler;
import net.sourceforge.nattable.layer.AbstractLayer;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;
import net.sourceforge.nattable.layer.LayerUtil;
import net.sourceforge.nattable.layer.SizeConfig;
import net.sourceforge.nattable.layer.event.StructuralRefreshEvent;
import net.sourceforge.nattable.resize.command.ColumnResizeCommandHandler;
import net.sourceforge.nattable.resize.command.MultiColumnResizeCommandHandler;
import net.sourceforge.nattable.resize.command.MultiRowResizeCommandHandler;
import net.sourceforge.nattable.resize.command.RowResizeCommandHandler;
import net.sourceforge.nattable.resize.event.ColumnResizeEvent;
import net.sourceforge.nattable.resize.event.RowResizeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataLayer
extends AbstractLayer
implements IUniqueIndexLayer {
    public static final String PERSISTENCE_KEY_ROW_HEIGHT = ".rowHeight";
    public static final String PERSISTENCE_KEY_COLUMN_WIDTH = ".columnWidth";
    public static final int DEFAULT_COLUMN_WIDTH = 100;
    public static final int DEFAULT_ROW_HEIGHT = 20;
    protected IDataProvider dataProvider;
    private final SizeConfig columnWidthConfig;
    private final SizeConfig rowHeightConfig;

    public DataLayer(IDataProvider dataProvider) {
        this(dataProvider, 100, 20);
    }

    public DataLayer(IDataProvider dataProvider, int defaultColumnWidth, int defaultRowHeight) {
        this.dataProvider = dataProvider;
        this.columnWidthConfig = new SizeConfig(defaultColumnWidth);
        this.rowHeightConfig = new SizeConfig(defaultRowHeight);
        this.registerCommandHandlers();
    }

    protected DataLayer() {
        this(100, 20);
    }

    protected DataLayer(int defaultColumnWidth, int defaultRowHeight) {
        this.columnWidthConfig = new SizeConfig(defaultColumnWidth);
        this.rowHeightConfig = new SizeConfig(defaultRowHeight);
        this.registerCommandHandlers();
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        this.columnWidthConfig.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.saveState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_HEIGHT, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.columnWidthConfig.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_WIDTH, properties);
        this.rowHeightConfig.loadState(String.valueOf(prefix) + PERSISTENCE_KEY_ROW_HEIGHT, properties);
        this.fireLayerEvent(new StructuralRefreshEvent(this));
    }

    private void registerCommandHandlers() {
        this.registerCommandHandler(new ColumnResizeCommandHandler(this));
        this.registerCommandHandler(new MultiColumnResizeCommandHandler(this));
        this.registerCommandHandler(new RowResizeCommandHandler(this));
        this.registerCommandHandler(new MultiRowResizeCommandHandler(this));
        this.registerCommandHandler(new UpdateDataCommandHandler(this));
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected void setDataProvider(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public int getColumnCount() {
        return this.dataProvider.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.getColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition >= 0 && columnPosition < this.getColumnCount()) {
            return columnPosition;
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            return columnIndex;
        }
        return -1;
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return localColumnPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        return underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        return underlyingColumnPositionRanges;
    }

    @Override
    public int getWidth() {
        return this.columnWidthConfig.getAggregateSize(this.getColumnCount());
    }

    @Override
    public int getPreferredWidth() {
        return this.getWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.columnWidthConfig.getSize(columnPosition);
    }

    public void setColumnWidthByPosition(int columnPosition, int width) {
        this.columnWidthConfig.setSize(columnPosition, width);
        this.fireLayerEvent(new ColumnResizeEvent((ILayer)this, columnPosition));
    }

    public void setDefaultColumnWidth(int width) {
        this.columnWidthConfig.setDefaultSize(width);
    }

    public void setDefaultColumnWidthByPosition(int columnPosition, int width) {
        this.columnWidthConfig.setDefaultSize(columnPosition, width);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.columnWidthConfig.isPositionResizable(columnPosition);
    }

    public void setColumnPositionResizable(int columnPosition, boolean resizable) {
        this.columnWidthConfig.setPositionResizable(columnPosition, resizable);
    }

    public void setColumnsResizableByDefault(boolean resizableByDefault) {
        this.columnWidthConfig.setResizableByDefault(resizableByDefault);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        return null;
    }

    @Override
    public int getRowCount() {
        return this.dataProvider.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition >= 0 && rowPosition < this.getRowCount()) {
            return rowPosition;
        }
        return -1;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return rowIndex;
        }
        return -1;
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return localRowPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        return underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        return underlyingRowPositionRanges;
    }

    @Override
    public int getHeight() {
        return this.rowHeightConfig.getAggregateSize(this.getRowCount());
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.rowHeightConfig.getSize(rowPosition);
    }

    public void setRowHeightByPosition(int rowPosition, int height) {
        this.rowHeightConfig.setSize(rowPosition, height);
        this.fireLayerEvent(new RowResizeEvent((ILayer)this, rowPosition));
    }

    public void setDefaultRowHeight(int height) {
        this.rowHeightConfig.setDefaultSize(height);
    }

    public void setDefaultRowHeightByPosition(int rowPosition, int height) {
        this.rowHeightConfig.setDefaultSize(rowPosition, height);
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.rowHeightConfig.isPositionResizable(rowPosition);
    }

    public void setRowPositionResizable(int rowPosition, boolean resizable) {
        this.rowHeightConfig.setPositionResizable(rowPosition, resizable);
    }

    public void setRowsResizableByDefault(boolean resizableByDefault) {
        this.rowHeightConfig.setResizableByDefault(resizableByDefault);
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        return null;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        int columnIndex = this.getColumnIndexByPosition(columnPosition);
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        return this.dataProvider.getDataValue(columnIndex, rowIndex);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.columnWidthConfig.getAggregateSize(columnPosition);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.rowHeightConfig.getAggregateSize(rowPosition);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return null;
    }
}

