/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.selection.MoveSelectionCommandHandler;
import net.sourceforge.nattable.selection.SelectionLayer;
import net.sourceforge.nattable.selection.command.MoveSelectionCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveCellSelectionCommandHandler
extends MoveSelectionCommandHandler<MoveSelectionCommand> {
    protected int newSelectedColumnPosition;
    protected int newSelectedRowPosition;
    protected PositionCoordinate lastSelectedCell;

    public MoveCellSelectionCommandHandler(SelectionLayer selectionLayer) {
        super(selectionLayer);
    }

    @Override
    protected void moveLastSelectedLeft(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasColumnSelection()) {
            this.lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int newSelectedRowPosition = this.lastSelectedCell.rowPosition;
            int n = this.newSelectedColumnPosition = stepSize >= 0 ? this.lastSelectedCell.columnPosition - stepSize : 0;
            if (this.newSelectedColumnPosition < 0) {
                this.newSelectedColumnPosition = 0;
            }
            if (stepSize == -1 && !withShiftMask) {
                this.selectionLayer.clear();
            }
            this.selectionLayer.selectCell(this.newSelectedColumnPosition, newSelectedRowPosition, withShiftMask, withControlMask);
            this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, false, withShiftMask, withControlMask);
        }
    }

    @Override
    protected void moveLastSelectedRight(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasColumnSelection()) {
            this.lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int newSelectedRowPosition = this.lastSelectedCell.rowPosition;
            int n = this.newSelectedColumnPosition = stepSize >= 0 ? this.lastSelectedCell.columnPosition + stepSize : this.selectionLayer.getColumnCount() - 1;
            if (this.newSelectedColumnPosition >= this.selectionLayer.getColumnCount()) {
                this.newSelectedColumnPosition = this.selectionLayer.getColumnCount() - 1;
            }
            if (stepSize == -1 && !withShiftMask) {
                this.selectionLayer.clear();
            }
            this.selectionLayer.selectCell(this.newSelectedColumnPosition, newSelectedRowPosition, withShiftMask, withControlMask);
            this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, false, withShiftMask, withControlMask);
        }
    }

    @Override
    protected void moveLastSelectedUp(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            this.lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int n = this.newSelectedRowPosition = stepSize >= 0 ? this.lastSelectedCell.rowPosition - stepSize : 0;
            if (this.newSelectedRowPosition < 0) {
                this.newSelectedRowPosition = 0;
            }
            this.selectionLayer.selectCell(this.lastSelectedCell.columnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
            this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, false, withShiftMask, withControlMask);
        }
    }

    @Override
    protected void moveLastSelectedDown(int stepSize, boolean withShiftMask, boolean withControlMask) {
        if (this.selectionLayer.hasRowSelection()) {
            this.lastSelectedCell = this.selectionLayer.getCellPositionToMoveFrom(withShiftMask, withControlMask);
            int n = this.newSelectedRowPosition = stepSize >= 0 ? this.lastSelectedCell.rowPosition + stepSize : this.selectionLayer.getRowCount() - 1;
            if (this.newSelectedRowPosition >= this.selectionLayer.getRowCount()) {
                this.newSelectedRowPosition = this.selectionLayer.getRowCount() - 1;
            }
            this.selectionLayer.selectCell(this.lastSelectedCell.columnPosition, this.newSelectedRowPosition, withShiftMask, withControlMask);
            this.selectionLayer.fireCellSelectionEvent(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, false, withShiftMask, withControlMask);
        }
    }

    @Override
    public Class<MoveSelectionCommand> getCommandClass() {
        return MoveSelectionCommand.class;
    }
}

