/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.tests.swtbot.internal.exported;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.tests.swtbot.internal.Activator;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.ScreenShotUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.AbstractMatcher;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.DefaultCondition;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarDropDownButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarPushButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarRadioButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarSeparatorButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarToggleButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SWTBotUtils {
    private static boolean enableDebugScreenshots = true;
    private static final String SCREENSHOT_DIR = "SWTBotScreenShots/";
    private static final String SCREENSHOT_FORMAT = ".png";
    private static final boolean DUMP_ENABLED = true;
    private static final int DUMP_INTERVAL = 30000;
    private static boolean dumpStarted = false;

    private SWTBotUtils() {
    }

    public static SWTBotToolbarButton getToolbarButton(String tooltipPrefix, int index, SWTWorkbenchBot pBot) {
        Matcher widgetOfTypeToolItem = WidgetMatcherFactory.widgetOfType(ToolItem.class);
        PrefixTextMatcher prefixTextMatcher = new PrefixTextMatcher(tooltipPrefix);
        Matcher matcher = WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{widgetOfTypeToolItem, prefixTextMatcher});
        ToolItem item = (ToolItem)pBot.widget(matcher, index);
        if (SWTUtils.hasStyle((Widget)item, (int)8)) {
            return new SWTBotToolbarPushButton(item, (SelfDescribing)matcher);
        }
        if (SWTUtils.hasStyle((Widget)item, (int)32)) {
            return new SWTBotToolbarToggleButton(item, (SelfDescribing)matcher);
        }
        if (SWTUtils.hasStyle((Widget)item, (int)16)) {
            return new SWTBotToolbarRadioButton(item, (SelfDescribing)matcher);
        }
        if (SWTUtils.hasStyle((Widget)item, (int)4)) {
            return new SWTBotToolbarDropDownButton(item, (SelfDescribing)matcher);
        }
        if (SWTUtils.hasStyle((Widget)item, (int)2)) {
            return new SWTBotToolbarSeparatorButton(item, (SelfDescribing)matcher);
        }
        throw new RuntimeException("toolbar button not found: " + tooltipPrefix);
    }

    public static void captureScreenShot(String imageName) {
        ScreenShotUtils.capture(imageName, 1);
    }

    public static void waitUntilNotEmpty(final SWTBotTree tree, int timeout) {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        bot.waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return tree.getAllItems().length > 0;
            }

            public String getFailureMessage() {
                return "Tree still empty after timeout";
            }
        }, (long)timeout);
    }

    public static void waitUntilAssertListSize(final int expected, final List<?> list) {
        new SWTWorkbenchBot().waitUntil((ICondition)new DefaultCondition(){

            public boolean test() throws Exception {
                return expected == list.size();
            }

            public String getFailureMessage() {
                return "List size assertion failed: expected " + expected + " elements; got " + list.size();
            }
        });
    }

    public static void executeCommand(final String commandID) {
        final IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    handlerService.executeCommand(commandID, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void closeWelcomeAndEditorsAndShells() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        for (SWTBotView view : bot.views()) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
        }
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewReferences;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = viewReferences = activePage.getViewReferences();
                int n = viewReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    activePage.hideView(viewReference);
                    ++n2;
                }
            }
        });
        SWTBotShell[] sWTBotShellArray = bot.shells();
        int n = sWTBotShellArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotShell sbShell = sWTBotShellArray[n2];
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n3 = iWorkbenchWindowArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n4];
                if (window.getShell() != sbShell.widget) {
                    sbShell.close();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void deleteAllProjects() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.close((IProgressMonitor)new NullProgressMonitor());
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            while (project.exists()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Logger.logWarning((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            ++n2;
        }
    }

    public static synchronized void startDebugDumpingIfEnabled() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            System.err.println("no dump on Windows");
            return;
        }
        if (dumpStarted) {
            return;
        }
        dumpStarted = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    int dumpCount = 0;
                    while (true) {
                        String filename = "stackdump_" + String.format("%03d", dumpCount) + ".txt";
                        ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", "-c", "jstack $PPID 1> " + filename + " 2> " + filename);
                        processBuilder.redirectErrorStream(true);
                        System.out.println("TAKING STACKDUMP: " + filename);
                        processBuilder.start();
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++dumpCount;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        thread.start();
        System.err.println("starting stackdump every 30000 ms");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrefixTextMatcher<T>
    extends AbstractMatcher<T> {
        private final String prefix;

        public PrefixTextMatcher(String prefix) {
            this.prefix = prefix;
        }

        public void describeTo(Description description) {
            description.appendText("with a label that starts with(" + this.prefix + ")");
        }

        protected boolean doMatch(Object item) {
            try {
                return SWTUtils.invokeMethod((Object)item, (String)"getToolTipText").toString().startsWith(this.prefix);
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

