/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Table Instance2</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2#getLocalCustomizations
 * <em>Local Customizations</em>}</li>
 * <li>
 * {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2#getFacets2
 * <em>Facets2</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package#getTableInstance2()
 * @model
 * @generated
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface TableInstance2 extends TableInstance {
	/**
	 * Returns the value of the '<em><b>Local Customizations</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.infra.browser.custom.MetamodelView}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Local Customizations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Local Customizations</em>' containment reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package#getTableInstance2_LocalCustomizations()
	 * @model containment="true" required="true"
	 * @generated
	 */
	EList<MetamodelView> getLocalCustomizations();

	/**
	 * Returns the value of the '<em><b>Facets2</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.emf.facet.infra.facet.Facet}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Facets2</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Facets2</em>' reference list.
	 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package#getTableInstance2_Facets2()
	 * @model
	 * @generated
	 */
	EList<Facet> getFacets2();

} // TableInstance2
