/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *   Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *   Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;

import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ImagePainter;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.widgets.internal.ImageProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget.BodyLayerStack;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

/**
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class HeaderImagePainter extends ImagePainter {

	private final BodyLayerStack bodyLayer;
	private final List<Column> columns;
	private final LabelProvider labelProvider;

	public HeaderImagePainter(final BodyLayerStack bodyLayer,
			final List<Column> columns, final LabelProvider labelProvider) {
		super(null, false);
		this.bodyLayer = bodyLayer;
		this.columns = columns;
		this.labelProvider = labelProvider;
	}

	@Override
	protected Image getImage(final LayerCell cell, final IConfigRegistry configRegistry) {
		ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext(
				new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()),
				this.bodyLayer.getBodyDataLayer());

		if (converted != null && converted.columnPosition >= 0
				&& converted.columnPosition < this.columns.size()) {
			return getColumnImage(this.columns.get(converted.columnPosition));
		}
		return null;
	}

	private Image getColumnImage(final Column column) {
		if (column instanceof AttributeColumn) {
			return ImageProvider.getInstance().getAttributeIcon();
		} else if (column instanceof ReferenceColumn) {
			ReferenceColumn referenceColumn = (ReferenceColumn) column;
			final EReference reference = referenceColumn.getReference();
			return this.labelProvider.getImage(reference);
		} else if (column instanceof QueryColumn) {
			return ImageProvider.getInstance().getQueryIcon();
		} else if (column instanceof FacetAttributeColumn) {
			return ImageProvider.getInstance().getFacetAttributeIcon();
		} else if (column instanceof FacetReferenceColumn) {
			return ImageProvider.getInstance().getFacetLinkIcon();
		} else {
			return null;
		}
	}
}
