/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Book;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Library;
import org.eclipse.emf.facet.efacet.examples.library.metamodel.library.Writer;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.serialization.ExtendedEObjectReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public abstract class AbstractFacetActionTests {
    protected static final String MY_LIBRARY = "my.library";
    protected static final String MY_FACETSET = "my.efacet2";
    protected static final String MY_SERIALIZATION = "my.serialization";
    protected static final Integer REVISION_1 = new Integer(1);
    private static final Integer REVISION_2 = new Integer(2);
    private ResourceSet resourceSet;
    private Resource libraryResource;
    private Resource facetSetResource;
    protected Resource serializationResource;
    protected Library library;
    private FacetSet facetSet;
    private EReference favoriteAuthorReference;
    private EAttribute revisionNumberAttribute;
    private Object writer2;
    private Writer writer1;
    private EAttribute timestampAttribute;
    protected EAttribute facet1Attribute;
    protected EAttribute facet2Attribute;
    protected Facet versionFacet;
    protected Facet facet1;
    protected Facet facet2;
    protected Facet facetNoConformanceTypedElement;

    @Before
    public void initResource() throws IOException {
        this.resourceSet = new ResourceSetImpl();
        this.libraryResource = this.resourceSet.getResource(this.getLibraryUri(), true);
        this.facetSetResource = this.resourceSet.getResource(this.getFacetSetUri(), true);
        this.serializationResource = this.resourceSet.createResource(this.getSerialisationModelUri());
        this.library = (Library)this.libraryResource.getContents().get(0);
        this.facetSet = (FacetSet)this.facetSetResource.getContents().get(0);
        this.versionFacet = FacetUtils.getFacet((FacetSet)this.facetSet, (String)"versionFacet");
        this.facet1 = FacetUtils.getFacet((FacetSet)this.facetSet, (String)"facet1");
        this.facet2 = FacetUtils.getFacet((FacetSet)this.facetSet, (String)"facet2");
        this.facetNoConformanceTypedElement = FacetUtils.getFacet((FacetSet)this.facetSet, (String)"facetNoConformanceTypedElement");
        this.revisionNumberAttribute = (EAttribute)FacetUtils.getETypedElement((Facet)this.versionFacet, (String)"revisionNumber", EAttribute.class);
        this.favoriteAuthorReference = (EReference)FacetUtils.getETypedElement((Facet)this.versionFacet, (String)"favoriteAuthor", EReference.class);
        this.timestampAttribute = (EAttribute)FacetUtils.getETypedElement((Facet)this.versionFacet, (String)"timestamp", EAttribute.class);
        this.facet1Attribute = (EAttribute)FacetUtils.getETypedElement((Facet)this.facet1, (String)"facet1Attribute", EAttribute.class);
        this.facet2Attribute = (EAttribute)FacetUtils.getETypedElement((Facet)this.facet2, (String)"facet2Attribute", EAttribute.class);
        this.writer1 = (Writer)this.library.getWriters().get(1);
        this.writer2 = this.library.getWriters().get(0);
    }

    protected abstract URI getSerialisationModelUri();

    protected abstract URI getFacetSetUri();

    protected abstract URI getLibraryUri();

    protected void assertReferenceInstanceListSize(int nbReferenceInstances, int nbAttributeInstances) {
        Assert.assertEquals((long)1L, (long)this.serializationResource.getContents().size());
        ExtendedEObjectReference extendedEObjectReference = (ExtendedEObjectReference)this.serializationResource.getContents().get(0);
        Assert.assertEquals((long)nbReferenceInstances, (long)extendedEObjectReference.getReferenceInstances().size());
        Assert.assertEquals((long)nbAttributeInstances, (long)extendedEObjectReference.getAttributeInstances().size());
    }

    public void addReferenceAndAttribute() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.revisionNumberAttribute, (Object)REVISION_1, null);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.favoriteAuthorReference, this.writer2, null);
        facetManager.saveStructuralFeatureInstanceModel();
        this.assertReferenceInstanceListSize(1, 1);
    }

    public void addReference() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.favoriteAuthorReference, this.writer2, null);
        facetManager.saveStructuralFeatureInstanceModel();
        this.assertReferenceInstanceListSize(1, 0);
    }

    public void addAttribute() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.revisionNumberAttribute, (Object)REVISION_1, null);
        facetManager.saveStructuralFeatureInstanceModel();
        this.assertReferenceInstanceListSize(0, 1);
    }

    @Test
    public void testSetGetExistingEAttribute() throws Exception {
        this.addReferenceAndAttribute();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        Assert.assertEquals((Object)REVISION_1, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.revisionNumberAttribute, Integer.class));
        facetManager.set((EObject)this.library, (EStructuralFeature)this.revisionNumberAttribute, (Object)REVISION_2, null);
        Assert.assertEquals((Object)REVISION_2, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.revisionNumberAttribute, Integer.class));
        this.assertReferenceInstanceListSize(1, 1);
    }

    @Test
    public void testSetGetExistingEReference() throws Exception {
        this.addReferenceAndAttribute();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        Assert.assertEquals((Object)this.writer2, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.favoriteAuthorReference, this.writer2.getClass()));
        facetManager.set((EObject)this.library, (EStructuralFeature)this.favoriteAuthorReference, (Object)this.writer1, null);
        Assert.assertEquals((Object)this.writer1, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.favoriteAuthorReference, this.writer1.getClass()));
        this.assertReferenceInstanceListSize(1, 1);
    }

    @Test
    public void testSetGetNonExistingEReferenceAndAlreadyExtendedEObject() throws Exception {
        this.addAttribute();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        Assert.assertEquals((long)1L, (long)this.serializationResource.getContents().size());
        Book book1 = (Book)this.library.getBooks().get(0);
        facetManager.set((EObject)this.library, (EStructuralFeature)((Facet)FacetUtils.getFacets((FacetSet)this.facetSet).get(0)).getFacetElements().get(2), (Object)book1, null);
        Assert.assertEquals((Object)book1, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)((Facet)FacetUtils.getFacets((FacetSet)this.facetSet).get(0)).getFacetElements().get(2), book1.getClass()));
        this.assertReferenceInstanceListSize(1, 1);
    }

    @Test
    public void testSetGetNonExistingEAttributeAndNonAlreadyExtendedEObject() throws Exception {
        Assert.assertEquals((long)0L, (long)this.serializationResource.getContents().size());
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.revisionNumberAttribute, (Object)new Integer(4), null);
        Assert.assertEquals((Object)new Integer(4), (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.revisionNumberAttribute, Integer.class));
        this.assertReferenceInstanceListSize(0, 1);
    }

    @Test
    public void testSetGetNonExistingEReferenceAndNonAlreadyExtendedEObject() throws Exception {
        Assert.assertEquals((long)0L, (long)this.serializationResource.getContents().size());
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.favoriteAuthorReference, this.writer2, null);
        Assert.assertEquals((Object)this.writer2, (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.favoriteAuthorReference, this.writer2.getClass()));
        this.assertReferenceInstanceListSize(1, 0);
    }

    @Test
    public void testSetGetNonExistingEAttributeAndAlreadyExtendedEObject() throws Exception {
        this.addReference();
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library, (EStructuralFeature)this.timestampAttribute, (Object)"I am a timestamp", null);
        Assert.assertEquals((Object)"I am a timestamp", (Object)facetManager.getOrInvoke((EObject)this.library, (ETypedElement)this.timestampAttribute, String.class));
        this.assertReferenceInstanceListSize(1, 1);
    }

    @Test(expected=FacetManagerException.class)
    public void testSetNonApplicableFacet() throws Exception {
        IFacetManager facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.serializationResource);
        facetManager.set((EObject)this.library.getBooks().get(0), (EStructuralFeature)this.timestampAttribute, (Object)"I am a timestamp", null);
    }

    @Ignore
    @Test
    public void testSetGetFacetAttribute() {
        throw new UnsupportedOperationException("test not yet implemented");
    }

    @Ignore
    @Test
    public void testSetGetFacetReference() {
        throw new UnsupportedOperationException("test not yet implemented");
    }

    @Ignore
    @Test
    public void testSetGetFacetOperation() {
        throw new UnsupportedOperationException("test not yet implemented");
    }
}

