/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot;

import java.io.IOException;
import java.util.List;
import net.sourceforge.nattable.NatTable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1;
import org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot.SWTBotNatTable;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotList;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditabilityTest {
    private static final String RESOURCES_TEST_UI_RESOURCES = "/resources/v0_1/testUiResources/";
    private static final int TIMEOUT = 30000;
    private static final int PREF_TIMEOUT = 5000;
    private static final int PREF_TYPE_INTERVAL = 10;
    private SWTWorkbenchBot bot;
    private static final String PROJECT_NAME = "tableTestProject";
    private static final String ECORE_TABLE_FILE_NAME = "_test_tableEcoreTest.table";
    private static final String SAMPLEMM_TABLE_FILE_NAME = "_test_sampleMM.table";
    private static final String ECORE_FILE_NAME = "_test_EcoreModel.ecore";
    private static final String SAMPLEMM_FILE_NAME = "_test_samplemm.samplemm";

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        this.bot = new SWTWorkbenchBot();
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/testUiResources/_test_tableEcoreTest.table", (IProject)testProject, (String)"/_test_tableEcoreTest.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/testUiResources/_test_sampleMM.table", (IProject)testProject, (String)"/_test_sampleMM.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/testUiResources/_test_EcoreModel.ecore", (IProject)testProject, (String)"/_test_EcoreModel.ecore", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/v0_1/testUiResources/_test_samplemm.samplemm", (IProject)testProject, (String)"/_test_samplemm.samplemm", (Bundle)bundle);
    }

    @Test(timeout=30000L)
    @Ignore
    public void testSingleLineStringEditability() {
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = this.bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 5);
        TableEditabilityTest.assertClassNameEquals(editor, "Class1");
        final SWTBotText cellEditor = this.bot.text("Class1");
        cellEditor.typeText("NewClassName");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Text)cellEditor.widget).notifyListeners(1, e);
            }
        });
        TableEditabilityTest.assertClassNameEquals(editor, "NewClassName");
        editor.saveAndClose();
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor2 = this.bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor2.setFocus();
        Assert.assertTrue((boolean)editor2.isActive());
        TableEditabilityTest.assertClassNameEquals(editor2, "NewClassName");
        editor2.close();
    }

    @Test(timeout=30000L)
    public void testMultiLineStringEditability() {
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = this.bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        TableEditabilityTest.assertClassNameEquals(editor, "Class1");
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 5);
        this.bot.button("...").click();
        Assert.assertTrue((boolean)this.bot.text().getText().equals("Class1"));
        this.bot.button("Cancel").click();
        TableEditabilityTest.assertClassNameEquals(editor, "Class1");
        this.getNatTable().doubleClick(1, 5);
        this.bot.button("...").click();
        this.bot.text().setText("");
        this.bot.text().typeText("This is a dummy piece of string\nThis is the second line");
        this.bot.button("OK").click();
        editor.save();
        String newline = System.getProperty("line.separator");
        TableEditabilityTest.assertClassNameEquals(editor, "This is a dummy piece of string" + newline + "This is the second line");
        editor.close();
    }

    @Test(timeout=30000L)
    @Ignore
    public void testUnaryContainmentEditability() {
        this.openTableFile(SAMPLEMM_TABLE_FILE_NAME);
        final SWTBotEditor editor = this.bot.editorByTitle(SAMPLEMM_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 4);
        final INatTableWidget2 iNatTableWidget2a = TableEditabilityTest.getINatTableWidget2(editor);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Class1 class1 = (Class1)((Row)iNatTableWidget2a.getTableInstance().getRows().get(0)).getElement();
                Assert.assertNotNull((Object)class1);
                Assert.assertNull((Object)class1.getUnaryContainmentReference());
                Event e = new Event();
                e.keyCode = 27;
                e.stateMask = 0;
                ((Combo)TableEditabilityTest.this.getSwtWorkbenchBot().comboBox().widget).notifyListeners(1, e);
                Assert.assertNull((Object)class1.getUnaryContainmentReference());
            }
        });
        this.getNatTable().doubleClick(1, 4);
        this.bot.comboBox().setSelection(0);
        final INatTableWidget2 iNatTableWidget2b = TableEditabilityTest.getINatTableWidget2(editor);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Class1 class1 = (Class1)((Row)iNatTableWidget2b.getTableInstance().getRows().get(0)).getElement();
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Combo)TableEditabilityTest.this.getSwtWorkbenchBot().comboBox().widget).notifyListeners(1, e);
                Class2 reference = class1.getUnaryContainmentReference();
                Assert.assertNotNull((Object)reference);
                Assert.assertEquals((Object)"first", (Object)reference.getName());
            }
        });
        editor.save();
        TableEditabilityTest.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 4);
        this.bot.button("...").click();
        SWTBotUtils.captureScreenShot((String)"CellEditorOpenedWithBrowseButton");
        this.bot.text().typeText("*Class33");
        this.bot.button("OK").click();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Class2 reference = class1.getUnaryContainmentReference();
                Assert.assertNotNull((Object)reference);
                Assert.assertEquals((Object)"Class33", (Object)reference.getName());
            }
        });
        editor.saveAndClose();
    }

    @Test(timeout=30000L)
    public void testNAryContainmentReferenceEditability() {
        this.openTableFile(SAMPLEMM_TABLE_FILE_NAME);
        final SWTBotEditor editor = this.bot.editorByTitle(SAMPLEMM_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"first", (Object)((Class2)class1.getNaryContainmentReference().get(0)).getName());
                Assert.assertEquals((Object)"Class31", (Object)((Class2)class1.getNaryContainmentReference().get(1)).getName());
                Assert.assertEquals((Object)"Class32", (Object)((Class2)class1.getNaryContainmentReference().get(2)).getName());
                Assert.assertEquals((Object)"Class33", (Object)((Class2)class1.getNaryContainmentReference().get(3)).getName());
            }
        });
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 3);
        SWTBotUtils.captureScreenShot((String)"cellEditorOpened");
        SWTBotTree tree = this.bot.tree();
        SWTBotList list = this.bot.list();
        Assert.assertEquals((long)2L, (long)tree.rowCount());
        Assert.assertEquals((long)4L, (long)list.itemCount());
        tree.select(new int[]{0});
        this.bot.button(">").click();
        Assert.assertEquals((long)1L, (long)tree.rowCount());
        Assert.assertEquals((long)5L, (long)list.itemCount());
        list.select(4);
        this.bot.button("<").click();
        Assert.assertEquals((long)2L, (long)tree.rowCount());
        Assert.assertEquals((long)4L, (long)list.itemCount());
        this.bot.button(">>").click();
        Assert.assertEquals((long)0L, (long)tree.rowCount());
        Assert.assertEquals((long)6L, (long)list.itemCount());
        this.bot.button("<<").click();
        Assert.assertEquals((long)6L, (long)tree.rowCount());
        Assert.assertEquals((long)0L, (long)list.itemCount());
        this.bot.button("Cancel").click();
        TableEditabilityTest.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 3);
        tree = this.bot.tree();
        list = this.bot.list();
        Assert.assertEquals((long)2L, (long)tree.rowCount());
        Assert.assertEquals((long)4L, (long)list.itemCount());
        Assert.assertEquals((Object)"Class2 first", (Object)list.getItems()[0]);
        list.select(0);
        this.bot.button("Down").click();
        this.bot.button("Down").click();
        Assert.assertEquals((Object)"Class2 first", (Object)list.getItems()[2]);
        this.bot.button("Up").click();
        Assert.assertEquals((Object)"Class2 first", (Object)list.getItems()[1]);
        this.bot.button("OK").click();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"Class31", (Object)((Class2)class1.getNaryContainmentReference().get(0)).getName());
                Assert.assertEquals((Object)"first", (Object)((Class2)class1.getNaryContainmentReference().get(1)).getName());
                Assert.assertEquals((Object)"Class32", (Object)((Class2)class1.getNaryContainmentReference().get(2)).getName());
                Assert.assertEquals((Object)"Class33", (Object)((Class2)class1.getNaryContainmentReference().get(3)).getName());
            }
        });
        TableEditabilityTest.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 3);
        tree = this.bot.tree();
        list = this.bot.list();
        Assert.assertEquals((long)2L, (long)tree.rowCount());
        Assert.assertEquals((long)4L, (long)list.itemCount());
        tree.getTreeItem("Class2 second").doubleClick();
        Assert.assertEquals((long)1L, (long)tree.rowCount());
        Assert.assertEquals((long)5L, (long)list.itemCount());
        this.bot.button("OK").click();
        Assert.assertTrue((boolean)editor.isDirty());
        editor.save();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"Class31", (Object)((Class2)class1.getNaryContainmentReference().get(0)).getName());
                Assert.assertEquals((Object)"first", (Object)((Class2)class1.getNaryContainmentReference().get(1)).getName());
                Assert.assertEquals((Object)"Class32", (Object)((Class2)class1.getNaryContainmentReference().get(2)).getName());
                Assert.assertEquals((Object)"Class33", (Object)((Class2)class1.getNaryContainmentReference().get(3)).getName());
                Assert.assertEquals((Object)"second", (Object)((Class2)class1.getNaryContainmentReference().get(4)).getName());
            }
        });
        editor.close();
    }

    @Test(timeout=30000L)
    public void testNAryReferenceEditability() {
        this.openTableFile(SAMPLEMM_TABLE_FILE_NAME);
        final SWTBotEditor editor = this.bot.editorByTitle(SAMPLEMM_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"second", (Object)((Class2)class1.getNaryReference().get(0)).getName());
                Assert.assertEquals((Object)"third", (Object)((Class2)class1.getNaryReference().get(1)).getName());
            }
        });
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 5);
        SWTBotUtils.captureScreenShot((String)"cellEditorOpenedWithTreeAndList");
        SWTBotTree tree = this.bot.tree();
        SWTBotList list = this.bot.list();
        Assert.assertEquals((long)4L, (long)tree.rowCount());
        Assert.assertEquals((long)2L, (long)list.itemCount());
        tree.select(new int[]{0});
        this.bot.button(">").click();
        Assert.assertEquals((long)3L, (long)tree.rowCount());
        Assert.assertEquals((long)3L, (long)list.itemCount());
        list.select(2);
        this.bot.button("<").click();
        Assert.assertEquals((long)4L, (long)tree.rowCount());
        Assert.assertEquals((long)2L, (long)list.itemCount());
        this.bot.button(">>").click();
        Assert.assertEquals((long)0L, (long)tree.rowCount());
        Assert.assertEquals((long)6L, (long)list.itemCount());
        this.bot.button("<<").click();
        Assert.assertEquals((long)6L, (long)tree.rowCount());
        Assert.assertEquals((long)0L, (long)list.itemCount());
        this.bot.button("Cancel").click();
        this.getNatTable().doubleClick(1, 5);
        tree = this.bot.tree();
        list = this.bot.list();
        Assert.assertEquals((long)4L, (long)tree.rowCount());
        Assert.assertEquals((long)2L, (long)list.itemCount());
        Assert.assertEquals((Object)"Class2 second", (Object)list.getItems()[0]);
        list.select(0);
        this.bot.button("Down").click();
        Assert.assertEquals((Object)"Class2 second", (Object)list.getItems()[1]);
        this.bot.button("OK").click();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"third", (Object)((Class2)class1.getNaryReference().get(0)).getName());
                Assert.assertEquals((Object)"second", (Object)((Class2)class1.getNaryReference().get(1)).getName());
            }
        });
        TableEditabilityTest.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 5);
        tree = this.bot.tree();
        list = this.bot.list();
        Assert.assertEquals((long)4L, (long)tree.rowCount());
        Assert.assertEquals((long)2L, (long)list.itemCount());
        tree.getTreeItem("Class3 Class32").doubleClick();
        Assert.assertEquals((long)3L, (long)tree.rowCount());
        Assert.assertEquals((long)3L, (long)list.itemCount());
        this.bot.button("OK").click();
        Assert.assertTrue((boolean)editor.isDirty());
        editor.save();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)"third", (Object)((Class2)class1.getNaryReference().get(0)).getName());
                Assert.assertEquals((Object)"second", (Object)((Class2)class1.getNaryReference().get(1)).getName());
                Assert.assertEquals((Object)"Class32", (Object)((Class2)class1.getNaryReference().get(2)).getName());
            }
        });
        editor.close();
    }

    @Test(timeout=30000L)
    public void testEIntAttrEditability() throws Exception {
        this.openTableFile(SAMPLEMM_TABLE_FILE_NAME);
        final SWTBotEditor editor = this.bot.editorByTitle(SAMPLEMM_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 2);
        final SWTBotText textEditor1 = this.bot.text("6");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 27;
                e.stateMask = 0;
                ((Text)textEditor1.widget).notifyListeners(1, e);
            }
        });
        this.getNatTable().doubleClick(1, 2);
        SWTBotUtils.captureScreenShot((String)"EditingValue6inTextField");
        final SWTBotText textEditor = this.bot.text("6");
        textEditor.typeText("666");
        SWTBotUtils.captureScreenShot((String)"typed \"666\"");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Text)textEditor.widget).notifyListeners(1, e);
            }
        });
        Assert.assertTrue((boolean)editor.isDirty());
        SWTBotUtils.captureScreenShot((String)"NewValueIs \"666\"");
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertTrue((class1.getEIntAttr() == 666 ? 1 : 0) != 0);
            }
        });
        editor.saveAndClose();
    }

    @Test(timeout=30000L)
    public void testEIntMultiAttrEditability() {
        this.openTableFile(SAMPLEMM_TABLE_FILE_NAME);
        final SWTBotEditor editor = this.bot.editorByTitle(SAMPLEMM_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertTrue((boolean)class1.getEIntMultiAttr().isEmpty());
            }
        });
        SWTBotUtils.captureScreenShot((String)"opened");
        this.getNatTable().doubleClick(1, 1);
        this.bot.button("Add").click();
        final SWTBotText textEditor = this.bot.text();
        textEditor.setText("12");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Text)textEditor.widget).notifyListeners(1, e);
            }
        });
        this.bot.button("OK").click();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertFalse((boolean)class1.getEIntMultiAttr().isEmpty());
                Assert.assertTrue((12 == (Integer)class1.getEIntMultiAttr().get(0) ? 1 : 0) != 0);
            }
        });
        TableEditabilityTest.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 1);
        this.bot.button("Add").click();
        final SWTBotText textEditor2 = this.bot.text();
        textEditor2.setText("33");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                ((Text)textEditor2.widget).notifyListeners(1, e);
            }
        });
        this.bot.button("OK").click();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertFalse((boolean)class1.getEIntMultiAttr().isEmpty());
                Assert.assertTrue((33 == (Integer)class1.getEIntMultiAttr().get(0) ? 1 : 0) != 0);
                Assert.assertTrue((12 == (Integer)class1.getEIntMultiAttr().get(1) ? 1 : 0) != 0);
            }
        });
        TableEditabilityTest.waitForResfreshJob(editor);
        this.getNatTable().doubleClick(1, 1);
        SWTBotTable table = this.bot.table();
        table.select(new int[]{0});
        this.bot.button("Delete").click();
        table.select(new int[]{0});
        this.bot.button("Delete").click();
        Assert.assertEquals((long)0L, (long)table.rowCount());
        int i = 0;
        while (i < 10) {
            this.bot.button("Add").click();
            final SWTBotText textEditor3 = this.bot.text();
            int newValue3 = i++;
            textEditor3.setText("" + newValue3);
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    Event e = new Event();
                    e.keyCode = 13;
                    e.stateMask = 0;
                    ((Text)textEditor3.widget).notifyListeners(1, e);
                }
            });
        }
        Assert.assertEquals((long)10L, (long)this.bot.table().rowCount());
        SWTBotTableItem item5 = table.getTableItem(5);
        Assert.assertEquals((Object)"4", (Object)item5.getText());
        table.select(new int[]{5});
        this.bot.button("Up").click();
        this.bot.button("Up").click();
        this.bot.button("Up").click();
        SWTBotTableItem item2 = table.getTableItem(2);
        Assert.assertEquals((Object)"4", (Object)item2.getText());
        table.select(new int[]{0});
        this.bot.button("Down").click();
        this.bot.button("Down").click();
        Assert.assertEquals((Object)"9", (Object)table.getTableItem(2).getText());
        Assert.assertEquals((Object)"4", (Object)table.getTableItem(1).getText());
        this.bot.button("OK").click();
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidget2 iNatTableWidget2 = TableEditabilityTest.getINatTableWidget2(editor);
                Class1 class1 = (Class1)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertFalse((boolean)class1.getEIntMultiAttr().isEmpty());
                Assert.assertTrue((8 == (Integer)class1.getEIntMultiAttr().get(0) ? 1 : 0) != 0);
                Assert.assertTrue((4 == (Integer)class1.getEIntMultiAttr().get(1) ? 1 : 0) != 0);
                Assert.assertTrue((9 == (Integer)class1.getEIntMultiAttr().get(2) ? 1 : 0) != 0);
            }
        });
        editor.saveAndClose();
    }

    @Test(timeout=30000L)
    public void testNonEditabilityOfNACells() {
        this.openTableFile(ECORE_TABLE_FILE_NAME);
        SWTBotEditor editor = this.bot.editorByTitle(ECORE_TABLE_FILE_NAME);
        editor.setFocus();
        Assert.assertTrue((boolean)editor.isActive());
        editor.bot().menu("Window").menu("Navigation").menu("Maximize Active View or Editor").click();
        SWTBotUtils.captureScreenShot((String)"1 After table editor openning");
        this.getNatTable().doubleClick(4, 5);
        SWTBotUtils.captureScreenShot((String)"2 A first cell editor should be active");
        SWTBotText cellEditor = this.bot.text("MyPackage");
        Assert.assertNotNull((Object)cellEditor);
        TableEditabilityTest.pressEscapeTo(cellEditor);
        SWTBotUtils.captureScreenShot((String)"3 The cell editor should be closed.");
        this.getNatTable().doubleClick(1, 6);
        SWTBotText text = this.bot.text();
        SWTBotUtils.captureScreenShot((String)"4 A second cell editor should be active.");
        Assert.assertNotNull((Object)text);
        TableEditabilityTest.pressEscapeTo(text);
        SWTBotUtils.captureScreenShot((String)"5 The second cell editor should be closed.");
        this.getNatTable().doubleClick(4, 6);
        List controls = new ChildrenControlFinder((Widget)this.bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Text.class));
        SWTBotUtils.captureScreenShot((String)"5 No cell editor should be active.");
        Assert.assertEquals((long)0L, (long)controls.size());
    }

    private static void pressEscapeTo(final AbstractSWTBot<?> swtbotText) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 27;
                e.stateMask = 0;
                swtbotText.widget.notifyListeners(1, e);
            }
        });
    }

    static INatTableWidget2 getINatTableWidget2(SWTBotEditor editor) {
        INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
        INatTableWidget2 iNatTableWidget2 = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
        return iNatTableWidget2;
    }

    private void openTableFile(String fileName) {
        SWTBotUtils.captureScreenShot((String)"1");
        this.bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = this.bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)this.bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        item.doubleClick();
    }

    private static void assertClassNameEquals(final SWTBotEditor editor, final String expectedName) {
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
                INatTableWidget2 iNatTableWidget2 = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
                EClass class1 = (EClass)((Row)iNatTableWidget2.getTableInstance().getRows().get(0)).getElement();
                Assert.assertEquals((Object)expectedName, (Object)class1.getName());
            }
        });
    }

    protected SWTWorkbenchBot getSwtWorkbenchBot() {
        return this.bot;
    }

    private SWTBotNatTable getNatTable() {
        NatTable nt = (NatTable)this.bot.widget(WidgetMatcherFactory.widgetOfType(NatTable.class));
        return new SWTBotNatTable(nt);
    }

    private static void waitForResfreshJob(final SWTBotEditor editor) {
        TableEditabilityTest.notSyncExec(new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((IEditorReference)editor.getReference()).getPart(true).getAdapter(INatTableWidgetProvider.class);
                INatTableWidgetInternal iNatTableWidgetInternal = (INatTableWidgetInternal)natTableWidgetPart.getNatTableWidget();
                iNatTableWidgetInternal.waitForResfreshJob();
            }
        });
    }

    public static void notSyncExec(VoidResult toExecute) {
        toExecute.run();
    }
}

