/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.custompt.IColor;
import org.eclipse.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custompt.Alignment;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custompt.Shadow;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.Messages;
import org.eclipse.emf.facet.custom.ui.internal.PropertiesHandler;
import org.eclipse.emf.facet.custom.ui.internal.custompt.ImageWrapper;
import org.eclipse.emf.facet.custom.ui.internal.custompt.URIImage;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedLabelProvider
extends CellLabelProvider
implements ICustomizedLabelProvider {
    private static final int RGB_MAX = 255;
    private static final RGB DEFAULT_BCKGND = new RGB(255, 255, 255);
    private static final RGB DEFAULT_FOREGND = new RGB(0, 0, 0);
    private Map<RGB, Color> colorCache = new HashMap<RGB, Color>();
    private Map<FontData, Font> fontCache = new HashMap<FontData, Font>();
    private final Map<String, Image> uriImageCache = new HashMap<String, Image>();
    private final ICustomizationManager customManager;
    private final PropertiesHandler propertiesHandler;
    private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    @Deprecated
    public CustomizedLabelProvider(ResourceSet resourceSet) {
        this.customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(resourceSet);
        this.propertiesHandler = new PropertiesHandler(resourceSet);
    }

    public CustomizedLabelProvider(ICustomizationManager customManager) {
        this.customManager = customManager;
        this.propertiesHandler = new PropertiesHandler(customManager);
    }

    private <T> T getPropertyValue(Object element, FacetOperation property, ETypedElement eTypedElement, Class<T> classs) {
        Object result = null;
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            try {
                result = eTypedElement == null ? this.customManager.getCustomValueOf(eObject, property, classs) : this.customManager.getCustomValueOf(eObject, eTypedElement, property, classs);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (String)("Failed to get the value of '" + property.getName() + "' for " + element), (Plugin)Activator.getDefault());
            }
        }
        return (T)result;
    }

    public String getText(Object element) {
        String result;
        if (element instanceof EObject) {
            result = this.getPropertyValue(element, this.propertiesHandler.getLabelProperty(), null, String.class);
        } else if (element == null) {
            result = Messages.CustomizedLabelProvider_null;
        } else if (element instanceof List) {
            StringBuffer strBuffer = new StringBuffer();
            List list = (List)element;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Object current = iter.next();
                strBuffer.append(this.getText(current));
                if (!iter.hasNext()) continue;
                strBuffer.append(", ");
            }
            result = strBuffer.toString();
        } else {
            result = element.toString();
        }
        return result;
    }

    @Override
    public String getText(Object object, ETypedElement eTypedElement) {
        String result;
        if (object == null) {
            result = Messages.CustomizedLabelProvider_null;
        } else if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            try {
                result = (String)this.customManager.getCustomValueOf(eObject, eTypedElement, this.propertiesHandler.getLabelProperty(), String.class);
            }
            catch (CustomizationException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                result = "!!! Error, cf log !!!";
            }
        } else {
            result = object.toString();
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
        for (Color color : this.colorCache.values()) {
            color.dispose();
        }
        for (Font font : this.fontCache.values()) {
            font.dispose();
        }
        for (Image image : this.uriImageCache.values()) {
            image.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    private Color getColor(RGB rgb) {
        Color color = this.colorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getDefault(), rgb);
            this.colorCache.put(rgb, color);
        }
        return color;
    }

    public Color getForeground(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getForegroundProperty(), null, IColor.class);
        Color result = color == null ? this.getColor(DEFAULT_FOREGND) : this.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        return result;
    }

    public Color getBackground(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getBackgroundProperty(), null, IColor.class);
        Color result = color == null ? this.getColor(DEFAULT_BCKGND) : this.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        return result;
    }

    private Font getFont(FontData fontData) {
        Font font = this.fontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)Display.getDefault(), fontData);
            this.fontCache.put(fontData, font);
        }
        return font;
    }

    public Font getFont(Object element) {
        Boolean isItalic;
        Boolean isBold;
        Integer fontSize;
        String fontName = this.getPropertyValue(element, this.propertiesHandler.getFontNameProperty(), null, String.class);
        if (fontName == null) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            fontName = fontData[0].getName();
        }
        if ((fontSize = this.getPropertyValue(element, this.propertiesHandler.getFontSizeProperty(), null, Integer.class)) == null) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            fontSize = fontData[0].getHeight();
        }
        if ((isBold = this.getPropertyValue(element, this.propertiesHandler.getIsBoldProperty(), null, Boolean.class)) == null) {
            isBold = Boolean.FALSE;
        }
        if ((isItalic = this.getPropertyValue(element, this.propertiesHandler.getIsItalicProperty(), null, Boolean.class)) == null) {
            isItalic = Boolean.FALSE;
        }
        int fontStyle = 0;
        if (isBold.booleanValue()) {
            fontStyle |= 1;
        }
        if (isItalic.booleanValue()) {
            fontStyle |= 2;
        }
        FontData fontData = new FontData(fontName, fontSize.intValue(), fontStyle);
        return this.getFont(fontData);
    }

    public Image getImage(Object element) {
        IImage image = this.getPropertyValue(element, this.propertiesHandler.getImageProperty(), null, ImageWrapper.class);
        Image result = null;
        Display device = PlatformUI.getWorkbench().getDisplay();
        if (image instanceof ImageWrapper) {
            ImageWrapper wrapper = (ImageWrapper)image;
            result = wrapper.getImage();
        } else if (image instanceof URIImage) {
            URIImage uriImage = (URIImage)image;
            String uriStr = uriImage.getUri();
            if (this.uriImageCache.keySet().contains(uriStr)) {
                result = this.uriImageCache.get(uriStr);
            } else {
                ImageDescriptor imgDecriptor;
                URI baseURI;
                String resourcePath;
                URI uri = URI.createURI((String)uriStr);
                String bundleId = uri.segment(1);
                Bundle bundle = Platform.getBundle((String)bundleId);
                URL url = bundle.getResource(resourcePath = uri.deresolve(baseURI = URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + '/'), (boolean)false)).toString());
                if (url == null) {
                    Logger.logError((String)NLS.bind((String)"Resource not found: {0}", (Object)resourcePath), (Plugin)Activator.getDefault());
                    imgDecriptor = ImageDescriptor.getMissingImageDescriptor();
                } else {
                    imgDecriptor = ImageDescriptor.createFromURL((URL)url);
                }
                result = imgDecriptor.createImage();
                this.uriImageCache.put(uriStr, result);
            }
        } else if (image != null) {
            result = new Image((Device)device, image.getInputStream());
        }
        return result;
    }

    @Override
    public Image getImage(Object element, ETypedElement featureColumn) {
        return this.getImage(element, this.propertiesHandler.getImageProperty(), featureColumn);
    }

    @Override
    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    @Override
    public boolean isUnderlined(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getIsUnderlinedProperty(), null, Boolean.class);
    }

    @Override
    public boolean isStruckthrough(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getIsStruckthroughProperty(), null, Boolean.class);
    }

    private Image getImage(Object element, FacetOperation operation, ETypedElement feature) {
        Image result = null;
        IImage iimage = this.getPropertyValue(element, operation, feature, IImage.class);
        if (iimage instanceof ImageWrapper) {
            result = ((ImageWrapper)iimage).getImage();
        } else if (iimage != null) {
            throw new IllegalArgumentException("Unexpected image type: " + iimage.getClass().getName());
        }
        return result;
    }

    @Override
    public Image getTopLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getTopLeftOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getTopMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getTopMiddleOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getTopRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getTopRightOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getBottomLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getBottomLeftOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getBottomMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getBottomMiddleOverlayProperty(), eTypedElement);
    }

    @Override
    public Image getBottomRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getImage(element, this.propertiesHandler.getBottomRightOverlayProperty(), eTypedElement);
    }

    public String getToolTipText(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTextProperty(), null, String.class);
    }

    public int getToolTipStyle(Object element) {
        int style = 0;
        Shadow shadow = this.getPropertyValue(element, this.propertiesHandler.getToolTipShadowProperty(), null, Shadow.class);
        switch (shadow) {
            case NONE: {
                style = 32;
                break;
            }
            case IN: {
                style = 4;
                break;
            }
            case OUT: {
                style = 8;
                break;
            }
            default: {
                throw new IllegalStateException("Un expected value");
            }
        }
        Alignment alignment = this.getPropertyValue(element, this.propertiesHandler.getToolTipAlignmentProperty(), null, Alignment.class);
        switch (alignment) {
            case LEFT: {
                style |= 0x4000;
                break;
            }
            case CENTER: {
                style |= 0x1000000;
                break;
            }
            case RIGHT: {
                style |= 0x20000;
                break;
            }
            default: {
                throw new IllegalStateException("Un expected value");
            }
        }
        return style;
    }

    public Image getToolTipImage(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipImageProperty(), null, Image.class);
    }

    public Color getToolTipBackgroundColor(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getToolTipBackgroundProperty(), null, IColor.class);
        return this.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
    }

    public Color getToolTipForegroundColor(Object element) {
        IColor color = this.getPropertyValue(element, this.propertiesHandler.getToolTipForegroundProperty(), null, IColor.class);
        return this.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
    }

    @Override
    public Image getToolTipTopLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTopLeftOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipTopMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTopMiddleOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipTopRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTopRightOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipBottomLeftOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipBottomLeftOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipBottomMiddleOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipBottomMiddleOverlayProperty(), null, Image.class);
    }

    @Override
    public Image getToolTipBottomRightOverlay(Object element, ETypedElement eTypedElement) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipBottomRightOverlayProperty(), null, Image.class);
    }

    public int getToolTipDisplayDelayTime(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipDisplayDelayTimeProperty(), null, Integer.class);
    }

    public int getToolTipTimeDisplayed(Object element) {
        return this.getPropertyValue(element, this.propertiesHandler.getToolTipTimeDisplayedProperty(), null, Integer.class);
    }

    public Font getToolTipFont(Object element) {
        String fontName = this.getPropertyValue(element, this.propertiesHandler.getToolTipFontNameProperty(), null, String.class);
        Integer fontSize = this.getPropertyValue(element, this.propertiesHandler.getToolTipFontSizeProperty(), null, Integer.class);
        Boolean isBold = this.getPropertyValue(element, this.propertiesHandler.getToolTipIsBoldProperty(), null, Boolean.class);
        Boolean isItalic = this.getPropertyValue(element, this.propertiesHandler.getToolTipIsItalicProperty(), null, Boolean.class);
        int fontStyle = 0;
        if (isBold.booleanValue()) {
            fontStyle |= 1;
        }
        if (isItalic.booleanValue()) {
            fontStyle |= 2;
        }
        FontData fontData = new FontData(fontName, fontSize.intValue(), fontStyle);
        return new Font((Device)Display.getDefault(), fontData);
    }

    @Override
    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        cell.setText(this.getText(element));
        cell.setBackground(this.getBackground(element));
        cell.setFont(this.getFont(element));
        cell.setForeground(this.getForeground(element));
        cell.setImage(this.getImage(element));
    }

    @Override
    public String getToolTipText(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Image getToolTipImage(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Font getToolTipFont(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Color getToolTipBackgroundColor(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public Color getToolTipForegroundColor(Object element, ETypedElement eTypedElement) {
        return null;
    }

    @Override
    public int getToolTipTimeDisplayed(Object element, ETypedElement eTypedElement) {
        return 0;
    }

    @Override
    public int getToolTipDisplayDelayTime(Object element, ETypedElement eTypedElement) {
        return 0;
    }

    @Override
    public int getToolTipStyle(Object element, ETypedElement eTypedElement) {
        return 0;
    }

    @Override
    public ICustomizedLabelProvider cloneLabelProvider() {
        return new CustomizedLabelProvider(this.customManager);
    }
}

