/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.ui.CustomizedContentProviderUtils;
import org.eclipse.emf.facet.custom.ui.ICustomizedContentProviderFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedTreeContentProvider;
import org.eclipse.emf.facet.custom.ui.IResolvingCustomizedLabelProviderFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedTreeContentProviderTests {
    private static final int MAX_DEPTH = 4;

    protected static TreeViewer createTreeInShell(ITreeContentProvider contentProvider, ILabelProvider labelProvider, Object input) {
        Shell shell = new Shell();
        shell.setLayout((Layout)new GridLayout());
        TreeViewer treeViewer = new TreeViewer((Composite)shell);
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setInput(input);
        treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        shell.layout();
        shell.open();
        return treeViewer;
    }

    @Test
    public void testCustomizedTreeContentProvider() throws Exception {
        final Object[] input = EcorePackage.eINSTANCE.getEClassifiers().toArray();
        ICustomizationManager customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager((ResourceSet)new ResourceSetImpl());
        final ICustomizedTreeContentProvider contentProvider = ICustomizedContentProviderFactory.DEFAULT.createCustomizedTreeContentProvider(customManager);
        final ICustomizedLabelProvider labelProvider = IResolvingCustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customManager);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CustomizedTreeContentProviderTests.this.customizedTreeContentProviderTest(contentProvider, labelProvider, input);
            }
        });
    }

    protected void customizedTreeContentProviderTest(ICustomizedTreeContentProvider contentProvider, ICustomizedLabelProvider labelProvider, Object input) {
        TreeViewer treeViewer = CustomizedTreeContentProviderTests.createTreeInShell((ITreeContentProvider)contentProvider, (ILabelProvider)labelProvider, input);
        Tree tree = (Tree)treeViewer.getControl();
        treeViewer.expandToLevel(4);
        this.checkRecursively(tree.getItems(), (List<? extends EObject>)EcorePackage.eINSTANCE.getEClassifiers(), null, 0);
        tree.getShell().close();
    }

    private void checkRecursively(TreeItem[] items, List<? extends EObject> eObjects, EObject parent, int depth) {
        if (depth >= 4) {
            return;
        }
        this.checkItems(items, eObjects);
        int index = 0;
        for (EObject eObject : eObjects) {
            TreeItem[] childItems = items[index].getItems();
            this.checkRecursively(eObject, childItems, parent, depth);
            ++index;
        }
    }

    private void checkRecursively(EObject eObject, TreeItem[] items, EObject parent, int depth) {
        if (parent == null) {
            ArrayList features = new ArrayList();
            features.addAll(eObject.eClass().getEAllAttributes());
            features.addAll(eObject.eClass().getEAllReferences());
            this.checkRecursively(items, features, eObject, depth + 1);
        } else {
            EStructuralFeature feature = (EStructuralFeature)eObject;
            Object result = parent.eGet(feature);
            if (result instanceof EObject) {
                EObject eObject2 = (EObject)result;
                this.checkRecursively(items, Collections.singletonList(eObject2), null, depth + 1);
            } else if (result instanceof List) {
                List list = (List)result;
                this.checkRecursively(items, list, null, depth + 1);
            }
        }
    }

    private void checkItems(TreeItem[] items, List<? extends EObject> eObjects) {
        Assert.assertEquals((String)"The number of tree elements must match the number of model elements", (long)eObjects.size(), (long)items.length);
        int index = 0;
        for (EObject eObject : eObjects) {
            Assert.assertEquals((String)"The tree elements must match the model elements", (Object)eObject, (Object)CustomizedContentProviderUtils.resolve((Object)items[index].getData()));
            ++index;
        }
    }
}

