/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.editor.editors;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.facet.infra.browser.custom.AttributeView;
import org.eclipse.emf.facet.infra.browser.custom.CustomView;
import org.eclipse.emf.facet.infra.browser.custom.CustomViewFeature;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ReferenceView;
import org.eclipse.emf.facet.infra.browser.custom.TypeView;
import org.eclipse.emf.facet.infra.browser.custom.editor.editors.MetaclassViewConfiguration;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.AttributeItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.emf.facet.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class MetaclassViewer {
    private final TreeViewer treeViewer;
    private final MetaclassViewConfiguration metaclassViewConfiguration;
    private MetamodelView fMetamodelView;

    public MetaclassViewer(Composite parent, MetaclassViewConfiguration metaclassViewConfiguration, MetamodelView metamodelView) {
        this.metaclassViewConfiguration = metaclassViewConfiguration;
        this.fMetamodelView = metamodelView;
        this.treeViewer = new TreeViewer(parent, 2820);
        this.initViewer();
    }

    public void setInput(Object input) {
        this.treeViewer.setInput(input);
    }

    private void initViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new MetaclassContentProvider());
        MetaclassLabelProvider labelProvider = new MetaclassLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof EClass && e2 instanceof EClass) {
                    EClass eClass1 = (EClass)e1;
                    EClass eClass2 = (EClass)e2;
                    return this.safeCompare(MetaclassViewer.this.getClassDisplayName(eClass1), MetaclassViewer.this.getClassDisplayName(eClass2));
                }
                if (e1 instanceof Attribute && e2 instanceof Reference) {
                    return -1;
                }
                if (e1 instanceof Reference && e2 instanceof Attribute) {
                    return 1;
                }
                if (e1 instanceof Attribute && e2 instanceof Attribute) {
                    int derived2;
                    EAttribute attribute1 = ((Attribute)e1).getEAttribute();
                    EAttribute attribute2 = ((Attribute)e2).getEAttribute();
                    int derived1 = attribute1.isDerived() ? 1 : 0;
                    int derivedDiff = derived1 - (derived2 = attribute2.isDerived() ? 1 : 0);
                    if (derivedDiff != 0) {
                        return derivedDiff;
                    }
                    return this.safeCompare(attribute1.getName(), attribute2.getName());
                }
                if (e1 instanceof Reference && e2 instanceof Reference) {
                    int rank2;
                    int rank1;
                    int diffRank;
                    EReference ref1 = ((Reference)e1).getEReference();
                    EReference ref2 = ((Reference)e2).getEReference();
                    if (MetaclassViewer.this.metaclassViewConfiguration.isSortLinksByType() && (diffRank = (rank1 = ModelElementItem.getReferenceRank((EReference)ref1)) - (rank2 = ModelElementItem.getReferenceRank((EReference)ref2))) != 0) {
                        return diffRank;
                    }
                    if (MetaclassViewer.this.metaclassViewConfiguration.isSortLinks()) {
                        return this.safeCompare(ref1.getName(), ref2.getName());
                    }
                    return 0;
                }
                return 0;
            }

            private int safeCompare(String name1, String name2) {
                if (name1 == null) {
                    return -1;
                }
                return name1.compareTo(name2);
            }
        });
    }

    public String getClassDisplayName(EClass eClass) {
        if (this.metaclassViewConfiguration.isShowMetaclassesFullQualifiedNames()) {
            return ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
        }
        return eClass.getName();
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            try {
                this.treeViewer.getTree().setRedraw(false);
                this.treeViewer.refresh();
            }
            finally {
                this.treeViewer.getTree().setRedraw(true);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(selectionChangedListener);
    }

    public void clearSelection() {
        this.treeViewer.setSelection(null);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    public void select(CustomView customView) {
        Object element = this.findTreeElement(customView);
        if (element != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(element), true);
        }
    }

    public Object findTreeElement(CustomView customView) {
        Object[] elements;
        Object input = this.treeViewer.getInput();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] objectArray = elements = contentProvider.getElements(input);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceView referenceView;
            Object element = objectArray[n2];
            EClass eClass = (EClass)element;
            String qualifiedName = ModelUtils.getMetaclassQualifiedName((EClassifier)eClass);
            if (customView instanceof TypeView) {
                TypeView typeView = (TypeView)customView;
                if (qualifiedName.equals(typeView.getMetaclassName())) {
                    return eClass;
                }
            } else if (customView instanceof AttributeView) {
                AttributeView attributeView = (AttributeView)customView;
                if (qualifiedName.equals(attributeView.getType().getMetaclassName())) {
                    Object[] children;
                    Object[] objectArray2 = children = contentProvider.getChildren((Object)eClass);
                    int n3 = children.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Attribute attribute;
                        Object child = objectArray2[n4];
                        if (child instanceof Attribute && (attribute = (Attribute)child).getEAttribute().getName().equals(attributeView.getAttributeName())) {
                            return attribute;
                        }
                        ++n4;
                    }
                    return eClass;
                }
            } else if (customView instanceof ReferenceView && qualifiedName.equals((referenceView = (ReferenceView)customView).getType().getMetaclassName())) {
                Object[] children;
                Object[] objectArray3 = children = contentProvider.getChildren((Object)eClass);
                int n5 = children.length;
                int n6 = 0;
                while (n6 < n5) {
                    Reference reference;
                    Object child = objectArray3[n6];
                    if (child instanceof Reference && (reference = (Reference)child).getEReference().getName().equals(referenceView.getReferenceName())) {
                        return reference;
                    }
                    ++n6;
                }
                return eClass;
            }
            ++n2;
        }
        return null;
    }

    public void setMetamodelView(MetamodelView metamodelView) {
        this.fMetamodelView = metamodelView;
    }

    public class Attribute {
        private final EClass eClass;
        private final EAttribute eAttribute;

        public Attribute(EClass eClass, EAttribute eAttribute) {
            this.eClass = eClass;
            this.eAttribute = eAttribute;
        }

        public EClass getEClass() {
            return this.eClass;
        }

        public EAttribute getEAttribute() {
            return this.eAttribute;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Attribute) {
                Attribute other = (Attribute)obj;
                return this.eClass == other.eClass && this.eAttribute == other.eAttribute;
            }
            return false;
        }

        public int hashCode() {
            return this.eClass.hashCode() * 47 + this.eAttribute.hashCode() + 13;
        }
    }

    protected class MetaclassContentProvider
    implements ITreeContentProvider {
        protected MetaclassContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Resource) {
                Resource resource = (Resource)inputElement;
                TreeIterator allContents = resource.getAllContents();
                ArrayList<EClass> metaclasses = new ArrayList<EClass>();
                while (allContents.hasNext()) {
                    EObject eObject = (EObject)allContents.next();
                    if (!(eObject instanceof EClass)) continue;
                    EClass eClass = (EClass)eObject;
                    metaclasses.add(eClass);
                }
                return metaclasses.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EClass) {
                EList references;
                EList attributes;
                EClass eClass = (EClass)parentElement;
                if (eClass instanceof Facet) {
                    Facet facet = (Facet)eClass;
                    attributes = facet.getEAttributes();
                    references = facet.getEReferences();
                } else {
                    attributes = eClass.getEAllAttributes();
                    references = eClass.getEAllReferences();
                }
                ArrayList<Object> children = new ArrayList<Object>();
                for (EAttribute attribute : attributes) {
                    if (attribute.isDerived() && !MetaclassViewer.this.metaclassViewConfiguration.isShowDerivedLinks()) continue;
                    children.add(new Attribute(eClass, attribute));
                }
                for (EReference reference : references) {
                    if (reference.isDerived() && !MetaclassViewer.this.metaclassViewConfiguration.isShowDerivedLinks()) continue;
                    children.add(new Reference(eClass, reference));
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Reference) {
                return ((Reference)element).getEClass();
            }
            if (element instanceof Attribute) {
                return ((Attribute)element).getEClass();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EClass) {
                return this.getChildren(element).length > 0;
            }
            return false;
        }
    }

    protected class MetaclassLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        private final RGB rgbGray = new RGB(128, 128, 128);
        private final Color colorGrayedOut = new Color((Device)Display.getDefault(), this.rgbGray);
        private final Font boldFont;

        public MetaclassLabelProvider() {
            FontDescriptor fontDescriptor = JFaceResources.getDefaultFontDescriptor();
            fontDescriptor = fontDescriptor.setStyle(1);
            this.boldFont = fontDescriptor.createFont((Device)Display.getDefault());
        }

        public String getText(Object element) {
            if (element instanceof EClass) {
                EClass eClass = (EClass)element;
                return MetaclassViewer.this.getClassDisplayName(eClass);
            }
            if (element instanceof Reference) {
                EReference reference = ((Reference)element).getEReference();
                boolean showMultiplicity = MetaclassViewer.this.metaclassViewConfiguration.isShowMultiplicity();
                return LinkItem.getStaticText((EReference)reference, (boolean)showMultiplicity, (boolean)false, null);
            }
            if (element instanceof Attribute) {
                EAttribute attribute = ((Attribute)element).getEAttribute();
                boolean showMultiplicity = MetaclassViewer.this.metaclassViewConfiguration.isShowMultiplicity();
                return AttributeItem.getStaticText((EAttribute)attribute, (boolean)showMultiplicity, null);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof EClass) {
                return ImageProvider.getInstance().getEClassIcon();
            }
            if (element instanceof Reference) {
                EReference reference = ((Reference)element).getEReference();
                return LinkItem.getImageFor((EReference)reference);
            }
            if (element instanceof Attribute) {
                return ImageProvider.getInstance().getAttributeIcon();
            }
            return null;
        }

        public void dispose() {
            this.colorGrayedOut.dispose();
            this.boldFont.dispose();
            super.dispose();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (this.isCustomized(element)) {
                return null;
            }
            return this.colorGrayedOut;
        }

        private boolean isCustomized(Object element) {
            block10: {
                MetamodelView metamodelView;
                block9: {
                    metamodelView = MetaclassViewer.this.fMetamodelView;
                    if (element instanceof EClass) {
                        EClass eClass = (EClass)element;
                        for (TypeView typeView : metamodelView.getTypes()) {
                            if (!typeView.getMetaclassName().equals(ModelUtils.getMetaclassQualifiedName((EClassifier)eClass))) continue;
                            if (this.containsInformation((CustomView)typeView)) {
                                return true;
                            }
                            EList attributes = typeView.getAttributes();
                            for (AttributeView attributeView : attributes) {
                                if (!this.containsInformation((CustomView)attributeView)) continue;
                                return true;
                            }
                            EList references = typeView.getReferences();
                            for (ReferenceView referenceView : references) {
                                if (!this.containsInformation((CustomView)referenceView)) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                    if (!(element instanceof Reference)) break block9;
                    Reference reference = (Reference)element;
                    EReference eReference = reference.getEReference();
                    EClass eClass = reference.getEClass();
                    for (TypeView typeView : metamodelView.getTypes()) {
                        if (!typeView.getMetaclassName().equals(ModelUtils.getMetaclassQualifiedName((EClassifier)eClass))) continue;
                        EList references = typeView.getReferences();
                        for (ReferenceView referenceView : references) {
                            if (!referenceView.getReferenceName().equals(eReference.getName())) continue;
                            return this.containsInformation((CustomView)referenceView);
                        }
                    }
                    break block10;
                }
                if (!(element instanceof Attribute)) break block10;
                Attribute attribute = (Attribute)element;
                EAttribute eAttribute = attribute.getEAttribute();
                EClass eClass = attribute.getEClass();
                for (TypeView typeView : metamodelView.getTypes()) {
                    if (!typeView.getMetaclassName().equals(ModelUtils.getMetaclassQualifiedName((EClassifier)eClass))) continue;
                    EList attributes = typeView.getAttributes();
                    for (AttributeView attributeView : attributes) {
                        if (!attributeView.getAttributeName().equals(eAttribute.getName())) continue;
                        return this.containsInformation((CustomView)attributeView);
                    }
                }
            }
            return false;
        }

        private boolean containsInformation(CustomView customView) {
            EList customizedFeatures = customView.getCustomizedFeatures();
            for (CustomViewFeature customViewFeature : customizedFeatures) {
                if (customViewFeature.getDefaultValue() == null && customViewFeature.getValueCases().size() <= 0) continue;
                return true;
            }
            return false;
        }

        public Font getFont(Object element) {
            if (this.isCustomized(element)) {
                return this.boldFont;
            }
            return null;
        }
    }

    public class Reference {
        private final EClass eClass;
        private final EReference eReference;

        public Reference(EClass eClass, EReference eReference) {
            this.eClass = eClass;
            this.eReference = eReference;
        }

        public EClass getEClass() {
            return this.eClass;
        }

        public EReference getEReference() {
            return this.eReference;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Reference) {
                Reference other = (Reference)obj;
                return this.eClass == other.eClass && this.eReference == other.eReference;
            }
            return false;
        }

        public int hashCode() {
            return this.eClass.hashCode() * 47 + this.eReference.hashCode() + 13;
        }
    }
}

