/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.tests.internal;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.facet.util.emf.core.internal.EMFUtils;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.Assert;
import org.junit.Test;

public class EMFUtilsTests {
    @Test
    public void testComputeLeastCommonSupertype1() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        this.sup(a, c);
        this.sup(b, c);
        EMFUtilsTests.assertCommon(c, a, b);
        EMFUtilsTests.assertCommon(c, a, b, c);
    }

    @Test
    public void testComputeLeastCommonSupertype2() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        EClass d = this.newClass("d");
        EClass e = this.newClass("e");
        this.sup(a, d);
        this.sup(b, d);
        this.sup(b, e);
        this.sup(b, c);
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), a, b, c);
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), a, b, c, d, e);
    }

    @Test
    public void testComputeLeastCommonSupertype3() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        EClass d = this.newClass("d");
        this.sup(d, b);
        this.sup(a, b);
        this.sup(d, c);
        this.sup(a, c);
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), a, d);
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), b, c);
        EMFUtilsTests.assertCommon(d, d);
    }

    @Test
    public void testComputeLeastCommonSupertype4() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        EClass d = this.newClass("d");
        EClass e = this.newClass("e");
        this.sup(a, c);
        this.sup(b, c);
        this.sup(c, d);
        this.sup(c, e);
        EMFUtilsTests.assertCommon(c, a, b);
    }

    @Test
    public void testComputeLeastCommonSupertype5() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        EClass d = this.newClass("d");
        EClass e = this.newClass("d");
        this.sup(a, c);
        this.sup(b, c);
        this.sup(c, d);
        this.sup(d, e);
        EMFUtilsTests.assertCommon(c, a, b);
        EMFUtilsTests.assertCommon(c, a, b, c);
    }

    @Test
    public void testComputeLeastCommonSupertype6() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        EClass d = this.newClass("d");
        this.sup(a, b);
        this.sup(b, c);
        this.sup(d, c);
        EMFUtilsTests.assertCommon(c, a, d);
        EMFUtilsTests.assertCommon(b, a, b);
        EMFUtilsTests.assertCommon(c, a, b, d);
        EMFUtilsTests.assertCommon(c, a, b, c, d);
    }

    @Test
    public void testComputeLeastCommonSupertype7() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass c = this.newClass("c");
        EClass d = this.newClass("d");
        EClass e = this.newClass("e");
        EClass f = this.newClass("f");
        EClass g = this.newClass("g");
        this.sup(d, b);
        this.sup(a, b);
        this.sup(d, c);
        this.sup(a, c);
        this.sup(b, e);
        this.sup(c, e);
        this.sup(e, f);
        this.sup(c, g);
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), a, d);
        EMFUtilsTests.assertCommon(e, b, c);
        EMFUtilsTests.assertCommon(b, b, a);
    }

    @Test
    public void testComputeLeastCommonSupertype8() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EClass d = this.newClass("d");
        EClass e = this.newClass("e");
        EClass f = this.newClass("f");
        EClass g = this.newClass("g");
        EClass h = this.newClass("h");
        this.sup(a, e);
        this.sup(b, e);
        this.sup(a, d);
        this.sup(b, f);
        this.sup(d, g);
        this.sup(e, g);
        this.sup(e, h);
        this.sup(f, h);
        EMFUtilsTests.assertCommon(e, a, b);
        EMFUtilsTests.assertCommon(e, a, b, e);
        EMFUtilsTests.assertCommon(h, e, f);
    }

    @Test
    public void testComputeLeastCommonSupertypeUMLWithFeature() {
        EClass umlClass = UMLPackage.eINSTANCE.getClass_();
        EClass umlPackage = UMLPackage.eINSTANCE.getPackage();
        EClass umlNamedElement = UMLPackage.eINSTANCE.getNamedElement();
        EMFUtilsTests.assertCommon(umlNamedElement, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), umlClass, umlPackage);
    }

    @Test
    public void testReturnsEObjectByDefault() {
        EClass a = this.newClass("a");
        EClass b = this.newClass("b");
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), a, b);
    }

    @Test
    public void testTwoMetamodels() {
        EClass aClass = this.newClass("aClass");
        EClass property = UMLPackage.eINSTANCE.getProperty();
        EMFUtilsTests.assertCommon(EcorePackage.eINSTANCE.getEObject(), aClass, property);
    }

    private EClass newClass(String name) {
        EClass newClass = EcoreFactory.eINSTANCE.createEClass();
        newClass.setName(name);
        return newClass;
    }

    private void sup(EClass a, EClass b) {
        a.getESuperTypes().add((Object)b);
    }

    private static void assertCommon(EClass common, EClass ... classes) {
        EMFUtilsTests.assertCommon(common, null, classes);
    }

    private static void assertCommon(EClass common, EStructuralFeature feature, EClass ... classes) {
        ArrayList<EClass> classesList = new ArrayList<EClass>();
        EClass[] eClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            classesList.add(eClass);
            ++n2;
        }
        Assert.assertEquals((Object)common, (Object)EMFUtils.computeLeastCommonSupertype(classesList, (EStructuralFeature)feature));
    }
}

