/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.util.emf.core.internal.EMFUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetUtils {
    private FacetUtils() {
    }

    public static Facet getFacet(FacetSet facetSet, String facetName) {
        Facet result = null;
        List<Facet> facets = FacetUtils.getFacets(facetSet);
        for (Facet facet : facets) {
            if (!facetName.equals(facet.getName())) continue;
            result = facet;
            break;
        }
        return result;
    }

    public static <T extends ETypedElement> T getETypedElement(Facet facet, String name, Class<T> classs) {
        ETypedElement result = null;
        ArrayList eTypedElements = new ArrayList();
        eTypedElements.addAll(facet.getFacetElements());
        eTypedElements.addAll(facet.getFacetOperations());
        for (ETypedElement eTypedElement : eTypedElements) {
            ETypedElement castResult;
            if (!name.equals(eTypedElement.getName()) || !classs.isInstance(eTypedElement)) continue;
            result = castResult = eTypedElement;
            break;
        }
        return (T)result;
    }

    public static Object getResultValue(ETypedElementResult eTEresult) {
        Object result = null;
        if (eTEresult instanceof ETypedElementEObjectListResult) {
            ETypedElementEObjectListResult eObjectList = (ETypedElementEObjectListResult)eTEresult;
            result = eObjectList.getResultList();
        } else if (eTEresult instanceof ETypedElementEObjectResult) {
            ETypedElementEObjectResult eObjectRef = (ETypedElementEObjectResult)eTEresult;
            result = eObjectRef.getResult();
        } else if (eTEresult instanceof ETypedElementPrimitiveTypeListResult) {
            ETypedElementPrimitiveTypeListResult objectList = (ETypedElementPrimitiveTypeListResult)eTEresult;
            result = objectList.getDerivedTypedElement();
        } else if (eTEresult instanceof ETypedElementPrimitiveTypeResult) {
            ETypedElementPrimitiveTypeResult objectRef = (ETypedElementPrimitiveTypeResult)eTEresult;
            result = objectRef.getResult();
        } else {
            throw new IllegalStateException("Unknown ETypedElementResult type: " + eTEresult.getClass());
        }
        return result;
    }

    public static FacetSet getFacetSet(Collection<FacetSet> facetSets, String name) {
        FacetSet result = null;
        for (FacetSet facetSet : facetSets) {
            if (!name.equals(facetSet.getName())) continue;
            result = facetSet;
        }
        return result;
    }

    public static List<FacetSet> getFacetSets(Collection<FacetSet> facetSets, String name) {
        ArrayList<FacetSet> result = new ArrayList<FacetSet>();
        for (FacetSet facetSet : facetSets) {
            if (!name.equals(facetSet.getName())) continue;
            result.add(facetSet);
        }
        return result;
    }

    public static Set<EPackage> getAllExtendedEPackage(FacetSet facetSet) {
        HashSet<EPackage> extendedEPackages = new HashSet<EPackage>();
        EPackage res1 = FacetUtils.getExtendedEPackage(facetSet);
        if (res1 != null) {
            extendedEPackages.add(res1);
        }
        for (FacetSet current : facetSet.getFacetSets()) {
            extendedEPackages.addAll(FacetUtils.getAllExtendedEPackage(current));
        }
        EList pack = facetSet.getESubpackages();
        for (EPackage current : pack) {
            if (!(current instanceof FacetSet)) continue;
            extendedEPackages.addAll(FacetUtils.getAllExtendedEPackage((FacetSet)current));
        }
        return extendedEPackages;
    }

    public static List<FacetSet> getFacetSetsByPath(Collection<FacetSet> rootFacetSets, String ... path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("The given path cannot be empty");
        }
        List<FacetSet> facetSets = new ArrayList<FacetSet>(rootFacetSets);
        int i = 0;
        while (i < path.length) {
            String name;
            if (i > 0) {
                facetSets = FacetUtils.getSubFacetSets(facetSets);
            }
            if ((facetSets = FacetUtils.getFacetSets(facetSets, name = path[i])).isEmpty()) break;
            ++i;
        }
        return facetSets;
    }

    private static List<FacetSet> getSubFacetSets(Collection<FacetSet> parents) {
        ArrayList<FacetSet> subFacetSets = new ArrayList<FacetSet>();
        for (FacetSet facetSet : parents) {
            EList eSubpackages = facetSet.getESubpackages();
            for (EPackage ePackage : eSubpackages) {
                if (!(ePackage instanceof FacetSet)) continue;
                FacetSet subFacetSet = (FacetSet)ePackage;
                subFacetSets.add(subFacetSet);
            }
        }
        return subFacetSets;
    }

    public static Facet getFacet(Collection<Facet> facets, String name) {
        Facet result = null;
        for (Facet facet : facets) {
            if (!name.equals(facet.getName())) continue;
            result = facet;
        }
        return result;
    }

    public static FacetSet getRootFacetSet(Facet facet) {
        FacetSet result = (FacetSet)facet.eContainer();
        while (result != null && result.eContainer() instanceof FacetSet) {
            result = (FacetSet)result.eContainer();
        }
        return result;
    }

    public static FacetSet getRootFacetSet(FacetSet facetSet) {
        FacetSet result = facetSet;
        while (result != null && result.eContainer() instanceof FacetSet) {
            result = (FacetSet)result.eContainer();
        }
        return result;
    }

    public static Set<? extends ETypedElement> getETypedElements(ResourceSet resourceSet) {
        HashSet<Object> result = new HashSet<Object>();
        Collection ePackages = EPackage.Registry.INSTANCE.values();
        for (Object object : ePackages) {
            EPackage ePackage = null;
            if (object instanceof EPackage) {
                ePackage = (EPackage)object;
            } else if (object instanceof EPackage.Descriptor) {
                EPackage.Descriptor descriptor = (EPackage.Descriptor)object;
                ePackage = descriptor.getEPackage();
            }
            if (ePackage == null) continue;
            result.addAll(FacetUtils.getETypedElements(ePackage));
        }
        result.addAll(FacetUtils.getFacetETypedElements(resourceSet));
        return result;
    }

    public static Set<? extends ETypedElement> getFacetETypedElements(ResourceSet resourceSet) {
        HashSet<ETypedElement> result = new HashSet<ETypedElement>();
        Collection<FacetSet> facetSets = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(resourceSet).getRegisteredFacetSets();
        for (FacetSet facetSet : facetSets) {
            result.addAll(FacetUtils.getETypedElements((EPackage)facetSet));
        }
        return result;
    }

    public static List<ETypedElement> getETypedElements(EPackage ePackage) {
        LinkedList<ETypedElement> result = new LinkedList<ETypedElement>();
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            result.addAll(FacetUtils.getETypedElements(eClassifier));
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            result.addAll(FacetUtils.getETypedElements(subPackage));
        }
        return result;
    }

    public static List<ETypedElement> getETypedElements(EClassifier eClassifier) {
        ArrayList<ETypedElement> result = new ArrayList<ETypedElement>();
        if (eClassifier instanceof Facet) {
            Facet facet = (Facet)eClassifier;
            result.addAll((Collection<ETypedElement>)facet.getFacetElements());
            result.addAll((Collection<ETypedElement>)facet.getFacetOperations());
        } else if (eClassifier instanceof EClass) {
            EClass eClass = (EClass)eClassifier;
            result.addAll((Collection<ETypedElement>)eClass.getEAllStructuralFeatures());
            result.addAll((Collection<ETypedElement>)eClass.getEAllOperations());
        }
        return result;
    }

    public static List<Facet> getFacets(FacetSet facetSet) {
        LinkedList<Facet> result = new LinkedList<Facet>();
        for (EClassifier eClassifier : facetSet.getEClassifiers()) {
            if (!(eClassifier instanceof Facet)) continue;
            Facet facet = (Facet)eClassifier;
            result.add(facet);
        }
        return result;
    }

    public static FacetSet getFacetSet(Facet facet) {
        FacetSet result = null;
        if (facet.getEPackage() instanceof FacetSet) {
            result = (FacetSet)facet.getEPackage();
        }
        return result;
    }

    public static EPackage getExtendedEPackage(FacetSet facetSet) {
        List<Facet> facets = FacetUtils.getFacets(facetSet);
        EPackage result = null;
        for (Facet facet : facets) {
            EPackage ePackage;
            EClass extendedMetaclass = facet.getExtendedMetaclass();
            if (extendedMetaclass == null || (ePackage = extendedMetaclass.getEPackage()) == null) continue;
            if (result != null && !ePackage.equals(result)) {
                throw new IllegalStateException("The Facets in a FacetSet must all extend EClasses from the same EPackage");
            }
            result = ePackage;
        }
        return result;
    }

    public static <T extends ETypedElement> Set<T> getETypedElements(EObject eObject, Class<T> classs, IFacetManager facetManager) throws FacetManagerException {
        HashSet<T> result = new HashSet<T>();
        for (FacetSet facetSet : facetManager.getManagedFacetSets()) {
            result.addAll(FacetUtils.getETypedElements(eObject, facetSet, classs, facetManager));
        }
        return result;
    }

    private static <T extends ETypedElement> Set<T> getETypedElements(EObject eObject, FacetSet facetSet, Class<T> classs, IFacetManager manager) throws FacetManagerException {
        HashSet<T> result = new HashSet<T>();
        for (EClassifier eClassifier : facetSet.getEClassifiers()) {
            Facet facet;
            if (!(eClassifier instanceof Facet) || !manager.isConforming(eObject, facet = (Facet)eClassifier)) continue;
            result.addAll(FacetUtils.getETypedElement(classs, facet));
        }
        for (EPackage ePackage : facetSet.getESubpackages()) {
            if (!(ePackage instanceof FacetSet)) continue;
            FacetSet subFacetSet = (FacetSet)ePackage;
            result.addAll(FacetUtils.getETypedElements(eObject, subFacetSet, classs, manager));
        }
        for (FacetSet subFacetSet : facetSet.getFacetSets()) {
            result.addAll(FacetUtils.getETypedElements(eObject, subFacetSet, classs, manager));
        }
        return result;
    }

    private static <T> Set<T> getETypedElement(Class<T> classs, Facet facet) {
        HashSet<Object> result = new HashSet<Object>();
        for (ETypedElement eTypedElement : FacetUtils.getAllETypedElements(facet)) {
            if (!classs.isInstance(eTypedElement)) continue;
            ETypedElement typedSF = eTypedElement;
            T resolvedTE = IResolverManager.DEFAULT.resolve(typedSF, classs);
            if (resolvedTE == null) {
                result.add(typedSF);
                continue;
            }
            result.add(resolvedTE);
        }
        return result;
    }

    private static List<ETypedElement> getAllETypedElements(Facet facet) {
        LinkedList<ETypedElement> structFeatures = new LinkedList<ETypedElement>();
        structFeatures.addAll((Collection<ETypedElement>)facet.getFacetElements());
        structFeatures.addAll((Collection<ETypedElement>)facet.getFacetOperations());
        for (Facet extFacet : facet.getExtendedFacets()) {
            structFeatures.addAll(FacetUtils.getAllETypedElements(extFacet));
        }
        return structFeatures;
    }

    public static FacetSet getFacetSet(ETypedElement eTypedElement) {
        Facet facet;
        FacetSet result = null;
        if (eTypedElement.eContainer() instanceof Facet && (facet = (Facet)eTypedElement.eContainer()).eContainer() instanceof FacetSet) {
            result = (FacetSet)facet.eContainer();
        }
        return result;
    }

    public static DerivedTypedElement getSignature(FacetOperation facetOperation) {
        FacetOperation current = facetOperation;
        while (current.getOverride() != null) {
            current = current.getOverride();
        }
        return current;
    }

    public static EClass getExtendedMetaclass(Facet facet) {
        EClass result = facet.getExtendedMetaclass();
        if (result == null) {
            LinkedList<EClass> eClasses = new LinkedList<EClass>();
            for (Facet extfacet : facet.getExtendedFacets()) {
                eClasses.add(FacetUtils.getExtendedMetaclass(extfacet));
            }
            result = EMFUtils.computeLeastCommonSupertype(eClasses);
        }
        return result;
    }

    public static <T extends DerivedTypedElement> T getTopOverrideFeature(T feature) throws FacetManagerException {
        Object signatureFeature = feature;
        while (signatureFeature.getOverride() != null) {
            if (feature.getClass().isInstance(signatureFeature.getOverride())) {
                signatureFeature = signatureFeature.getOverride();
                continue;
            }
            String sfTypeName = signatureFeature.eClass().getName();
            String sfName = ModelUtils.getQualifiedName(signatureFeature);
            String ofName = signatureFeature.getOverride().eClass().getName();
            throw new FacetManagerException("The " + sfTypeName + " '" + sfName + "' overides a " + ofName);
        }
        return signatureFeature;
    }

    public static EClass findExtendedEClass(Facet facet) {
        EClass result = facet.getExtendedMetaclass();
        if (result == null) {
            for (Facet extFacet : facet.getExtendedFacets()) {
                result = FacetUtils.findExtendedEClass(extFacet);
                if (result != null) break;
            }
        }
        return result;
    }

    public static DerivedTypedElement getContainingDerivedTypedElement(EObject eObject) {
        DerivedTypedElement dte = null;
        if (eObject instanceof DerivedTypedElement) {
            dte = (DerivedTypedElement)eObject;
        } else if (eObject != null) {
            dte = FacetUtils.getContainingDerivedTypedElement(eObject.eContainer());
        }
        return dte;
    }

    public static FacetSet getContainingFacetSet(EObject eObject) {
        FacetSet result = null;
        if (eObject instanceof FacetSet) {
            result = (FacetSet)eObject;
        } else {
            EObject container = eObject.eContainer();
            if (container != null) {
                result = FacetUtils.getContainingFacetSet(container);
            }
        }
        return result;
    }

    public static Map<String, FacetOperation> getAllOperationsByName(FacetSet parent) {
        HashMap<String, FacetOperation> operations = new HashMap<String, FacetOperation>();
        for (EClassifier facet : parent.getEClassifiers()) {
            for (FacetOperation operation : ((Facet)facet).getFacetOperations()) {
                operations.put(operation.getName(), operation);
            }
        }
        for (EPackage element : parent.getESubpackages()) {
            operations.putAll(FacetUtils.getAllOperationsByName((FacetSet)element));
        }
        return operations;
    }

    public static Map<String, Facet> getAllFacetsByName(FacetSet parent) {
        HashMap<String, Facet> facets = new HashMap<String, Facet>();
        for (EClassifier facet : parent.getEClassifiers()) {
            facets.put(facet.getName(), (Facet)facet);
        }
        for (EPackage element : parent.getESubpackages()) {
            facets.putAll(FacetUtils.getAllFacetsByName((FacetSet)element));
        }
        return facets;
    }

    public static Map<String, FacetSet> getAllFacetSetsByName(EPackage parent) {
        HashMap<String, FacetSet> facetSets = new HashMap<String, FacetSet>();
        if (parent instanceof FacetSet) {
            FacetSet facetSet = (FacetSet)parent;
            facetSets.put(parent.getName(), facetSet);
        }
        for (EPackage element : parent.getESubpackages()) {
            facetSets.putAll(FacetUtils.getAllFacetSetsByName(element));
        }
        return facetSets;
    }

    public static List<Facet> getAllFacet(FacetSet facetSet) {
        ArrayList<Facet> result = new ArrayList<Facet>();
        for (EClassifier eClassifier : facetSet.getEClassifiers()) {
            if (!(eClassifier instanceof Facet)) continue;
            Facet facet = (Facet)eClassifier;
            result.add(facet);
        }
        for (EPackage ePackage : facetSet.getESubpackages()) {
            if (!(ePackage instanceof FacetSet)) continue;
            FacetSet subFacetSet = (FacetSet)ePackage;
            result.addAll(FacetUtils.getAllFacet(subFacetSet));
        }
        return result;
    }
}

