/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.facet.tests.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.EcoreCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.resource.EmfFacetResourceSet;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FileUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FolderUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.IFilter;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.facet.tests.internal.Activator;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.tests.internal.Utils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class FacetTests {
    public static final String FILE_EXT = ".facetSet";
    public static final String QUERY_EXT = ".querySet";
    private final Utils utils = new Utils((Plugin)Activator.getDefault());
    private final EPackage ecorePackage = this.utils.getEcorePackage();
    private final ResourceSet resourceSet = new ResourceSetImpl();

    protected Utils getUtils() {
        return this.utils;
    }

    @Test
    public void test001() throws Exception {
        IProject projectToCreate = this.utils.createProject("test001");
        IFile queryFile = FileUtils.copyFileFromBundle((String)"resources/test001.querySet", (IProject)projectToCreate, (String)"/test001.querySet", (Bundle)Activator.getDefault().getBundle());
        IFile facetFile = FileUtils.copyFileFromBundle((String)"resources/test001.facetSet", (IProject)projectToCreate, (String)"/test001.facetSet", (Bundle)Activator.getDefault().getBundle());
        IFile javaFile = FileUtils.copyFileFromBundle((String)"src/org/eclipse/emf/facet/infra/facet/tests/internal/queries/GetSubClasses.java", (IProject)projectToCreate, (String)"/src/org/eclipse/emf/facet/infra/facet/tests/internal/queries/GetSubClasses.java", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)projectToCreate);
        FileUtils.checkNoMarkerOn((IFile)javaFile);
        FileUtils.checkNoMarkerOn((IFile)queryFile);
        FileUtils.checkNoMarkerOn((IFile)facetFile);
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("test001");
        Assert.assertNotNull((Object)facetSet);
        FacetContext context = new FacetContext();
        context.addFacetSet(facetSet);
        Facet facet = facetSet.getFacet("EPackageFacet");
        Assert.assertNotNull((Object)facet);
        Assert.assertTrue((boolean)context.isInstance((EObject)this.ecorePackage, facet));
        Object object = context.get((EObject)this.ecorePackage, facet.getEStructuralFeature("nbEClassifiers"));
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Integer));
        Assert.assertEquals((Object)new Integer(53), (Object)object);
        Facet facet2 = facetSet.getFacet("EClassFacet");
        Assert.assertNotNull((Object)facet2);
        Assert.assertTrue((boolean)context.isInstance((EObject)this.ecorePackage.getEClassifier("ENamedElement"), facet2));
        Object object2 = context.get((EObject)this.ecorePackage.getEClassifier("ENamedElement"), facet2.getEStructuralFeature("subClasses"));
        Assert.assertNotNull((Object)object2);
        Assert.assertTrue((boolean)(object2 instanceof Collection));
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            Assert.assertEquals((long)14L, (long)collection.size());
        } else {
            Assert.fail((String)"Unexpected type for object2");
        }
    }

    @Test
    public void test002() throws Exception {
        IProject projectToCreate = this.utils.createProject("test002");
        IFile queryFile = FileUtils.copyFileFromBundle((String)"resources/test002.querySet", (IProject)projectToCreate, (String)"/test002.querySet", (Bundle)Activator.getDefault().getBundle());
        IFile facetFile = FileUtils.copyFileFromBundle((String)"resources/test002.facetSet", (IProject)projectToCreate, (String)"/test002.facetSet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)projectToCreate);
        FileUtils.checkNoMarkerOn((IFile)queryFile);
        FileUtils.checkNoMarkerOn((IFile)facetFile);
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("test002");
        Assert.assertNotNull((Object)facetSet);
        FacetContext context = new FacetContext();
        context.addFacetSet(facetSet);
        Facet facet = facetSet.getFacet("EPackageFacet");
        FacetAttribute attribute = (FacetAttribute)facet.getEStructuralFeature("nbEClassifiers");
        ModelQuery queryFromFacet1 = attribute.getValueQuery();
        Assert.assertEquals((Object)"x", (Object)queryFromFacet1.getDescription());
        Assert.assertFalse((boolean)queryFromFacet1.eIsProxy());
        FileUtils.copyFileFromBundle((String)"resources/test002bis.querySet", (IProject)projectToCreate, (String)"/test002.querySet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)projectToCreate);
        FileUtils.checkNoMarkerOn((IFile)queryFile);
        FileUtils.checkNoMarkerOn((IFile)facetFile);
        ModelQuerySet querySet = ModelQuerySetCatalog.getSingleton().getModelQuerySet("test002");
        ModelQuery modelQuery = querySet.getQuery("nbEClassifiers");
        Assert.assertEquals((Object)"bis", (Object)modelQuery.getDescription());
        FacetSet facetSet2 = FacetSetCatalog.getSingleton().getFacetSet("test002");
        Facet facet2 = facetSet2.getFacet("EPackageFacet");
        FacetAttribute attribute2 = (FacetAttribute)facet2.getEStructuralFeature("nbEClassifiers");
        ModelQuery queryFromFacet2 = attribute2.getValueQuery();
        Assert.assertEquals((Object)"bis", (Object)queryFromFacet2.getDescription());
        Assert.assertNotNull((Object)queryFromFacet2);
        Assert.assertEquals((Object)queryFromFacet2.getName(), (Object)"nbEClassifiers");
        Assert.assertEquals((long)0L, (long)queryFromFacet2.getParameters().size());
        Assert.assertNotNull((Object)modelQuery);
        Assert.assertNotNull((Object)modelQuery.eResource());
        Assert.assertEquals((Object)EmfFacetResourceSet.getResourceSetSingleton(), (Object)modelQuery.eResource().getResourceSet());
        Assert.assertNotNull((Object)queryFromFacet2.eResource());
        Assert.assertEquals((Object)EmfFacetResourceSet.getResourceSetSingleton(), (Object)queryFromFacet2.eResource().getResourceSet());
        Assert.assertEquals((Object)queryFromFacet2.eResource().getURI(), (Object)modelQuery.eResource().getURI());
        Assert.assertEquals((Object)queryFromFacet2.eResource().getResourceSet(), (Object)modelQuery.eResource().getResourceSet());
        Assert.assertEquals((Object)queryFromFacet2, (Object)modelQuery);
        Assert.assertEquals((Object)"bis", (Object)modelQuery.getDescription());
    }

    @Test
    public void test003() throws Exception {
        IProject projectToCreate = this.utils.createProject("test003");
        IFile queryFile = FileUtils.copyFileFromBundle((String)"resources/test003.querySet", (IProject)projectToCreate, (String)"/test003.querySet", (Bundle)Activator.getDefault().getBundle());
        IFile facetFile = FileUtils.copyFileFromBundle((String)"resources/test003.facetSet", (IProject)projectToCreate, (String)"/test003.facetSet", (Bundle)Activator.getDefault().getBundle());
        IFile ecoreFile = FileUtils.copyFileFromBundle((String)"resources/test003.ecore", (IProject)projectToCreate, (String)"/test003.ecore", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)projectToCreate);
        FileUtils.checkNoMarkerOn((IFile)queryFile);
        FileUtils.checkNoMarkerOn((IFile)ecoreFile);
        FileUtils.checkNoMarkerOn((IFile)facetFile);
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("test003");
        Assert.assertNotNull((Object)facetSet);
        Facet facet = facetSet.getFacet("EPackageFacet");
        FacetReference attribute = (FacetReference)facet.getEStructuralFeature("nbEClassifiers");
        ModelQuery queryFromFacet1 = attribute.getValueQuery();
        Assert.assertFalse((boolean)((EClass)queryFromFacet1.getReturnType()).isAbstract());
        String mmNsUri = queryFromFacet1.getReturnType().getEPackage().getNsURI();
        Assert.assertFalse((boolean)queryFromFacet1.eIsProxy());
        FileUtils.copyFileFromBundle((String)"resources/test003bis.ecore", (IProject)projectToCreate, (String)"/test003.ecore", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)projectToCreate);
        FileUtils.checkNoMarkerOn((IFile)ecoreFile);
        EPackage epackage = EPackage.Registry.INSTANCE.getEPackage(mmNsUri);
        Assert.assertNotNull((Object)epackage);
        Assert.assertTrue((boolean)((EClass)epackage.getEClassifier("Test003Class")).isAbstract());
        FacetSet facetSet2 = FacetSetCatalog.getSingleton().getFacetSet("test003");
        Facet facet2 = facetSet2.getFacet("EPackageFacet");
        FacetReference attribute2 = (FacetReference)facet2.getEStructuralFeature("nbEClassifiers");
        ModelQuery queryFromFacet2 = attribute2.getValueQuery();
        Assert.assertTrue((boolean)((EClass)queryFromFacet2.getReturnType()).isAbstract());
    }

    @Test
    public void test004() throws Exception {
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("test004");
        Assert.assertNotNull((Object)facetSet);
        FacetContext context = new FacetContext();
        context.addFacetSet(facetSet);
        Facet facet = facetSet.getFacet("test004");
        FacetReference reference = (FacetReference)facet.getEStructuralFeature("test004Reference");
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        context.set((EObject)eClass, (FacetStructuralFeature)reference, (Object)"test004", (EditingDomain)editingDomain);
        Assert.assertTrue((boolean)eClass.getName().equals("test004"));
    }

    @Test
    public void wrongName() throws Exception {
        this.checkValidation("wrongName");
    }

    @Test
    public void wrongIsAbstract() throws Exception {
        IProject project = this.utils.createProject("wrongIsAbstract");
        FileUtils.copyFileFromBundle((String)"resources/validation/wrongIsAbstract.facetSet", (IProject)project, (String)"/wrongIsAbstract.facetSet", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/validation/wrongIsAbstract.querySet", (IProject)project, (String)"/wrongIsAbstract.querySet", (Bundle)Activator.getDefault().getBundle());
        this.wrongX("wrongIsAbstract", project, 1);
    }

    public void wrongAttrChangeable() throws Exception {
        String name = "wrongAttrChangeable";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EPackageFacet");
        facetSet.setName(name);
        FacetAttribute facetReference = (FacetAttribute)facet.getEStructuralFeature("nbEClassifiers");
        facetReference.setChangeable(true);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongAttrDerived() throws Exception {
        String name = "wrongRefDerived";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EPackageFacet");
        facetSet.setName(name);
        FacetAttribute facetReference = (FacetAttribute)facet.getEStructuralFeature("nbEClassifiers");
        facetReference.setDerived(false);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongAttrVolatile() throws Exception {
        String name = "wrongRefVolatile";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EPackageFacet");
        facetSet.setName(name);
        FacetAttribute facetReference = (FacetAttribute)facet.getEStructuralFeature("nbEClassifiers");
        facetReference.setVolatile(false);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongAttrUnsettable() throws Exception {
        String name = "wrongRefUnsettable";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EPackageFacet");
        facetSet.setName(name);
        FacetAttribute facetReference = (FacetAttribute)facet.getEStructuralFeature("nbEClassifiers");
        facetReference.setUnsettable(false);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongRefChangeable() throws Exception {
        String name = "wrongRefChangeable";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EClassFacet");
        facetSet.setName(name);
        FacetReference facetReference = (FacetReference)facet.getEStructuralFeature("subClasses");
        facetReference.setChangeable(true);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongRefDerived() throws Exception {
        String name = "wrongRefDerived";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EClassFacet");
        facetSet.setName(name);
        FacetReference facetReference = (FacetReference)facet.getEStructuralFeature("subClasses");
        facetReference.setDerived(false);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongRefVolatile() throws Exception {
        String name = "wrongRefVolatile";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EClassFacet");
        facetSet.setName(name);
        FacetReference facetReference = (FacetReference)facet.getEStructuralFeature("subClasses");
        facetReference.setVolatile(false);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongRefContainment() throws Exception {
        String name = "wrongRefVolatile";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EClassFacet");
        facetSet.setName(name);
        FacetReference facetReference = (FacetReference)facet.getEStructuralFeature("subClasses");
        facetReference.setContainment(true);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    public void wrongRefUnsettable() throws Exception {
        String name = "wrongRefUnsettable";
        IProject project = this.createWrongProjectFromTest001(name);
        URI uri = URI.createURI((String)("platform:/resource/" + name + "/" + name + FILE_EXT));
        Resource resource = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)resource.getContents().get(0);
        Facet facet = (Facet)facetSet.getEClassifier("EClassFacet");
        facetSet.setName(name);
        FacetReference facetReference = (FacetReference)facet.getEStructuralFeature("subClasses");
        facetReference.setUnsettable(false);
        resource.save(Collections.EMPTY_MAP);
        this.wrongX(name, project, 1);
    }

    @Test
    public void wrongNbOfSuperType() throws Exception {
        String name = "wrongNbOfSuperType";
        IProject project = this.utils.createProject(name);
        FileUtils.copyFileFromBundle((String)("resources/validation/" + name + FILE_EXT), (IProject)project, (String)("/" + name + FILE_EXT), (Bundle)Activator.getDefault().getBundle());
        this.wrongX(name, project, 1);
    }

    @Test
    public void emptyNsURI() throws Exception {
        this.checkValidation("emptyNsURI");
    }

    @Test
    public void emptyNsPrefix() throws Exception {
        this.checkValidation("emptyNsPrefix");
    }

    @Test
    public void emptyExtendedPackages() throws Exception {
        this.checkValidation("emptyExtendedPackages");
    }

    private void checkValidation(String name) throws Exception {
        IProject project = this.utils.createProject(name);
        FileUtils.copyFileFromBundle((String)("resources/validation/" + name + FILE_EXT), (IProject)project, (String)("/" + name + FILE_EXT), (Bundle)Activator.getDefault().getBundle());
        this.wrongX(name, project, 1);
    }

    private IProject createWrongProjectFromTest001(String name) throws Exception {
        IProject projectToCreate = this.utils.createProject(name);
        FileUtils.copyFileFromBundle((String)"resources/test001.querySet", (IProject)projectToCreate, (String)("/" + name + QUERY_EXT), (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/test001.facetSet", (IProject)projectToCreate, (String)("/" + name + FILE_EXT), (Bundle)Activator.getDefault().getBundle());
        this.changeQuerySetName(name, projectToCreate);
        this.changeFacetsetName(name, projectToCreate);
        return projectToCreate;
    }

    private void changeQuerySetName(String name, IProject project) throws IOException {
        URI uri = URI.createURI((String)("platform:/resource/" + project.getName() + "/" + name + QUERY_EXT));
        Resource r = this.resourceSet.getResource(uri, true);
        ModelQuerySet queryset = (ModelQuerySet)r.getContents().get(0);
        queryset.setName(name);
        r.save(Collections.EMPTY_MAP);
    }

    private void changeFacetsetName(String name, IProject project) throws IOException {
        URI uri = URI.createURI((String)("platform:/resource/" + project.getName() + "/" + name + FILE_EXT));
        Resource r = this.resourceSet.getResource(uri, true);
        FacetSet facetSet = (FacetSet)r.getContents().get(0);
        facetSet.setName(name);
        r.save(Collections.EMPTY_MAP);
    }

    private IMarker[] wrongX(String name, IProject project, int nbOfExpectedMarkers) throws CoreException, InterruptedException {
        return this.wrongX(name, project, nbOfExpectedMarkers, "org.eclipse.emf.ecore.diagnostic");
    }

    private IMarker[] wrongX(String name, IProject project, int nbOfExpectedMarkers, String markerType) throws CoreException, InterruptedException {
        ProjectUtils.refresh((IProject)project);
        IMarker[] markers = null;
        FacetSetCatalog catalog = FacetSetCatalog.getSingleton();
        if (nbOfExpectedMarkers != 0) {
            Assert.assertNull((Object)catalog.getFacetSet(name));
        }
        IFile file = project.getFile(String.valueOf(name) + FILE_EXT);
        markers = file.findMarkers(markerType, true, 2);
        Assert.assertEquals((String)("Wrong number of markers. Markers:\n" + this.printMarkers(markers)), (long)nbOfExpectedMarkers, (long)markers.length);
        return markers;
    }

    private IMarker[] expectXMarkers(String name, IProject project, int nbOfExpectedMarkers) throws CoreException, InterruptedException {
        ProjectUtils.refresh((IProject)project);
        IMarker[] markers = null;
        FacetSetCatalog catalog = FacetSetCatalog.getSingleton();
        if (nbOfExpectedMarkers != 0) {
            Assert.assertNull((Object)catalog.getFacetSet(name));
        }
        IFile file = project.getFile(String.valueOf(name) + FILE_EXT);
        markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        Assert.assertEquals((String)("Wrong number of markers. Markers:\n" + this.printMarkers(markers)), (long)nbOfExpectedMarkers, (long)markers.length);
        return markers;
    }

    private String printMarkers(IMarker[] markers) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            builder.append("[").append(i).append("]").append(MarkerUtilities.getMessage((IMarker)marker)).append(" (on ").append(marker.getResource().getFullPath()).append(")").append("\n");
            ++i;
            ++n2;
        }
        return builder.toString();
    }

    @Test
    public void compo() throws Exception {
        IProject projectToCreate = this.utils.createProject("compo");
        IFile facetFile = FileUtils.copyFileFromBundle((String)"resources/compo.facetSet", (IProject)projectToCreate, (String)"/compo.facetSet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)projectToCreate);
        FileUtils.checkNoMarkerOn((IFile)facetFile);
        URI uriR1 = URI.createURI((String)"platform:/resource/compo/r1.xmi");
        Resource r1 = this.resourceSet.createResource(uriR1);
        EClass eClass1 = EcoreFactory.eINSTANCE.createEClass();
        eClass1.setName("eClass1");
        r1.getContents().add((Object)eClass1);
        r1.save(Collections.EMPTY_MAP);
        URI uriR2 = URI.createURI((String)"platform:/resource/compo/r2.xmi");
        Resource r2 = this.resourceSet.createResource(uriR2);
        EEnum eEnum1 = EcoreFactory.eINSTANCE.createEEnum();
        eEnum1.setName("eEnum2");
        r2.getContents().add((Object)eEnum1);
        r2.save(Collections.EMPTY_MAP);
        URI compModelUri = URI.createURI((String)"platform:/resource/compo/compo.xmi");
        Resource compoModel = this.resourceSet.createResource(compModelUri);
        EPackage compMmPackage = EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/EmfFacet/facet/test/compo");
        Assert.assertNotNull((Object)compMmPackage);
        EClass eClassToEEnum = (EClass)compMmPackage.getEClassifier("EClassToEEnum");
        Assert.assertNotNull((Object)compMmPackage.getEFactoryInstance());
        EObject eClassToEENumInst = compMmPackage.getEFactoryInstance().create(eClassToEEnum);
        eClassToEENumInst.eSet(eClassToEEnum.getEStructuralFeature("toEEnum"), (Object)eEnum1);
        eClassToEENumInst.eSet(eClassToEEnum.getEStructuralFeature("toEClass"), (Object)eClass1);
        compoModel.getContents().add((Object)eClassToEENumInst);
        compoModel.save(Collections.EMPTY_MAP);
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("compo");
        FacetContext facetContext = new FacetContext();
        facetContext.addFacetSet(facetSet);
        facetContext.setResources(Collections.singleton(compoModel));
        Facet eClassExt = (Facet)facetSet.getEClassifier("ClassExt");
        Assert.assertNotNull((Object)eClassExt);
        Assert.assertNotNull((Object)eClassExt.getEStructuralFeature("toEClass2EEnum"));
        EObject eClass2EEnum1 = (EObject)facetContext.get((EObject)eClass1, eClassExt.getEStructuralFeature("toEClass2EEnum"));
        Assert.assertEquals((Object)compoModel.getContents().get(0), (Object)eClass2EEnum1);
        EObject toEEnum = (EObject)facetContext.get((EObject)eClass1, eClassExt.getEStructuralFeature("toEEnum"));
        Assert.assertEquals((Object)eEnum1, (Object)toEEnum);
        Facet eEnumExt = (Facet)facetSet.getEClassifier("EnumExt");
        EObject eClass2EEnum2 = (EObject)facetContext.get((EObject)eEnum1, eEnumExt.getEStructuralFeature("toEClass2EEnum"));
        Assert.assertEquals((Object)compoModel.getContents().get(0), (Object)eClass2EEnum2);
        EObject toEClass = (EObject)facetContext.get((EObject)eEnum1, eEnumExt.getEStructuralFeature("toEClass"));
        Assert.assertEquals((Object)eClass1, (Object)toEClass);
    }

    @Test
    public void bug301692() {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.facet.tests/resources/test001.facetSet");
        Resource r = this.resourceSet.getResource(uri, true);
        FacetSet fs = (FacetSet)r.getContents().get(0);
        Facet f = (Facet)fs.getFacets().get(0);
        Assert.assertEquals((Object)f.getFacetSet(), (Object)fs);
    }

    @Test
    public void bug305688() throws Exception {
        this.test001();
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("test001");
        URI uri = URI.createURI((String)"platform:/resource/test001/2test001.facetSet");
        Resource r = this.resourceSet.createResource(uri);
        r.getContents().add((Object)facetSet);
        r.save(Collections.EMPTY_MAP);
    }

    public void bug307715() throws CoreException, IOException, InterruptedException {
        final ArrayList statusList = new ArrayList();
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                statusList.add(status);
            }
        };
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.emf.facet.infra.facet.core"));
        log.addLogListener(listener);
        ProjectUtils.importPlugin((Bundle)Platform.getBundle((String)"org.eclipse.emf.facet.java.queries"), (IFilter)new IFilter(){

            public boolean filter(Object object) {
                boolean result = true;
                if (object instanceof File) {
                    File file = (File)object;
                    result = !file.getName().equals(".checkstyle");
                } else if (object instanceof String) {
                    String str = (String)object;
                    result = !str.equals(".checkstyle");
                }
                return result;
            }
        });
        log.removeLogListener(listener);
        if (!statusList.isEmpty()) {
            MultiStatus status = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 4, statusList.toArray(new IStatus[0]), "Test failed.", (Throwable)new Exception());
            throw new CoreException((IStatus)status);
        }
    }

    public void bug307715v2() throws CoreException, IOException, InterruptedException {
        final ArrayList statusList = new ArrayList();
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                statusList.add(status);
            }
        };
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.emf.facet.infra.facet.core"));
        log.addLogListener(listener);
        ResourcesPlugin.getWorkspace().getRoot().delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)new NullProgressMonitor());
        this.joinJobs();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.emf.facet.java.queries");
        ProjectUtils.create((IProject)project, (IProgressMonitor)new NullProgressMonitor());
        Bundle javaQueriesBundle = Platform.getBundle((String)"org.eclipse.emf.facet.java.queries");
        FileUtils.copyFileFromBundle((String)"META-INF/MANIFEST.MF", (IProject)project, (String)"META-INF/MANIFEST.MF", (Bundle)javaQueriesBundle);
        FolderUtils.copyFolderFromBundle((String)"/src", (Bundle)javaQueriesBundle, (String)"/src", (IProject)project);
        FileUtils.copyFileFromBundle((String)"textJavaQueries.querySet", (IProject)project, (String)"/textJavaQueries.querySet", (Bundle)javaQueriesBundle);
        IFile f = project.getFile("textJavaQueries.querySet");
        ModelQuerySetCatalog.getSingleton().scheduleAddWSFile(f);
        ModelQuerySetCatalog.getSingleton().scheduleRemoveWSFile(f);
        FacetSetCatalog.getSingleton();
        log.removeLogListener(listener);
        if (!statusList.isEmpty()) {
            MultiStatus status = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 4, statusList.toArray(new IStatus[0]), "Test failed.", (Throwable)new Exception());
            CoreException e = new CoreException((IStatus)status);
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            throw e;
        }
    }

    @Test
    public void bug304798() throws Exception {
        String name = "bug304798";
        Bundle bundle = Activator.getDefault().getBundle();
        IProject project = ProjectUtils.createTestProject((String)name, (Bundle)bundle, (String)".");
        IFile queryFile = FileUtils.copyFileFromBundle((String)("/resources/" + name + QUERY_EXT), (IProject)project, (String)("/" + name + QUERY_EXT), (Bundle)bundle);
        IFile facetFile = FileUtils.copyFileFromBundle((String)("/resources/" + name + FILE_EXT), (IProject)project, (String)("/" + name + FILE_EXT), (Bundle)bundle);
        ProjectUtils.refresh((IProject)project);
        FileUtils.checkNoMarkerOn((IFile)queryFile);
        FileUtils.checkNoMarkerOn((IFile)facetFile);
        project.getFile(String.valueOf(name) + QUERY_EXT).delete(true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        IMarker[] markers = facetFile.findMarkers(AbstractEmfFacetCatalog.BROKEN_REF_MARKER, true, 2);
        Assert.assertTrue((markers.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void bug308614() throws Exception {
        String name = "bug308614";
        Bundle bundle = Activator.getDefault().getBundle();
        IProject project = ProjectUtils.createTestProject((String)name, (Bundle)bundle, (String)".");
        FileUtils.copyFileFromBundle((String)("/resources/" + name + "_1" + FILE_EXT), (IProject)project, (String)("/" + name + "_1" + FILE_EXT), (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)("/resources/" + name + "_2" + FILE_EXT), (IProject)project, (String)("/" + name + "_2" + FILE_EXT), (Bundle)bundle);
        ProjectUtils.refresh((IProject)project);
        IFile facetFile1 = project.getFile(String.valueOf(name) + "_1" + FILE_EXT);
        IMarker[] markers1 = facetFile1.findMarkers(EcoreCatalog.NS_URI_CONFLICT_MARKER, true, 2);
        IFile facetFile2 = project.getFile(String.valueOf(name) + "_2" + FILE_EXT);
        IMarker[] markers2 = facetFile2.findMarkers(EcoreCatalog.NS_URI_CONFLICT_MARKER, true, 2);
        Assert.assertEquals((long)1L, (long)(markers1.length + markers2.length));
        project.build(15, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        this.joinJobs();
        markers1 = facetFile1.findMarkers(EcoreCatalog.NS_URI_CONFLICT_MARKER, true, 2);
        markers2 = facetFile2.findMarkers(EcoreCatalog.NS_URI_CONFLICT_MARKER, true, 2);
        Assert.assertEquals((long)1L, (long)(markers1.length + markers2.length));
    }

    public void bug308947() throws CoreException, IOException, InterruptedException {
        final ArrayList statusList = new ArrayList();
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                statusList.add(status);
            }
        };
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.emf.facet.infra.facet.core"));
        log.addLogListener(listener);
        String pluginName = "org.eclipse.emf.facet.infra.browser.custom.examples.java.jdk";
        ProjectUtils.importPlugin((Bundle)Platform.getBundle((String)pluginName), (IFilter)new IFilter(){

            public boolean filter(Object object) {
                boolean result = true;
                if (object instanceof File) {
                    File file = (File)object;
                    result = !file.getName().equals(".checkstyle");
                } else if (object instanceof String) {
                    String str = (String)object;
                    result = !str.equals(".checkstyle");
                }
                return result;
            }
        });
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginName);
        ProjectUtils.refresh((IProject)project);
        project.close((IProgressMonitor)new NullProgressMonitor());
        this.joinJobs();
        project.open((IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        log.removeLogListener(listener);
        if (!statusList.isEmpty()) {
            MultiStatus status = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 4, statusList.toArray(new IStatus[0]), "Test failed.", (Throwable)new Exception());
            CoreException e = new CoreException((IStatus)status);
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            throw e;
        }
    }

    private void joinJobs() throws InterruptedException {
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_BUILD, null);
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
    }

    @Test
    public void bug309657() throws Exception {
        IProject project = this.utils.createProject("bug309657");
        FileUtils.copyFileFromBundle((String)"resources/bug309657.facetSet", (IProject)project, (String)"bug309657.facetSet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        IFolder folder = project.getFolder("f1");
        folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IFile sourceFile = project.getFile("bug309657.facetSet");
        IPath sourcePath = sourceFile.getFullPath();
        Path targetPath = new Path(folder.getFullPath() + "/" + "bug309657" + FILE_EXT);
        sourceFile.move((IPath)targetPath, true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)targetPath);
        IMarker[] markers = targetFile.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
        targetFile.move(sourcePath, true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        markers = sourceFile.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)markers.length);
    }

    @Test
    public void bug309990() throws Exception {
        String nsURI = "http://www.eclipse.org/EmfFacet/facet/bug309990";
        Assert.assertNull((Object)EPackage.Registry.INSTANCE.get((Object)nsURI));
        IProject project = ProjectUtils.createTestProject((String)"bug309990", (Bundle)Activator.getDefault().getBundle(), (String)".");
        FileUtils.copyFileFromBundle((String)"resources/bug309990.facetSet", (IProject)project, (String)"bug309990.facetSet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        Assert.assertNotNull((Object)EPackage.Registry.INSTANCE.get((Object)nsURI));
        FileUtils.copyFileFromBundle((String)"resources/bug309990_bis.facetSet", (IProject)project, (String)"bug309990.facetSet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        Assert.assertNotNull((Object)EPackage.Registry.INSTANCE.get((Object)(String.valueOf(nsURI) + "_bis")));
        Assert.assertNull((Object)EPackage.Registry.INSTANCE.get((Object)nsURI));
        project.getFile("bug309990.facetSet").delete(true, (IProgressMonitor)new NullProgressMonitor());
        ProjectUtils.refresh((IProject)project);
        Assert.assertNull((Object)EPackage.Registry.INSTANCE.get((Object)(String.valueOf(nsURI) + "_bis")));
    }

    @Test
    public void bug310279() throws Exception {
        IProject project = this.utils.createProject("310279");
        FileUtils.copyFileFromBundle((String)"src/org/eclipse/emf/facet/infra/facet/tests/internal/queries/Bug310279.java", (IProject)project, (String)"src/org/eclipse/emf/facet/infra/facet/tests/internal/queries/Bug310279.java", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/bug310279_1.facetSet", (IProject)project, (String)"bug310279_1.facetSet", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/bug310279_2.facetSet", (IProject)project, (String)"bug310279_2.facetSet", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/bug310279.querySet", (IProject)project, (String)"bug310279.querySet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        this.joinJobs();
        this.expectXMarkers("bug310279_1", project, 0);
        this.expectXMarkers("bug310279_2", project, 0);
        FileUtils.copyFileFromBundle((String)"resources/bug310279_2.querySet", (IProject)project, (String)"bug310279.querySet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        this.joinJobs();
        this.expectXMarkers("bug310279_1", project, 1);
        this.expectXMarkers("bug310279_2", project, 1);
    }

    @Test
    public void bug310279_3() throws Exception {
        if (Platform.inDebugMode()) {
            System.out.println("--- bug310279 ---");
        }
        IProject project = this.utils.createProject("310279");
        FileUtils.copyFileFromBundle((String)"resources/bug310279_1.facetSet", (IProject)project, (String)"bug310279_1.facetSet", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/bug310279_2.facetSet", (IProject)project, (String)"bug310279_2.facetSet", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/bug310279_3.querySet", (IProject)project, (String)"bug310279.querySet", (Bundle)Activator.getDefault().getBundle());
        if (Platform.inDebugMode()) {
            System.out.println("--- bug310279 -> refresh ---");
        }
        ProjectUtils.refresh((IProject)project);
        this.joinJobs();
        IFile query = project.getFile("bug310279.querySet");
        IMarker[] queryFileMarkers = query.findMarkers(AbstractEmfFacetCatalog.PROBLEM_MARKER, true, 2);
        Assert.assertEquals((long)0L, (long)queryFileMarkers.length);
        FacetSet fs1 = FacetSetCatalog.getSingleton().getFacetSet("bug310279_1");
        Assert.assertNotNull((Object)fs1);
        FacetSet fs2 = FacetSetCatalog.getSingleton().getFacetSet("bug310279_2");
        Assert.assertNotNull((Object)fs2);
        if (Platform.inDebugMode()) {
            System.out.println("--- update ---");
        }
        FileUtils.copyFileFromBundle((String)"resources/bug310279_2.querySet", (IProject)project, (String)"bug310279.querySet", (Bundle)Activator.getDefault().getBundle());
        ProjectUtils.refresh((IProject)project);
        this.joinJobs();
        this.wrongX("bug310279_1", project, 1, AbstractEmfFacetCatalog.BROKEN_REF_MARKER);
        this.wrongX("bug310279_2", project, 1, AbstractEmfFacetCatalog.BROKEN_REF_MARKER);
    }

    @Test
    public void bug311684() throws Exception {
        IProject project = this.utils.createProject("311684");
        FileUtils.copyFileFromBundle((String)"src/org/eclipse/emf/facet/infra/facet/tests/internal/queries/Bug311684.java", (IProject)project, (String)"src/org/eclipse/emf/facet/infra/facet/tests/internal/queries/Bug311684.java", (Bundle)Activator.getDefault().getBundle());
        IFile queryFile = FileUtils.copyFileFromBundle((String)"resources/bug311684_workspace.querySet", (IProject)project, (String)"bug311684.querySet", (Bundle)Activator.getDefault().getBundle());
        FileUtils.copyFileFromBundle((String)"resources/bug311684.facetSet", (IProject)project, (String)"bug311684.facetSet", (Bundle)Activator.getDefault().getBundle());
        FacetSetCatalog.getSingleton().waitUntilBuilt();
        this.wrongX("bug311684", project, 1, "org.eclipse.core.resources.problemmarker");
        queryFile.delete(false, (IProgressMonitor)new NullProgressMonitor());
        FacetSetCatalog.getSingleton().waitUntilBuilt();
        this.wrongX("bug311684", project, 0, "org.eclipse.core.resources.problemmarker");
    }
}

