/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.swtbot;

import java.util.List;
import net.sourceforge.nattable.NatTable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.tests.swtbot.SWTBotNatTable;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.VisibilityKind;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bug352822Test {
    private static final int TIMEOUT = 30000;
    private static final int PREF_TIMEOUT = 5000;
    private static final int PREF_TYPE_INTERVAL = 10;
    private static final String PROJECT_NAME = "Bug352822";
    private static final String UML_FILE_NAME = "Bug352822.uml";

    @BeforeClass
    public static void beforeClass() throws Exception {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
        SWTBotUtils.deleteAllProjects();
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/Bug352822/Bug352822.uml", (IProject)testProject, (String)"/Bug352822.uml", (Bundle)bundle);
    }

    @Before
    public void beforeTest() throws Exception {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
    }

    @Test(timeout=30000L)
    @Ignore
    public void testBug352822() throws Exception {
        final SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openUMLEditor();
        SWTBotTree tree = bot.editorByTitle(UML_FILE_NAME).bot().tree();
        SWTBotTreeItem classNode = tree.getAllItems()[0].expand().expandNode(new String[]{"<Model>"}).getNode("<Class> MyClass");
        classNode.select();
        classNode.contextMenu("Edit in a table editor").click();
        bot.toolbarButtonWithTooltip("Load an EMF Facet").click();
        bot.tree().expandNode(new String[]{PROJECT_NAME}).getNode("Bug352822_enum").check();
        bot.button("OK").click();
        bot.toolbarButtonWithTooltip("Select columns to hide").click();
        SWTBotUtils.captureScreenShot((String)"_1a columns to hide");
        this.deselectAll();
        SWTBotUtils.captureScreenShot((String)"_1b clicked Deselect All");
        bot.table().getTableItem("facetEnum").check();
        bot.table().getTableItem("name").check();
        bot.button("OK").click();
        EObject eObject = (EObject)UIThreadRunnable.syncExec((Result)new Result<EObject>(){

            public EObject run() {
                INatTableWidgetInternal natTableWidget = (INatTableWidgetInternal)bot.widget(WidgetMatcherFactory.widgetOfType(NatTableWidget.class));
                return (EObject)natTableWidget.getTableInstance().getElements().get(0);
            }
        });
        Class umlClass = (Class)eObject;
        Assert.assertEquals((Object)"MyClass", (Object)umlClass.getName());
        this.getNatTable().doubleClick(1, 2);
        SWTBotUtils.captureScreenShot((String)"_2 cell editor opened");
        bot.comboBox().setText("");
        bot.comboBox().typeText("composite");
        SWTBotUtils.captureScreenShot((String)"_3 typed \"composite\"");
        this.hitEnter((AbstractSWTBot<?>)bot.comboBox());
        SWTBotUtils.captureScreenShot((String)"_4 closed cell editor");
        Assert.assertEquals((Object)"composite", (Object)umlClass.getName());
    }

    private void deselectAll() {
        SWTWorkbenchBot bot1 = new SWTWorkbenchBot();
        SWTBotShell shell = bot1.shell("Select columns to show/hide");
        System.out.println("Shell text: " + shell.getText());
        shell.activate();
        System.out.println("Shell text after activate: " + shell.getText());
        SWTBot bot = bot1.shell("Select columns to show/hide").bot();
        final List buttons = bot.widgets(WidgetMatcherFactory.allOf((Matcher[])new Matcher[]{WidgetMatcherFactory.widgetOfType(Button.class), WidgetMatcherFactory.withStyle((int)8, (String)"SWT.PUSH")}));
        final Button[] result = new Button[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (Button button : buttons) {
                    if (!button.getText().replaceAll("\\&", "").contains("Deselect All")) continue;
                    result[0] = button;
                    break;
                }
            }
        });
        if (result[0] == null) {
            throw new WidgetNotFoundException("Deselect All button not found");
        }
        new SWTBotButton(result[0]).click();
    }

    @Test(timeout=30000L)
    @Ignore
    public void testFacetAttributeEdition() {
        final SWTWorkbenchBot bot = new SWTWorkbenchBot();
        this.openUMLEditor();
        SWTBotTree tree = bot.editorByTitle(UML_FILE_NAME).bot().tree();
        SWTBotTreeItem classNode = tree.getAllItems()[0].expand().expandNode(new String[]{"<Model>"}).getNode("<Class> MyClass");
        classNode.select();
        classNode.contextMenu("Edit in a table editor").click();
        bot.toolbarButtonWithTooltip("Load an EMF Facet").click();
        bot.tree().expandNode(new String[]{PROJECT_NAME}).getNode("Bug352822_visibilitySymbol").check();
        bot.button("OK").click();
        bot.toolbarButtonWithTooltip("Select columns to hide").click();
        SWTBotUtils.captureScreenShot((String)"1 columns to hide 2");
        this.deselectAll();
        SWTBotUtils.captureScreenShot((String)"2 clicked Deselect All");
        bot.table().getTableItem("visibility").check();
        bot.table().getTableItem("visibilitySymbol").check();
        bot.button("OK").click();
        EObject eObject = (EObject)UIThreadRunnable.syncExec((Result)new Result<EObject>(){

            public EObject run() {
                INatTableWidget natTableWidget = (INatTableWidget)bot.widget(WidgetMatcherFactory.widgetOfType(NatTableWidget.class));
                return (EObject)natTableWidget.getTableInstance().getElements().get(0);
            }
        });
        Class umlClass = (Class)eObject;
        Assert.assertEquals((Object)VisibilityKind.PUBLIC_LITERAL, (Object)umlClass.getVisibility());
        this.getNatTable().doubleClick(1, 2);
        SWTBotText text = bot.text("+");
        text.typeText("#");
        this.hitEnter((AbstractSWTBot<?>)text);
        Assert.assertEquals((Object)VisibilityKind.PROTECTED_LITERAL, (Object)umlClass.getVisibility());
    }

    @After
    public void afterTest() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }

    private void openUMLEditor() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IFile umlFile = ResourcesPlugin.getWorkspace().getRoot().getProject(Bug352822Test.PROJECT_NAME).getFile(Bug352822Test.UML_FILE_NAME);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)umlFile, (String)"org.eclipse.uml2.uml.editor.presentation.UMLEditorID");
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private SWTBotNatTable getNatTable() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        NatTable nt = (NatTable)bot.widget(WidgetMatcherFactory.widgetOfType(NatTable.class));
        return new SWTBotNatTable(nt);
    }

    private void hitEnter(final AbstractSWTBot<?> widget) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 13;
                e.stateMask = 0;
                widget.widget.notifyListeners(1, e);
            }
        });
    }
}

