/*******************************************************************************
 * Copyright (c) 2010, 2011, 2012 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *    Nicolas Bros (Mia-Software) - Bug 332437 - NatTable : pluggable cell editors
 *    Nicolas Guyomar (Mia-Software) - Bug 331442 - To be able to add and remove lines (model elements) from the table
 *    Nicolas Bros (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Bros (Mia-Software) - Bug 332438 - NatTable : table type
 *    Nicolas Bros (Mia-Software) - Bug 332440 - NatTable : force cell editors
 *    Nicolas Bros (Mia-Software) - Bug 331675 - NatTable : copy cells as text 
 *    Nicolas Bros (Mia-Software) - Bug 331900 - customizable NatTable
 *    Nicolas Bros (Mia-Software) - Bug 332010 - view Facet customizations on NatTable
 *    Nicolas Bros (Mia-Software) - Bug 332215 - customizable NatTable column headers
 *    Nicolas Guyomar (Mia-Software) - Bug 332215 - customizable NatTable column headers
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Nicolas Guyomar (Mia-Software) - Bug 333414 - The user must be able to save the column order
 *    Nicolas Guyomar (Mia-Software) - Bug 335154 - Sort Column By Type : Cannot modify resource set without a write transaction
 *    Nicolas Guyomar (Mia-Software) - Bug 335155 - Hide Empty Column : Cannot modify resource set without a write transaction
 *    Nicolas Guyomar (Mia-Software) - Bug 335156 - Only Show Common column : Cannot modify resource set without a write transaction
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 337322 - [TableConfiguration] Customization declared in the file tableconfiguration is not loaded
 *    Nicolas Guyomar (Mia-Software) - Bug 338536 - Problem with the refresh of the table : the scrollbar returns to this initial position
 *    Nicolas Bros (Mia-Software) - Bug 338536 - Problem with the refresh of the table : the scrollbar returns to this initial position
 *    Nicolas Guyomar (Mia-Software) - Bug 337454 - We can't delete a query Column
 *    Nicolas Guyomar (Mia-Software) - Bug 337395 - Unused columns should be destroyed
 *    Nicolas Guyomar (Mia-Software) - Bug 339554 - org.eclipse.emf.facet.widgets.celleditors API cleaning
 *    Nicolas Guyomar (Mia-Software) - Bug 339922 - INatTableWidget method isCellSelected should use the plural
 *    Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *    Vincent Lorenzo (CEA-LIST) - Bug 337326 - Show/Hide Column : Sort the columns by name 
 *    Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *    Vincent Lorenzo (CEA-LIST) - Bug 337408 - Add an action to sort columns by name 
 *    Nicolas Guyomar (Mia-Software) - Bug 336482 - KeyBinding to edit element in Table : F2 
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Gregoire Dupe (Mia-Software) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 343411 - [Table] Create new elements does not support IJavaModelQuery anymore
 *    Gregoire Dupe (Mia-Software) - Bug 343811 - EMF Facet Regression : Created elements in a table are not serialized
 *    Vincent Lorenzo (CEA-LIST) - Bug 344125 - The API should provide a method selectRows(List<EObject> elementsToSelect)
 *    Nicolas Guyomar (Mia-Software) - Bug 344274 - SWT BOT fail on Hudson
 *    Nicolas Guyomar (Mia-Software) - Bug 344475 - To be able to select a cell by EStructuralFeature in the table
 *    Nicolas Guyomar (Mia-Software) - Bug 342028 - Field can be edited even if they are marked as N/A
 *    Nicolas Guyomar (Mia-Software) - Bug 344413 - Facet Columns are never created when we begin with an empty table
 *    Gregoire Dupe (Mia-Software) - Bug 343859 - The local customizations are not applied when we reopen a table
 *    Nicolas Guyomar (Mia-Software) - Bug 344670 - Problems with the columns creation : very slow + scrollbar blinked
 *    Vincent Lorenzo (CEA LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 344925 - Undo/Redo after the action Show Columns
 *    Gregoire Dupe (Mia-Software) - Bug 344925 - Undo/Redo after the action Show Columns - Regression fix
 *    Nicolas Guyomar (Mia-Software) - Bug 345665 - Columns are duplicated when you drop many elements in the same time
 *    Nicolas Guyomar (Mia-Software) - Bug 346465 - [EMF Facet Table] Remove line does not remove obsolete column
 *    Gregoire Dupe (Mia-Software) - Bug 345730 - Deleting an element in the model breaks the table
 *    Gregoire Dupe (Mia-Software) - Bug 354224 - mutually exclusive Facets
 *    Grgoire Dup (Mia-Software) - Bug 356795 - [Unit Test Failure][0.2/4.2][0.2/3.8] org.eclipse.emf.facet.widgets.nattable.tests.Bug344413Test.testBug344413
 *    Gregoire Dupe (Mia-Software) - Bug 366804 - [Restructuring] Table widget upgrade
 *    Gregoire Dupe (Mia-Software) - Bug 367613 - Table widget refactoring
 *    Gregoire Dupe (Mia-Software) - Bug 367700 - [Unit Test Failure][0.2/3.8] org.eclipse.emf.facet.widgets.table.tests.internal.v0_2.swtbot.NatTableUITests.testOpenLoadCustomizationDialog
 *    Gregoire Dupe (Mia-Software) - Bug 369987 - [Restructuring][Table] Switch to the new customization and facet framework
 *    Gregoire Dupe (Mia-Software) - Bug 373078 - API Cleaning
 *    Gregoire Dupe (Mia-Software) - Bug 375087 - [Table] ITableWidget.addColumn(List<ETypedElement>, List<FacetSet>)
 *    Gregoire Dupe (Mia-Software) - Bug 372626 - Aggregates
 *    Gregoire Dupe (Mia-Software) - Bug 376158 - [Table] Unexpected columns when customizations are loaded
 *    Nicolas Bros (Mia-Software) - Bug 378475 - unit test failures after table refactoring
 *    Olivier Remaud (Soft-Maint) - Bug 378499 - optimizing table opening
 *    Gregoire Dupe (Mia-Software) - Bug 387008 - [Table] Papyrus needs methods provided by TableInstanceCommandFactory
 *    Gregoire Dupe (Mia-Software) - Bug 388422 - [Table] Queries for InstanciationMethod needs to have 2 parameters
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomFactory;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.CustomPackage;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.ICustomizationCommandFactoryFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.IsOneOfQuery;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.query.QueryPackage;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.EmfDebugUtils;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResult;
import org.eclipse.emf.facet.util.emf.core.command.ICommandFactoryResultFactory;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.ui.internal.command.TableCommandFactoryFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IPositionCoordinate;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.MultiModelQueryException;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class TableInstanceCommandFactory {
	
	protected static final boolean DEBUG = DebugUtils.getDebugStatus(Activator.getDefault());

	/**
	 * 
	 * @param natTableWidget
	 * @return
	 * @throws CoreException can be caused by query error in the facet framework
	 */
	public static Command createDeleteSelectedElementsCommand(final TableWidgetController natTableWidget,
			final ICommandFactory commandFactory) throws CoreException {
		Set<EObject> toDelete = new HashSet<EObject>();
		List<Object> rawSelection = natTableWidget.getRawSelection();
		for (Object selectedElement : rawSelection) {
			if (selectedElement instanceof IGridElement) {
				IGridElement gridElement = (IGridElement) selectedElement;
				try {
					Object value = TableWidgetUtils.getValueOf(gridElement, natTableWidget.getFacetContext());
					if (value instanceof EObject) {
						EObject eObject = (EObject) value;
						toDelete.add(eObject);
					}
				} catch (FacetManagerException e) {
					Logger.logError("Error getting the value of a grid element to delete", Activator.getDefault()); //$NON-NLS-1$
				}
			}
		}
		
		CompoundCommand compoundCommand = new CompoundCommand();
		for (EObject eObjectToDelete : toDelete) {
			Command deleteCommand = commandFactory.createDeleteCommand(natTableWidget.getEditingDomain(), eObjectToDelete);
			compoundCommand.append(deleteCommand);
		}
		
		DebugUtils.debug(TableInstanceCommandFactory.DEBUG, "compoundCommand.canExecute()=" + compoundCommand.canExecute()); //$NON-NLS-1$
		return compoundCommand;
	}
	
	public static Command createShowHideColumnCommand(final TableWidgetController widgetController,
			final List<Column> columnsToShow, final List<Column> columnsToHide,
			final boolean putOnTheTop) {
		CompoundCommand compoundCommand = new CompoundCommand("Show/hide column"); //$NON-NLS-1$
		EditingDomain editingDomain = widgetController.getEditingDomain();
		ICommandFactory commandFactory = widgetController.getCommandFactory();
		
			for (Column current : columnsToShow) {
			if (current instanceof SourceColumn) {
					Command cmd = commandFactory.createSetCommand(editingDomain, current,
						TablePackage.eINSTANCE.getSourceColumn_IsHidden(), Boolean.FALSE);
					if (cmd.canExecute()) {
						compoundCommand.append(cmd);
					}
				}
			}
			HashSet<FeatureColumn> fColumnsToHide = new HashSet<FeatureColumn>();
			for (Column current : columnsToHide) {
				if (current instanceof FeatureColumn) {
					fColumnsToHide.add((FeatureColumn) current);
				} else {
				Command cmd = commandFactory
						.createSetCommand(widgetController.getEditingDomain(),
								current, TablePackage.eINSTANCE
										.getSourceColumn_IsHidden(), Boolean.TRUE);
					compoundCommand.append(cmd);
				}
			}
		Command tmp = createHideColumnCommand(widgetController, fColumnsToHide);
			if (tmp != null) {
				compoundCommand.append(tmp);
			}
		if (putOnTheTop) {
			Command cmd = createPutLocalCustomizationOnTheTopCommand(widgetController);
			if (cmd.canExecute()) {
				compoundCommand.append(cmd);
			}
		}
		return compoundCommand;
	}

	public static Command createPutLocalCustomizationOnTheTopCommand(
			final TableWidgetController natTableWidget) {
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		List<Customization> localCustoms = natTableWidget.getLocalCustomizations();
		List<Customization> customizations = new ArrayList<Customization>();
		customizations.addAll(natTableWidget.getTable().getCustomizations());
		customizations.removeAll(localCustoms);
		customizations.addAll(0, localCustoms);
		return commandFactory.createSetCommand(natTableWidget.getEditingDomain(),
				natTableWidget.getTable(),
				TablePackage.eINSTANCE.getTable_Customizations(),
				customizations);
	}

	public static CompoundCommand createDropCommand(final TableWidgetController natTableWidget,
			final IStructuredSelection structuredSelection, final Object element,
			final EStructuralFeature feature) {
		EditingDomain editingDomain = natTableWidget.getEditingDomain();
		if (editingDomain == null) {
			return null;
		}
		ICommandFactory commandFactory = natTableWidget.getCommandFactory();
		CompoundCommand compoundCommand = new CompoundCommand();
		if (feature.isMany()) {
			Iterator<?> iterator = structuredSelection.iterator();
			while (iterator.hasNext()) {
				Object object = iterator.next();
				Command addCommand = commandFactory.createAddCommand(editingDomain, element,
						feature, object);
				compoundCommand.append(addCommand);
			}
		} else {
			if (structuredSelection.toList().size() == 1) {
				Object firstElement = structuredSelection.getFirstElement();
				Command addCommand = commandFactory.createSetCommand(editingDomain, element,
						feature, firstElement);
				compoundCommand.append(addCommand);
			}
		}
		return compoundCommand;
	}

	/**
	 * 
	 * @param column
	 *            a column
	 * @param isHidden
	 *            the new feature value for this column
	 * @param customizedFeatureName
	 *            the customized feature name
	 * @return
	 */
	public static Command createHideColumnCommand(final TableWidgetController widgetController,
			final Collection<FeatureColumn> featureColumns) {
		final FacetOperation isVisibleProperty = widgetController
				.getCustomPropertiesHandler().getIsVisible();
		final CompoundCommand resultCmd = new CompoundCommand("Show/hide column"); //$NON-NLS-1$
		final EditingDomain editingDomain = widgetController.getEditingDomain();
		final ICommandFactory commandFactory = ICommandFactoriesRegistry.INSTANCE
				.getCommandFactoryFor(editingDomain);
//		final EStructuralFeature featureOfTheColumn = featureColumn
//				.getFeature();
//		EObject packageLevel = featureOfTheColumn.eContainer().eContainer();
//		if (!(packageLevel instanceof EPackage)) {
//			throw new IllegalStateException(
//					"Unexpected feature container type " + packageLevel + " found. (EPackage is execpected)"); //$NON-NLS-1$ //$NON-NLS-2$
//		}
//		final EPackage customizedEPackage = (EPackage) packageLevel;
		// 1 we look for the corresponding customization
		final List<Customization> localCustomizations = widgetController.getTable()
				.getLocalCustomizations();
		Customization customization = null;
		if (!localCustomizations.isEmpty()) {
			customization = localCustomizations.get(0);
		}
		final ICustomizationCommandFactory customCmdFactory = ICustomizationCommandFactoryFactory.DEFAULT
				.createCustomizationCommandFactory(editingDomain, commandFactory);
		// If the wanted customization does not exist then we create it.
		if (customization == null) {
			final TableCommandFactory factory = new TableCommandFactory(
					widgetController.getTable(),
					widgetController.getEditingDomain(), commandFactory, null);
			final ICommandFactoryResult<Customization> cmdFactoryResult = factory
					.createCreateLocalCustom(EcorePackage.eINSTANCE);
			customization = cmdFactoryResult.getResult();
			resultCmd.append(cmdFactoryResult.getCommand());
		}
		Facet typeCustomization = CustomizationUtils
				.findFacetByExtendedMetaclass(
						FacetUtils.getFacets(customization),
						EcorePackage.eINSTANCE.getETypedElement());
		IsOneOfQuery conformanceQuery;
		if (typeCustomization == null) {
			conformanceQuery = QueryFactory.eINSTANCE.createIsOneOfQuery();
			ICommandFactoryResult<EClassCustomization> createEClassCustom = customCmdFactory
					.createEClassCustomization(customization,
							EcorePackage.eINSTANCE.getETypedElement(),
							conformanceQuery);
			typeCustomization = createEClassCustom.getResult();
			resultCmd.append(createEClassCustom.getCommand());
		} else {
			if (!(typeCustomization instanceof EClassCustomization)) {
				throw new TableWidgetRuntimeException(
						"Unexpected type for the variable 'featureContainer'"); //$NON-NLS-1$
			}
			DerivedTypedElement conformanceTE = (DerivedTypedElement) typeCustomization.getConformanceTypedElement();
			conformanceQuery = (IsOneOfQuery) conformanceTE.getQuery();
		}
		final HashSet<ETypedElement> featuresToHide = new HashSet<ETypedElement>();
		for (FeatureColumn column : featureColumns) {
			featuresToHide.add(column.getFeature());
		}
		final Command initQuery = commandFactory.createSetCommand(editingDomain,
				conformanceQuery,
				QueryPackage.eINSTANCE.getIsOneOfQuery_ExpectedEObjects(),
				new ArrayList<ETypedElement>(featuresToHide));
		resultCmd.append(initQuery);
		final Query query = QueryFactory.eINSTANCE.createFalseLiteralQuery();
		final ICommandFactoryResult<Facet> propConfigCmd = customCmdFactory
				.setPropertyConfig(typeCustomization, null, isVisibleProperty,
						query);
		resultCmd.append(propConfigCmd.getCommand());
		return resultCmd;
	}

	private TableInstanceCommandFactory() {
		// Prevents instantiation
	}

	/**
	 * This method retruns an EMF command deleting the a collection of EObject 
	 * @param label This label will be visible in the menu 'Edit'.
	 * @param eObjects
	 * @param controller
	 * @return
	 */
	public static Command delete(final String label, final Collection<? extends EObject> eObjects,
			final TableWidgetController controller) {
		List<Command> cmdList = new ArrayList<Command>();
		for (EObject eObject : eObjects) {
			Command command = controller
					.getCommandFactory()
					.createDeleteCommand(controller.getEditingDomain(), eObject);
			cmdList.add(command);
		}
		Command result = null;
		if (!cmdList.isEmpty()) {
			result = new CompoundCommand(label, cmdList);
		}
		return result;
	}

	/**
	 * This method create a command deleting use less row and columns.
	 * @param controller
	 * @return null if no action has to be performed.
	 */
	public static final Command createRemoveUselessRowsAndColumnsCommand(
			final TableWidgetController controller) {
		List<Command> cmdList = new ArrayList<Command>();
		List<Row> rowsToRemove = InternalTableUtils.findUselessRow(controller
				.getTable());
		if (TableWidgetController.DEBUG_REMOVE_USELESS_ROWS_AND_COLUMNS) {
			DebugUtils.debug("Rows to be removed: " + rowsToRemove.size()); //$NON-NLS-1$
		}
		final Command deleteRows = TableInstanceCommandFactory.delete(
				Messages.TableWidgetController_DeleteUselessRows, rowsToRemove,
				controller);
		if (deleteRows != null) {
			cmdList.add(deleteRows);
		}
		final TableCommandFactory tableCmdFactory = new TableCommandFactory(
				controller.getTable(), controller.getEditingDomain(),
				controller.getCommandFactory(), null);
		final Command removeColumnCommand = tableCmdFactory
				.createRemoveUselessColumnsCommand(rowsToRemove, null);
		if (removeColumnCommand != null) {
			if (!removeColumnCommand.canExecute()) {
				throw new TableWidgetRuntimeException(
						"Command cannot be executed"); //$NON-NLS-1$
			}
			cmdList.add(removeColumnCommand);
		}
		CompoundCommand command = null;
		if (!cmdList.isEmpty()) {
			command = new CompoundCommand(
					Messages.TableWidgetController_RemoveUselessRowsAndColumns,
					cmdList);
		}
		return command;
	}
	
}
