/*******************************************************************************
 * Copyright (c) 2010, 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 332437 - NatTable : pluggable cell editors
 *   Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *   Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *   Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;

import net.sourceforge.nattable.data.convert.IDisplayConverter;
import net.sourceforge.nattable.data.validate.IDataValidator;
import net.sourceforge.nattable.edit.ICellEditHandler;
import net.sourceforge.nattable.edit.editor.ICellEditor;
import net.sourceforge.nattable.selection.SelectionLayer.MoveDirectionEnum;
import net.sourceforge.nattable.style.IStyle;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.facet.FacetStructuralFeature;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.exception.EmfFacetFacetException;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditHandler;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditor;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * Adapts an {@link IModelCellEditor} to an {@link ICellEditor}
 * 
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public class NatTableCellEditorAdapter implements ICellEditor {

	private final IModelCellEditor modelCellEditor;
	private final List<Column> columns;
	private Control control;
	private Composite fParent;
	private Object element;
	private FacetContext facetContext;

	public NatTableCellEditorAdapter(final IModelCellEditor modelCellEditor,
			final List<Column> columns, final FacetContext facetContext) {
		this.modelCellEditor = modelCellEditor;
		this.columns = columns;
		this.facetContext = facetContext;
	}

	public Control activateCell(final Composite parent, final Object originalCanonicalValue,
			final Character initialEditValue, final IDisplayConverter displayConverter,
			final IStyle cellStyle, final IDataValidator dataValidator,
			final ICellEditHandler editHandler, final int colIndex, final int rowIndex) {

		this.fParent = parent;

		IModelCellEditHandler modelCellEditHandler = new IModelCellEditHandler() {
			public void commit() {
				editHandler.commit(MoveDirectionEnum.NONE, true);
			}
		};

		Column column = this.columns.get(colIndex);
		if (column instanceof FeatureColumn) {
			FeatureColumn featureColumn = (FeatureColumn) column;
			EStructuralFeature feature = featureColumn.getFeature();
			GridElement gridElement = (GridElement) originalCanonicalValue;
			this.element = gridElement.getElement();
			if (this.element instanceof EObject) {
				EObject eObject = (EObject) this.element;
				Object value = null;
				if (feature instanceof FacetStructuralFeature) {
					try {
						value = this.facetContext.get(eObject, feature);
					} catch (ModelQueryException e) {
						Logger.logError(e, Activator.getDefault());
					} catch (EmfFacetFacetException e) {
						Logger.logError(e, Activator.getDefault());
					}
				} else {
					value = eObject.eGet(feature);
				}
				this.control = this.modelCellEditor.activateCell(parent, value,
						modelCellEditHandler, feature, eObject);
				return this.control;
			}
			throw new IllegalArgumentException("not an EObject"); //$NON-NLS-1$
		}
		// error (when called for multi-cell editing)
		this.control = new Composite(parent, SWT.NONE);
		return this.control;
	}

	public void setCanonicalValue(final Object canonicalValue) {
		// no reason to set the value after creation
		throw new UnsupportedOperationException();
	}

	public Object getCanonicalValue() {
		return this.modelCellEditor.getValue();
	}

	public void close() {
		if (this.fParent != null && !this.fParent.isDisposed()) {
			this.fParent.forceFocus();
		}
		if (this.control != null && !this.control.isDisposed()) {
			this.control.dispose();
		}
	}

	public boolean isClosed() {
		return this.control == null || this.control.isDisposed();
	}

}
