/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.tests.internal;

import junit.framework.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedContentProviderFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedTreeContentProvider;
import org.eclipse.emf.facet.custom.ui.IResolvingCustomizedLabelProviderFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Test;

public class Bug386387 {
    private static final int TREE_DEPTH = 5;

    @Test
    public void refreshWithoutChanges() {
        Shell[] shellPointer = new Shell[1];
        TreeViewer[] treePointer = new TreeViewer[1];
        int[] lengthPointer = new int[1];
        EPackage root = Bug386387.createResource();
        Bug386387.createTree(shellPointer, treePointer, lengthPointer, root.eResource());
        int intialsize = lengthPointer[0];
        Bug386387.refreshTree(treePointer, lengthPointer);
        Assert.assertTrue((String)"The treeview must not be collapsed", (lengthPointer[0] == intialsize ? 1 : 0) != 0);
        Bug386387.closeShell(shellPointer);
    }

    @Test
    public void refreshWithChanges() {
        Shell[] shellPointer = new Shell[1];
        TreeViewer[] treePointer = new TreeViewer[1];
        int[] lengthPointer = new int[1];
        EPackage root = Bug386387.createResource();
        Bug386387.createTree(shellPointer, treePointer, lengthPointer, root.eResource());
        root.getEClassifiers().remove(0);
        int intialsize = lengthPointer[0];
        Bug386387.refreshTree(treePointer, lengthPointer);
        Assert.assertTrue((String)"The treeview must be partially collapsed", (lengthPointer[0] < intialsize ? 1 : 0) != 0);
        Bug386387.closeShell(shellPointer);
    }

    protected static void refreshTree(final TreeViewer[] treePointer, final int[] lengthPointer) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                treePointer[0].refresh();
                lengthPointer[0] = treePointer[0].getExpandedElements().length;
            }
        });
    }

    protected static void closeShell(final Shell[] shellPointer) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                shellPointer[0].close();
            }
        });
    }

    protected static void createTree(final Shell[] shellPointer, final TreeViewer[] treePointer, int[] lengthPointer, Resource resource) {
        ICustomizationManager customizationMgr = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(resource.getResourceSet());
        final ICustomizedTreeContentProvider contentProvider = ICustomizedContentProviderFactory.DEFAULT.createCustomizedTreeContentProvider(customizationMgr);
        ICustomizedLabelProvider labelProvider = IResolvingCustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(customizationMgr);
        Display.getDefault().syncExec(new Runnable((ILabelProvider)labelProvider, resource, lengthPointer){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            private final /* synthetic */ Resource val$resource;
            private final /* synthetic */ int[] val$lengthPointer;
            {
                this.val$labelProvider = iLabelProvider;
                this.val$resource = resource;
                this.val$lengthPointer = nArray;
            }

            public void run() {
                TreeViewer tree;
                Shell shell;
                shellPointer[0] = shell = new Shell(Display.getDefault(), 65728);
                shell.setLayout((Layout)new GridLayout(1, true));
                treePointer[0] = tree = new TreeViewer((Composite)shell);
                tree.getTree().setLayoutData((Object)new GridData(1808));
                tree.setContentProvider((IContentProvider)contentProvider);
                tree.setLabelProvider((IBaseLabelProvider)this.val$labelProvider);
                tree.setInput((Object)this.val$resource.getContents());
                shell.open();
                tree.expandToLevel(5);
                this.val$lengthPointer[0] = treePointer[0].getExpandedElements().length;
            }
        });
    }

    protected static EPackage createResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI uri = URI.createPlatformResourceURI((String)"/tmp/tmp", (boolean)true);
        Resource resource = resourceSet.createResource(uri);
        EPackage eObject = (EPackage)EcoreUtil.copy((EObject)EcorePackage.eINSTANCE);
        resource.getContents().add((Object)eObject);
        return eObject;
    }
}

