/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.sdk.tests.internal;

import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.common.sdk.core.internal.exported.utils.ProjectUtils;
import org.eclipse.emf.facet.custom.sdk.tests.internal.Activator;
import org.junit.Assert;
import org.junit.Test;

public class CustomValidationTests {
    private static final String BUG375054 = "Bug375054";
    private static final String CUSTOM_FILE = "Bug375054.custom";
    private static final String RULE_ATTRIBUTE = "rule";
    private static final String AVOID_ECLASS_OVERLAY_RULE = "org.eclipse.emf.facet.custom.sdk.core.constraint.avoidEClassOverlay";

    @Test
    public void testBug375054EClassOverlayWarning() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(BUG375054);
        ProjectUtils.createEmfFacetProject((IProject)project, (IPath)project.getLocation(), (IProgressMonitor)new NullProgressMonitor());
        IFile customFile = project.getFile(CUSTOM_FILE);
        URL resource = Activator.getDefault().getBundle().getResource("resources/Bug375054.custom");
        customFile.create(resource.openStream(), true, (IProgressMonitor)new NullProgressMonitor());
        project.build(6, (IProgressMonitor)new NullProgressMonitor());
        IMarker[] markers = customFile.findMarkers("org.eclipse.emf.validation.problem", true, 0);
        Assert.assertEquals((String)"The customization should have one warning", (long)1L, (long)markers.length);
        Assert.assertEquals((String)"The warning should be about the EClass overlay", (Object)AVOID_ECLASS_OVERLAY_RULE, (Object)markers[0].getAttribute(RULE_ATTRIBUTE));
    }
}

