/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public final class TableTestUtils {
    private TableTestUtils() {
    }

    public static void createTestProject(String projectName, String testFile) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject testProject = workspace.getRoot().getProject(projectName);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)("/resources/" + testFile), (IProject)testProject, (String)("/" + testFile), (Bundle)bundle);
    }

    public static void openUMLEditorOnTestFile(final String projectName, final String testFile) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IFile umlFile = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(testFile);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)umlFile, (String)"org.eclipse.uml2.uml.editor.presentation.UMLEditorID");
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static INatTableWidget2 getNatTableWidgetOfActivePart() {
        final INatTableWidget2[] result = new INatTableWidget2[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = activePage.getActiveEditor();
                INatTableWidgetProvider iNatTableWidgetProvider = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class);
                result[0] = (INatTableWidget2)iNatTableWidgetProvider.getNatTableWidget();
            }
        });
        return result[0];
    }
}

