/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.custompt.ImageWrapper;
import org.eclipse.emf.facet.custom.ui.internal.custompt.URIImage;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ImageManager {
    private final Map<String, Image> uriImageCache = new HashMap<String, Image>();

    private Image getImage(URIImage uriImage) {
        Image result;
        String uriStr = uriImage.getUri();
        if (this.uriImageCache.keySet().contains(uriStr)) {
            result = this.uriImageCache.get(uriStr);
        } else {
            ImageDescriptor imgDecriptor = this.createImageDescriptor(uriStr);
            result = imgDecriptor.createImage();
            this.uriImageCache.put(uriStr, result);
        }
        return result;
    }

    private ImageDescriptor createImageDescriptor(String uriStr) {
        ImageDescriptor imgDecriptor;
        URI baseURI;
        String resourcePath;
        URI uri = URI.createURI((String)uriStr);
        String bundleId = uri.segment(1);
        Bundle bundle = Platform.getBundle((String)bundleId);
        URL url = bundle.getResource(resourcePath = uri.deresolve(baseURI = URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + '/'), (boolean)false)).toString());
        if (url == null) {
            Logger.logError((String)NLS.bind((String)"Resource not found: {0}", (Object)resourcePath), (Plugin)Activator.getDefault());
            imgDecriptor = ImageDescriptor.getMissingImageDescriptor();
        } else {
            imgDecriptor = ImageDescriptor.createFromURL((URL)url);
        }
        return imgDecriptor;
    }

    public Image getImage(IImage image) {
        Image result = null;
        Display device = PlatformUI.getWorkbench().getDisplay();
        if (image instanceof ImageWrapper) {
            ImageWrapper wrapper = (ImageWrapper)image;
            result = wrapper.getImage();
        } else if (image instanceof URIImage) {
            URIImage uriImage = (URIImage)image;
            result = this.getImage(uriImage);
        } else if (image != null) {
            result = new Image((Device)device, image.getInputStream());
        }
        return result;
    }

    public void dispose() {
        for (Image image : this.uriImageCache.values()) {
            image.dispose();
        }
    }

    public ImageDescriptor getImageDescriptor(IImage image) {
        ImageDescriptor result = null;
        if (image instanceof URIImage) {
            URIImage uriImage = (URIImage)image;
            result = this.createImageDescriptor(uriImage.getUri());
        }
        return result;
    }
}

