/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.widget.IETypedElementSelectionWidget;
import org.eclipse.emf.facet.efacet.ui.internal.exported.widget.IETypedElementSelectionWidgetFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETypedElementsSelectionWidgetTests {
    private static final String STRING_ATTRIBUTE = "stringAttribute";
    private static final String BOOLEAN_ATTRIBUTE = "booleanAttribute";
    private static final String FACET1 = "facet1";
    private static final String FACET_ENAMEDELEMENT = "facetOnENamedElement";
    private static final String FACET_ECLASSIFIER = "facetOnEClassifier";
    private static final String FACET_EPACKAGE = "facetOnEpackage";
    private static final String FACET_EOPERATION = "facetOnEOperation";
    private static final String BUG370806 = "Bug370806";
    private Facet facet1;
    private FacetAttribute booleanAttribute1;
    private FacetAttribute stringAttribute1;
    private Facet facetOnENamedElement;
    private FacetAttribute booleanAttribute2;
    private FacetAttribute stringAttribute2;
    private Facet facetOnEClassifier;
    private FacetAttribute booleanAttribute3;
    private FacetAttribute stringAttribute3;
    private Facet facetOnEOperation;
    private FacetAttribute booleanAttribute4;
    private FacetAttribute stringAttribute4;
    private Facet facetOnEPackage;
    private FacetAttribute booleanAttribute5;
    private FacetAttribute stringAttribute5;
    private FacetSet facetSet;
    private IFacetSetCatalogManager catalogMgr;

    private void init() {
        if (this.facetSet != null) {
            return;
        }
        this.catalogMgr = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)new ResourceSetImpl());
        this.facetSet = FacetUtils.getFacetSet((Collection)this.catalogMgr.getRegisteredFacetSets(), (String)BUG370806);
        this.facet1 = FacetUtils.getFacet((FacetSet)this.facetSet, (String)FACET1);
        this.booleanAttribute1 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facet1, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        this.stringAttribute1 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facet1, (String)STRING_ATTRIBUTE, FacetAttribute.class);
        this.facetOnENamedElement = FacetUtils.getFacet((FacetSet)this.facetSet, (String)FACET_ENAMEDELEMENT);
        this.booleanAttribute2 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnENamedElement, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        this.stringAttribute2 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnENamedElement, (String)STRING_ATTRIBUTE, FacetAttribute.class);
        this.facetOnEClassifier = FacetUtils.getFacet((FacetSet)this.facetSet, (String)FACET_ECLASSIFIER);
        this.booleanAttribute3 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnEClassifier, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        this.stringAttribute3 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnEClassifier, (String)STRING_ATTRIBUTE, FacetAttribute.class);
        this.facetOnEOperation = FacetUtils.getFacet((FacetSet)this.facetSet, (String)FACET_EOPERATION);
        this.booleanAttribute4 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnEOperation, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        this.stringAttribute4 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnEOperation, (String)STRING_ATTRIBUTE, FacetAttribute.class);
        this.facetOnEPackage = FacetUtils.getFacet((FacetSet)this.facetSet, (String)FACET_EPACKAGE);
        this.booleanAttribute5 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnEPackage, (String)BOOLEAN_ATTRIBUTE, FacetAttribute.class);
        this.stringAttribute5 = (FacetAttribute)FacetUtils.getETypedElement((Facet)this.facetOnEPackage, (String)STRING_ATTRIBUTE, FacetAttribute.class);
    }

    private ETypedElementSelectionWidgetInShell syncOpenWidget(final boolean multiSelection, final boolean allowEmptySelection) {
        final ETypedElementSelectionWidgetInShell[] result = new ETypedElementSelectionWidgetInShell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                result[0] = ETypedElementsSelectionWidgetTests.this.openWidget(multiSelection, allowEmptySelection);
            }
        });
        return result[0];
    }

    protected ETypedElementSelectionWidgetInShell openWidget(boolean multiSelection, boolean allowEmptySelection) {
        Shell shell = new Shell();
        shell.setSize(800, 600);
        shell.setLayout((Layout)new GridLayout());
        IETypedElementSelectionWidget widget = IETypedElementSelectionWidgetFactory.DEFAULT.createETypedElementSelectionWidget(multiSelection ? Integer.MAX_VALUE : 1, allowEmptySelection, (Composite)shell, null, this.catalogMgr.getRegisteredFacetSets());
        shell.open();
        return new ETypedElementSelectionWidgetInShell(shell, widget);
    }

    private List<FacetAttribute> getAllTypedElements() {
        return Arrays.asList(this.booleanAttribute1, this.stringAttribute1, this.booleanAttribute2, this.stringAttribute2, this.booleanAttribute3, this.stringAttribute3, this.booleanAttribute4, this.stringAttribute4, this.booleanAttribute5, this.stringAttribute5);
    }

    @Test
    public void testSelectSingleETypedElement() throws Exception {
        this.init();
        ETypedElementSelectionWidgetInShell widgetInShell = this.syncOpenWidget(false, true);
        IETypedElementSelectionWidget widget = widgetInShell.getWidget();
        List selection = widget.getSelectedETypedElements();
        Assert.assertTrue((String)"The selection should be empty initially", (boolean)selection.isEmpty());
        List<FacetAttribute> availableETypedElements = Arrays.asList(this.booleanAttribute1, this.stringAttribute1, this.booleanAttribute2, this.stringAttribute2, this.booleanAttribute3, this.stringAttribute3, this.booleanAttribute4, this.stringAttribute4, this.booleanAttribute5, this.stringAttribute5);
        widget.setAvailableETypedElements(availableETypedElements);
        widget.setSelectedETypedElements(Collections.singleton(this.stringAttribute1));
        List selected = widget.getSelectedETypedElements();
        Assert.assertEquals((String)"Only the selected element should be in the selection", (long)1L, (long)selected.size());
        Assert.assertEquals((String)"The selected element should be in the selection", (Object)this.stringAttribute1, selected.get(0));
        widgetInShell.close();
    }

    @Test
    public void testSelectMultipleETypedElements() throws Exception {
        this.init();
        ETypedElementSelectionWidgetInShell widgetInShell = this.syncOpenWidget(true, true);
        IETypedElementSelectionWidget widget = widgetInShell.getWidget();
        List selection = widget.getSelectedETypedElements();
        Assert.assertTrue((String)"The selection should be empty initially", (boolean)selection.isEmpty());
        List<FacetAttribute> availableETypedElements = this.getAllTypedElements();
        widget.setAvailableETypedElements(availableETypedElements);
        List<FacetAttribute> elementsToSelect = Arrays.asList(this.booleanAttribute2, this.stringAttribute3, this.booleanAttribute5);
        widget.setSelectedETypedElements(elementsToSelect);
        selection = widget.getSelectedETypedElements();
        Assert.assertEquals((String)"The selection should contain only the elements that were selected", (long)elementsToSelect.size(), (long)selection.size());
        Assert.assertTrue((String)"The selection should contain all the elements that were selected", (boolean)selection.containsAll(elementsToSelect));
        widgetInShell.close();
    }

    @Test
    public void testSelectETypedElementsFiltered() throws Exception {
        this.init();
        ETypedElementSelectionWidgetInShell widgetInShell = this.syncOpenWidget(true, true);
        IETypedElementSelectionWidget widget = widgetInShell.getWidget();
        List selection = widget.getSelectedETypedElements();
        Assert.assertTrue((String)"The selection should be empty initially", (boolean)selection.isEmpty());
        List<FacetAttribute> availableETypedElements = Arrays.asList(this.booleanAttribute1, this.booleanAttribute2, this.booleanAttribute3, this.booleanAttribute4, this.booleanAttribute5);
        widget.setAvailableETypedElements(availableETypedElements);
        List<FacetAttribute> allTypedElements = this.getAllTypedElements();
        widget.setSelectedETypedElements(allTypedElements);
        selection = widget.getSelectedETypedElements();
        Assert.assertEquals((String)"The selection should contain only the elements that were selected", (long)availableETypedElements.size(), (long)selection.size());
        Assert.assertTrue((String)"The selection should contain all the elements that were selected", (boolean)selection.containsAll(availableETypedElements));
        widgetInShell.close();
    }

    @Test
    public void testEmptySelectionOnSingleSelectDialog() throws Exception {
        this.testEmptySelection(false);
    }

    @Test
    public void testEmptySelectionOnMultiSelectDialog() throws Exception {
        this.testEmptySelection(true);
    }

    private void testEmptySelection(boolean multiselect) {
        this.init();
        ETypedElementSelectionWidgetInShell widgetInShell = this.syncOpenWidget(multiselect, true);
        IETypedElementSelectionWidget widget = widgetInShell.getWidget();
        List selection = widget.getSelectedETypedElements();
        Assert.assertTrue((String)"The selection should be empty initially", (boolean)selection.isEmpty());
        widget.setAvailableETypedElements(this.getAllTypedElements());
        widget.setSelectedETypedElements(this.getAllTypedElements());
        List emptySelection = Collections.emptyList();
        widget.setSelectedETypedElements(emptySelection);
        Assert.assertTrue((String)"The selection must be empty", (boolean)widget.getSelectedETypedElements().isEmpty());
        widgetInShell.close();
    }

    private class ETypedElementSelectionWidgetInShell {
        private final Shell shell;
        private final IETypedElementSelectionWidget widget;

        public ETypedElementSelectionWidgetInShell(Shell shell, IETypedElementSelectionWidget widget) {
            this.shell = shell;
            this.widget = widget;
        }

        public Shell getShell() {
            return this.shell;
        }

        public void close() {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ETypedElementSelectionWidgetInShell.this.getShell().close();
                }
            });
        }

        public IETypedElementSelectionWidget getWidget() {
            return this.widget;
        }
    }
}

