/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FeatureColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.GridElement;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class NatTableAPITests {
    private static final int TIMEOUT = 30000;
    private static final String RESOURCES_TEST = "tableTestNatTableAPITest.table";
    private static final String RESOURCES_ECORE_MODEL = "ecoreModel.ecore";
    private static final String PROJECT_NAME = "NatTableAPITestsProject";
    private static final String RESOURCES_TEST_WITH_TABLECONFIGURATION = "tableTestWithTableConfiguration.table";
    private static final String TEST_ECORE_TABLECONFIGURATION = "_test_EcoreTableConfiguration.tableconfiguration";
    private INatTableWidget2 natTableWidget;
    private EditingDomain editingDomain;
    private Resource ecoreModel;
    private IProject project;

    private IEditorPart openEditorOnTable() throws PartInitException {
        IFile tableFile = this.project.getFile(RESOURCES_TEST);
        IEditorPart editor = NatTableAPITests.openEditor(tableFile);
        INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class);
        Assert.assertNotNull((Object)natTableWidgetPart);
        this.natTableWidget = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
        return editor;
    }

    private static IEditorPart openEditor(final IFile file) throws PartInitException {
        final IEditorPart[] editorHandler = new IEditorPart[1];
        final PartInitException[] exceptionHander = new PartInitException[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    editorHandler[0] = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
                }
                catch (PartInitException e) {
                    exceptionHander[0] = e;
                }
            }
        });
        if (exceptionHander[0] != null) {
            throw exceptionHander[0];
        }
        return editorHandler[0];
    }

    @Before
    public void initResource() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            project2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        this.project = workspace.getRoot().getProject(PROJECT_NAME);
        this.project.create((IProgressMonitor)new NullProgressMonitor());
        this.project.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/tableTestNatTableAPITest.table", (IProject)this.project, (String)"/tableTestNatTableAPITest.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/ecoreModel.ecore", (IProject)this.project, (String)"/ecoreModel.ecore", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/tableTestWithTableConfiguration.table", (IProject)this.project, (String)"/tableTestWithTableConfiguration.table", (Bundle)bundle);
        FileUtils.copyFileFromBundle((String)"/resources/_test_EcoreTableConfiguration.tableconfiguration", (IProject)this.project, (String)"/_test_EcoreTableConfiguration.tableconfiguration", (Bundle)bundle);
        IEditorPart editor = this.openEditorOnTable();
        Assert.assertTrue((boolean)(editor instanceof IEditingDomainProvider));
        this.editingDomain = ((IEditingDomainProvider)editor).getEditingDomain();
        Assert.assertNotNull((Object)this.editingDomain);
        this.ecoreModel = this.editingDomain.getResourceSet().getResource(URI.createPlatformResourceURI((String)"NatTableAPITestsProject/ecoreModel.ecore", (boolean)true), true);
        Assert.assertNotNull((Object)this.ecoreModel);
    }

    @Test(timeout=30000L)
    public void deleteSelectionTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        EObject eObject = (EObject)this.natTableWidget.getTableInstance().getElements().get(0);
        this.natTableWidget.selectDefaultLabelCell(eObject);
        Assert.assertTrue((boolean)(this.natTableWidget.getSelection() instanceof StructuredSelection));
        StructuredSelection selection = (StructuredSelection)this.natTableWidget.getSelection();
        Assert.assertEquals((Object)selection.getFirstElement(), (Object)eObject);
        Assert.assertTrue((boolean)this.natTableWidget.isCellSelected());
        Assert.assertTrue((boolean)this.natTableWidget.isCellsDeletable());
        int oldRowSize = this.natTableWidget.getTableInstance().getRows().size();
        this.natTableWidget.deleteSelection();
        Assert.assertEquals((long)(oldRowSize - 1), (long)this.natTableWidget.getTableInstance().getRows().size());
        Assert.assertFalse((boolean)this.natTableWidget.getTableInstance().getElements().contains((Object)eObject));
        EObject contents = (EObject)this.ecoreModel.getContents().get(0);
        Assert.assertTrue((boolean)(contents instanceof EPackage));
        Assert.assertFalse((boolean)((EPackage)contents).getEClassifiers().contains((Object)eObject));
    }

    @Test(timeout=30000L)
    public void loadFacetTest() throws CoreException {
        Assert.assertNotNull((Object)this.natTableWidget);
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("_example_Ecore");
        Assert.assertNotNull((Object)facetSet);
        Facet facet = facetSet.getFacet("FacetExample");
        Assert.assertNotNull((Object)facet);
        int columnCount = this.natTableWidget.getTableInstance().getColumns().size();
        this.natTableWidget.setFacets(Arrays.asList(facet));
        Assert.assertEquals((long)(columnCount + 2), (long)this.natTableWidget.getTableInstance().getColumns().size());
        int indexAbstractClassColumn = -1;
        int index = 0;
        for (Column c : this.natTableWidget.getTableInstance().getColumns()) {
            if (c instanceof FacetReferenceColumn) {
                FacetReferenceColumn facetReferenceColumn = (FacetReferenceColumn)c;
                Assert.assertTrue((boolean)NatTableWidgetInternalUtils.getColumnName((Column)facetReferenceColumn).equalsIgnoreCase("usedBy"));
            } else if (c instanceof FacetAttributeColumn) {
                FacetAttributeColumn facetAttributeColumn = (FacetAttributeColumn)c;
                Assert.assertTrue((boolean)NatTableWidgetInternalUtils.getColumnName((Column)facetAttributeColumn).equalsIgnoreCase("AbstractClass"));
                indexAbstractClassColumn = index;
            }
            ++index;
        }
        INatTableWidgetInternal iNatTableWidgetInternal = (INatTableWidgetInternal)this.natTableWidget;
        for (Row row : this.natTableWidget.getTableInstance().getRows()) {
            Assert.assertTrue((boolean)(row.getElement() instanceof EClass));
            String text = iNatTableWidgetInternal.getTableLabelProvider().getColumnText(new GridElement((Object)row.getElement(), (Column)this.natTableWidget.getTableInstance().getColumns().get(indexAbstractClassColumn)), indexAbstractClassColumn);
            if (((EClass)row.getElement()).isAbstract()) {
                Assert.assertEquals((Object)"Abstract", (Object)text);
                continue;
            }
            Assert.assertEquals((Object)"Not Abstract", (Object)text);
        }
        this.natTableWidget.setFacets(new ArrayList());
        Assert.assertEquals((long)this.natTableWidget.getTableInstance().getColumns().size(), (long)columnCount);
    }

    @Test(timeout=30000L)
    public void selectAllTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        EList eObjectsInTable = this.natTableWidget.getTableInstance().getElements();
        this.natTableWidget.selectAll();
        Assert.assertTrue((boolean)(this.natTableWidget.getSelection() instanceof StructuredSelection));
        StructuredSelection selection = (StructuredSelection)this.natTableWidget.getSelection();
        Assert.assertEquals((Object)eObjectsInTable, selection.toList().subList(0, eObjectsInTable.size()));
    }

    @Test(timeout=30000L)
    public void addRowsTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        EList initialObjects = this.natTableWidget.getTableInstance().getElements();
        ArrayList<EClass> newObjects = new ArrayList<EClass>();
        newObjects.add(EcoreFactory.eINSTANCE.createEClass());
        newObjects.add(EcoreFactory.eINSTANCE.createEClass());
        this.natTableWidget.addRows(newObjects);
        EList actualObjects = this.natTableWidget.getTableInstance().getElements();
        ArrayList<EClass> expectedObjects = new ArrayList<EClass>((Collection<EClass>)initialObjects);
        expectedObjects.addAll(newObjects);
        Assert.assertEquals(expectedObjects, (Object)actualObjects);
        Assert.assertEquals((long)27L, (long)this.natTableWidget.getTableInstance().getColumns().size());
        ArrayList<EPackage> newEPackages = new ArrayList<EPackage>();
        newEPackages.add(EcoreFactory.eINSTANCE.createEPackage());
        newEPackages.add(EcoreFactory.eINSTANCE.createEPackage());
        newEPackages.add(EcoreFactory.eINSTANCE.createEPackage());
        this.natTableWidget.addRows(newEPackages);
        Assert.assertEquals((long)33L, (long)this.natTableWidget.getTableInstance().getColumns().size());
    }

    @Test(timeout=30000L)
    public void removeLineTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        EObject eObject = (EObject)this.natTableWidget.getTableInstance().getElements().get(0);
        this.natTableWidget.selectDefaultLabelCell(eObject);
        Assert.assertTrue((boolean)(this.natTableWidget.getSelection() instanceof StructuredSelection));
        StructuredSelection selection = (StructuredSelection)this.natTableWidget.getSelection();
        Assert.assertEquals((Object)selection.getFirstElement(), (Object)eObject);
        Assert.assertTrue((boolean)this.natTableWidget.isCellsDeletable());
        int oldRowSize = this.natTableWidget.getTableInstance().getRows().size();
        this.natTableWidget.removeLine();
        Assert.assertEquals((long)(oldRowSize - 1), (long)this.natTableWidget.getTableInstance().getRows().size());
        Assert.assertFalse((boolean)this.natTableWidget.getTableInstance().getElements().contains((Object)eObject));
        EObject contents = (EObject)this.ecoreModel.getContents().get(0);
        Assert.assertTrue((boolean)(contents instanceof EPackage));
        Assert.assertTrue((boolean)((EPackage)contents).getEClassifiers().contains((Object)eObject));
    }

    @Test(timeout=30000L)
    public void saveTest() throws CoreException {
        Assert.assertNotNull((Object)this.natTableWidget);
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("_example_Ecore");
        Assert.assertNotNull((Object)facetSet);
        Facet facet = facetSet.getFacet("FacetExample");
        Assert.assertNotNull((Object)facet);
        this.natTableWidget.setFacets(Arrays.asList(facet));
        this.natTableWidget.save();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
        this.openEditorOnTable();
        Assert.assertTrue((boolean)(this.natTableWidget.getTableInstance() instanceof TableInstance2));
        Assert.assertTrue((boolean)((TableInstance2)this.natTableWidget.getTableInstance()).getFacets2().contains((Object)facet));
    }

    @Test(timeout=30000L)
    public void selectCellByEStructuralFeature() throws CoreException {
        Assert.assertNotNull((Object)this.natTableWidget);
        INatTableWidgetInternal natTableWidget2 = (INatTableWidgetInternal)this.natTableWidget;
        EObject eClass1 = (EObject)this.natTableWidget.getTableInstance().getElements().get(1);
        this.natTableWidget.selectCell(eClass1, (EStructuralFeature)EcorePackage.eINSTANCE.getENamedElement_Name());
        PositionCoordinate position = (PositionCoordinate)natTableWidget2.getSelectedCellsPositions().get(0);
        Assert.assertEquals((long)4L, (long)position.getColumnPosition());
        Assert.assertEquals((long)1L, (long)position.getRowPosition());
        EObject eClass2 = (EObject)this.natTableWidget.getTableInstance().getElements().get(2);
        this.natTableWidget.selectCell(eClass2, (EStructuralFeature)EcorePackage.eINSTANCE.getEClass_Interface());
        position = (PositionCoordinate)natTableWidget2.getSelectedCellsPositions().get(0);
        Assert.assertEquals((long)12L, (long)position.getColumnPosition());
        Assert.assertEquals((long)2L, (long)position.getRowPosition());
        FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet("_example_Ecore");
        Assert.assertNotNull((Object)facetSet);
        Facet facet = facetSet.getFacet("FacetExample");
        Assert.assertNotNull((Object)facet);
        this.natTableWidget.setFacets(Arrays.asList(facet));
        FeatureColumn abstractClassFacetColumn = (FeatureColumn)this.natTableWidget.getTableInstance().getColumns().get(27);
        this.natTableWidget.selectCell(eClass1, abstractClassFacetColumn.getFeature());
        position = (PositionCoordinate)natTableWidget2.getSelectedCellsPositions().get(0);
        Assert.assertEquals((long)27L, (long)position.getColumnPosition());
        Assert.assertEquals((long)1L, (long)position.getRowPosition());
        FeatureColumn usedByFacetColumn = (FeatureColumn)this.natTableWidget.getTableInstance().getColumns().get(28);
        this.natTableWidget.selectCell(eClass2, usedByFacetColumn.getFeature());
        position = (PositionCoordinate)natTableWidget2.getSelectedCellsPositions().get(0);
        Assert.assertEquals((long)28L, (long)position.getColumnPosition());
        Assert.assertEquals((long)2L, (long)position.getRowPosition());
    }

    @Test(timeout=30000L)
    public void selectRowsTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        EList ownedElements = this.natTableWidget.getTableInstance().getElements();
        Assert.assertTrue((ownedElements.size() >= 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.natTableWidget.getSelection().isEmpty());
        ArrayList elementsToSelect = new ArrayList();
        elementsToSelect.addAll(ownedElements);
        this.natTableWidget.selectRows(elementsToSelect, true);
        Assert.assertTrue((boolean)(this.natTableWidget.getSelection() instanceof IStructuredSelection));
        IStructuredSelection selection = (IStructuredSelection)this.natTableWidget.getSelection();
        Assert.assertTrue((selection.size() == elementsToSelect.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(0)));
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(1)));
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(2)));
        elementsToSelect.remove(1);
        this.natTableWidget.selectRows(elementsToSelect, true);
        selection = (IStructuredSelection)this.natTableWidget.getSelection();
        Assert.assertTrue((selection.size() == elementsToSelect.size() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(0)));
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(1)));
        EObject eClass1 = (EObject)this.natTableWidget.getTableInstance().getElements().get(1);
        this.natTableWidget.selectCell(eClass1, (EStructuralFeature)EcorePackage.eINSTANCE.getEClassifier_EPackage());
        this.natTableWidget.selectRows(elementsToSelect, false);
        selection = (IStructuredSelection)this.natTableWidget.getSelection();
        Assert.assertTrue((selection.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)selection.toList().contains(eClass1.eContainer()));
        Assert.assertFalse((boolean)selection.toList().contains(eClass1));
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(0)));
        Assert.assertTrue((boolean)selection.toList().contains(elementsToSelect.get(1)));
    }

    @Test(timeout=30000L)
    public void getSelectionChangedListenersTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        SelectionChangeListenerTest selectionChangedListener = new SelectionChangeListenerTest();
        this.natTableWidget.addSelectionChangedListener((ISelectionChangedListener)selectionChangedListener);
        Assert.assertTrue((boolean)this.natTableWidget.getSelectionChangedListeners().contains(selectionChangedListener));
        Assert.assertFalse((boolean)selectionChangedListener.hasBeenNotified());
        this.natTableWidget.selectAll();
        Assert.assertTrue((boolean)selectionChangedListener.hasBeenNotified());
        this.natTableWidget.removeSelectionChangedListener((ISelectionChangedListener)selectionChangedListener);
        Assert.assertFalse((boolean)this.natTableWidget.getSelectionChangedListeners().contains(selectionChangedListener));
    }

    @Test(timeout=30000L)
    public void setHideEmptyColumnsTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        Assert.assertFalse((boolean)this.natTableWidget.getTableInstance().isHideEmptyColumns());
        this.natTableWidget.setHideEmptyColumns(true);
        Assert.assertTrue((boolean)this.natTableWidget.getTableInstance().isHideEmptyColumns());
        this.natTableWidget.setHideEmptyColumns(false);
        Assert.assertFalse((boolean)this.natTableWidget.getTableInstance().isHideEmptyColumns());
    }

    @Test(timeout=30000L)
    public void setOnlyShowCommonColumnsTest() {
        Assert.assertNotNull((Object)this.natTableWidget);
        Assert.assertFalse((boolean)this.natTableWidget.getTableInstance().isOnlyShowCommonColumns());
        this.natTableWidget.setOnlyShowCommonColumns(true);
        Assert.assertTrue((boolean)this.natTableWidget.getTableInstance().isOnlyShowCommonColumns());
        this.natTableWidget.setOnlyShowCommonColumns(false);
        Assert.assertFalse((boolean)this.natTableWidget.getTableInstance().isOnlyShowCommonColumns());
    }

    @Test(timeout=30000L)
    public void testSortColumnsByType() {
        String[] nonSortedList = new String[]{"[Label]", "[Metaclass]", "/eContainer", "eAnnotations", "name", "instanceClassName", "/instanceClass", "/defaultValue", "instanceTypeName", "ePackage", "eTypeParameters", "abstract", "interface", "eSuperTypes", "eOperations", "/eAllAttributes", "/eAllReferences", "/eReferences", "/eAttributes", "/eAllContainments", "/eAllOperations", "/eAllStructuralFeatures", "/eAllSuperTypes", "/eIDAttribute", "eStructuralFeatures", "eGenericSuperTypes", "/eAllGenericSuperTypes"};
        String[] sortedByTypeList = new String[]{"[Label]", "[Metaclass]", "/eContainer", "name", "instanceClassName", "/instanceClass", "/defaultValue", "instanceTypeName", "abstract", "interface", "eAnnotations", "ePackage", "eTypeParameters", "eSuperTypes", "eOperations", "/eAllAttributes", "/eAllReferences", "/eReferences", "/eAttributes", "/eAllContainments", "/eAllOperations", "/eAllStructuralFeatures", "/eAllSuperTypes", "/eIDAttribute", "eStructuralFeatures", "eGenericSuperTypes", "/eAllGenericSuperTypes"};
        String[] sortedByTypeAtoZList = new String[]{"[Label]", "[Metaclass]", "/eContainer", "abstract", "/defaultValue", "/instanceClass", "instanceClassName", "instanceTypeName", "interface", "name", "/eAllAttributes", "/eAllContainments", "/eAllGenericSuperTypes", "/eAllOperations", "/eAllReferences", "/eAllStructuralFeatures", "/eAllSuperTypes", "eAnnotations", "/eAttributes", "eGenericSuperTypes", "/eIDAttribute", "eOperations", "ePackage", "/eReferences", "eStructuralFeatures", "eSuperTypes", "eTypeParameters"};
        Assert.assertNotNull((Object)this.natTableWidget);
        EList columns = this.natTableWidget.getTableInstance().getColumns();
        int i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)nonSortedList[i], (Object)NatTableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
        this.natTableWidget.sortColumnsByType();
        i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)sortedByTypeList[i], (Object)NatTableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
        this.natTableWidget.sortColumnsByType();
        this.natTableWidget.sortColumnsByType();
        i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)sortedByTypeList[i], (Object)NatTableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
        this.natTableWidget.sortColumnByNameAtoZ();
        this.natTableWidget.sortColumnsByType();
        i = 0;
        while (i < columns.size()) {
            Assert.assertEquals((Object)sortedByTypeAtoZList[i], (Object)NatTableWidgetInternalUtils.getColumnName((Column)((Column)columns.get(i))));
            ++i;
        }
    }

    @Test(timeout=30000L)
    public void testGetInstantiationMethodHistory() throws PartInitException {
        this.closeAllEditors();
        IFile tableFile = this.project.getFile(RESOURCES_TEST_WITH_TABLECONFIGURATION);
        IEditorPart editor = NatTableAPITests.openEditor(tableFile);
        INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)editor.getAdapter(INatTableWidgetProvider.class);
        Assert.assertNotNull((Object)natTableWidgetPart);
        this.natTableWidget = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
        TableConfiguration tableConfiguration = this.natTableWidget.getTableConfiguration();
        Assert.assertNotNull((Object)tableConfiguration);
        Assert.assertEquals((long)2L, (long)tableConfiguration.getInstantiationMethod().size());
        InstantiationMethod method0 = (InstantiationMethod)tableConfiguration.getInstantiationMethod().get(0);
        this.natTableWidget.createNewElement(method0);
        Assert.assertEquals((Object)method0, this.natTableWidget.getInstantionMethodHistory().get(0));
        InstantiationMethod method1 = (InstantiationMethod)tableConfiguration.getInstantiationMethod().get(1);
        this.natTableWidget.createNewElement(method1);
        Assert.assertEquals((Object)method1, this.natTableWidget.getInstantionMethodHistory().get(0));
    }

    @After
    public void closeAllEditors() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }

    private class SelectionChangeListenerTest
    implements ISelectionChangedListener {
        private boolean hasBeenNotified = false;

        public boolean hasBeenNotified() {
            return this.hasBeenNotified;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.hasBeenNotified = true;
        }
    }
}

