/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.swtbot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.util.core.internal.AbstractLogListenerTest;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug365843
extends AbstractLogListenerTest {
    private static final int TIMEOUT = 30000;
    private static final String PROJECT_NAME = Bug365843.class.getName();
    private static final String ECORE_FILE_NAME = String.valueOf(Bug365843.class.getSimpleName()) + ".ecore";
    private static final String RESOURCES = "resources/" + Bug365843.class.getSimpleName() + '/';
    private static final String UI_PLUGIN_ID = "org.eclipse.ui";
    private static final String CORE_RESOURCE_PLUGIN_ID = "org.eclipse.core.resources";
    private static final String CORE_JOBS_PLUGIN_ID = "org.eclipse.core.jobs";
    private static final String WIDGET_NATTABLE_PLUGIN_ID = "org.eclipse.emf.facet.widgets.nattable";

    @Before
    public void beforeTests() throws CoreException {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        SWTBotUtils.deleteAllProjects();
    }

    @Test(timeout=30000L)
    public void testScenario1WithAnEditorEditingDomain() throws CoreException, IOException {
        Bug365843.createProjectAndOpenEditor();
        EditingDomain editingDomain = Bug365843.getEditorEditingDomain();
        EPackage ePackage = (EPackage)((Resource)editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
        Bug365843.scenario1(ePackage, editingDomain);
    }

    @Test(timeout=30000L)
    public void testScenario2WithAnEditorEditingDomain() throws CoreException, IOException {
        Bug365843.createProjectAndOpenEditor();
        EditingDomain editingDomain = Bug365843.getEditorEditingDomain();
        EPackage ePackage = (EPackage)((Resource)editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
        Bug365843.scenario2(ePackage, editingDomain);
    }

    @Test(timeout=30000L)
    public void testScenario1WithAnBasicEditingDomain() {
        EPackage ePackage = Bug365843.createAnEPackageInANewResource();
        EditingDomain editingDomain = Bug365843.initializeAnEditingDomain();
        Bug365843.scenario1(ePackage, editingDomain);
    }

    @Test(timeout=30000L)
    public void testScenario2WithAnBasicEditingDomain() {
        EPackage ePackage = Bug365843.createAnEPackageInANewResource();
        EditingDomain editingDomain = Bug365843.initializeAnEditingDomain();
        Bug365843.scenario2(ePackage, editingDomain);
    }

    private static void scenario1(EPackage ePackage, EditingDomain editingDomain) {
        Bug365843.checkResourceSet(editingDomain.getResourceSet());
        EClass newEClass = EcoreFactory.eINSTANCE.createEClass();
        CommandParameter classCmdParam = new CommandParameter((Object)ePackage, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)newEClass);
        Command createEClass = CreateChildCommand.create((EditingDomain)editingDomain, (Object)ePackage, (Object)classCmdParam, (Collection)Collections.EMPTY_LIST);
        EReference newEReference = EcoreFactory.eINSTANCE.createEReference();
        CommandParameter refCmdParam = new CommandParameter((Object)ePackage, (Object)EcorePackage.eINSTANCE.getEClass_EStructuralFeatures(), (Object)newEReference);
        Command createEReference = CreateChildCommand.create((EditingDomain)editingDomain, (Object)newEClass, (Object)refCmdParam, (Collection)Collections.EMPTY_LIST);
        ArrayList<Command> cmdList = new ArrayList<Command>();
        cmdList.add(createEClass);
        cmdList.add(createEReference);
        CompoundCommand compoundCmd = new CompoundCommand(cmdList);
        Bug365843.executeCommandAndCheck(ePackage, editingDomain, newEClass, newEReference, (Command)compoundCmd);
    }

    private static void scenario2(EPackage ePackage, EditingDomain editingDomain) {
        Bug365843.checkResourceSet(editingDomain.getResourceSet());
        EClass newEClass = EcoreFactory.eINSTANCE.createEClass();
        CommandParameter classCmdParam = new CommandParameter((Object)ePackage, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)newEClass);
        Command createEClass = CreateChildCommand.create((EditingDomain)editingDomain, (Object)ePackage, (Object)classCmdParam, (Collection)Collections.EMPTY_LIST);
        EReference newEReference = EcoreFactory.eINSTANCE.createEReference();
        newEClass.getEStructuralFeatures().add((Object)newEReference);
        Bug365843.executeCommandAndCheck(ePackage, editingDomain, newEClass, newEReference, createEClass);
    }

    private static void executeCommandAndCheck(EPackage ePackage, EditingDomain editingDomain, EClass newEClass, EReference newEReference, Command command) {
        Bug365843.checkResourceSet(editingDomain.getResourceSet());
        Assert.assertTrue((String)"The create child command should be executable", (boolean)command.canExecute());
        editingDomain.getCommandStack().execute(command);
        Assert.assertTrue((String)"After the command execution, the new EClass should be contained by the EPackage", (boolean)ePackage.getEClassifiers().contains((Object)newEClass));
        Assert.assertTrue((String)"After the command execution, the new EClass should be contained by the EPackage", (boolean)newEClass.getEStructuralFeatures().contains((Object)newEReference));
        editingDomain.getCommandStack().undo();
        Assert.assertFalse((String)"After an undo, the new EClass should be removed from the EPackage", (boolean)ePackage.getEClassifiers().contains((Object)newEClass));
        editingDomain.getCommandStack().redo();
        Assert.assertTrue((String)"After a redo, the new EClass should be contained by the EPackage", (boolean)ePackage.getEClassifiers().contains((Object)newEClass));
    }

    private static EditingDomain getEditorEditingDomain() {
        IEditorPart editor = Bug365843.getActiveEditor();
        IEditingDomainProvider domainProvider = null;
        EditingDomain editingDomain = null;
        if (editor instanceof IEditingDomainProvider) {
            domainProvider = (IEditingDomainProvider)editor;
            editingDomain = domainProvider.getEditingDomain();
        }
        return editingDomain;
    }

    private static IEditorPart getActiveEditor() {
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                editor[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            }
        });
        return editor[0];
    }

    private static IEditorPart openEditor(final IFile file) throws PartInitException {
        final PartInitException[] exception = new PartInitException[]{null};
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    editor[0] = IDE.openEditor((IWorkbenchPage)activePage, (IFile)file);
                }
                catch (PartInitException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw new PartInitException(exception[0].getMessage(), (Throwable)exception[0]);
        }
        return editor[0];
    }

    private static EditingDomain initializeAnEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        return editingDomain;
    }

    private static EPackage createAnEPackageInANewResource() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File resourceFile = new File("test.xmi");
        URI uri = URI.createFileURI((String)resourceFile.toString());
        Resource resource = resourceSet.createResource(uri);
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        resource.getContents().add((Object)ePackage);
        return ePackage;
    }

    private static void createProjectAndOpenEditor() throws CoreException, IOException, PartInitException {
        IProject testProject = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        IFile file = FileUtils.copyFileFromBundle((String)(String.valueOf(RESOURCES) + ECORE_FILE_NAME), (IProject)testProject, (String)(String.valueOf('/') + ECORE_FILE_NAME), (Bundle)bundle);
        Bug365843.openEditor(file);
    }

    protected Bundle[] getPluginsToListen() {
        return new Bundle[]{Platform.getBundle((String)CORE_RESOURCE_PLUGIN_ID), Platform.getBundle((String)UI_PLUGIN_ID), Platform.getBundle((String)CORE_JOBS_PLUGIN_ID), Platform.getBundle((String)WIDGET_NATTABLE_PLUGIN_ID)};
    }

    private static void checkResourceSet(ResourceSet resourceSet) {
        for (Resource resource : resourceSet.getResources()) {
            Assert.assertNotNull((String)"The resource's URI must not be null.", (Object)resource.getURI());
        }
    }
}

