/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.tests.internal.v0_1.swtbot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.internal.exported.FileUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget2;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.internal.INatTableWidgetInternal;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditor;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.emf.facet.widgets.table.tests.internal.Activator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.ChildrenControlFinder;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class Bug345730Test {
    private static final int TIMEOUT = 30000;
    private static final int PREF_TIMEOUT = 5000;
    private static final int PREF_TYPE_INTERVAL = 10;
    private SWTWorkbenchBot bot;
    private static final String PROJECT_NAME = "projectBug345730";
    private static final String ECORE_FILE_NAME = "_Bug345730_EcoreModel.ecore";

    @BeforeClass
    public static void beforeClass() {
        SWTBotPreferences.TIMEOUT = 5000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        SWTBotPreferences.TYPE_INTERVAL = 10;
    }

    @Before
    public void beforeTests() throws CoreException, IOException {
        this.bot = new SWTWorkbenchBot();
        for (SWTBotView view : this.bot.views()) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
        IProject testProject = workspace.getRoot().getProject(PROJECT_NAME);
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        Bundle bundle = Activator.getDefault().getBundle();
        FileUtils.copyFileFromBundle((String)"/resources/Bug345730/_Bug345730_EcoreModel.ecore", (IProject)testProject, (String)"/_Bug345730_EcoreModel.ecore", (Bundle)bundle);
    }

    private void openTableFile(String fileName) {
        SWTBotUtils.captureScreenShot((String)"1");
        this.bot.menu("Window").menu("Show View").menu("Project Explorer").click();
        SWTBotUtils.captureScreenShot((String)"2");
        SWTBotView view = this.bot.viewByTitle("Project Explorer");
        view.setFocus();
        List controls = new ChildrenControlFinder((Widget)this.bot.getFocusedWidget()).findControls(WidgetOfType.widgetOfType(Tree.class));
        assert (controls.size() == 1);
        SWTBotTree tree = new SWTBotTree((Tree)controls.get(0));
        final SWTBotTreeItem item = tree.expandNode(new String[]{PROJECT_NAME}).getNode(fileName).select();
        try {
            ((SWTBotMenu)UIThreadRunnable.syncExec((Result)new Result<SWTBotMenu>(){

                public SWTBotMenu run() {
                    try {
                        return item.contextMenu("Open With").menu("Other...");
                    }
                    catch (WidgetNotFoundException widgetNotFoundException) {
                        return null;
                    }
                }
            })).click();
            SWTBotTable table = this.bot.table();
            table.select(new String[]{"Sample Ecore Model Editor"});
            this.bot.button("OK").click();
        }
        catch (NullPointerException nullPointerException) {
            item.doubleClick();
        }
    }

    @Test(timeout=30000L)
    public void bug345730Test() {
        this.openTableFile(ECORE_FILE_NAME);
        SWTBotEditor swtBotEditor = this.bot.editorByTitle(ECORE_FILE_NAME);
        swtBotEditor.setFocus();
        Assert.assertTrue((boolean)swtBotEditor.isActive());
        swtBotEditor.bot().tree().expandNode(new String[]{"platform:/resource/projectBug345730/_Bug345730_EcoreModel.ecore"}).select("Package_Bug345730").click();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                ISelection selection = window.getSelectionService().getSelection();
                IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IEditingDomainProvider editingDomainProvider = null;
                EditingDomain editingDomain = null;
                editingDomainProvider = (IEditingDomainProvider)editor;
                editingDomain = editingDomainProvider.getEditingDomain();
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Object fistElement = structuredSelection.getFirstElement();
                EPackage ePackage = (EPackage)fistElement;
                try {
                    ArrayList list = new ArrayList();
                    list.addAll(ePackage.getEClassifiers());
                    NatTableEditorFactory.getInstance().openOn(list, editingDomain, "", null, null, null);
                }
                catch (UnsatisfiedConfigurationConstraint e) {
                    throw new RuntimeException(e);
                }
            }
        });
        final ArrayList rowList = new ArrayList();
        final SWTBotEditor nattableEditor = this.bot.editorByTitle("Model Table");
        nattableEditor.setFocus();
        nattableEditor.show();
        Assert.assertTrue((boolean)nattableEditor.isDirty());
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((NatTableEditor)((IEditorReference)nattableEditor.getReference()).getPart(true)).getAdapter(INatTableWidgetProvider.class);
                INatTableWidget2 iNatTableWidget2 = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
                EList rows = iNatTableWidget2.getTableInstance().getRows();
                rowList.addAll(rows);
                Assert.assertEquals((long)3L, (long)rows.size());
            }
        });
        SWTBotEditor ecoreModelEditor = this.bot.editorByTitle(ECORE_FILE_NAME);
        ecoreModelEditor.show();
        ecoreModelEditor.setFocus();
        Assert.assertTrue((boolean)ecoreModelEditor.isActive());
        Assert.assertFalse((boolean)ecoreModelEditor.isDirty());
        ecoreModelEditor.save();
        final SWTBotTreeItem item = ecoreModelEditor.bot().tree().expandNode(new String[]{"platform:/resource/projectBug345730/_Bug345730_EcoreModel.ecore"}).expandNode(new String[]{"Package_Bug345730"}).select("Class1");
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                Event e = new Event();
                e.keyCode = 127;
                e.stateMask = 0;
                ((TreeItem)item.widget).notifyListeners(1, e);
            }
        });
        nattableEditor.setFocus();
        nattableEditor.show();
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                INatTableWidgetProvider natTableWidgetPart = (INatTableWidgetProvider)((NatTableEditor)((IEditorReference)nattableEditor.getReference()).getPart(true)).getAdapter(INatTableWidgetProvider.class);
                INatTableWidget2 iNatTableWidget2 = (INatTableWidget2)natTableWidgetPart.getNatTableWidget();
                INatTableWidgetInternal iNatTableWidgetInternal = (INatTableWidgetInternal)natTableWidgetPart.getNatTableWidget();
                iNatTableWidgetInternal.waitForResfreshJob();
                EList rows = iNatTableWidget2.getTableInstance().getRows();
                Assert.assertEquals((long)2L, (long)rows.size());
                Assert.assertTrue((!rows.contains(rowList.get(0)) ? 1 : 0) != 0);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            }
        });
    }

    @After
    public void afterTests() {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                activePage.closeAllEditors(false);
            }
        });
    }
}

