/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class DefaultSizeUtils {
    private static final boolean DEBUG = DebugUtils.getDebugStatus((Plugin)Activator.getDefault());
    private static final int DEFAULT_WIDTH = 100;
    private static final int WIDTH_MARGIN = 0;
    private static final int DEFAULT_HEIGHT = 20;
    private static final int HEIGHT_MARGIN = 4;
    private static final int DEFAULT_HEADER_WIDTH = 20;
    private static final int DEFAULT_HEADER_WIDTH_PER_DIGIT = 8;
    private static final int HEADER_WIDTH_MARGIN = 4;
    private static final int DEFAULT_DPI = 96;

    private DefaultSizeUtils() {
    }

    public static int getDefaultCellHeight() {
        return DefaultSizeUtils.getCellHeight(-1);
    }

    public static int getCellHeight(int storedHeight) {
        int height = storedHeight == -1 ? (int)(20.0 * DefaultSizeUtils.getRatio()) + 4 : (int)((double)(Math.max(1, storedHeight) - 4) * DefaultSizeUtils.getRatio() + 4.0);
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: height=" + height);
        }
        return height;
    }

    public static int getDefaultCellWidth() {
        return DefaultSizeUtils.getCellWidth(-1);
    }

    public static int getCellWidth(int storedWidth) {
        int width = storedWidth == -1 ? (int)(100.0 * DefaultSizeUtils.getRatio()) + 0 : (int)((double)(Math.max(1, storedWidth) - 0) * DefaultSizeUtils.getRatio() + 0.0);
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellWidth: " + width);
        }
        return width;
    }

    public static int getDefaultRowHeaderWidth() {
        int width = (int)(20.0 * DefaultSizeUtils.getRatio()) + 4;
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultRowHeaderWidth: " + width);
        }
        return width;
    }

    public static int getRowHeaderWidth(int rowCount) {
        int width = (int)((double)Math.max(20, 8 * String.valueOf(rowCount).length()) * DefaultSizeUtils.getRatio()) + 4;
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getRowHeaderWidth: " + width);
        }
        return width;
    }

    public static Font getHeaderFont() {
        FontData[] fd = (FontData[])Display.getDefault().getSystemFont().getFontData().clone();
        fd[0].setStyle(1);
        Font headerFont = new Font((Device)Display.getDefault(), fd);
        return headerFont;
    }

    private static double getRatio() {
        int dpiX = Display.getDefault().getDPI().x;
        int dpiY = Display.getDefault().getDPI().y;
        if (DEBUG) {
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: dpi x=" + dpiX);
            System.out.println(String.valueOf(DefaultSizeUtils.class.getName()) + ".getDefaultCellHeight: dpi y=" + dpiY);
        }
        return (double)dpiY / 96.0;
    }
}

