/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.core.tests.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.facet.util.core.internal.PluginUtils;
import org.eclipse.emf.facet.util.core.internal.exported.IFilter;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class PluginUtilsTests {
    private static final String RESOURCES_FOLDER = "resources";
    private static final String RESOURCES_FILE = "resources/testFile.txt";
    private static final String EXTENSION_POINT_ID = "org.eclipse.emf.facet.util.emf.core.modeldeclaration";
    private IProject project;
    private IFile iFile;

    @Test
    public void isRegisteredTest() throws CoreException, IOException {
        this.initResource();
        PluginUtils.register((IFile)this.iFile, (String)EXTENSION_POINT_ID, (String)"MyName");
        Assert.assertTrue((boolean)PluginUtils.isRegistered((IFile)this.iFile, (String)EXTENSION_POINT_ID));
    }

    @Test
    public void testPluginUtils() throws CoreException, IOException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject testProject = workspace.getRoot().getProject("testProject002");
        testProject.create((IProgressMonitor)new NullProgressMonitor());
        testProject.open((IProgressMonitor)new NullProgressMonitor());
        String javaNature = "org.eclipse.jdt.core.javanature";
        IProjectDescription description = testProject.getDescription();
        String[] natures = description.getNatureIds();
        if (!Arrays.asList(natures).contains(javaNature)) {
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = javaNature;
            description.setNatureIds(newNatures);
            testProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
        }
        Assert.assertTrue((testProject.exists() && testProject.isOpen() ? 1 : 0) != 0);
        IFile file = testProject.getFile("myfile");
        Assert.assertTrue((!file.exists() ? 1 : 0) != 0);
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, null);
        Assert.assertTrue((boolean)file.exists());
        PluginUtils.register((IFile)file, (String)EXTENSION_POINT_ID, (String)"MyName");
        PluginUtils.configureAsPluginProject((IProject)testProject);
        Assert.assertTrue((boolean)PluginUtils.isPluginProject((IProject)testProject));
        Assert.assertTrue((boolean)PluginUtils.isInPluginProject((IPath)file.getFullPath()));
        Assert.assertTrue((boolean)PluginUtils.isRegistered((IFile)file, (String)EXTENSION_POINT_ID));
    }

    public void initResource() throws CoreException, IOException {
        IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.emf.facet.util.core.tests");
        if (oldProject.exists()) {
            oldProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.facet.util.core.tests");
        this.project = null;
        IFilter<String> filter = new IFilter<String>(){

            public boolean filter(String object) {
                return !object.matches(".*\\.checkstyle.*") && !object.matches(".*\\.svn");
            }
        };
        this.project = PluginUtils.importPlugin((Bundle)bundle, (IFilter)filter);
        this.iFile = this.project.getFile(RESOURCES_FILE);
        Assert.assertNotNull((Object)this.iFile);
    }
}

