/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.reorder.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.nattable.coordinate.PositionUtil;
import net.sourceforge.nattable.coordinate.Range;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.event.ColumnStructuralChangeEvent;
import net.sourceforge.nattable.layer.event.StructuralDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnReorderEvent
extends ColumnStructuralChangeEvent {
    private Collection<Range> beforeFromColumnPositionRanges;
    private int beforeToColumnPosition;

    public ColumnReorderEvent(ILayer layer, int beforeFromColumnPosition, int beforeToColumnPosition) {
        this(layer, Arrays.asList(beforeFromColumnPosition), beforeToColumnPosition);
    }

    public ColumnReorderEvent(ILayer layer, List<Integer> beforeFromColumnPositions, int beforeToColumnPosition) {
        super(layer, new Range[0]);
        this.beforeFromColumnPositionRanges = PositionUtil.getRanges(beforeFromColumnPositions);
        this.beforeToColumnPosition = beforeToColumnPosition;
        ArrayList<Integer> allColumnPositions = new ArrayList<Integer>(beforeFromColumnPositions);
        allColumnPositions.add(beforeToColumnPosition);
        this.setColumnPositionRanges(PositionUtil.getRanges(allColumnPositions));
    }

    public ColumnReorderEvent(ColumnReorderEvent event) {
        super(event);
        this.beforeFromColumnPositionRanges = event.beforeFromColumnPositionRanges;
        this.beforeToColumnPosition = event.beforeToColumnPosition;
    }

    public Collection<Range> getBeforeFromColumnPositionRanges() {
        return this.beforeFromColumnPositionRanges;
    }

    public int getBeforeToColumnPosition() {
        return this.beforeToColumnPosition;
    }

    @Override
    public Collection<StructuralDiff> getColumnDiffs() {
        ArrayList<StructuralDiff> columnDiffs = new ArrayList<StructuralDiff>();
        Collection<Range> beforeFromColumnPositionRanges = this.getBeforeFromColumnPositionRanges();
        int afterAddColumnPosition = this.beforeToColumnPosition;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            if (beforeFromColumnPositionRange.start >= this.beforeToColumnPosition) break;
            afterAddColumnPosition -= Math.min(beforeFromColumnPositionRange.end, this.beforeToColumnPosition) - beforeFromColumnPositionRange.start;
        }
        int cumulativeAddSize = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            cumulativeAddSize += beforeFromColumnPositionRange.size();
        }
        int offset = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            int afterDeleteColumnPosition = beforeFromColumnPositionRange.start - offset;
            if (afterAddColumnPosition < afterDeleteColumnPosition) {
                afterDeleteColumnPosition += cumulativeAddSize;
            }
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, beforeFromColumnPositionRange, new Range(afterDeleteColumnPosition, afterDeleteColumnPosition)));
            offset += beforeFromColumnPositionRange.size();
        }
        Range beforeAddRange = new Range(this.beforeToColumnPosition, this.beforeToColumnPosition);
        offset = 0;
        for (Range beforeFromColumnPositionRange : beforeFromColumnPositionRanges) {
            int size = beforeFromColumnPositionRange.size();
            columnDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, beforeAddRange, new Range(afterAddColumnPosition + offset, afterAddColumnPosition + offset + size)));
            offset += size;
        }
        return columnDiffs;
    }

    @Override
    public boolean convertToLocal(ILayer targetLayer) {
        this.beforeFromColumnPositionRanges = targetLayer.underlyingToLocalColumnPositions(this.getLayer(), this.beforeFromColumnPositionRanges);
        this.beforeToColumnPosition = targetLayer.underlyingToLocalColumnPosition(this.getLayer(), this.beforeToColumnPosition);
        if (this.beforeToColumnPosition >= 0) {
            return super.convertToLocal(targetLayer);
        }
        return false;
    }

    @Override
    public ColumnReorderEvent cloneEvent() {
        return new ColumnReorderEvent(this);
    }
}

