/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationCatalogManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.exception.CustomizationException;
import org.eclipse.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.IContentPropertiesHandlerFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProviderFactory;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandler;
import org.eclipse.emf.facet.custom.ui.ISelectionPropertiesHandlerFactory;
import org.eclipse.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialog;
import org.eclipse.emf.facet.custom.ui.internal.exported.dialog.ILoadCustomizationsDialogFactory;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.core.internal.exported.IResolverManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialog;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IETypedElementSelectionDialogFactory;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialog;
import org.eclipse.emf.facet.efacet.ui.internal.exported.dialog.IFacetSetSelectionDialogFactory;
import org.eclipse.emf.facet.util.core.DebugUtils;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.util.emf.core.CommandFactory;
import org.eclipse.emf.facet.util.emf.core.EmfDebugUtils;
import org.eclipse.emf.facet.util.emf.core.ModelUtils;
import org.eclipse.emf.facet.util.emf.core.command.ILockableUndoCommand;
import org.eclipse.emf.facet.util.emf.core.internal.EMFUtils;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallback;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IDialogCallbackWithPreCommit;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IQuestionDialog;
import org.eclipse.emf.facet.util.ui.internal.exported.dialog.IQuestionDialogFactory;
import org.eclipse.emf.facet.widgets.celleditors.ICellEditorsRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.celleditors.IModelCellEditorContainer;
import org.eclipse.emf.facet.widgets.celleditors.modelCellEditor.AbstractModelCellEditor;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.SourceColumn;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Table;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TableFactory;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.TablePackage;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.table.ui.command.ITableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.InternalTableUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.TableInstanceCommandFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.comparator.ColumnComparator;
import org.eclipse.emf.facet.widgets.table.ui.internal.emf.listener.RowDeleteCommandStackListener;
import org.eclipse.emf.facet.widgets.table.ui.internal.emf.listener.RowDeleteTriggerListener;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IPositionCoordinate;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetView;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetViewFactory;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetInternalUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.TableWidgetUtils;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IAllowedContentsETypedElementSelectionDialogCallback;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.dialog.IMustRemoveNonConformingElementsDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.exception.TableWidgetRuntimeException;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.AllowedContentsETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.ColumnsToHideDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.MustRemoveNonConformingElementsPromptDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.SynchronizedMustRemoveNonConformingElementsPromptDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.jface.dialog.SynchronizedPresentabilityETypedElementSelectionDialog;
import org.eclipse.emf.facet.widgets.table.ui.internal.preferences.PreferenceConstants;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWidgetController
implements DisposeListener,
ITableWidgetInternal {
    protected static final boolean DEBUG_EVENTS = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"events");
    protected static final boolean DEBUG_RESOURCE_LISTENER = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"resource_listener");
    protected static final boolean DEBUG_REMOVE_USELESS_ROWS_AND_COLUMNS = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"removeUselessRowsAndColumns");
    private static final boolean DEBUG_SET_FACET = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"setFacet");
    protected static final boolean DEBUG_SELECTION = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"selection");
    protected static final boolean DEBUG_SORT = DebugUtils.getDebugStatus((Plugin)Activator.getDefault(), (String)"sort");
    private static final int REFRESH_JOB_DELAY = 100;
    protected static final String TMP_FILE_NAME = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".tmp.table";
    public static final File DEFAULT_RESOURCE_FILE = new File(Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()).toOSString(), TMP_FILE_NAME);
    private final Table tableInstance;
    private ICustomizedLabelProvider tableLabelProvider;
    private final Collection<ISelectionChangedListener> fSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final List<Resource> listenedResources = new ArrayList<Resource>();
    private ICustomizationManager customizationEngine;
    private Set<EClass> metaclasses;
    private Resource resource;
    private final MenuManager menuMgr;
    private boolean dataEditable;
    private final EditingDomain editingDomain;
    private final transient ICommandFactory commandFactory;
    private transient List<InstantiationMethod> launchedInstMethHistory;
    private boolean listenReorderEvent = true;
    private final ITableWidgetView view;
    private final IFacetManager facetManager;
    private Action loadCustomizationsAction;
    private Action loadFacetsAction;
    private final List<IActionDelegate> actionList = new ArrayList<IActionDelegate>();
    private IContentPropertiesHandler contentPropertiesHandler;
    private ISelectionPropertiesHandler selectionPropertiesHandler;
    private final TableCommandFactory tableCommandFactory;
    private boolean disposed;
    private final Job refreshJob = new Job("Refresh EMF Facet Table"){

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"Refresh job execution.");
                    try {
                        if (!TableWidgetController.this.isDisposed()) {
                            TableWidgetController.this.reset();
                        }
                    }
                    catch (CustomizationException e) {
                        throw new TableWidgetRuntimeException(e);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    };
    private final Adapter modelChangeAdapter = new AdapterImpl(){

        public void notifyChanged(final Notification msg) {
            boolean redrawNeeded;
            int eventType = msg.getEventType();
            boolean bl = redrawNeeded = eventType != 8 && eventType != 9;
            if (DEBUG_RESOURCE_LISTENER) {
                DebugUtils.debug((String)("notification=" + msg));
                DebugUtils.debug((String)("redrawNeeded=" + redrawNeeded));
            }
            if (redrawNeeded) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (DEBUG_RESOURCE_LISTENER) {
                            DebugUtils.debug((String)("Call of the refresh=" + msg));
                        }
                        TableWidgetController.this.refreshDelayed();
                    }
                });
            }
        }
    };
    private final Adapter tableInstanceAdapter = new AdapterImpl(){

        public synchronized void notifyChanged(Notification msg) {
            int eventType = msg.getEventType();
            if (eventType != 8 && eventType != 9) {
                DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"tableInstanceAdapter called");
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"tableInstanceAdapter asyncExec");
                        TableWidgetController.this.refreshDelayed();
                    }
                });
            }
        }
    };

    public TableWidgetController(Composite parent, IEditingDomainProvider editingDomainProvider, Table tableInstanceParam, MenuManager menuMgr, ITableWidgetViewFactory viewFactory) throws CustomizationException {
        this.view = viewFactory.createTableView(parent, this);
        this.menuMgr = menuMgr;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        if (editingDomainProvider == null || editingDomainProvider.getEditingDomain() == null) {
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
            this.dataEditable = false;
        } else {
            this.editingDomain = editingDomainProvider.getEditingDomain();
            this.dataEditable = true;
        }
        if (tableInstanceParam == null) {
            this.tableInstance = TableFactory.eINSTANCE.createTable();
            this.resource = this.createDefaultResource();
            this.resource.getContents().add((Object)this.tableInstance);
        } else if (tableInstanceParam.eResource() != null) {
            this.tableInstance = tableInstanceParam;
            this.resource = tableInstanceParam.eResource();
        } else {
            this.tableInstance = tableInstanceParam;
            this.resource = this.createDefaultResource();
            Command setResourceContentCommand = CommandFactory.createSetResourceContentsCommand((Resource)this.resource, (EObject)this.tableInstance);
            if (setResourceContentCommand instanceof ILockableUndoCommand) {
                ILockableUndoCommand lockableUndoCommand = (ILockableUndoCommand)setResourceContentCommand;
                lockableUndoCommand.enableCanUndo(false);
            }
            this.editingDomain.getCommandStack().execute(setResourceContentCommand);
            this.resource.getContents().add((Object)this.tableInstance);
        }
        this.initLaunchedHistory();
        this.commandFactory = ICommandFactoriesRegistry.INSTANCE.getCommandFactoryFor(this.editingDomain);
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.resource.getResourceSet());
        this.tableCommandFactory = new TableCommandFactory(this.tableInstance, this.editingDomain, this.commandFactory, this.facetManager);
        this.customizationEngine = ICustomizationManagerFactory.DEFAULT.createICustomizationManager(this.facetManager);
        this.contentPropertiesHandler = IContentPropertiesHandlerFactory.DEFAULT.createIContentPropertiesHandler(this.customizationEngine);
        this.selectionPropertiesHandler = ISelectionPropertiesHandlerFactory.DEFAULT.createSelectionPropertiesHandler(this.customizationEngine);
        this.init();
    }

    private final Resource createDefaultResource() {
        return this.editingDomain.getResourceSet().createResource(URI.createFileURI((String)DEFAULT_RESOURCE_FILE.getPath()));
    }

    private void init() throws CustomizationException {
        DebugUtils.debug((boolean)DEBUG_EVENTS);
        this.reset();
        this.view.asComposite().setLayout((Layout)new FillLayout());
        this.view.asComposite().addDisposeListener((DisposeListener)this);
        if (this.tableInstance != null) {
            this.tableInstance.eAdapters().add((Object)this.tableInstanceAdapter);
            this.resource.setTrackingModification(true);
            this.resource.eAdapters().add((Object)this.tableInstanceAdapter);
        }
        if (this.editingDomain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)this.editingDomain;
            transactionalEditingDomain.addResourceSetListener((ResourceSetListener)new RowDeleteTriggerListener(this.tableInstance));
        } else {
            this.editingDomain.getCommandStack().addCommandStackListener((CommandStackListener)new RowDeleteCommandStackListener(this.tableInstance, this.editingDomain));
        }
    }

    private final synchronized void reset() throws CustomizationException {
        DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"Start");
        this.updateMetaClassList();
        this.tableLabelProvider = ICustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(this.customizationEngine);
        this.facetManager.getManagedFacetSets().clear();
        this.facetManager.getManagedFacetSets().addAll(this.tableInstance.getFacetSets());
        new ArrayList(this.facetManager.getManagedFacetSets());
        if (this.getTable().getCustomizations() != null) {
            this.loadCustomizationsInCustomEngine((List<Customization>)this.getTable().getCustomizations());
        }
        this.removeUselessRowsAndColumns();
        this.fullRedraw();
        DebugUtils.debug((boolean)DEBUG_EVENTS, (String)"End");
    }

    private final void updateMetaClassList() {
        this.metaclasses = new HashSet<EClass>();
        for (EObject eObject : TableWidgetUtils.getElements(this.tableInstance)) {
            this.metaclasses.add(eObject.eClass());
        }
    }

    private final void initLaunchedHistory() {
        this.launchedInstMethHistory = new ArrayList<InstantiationMethod>();
        if (this.getTableConfiguration() != null && this.getTableConfiguration().getInstantiationMethod() != null) {
            for (InstantiationMethod meth : this.getTableConfiguration().getInstantiationMethod()) {
                this.launchedInstMethHistory.add(meth);
            }
        }
    }

    @Override
    public final void addChangeListener(List<Row> elementsValue) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Row row : elementsValue) {
            EObject eObject = row.getElement();
            if (eObject == null) continue;
            resources.add(eObject.eResource());
        }
        for (Resource referedResource : resources) {
            if (referedResource == null || this.listenedResources.contains(referedResource)) continue;
            this.listenedResources.add(referedResource);
            referedResource.setTrackingModification(true);
            if (referedResource.eAdapters().contains((Object)this.modelChangeAdapter)) continue;
            referedResource.eAdapters().add((Object)this.modelChangeAdapter);
        }
    }

    public final void widgetDisposed(DisposeEvent event) {
        this.disposed = true;
        this.fSelectionChangedListeners.clear();
        for (Resource resourceElt : this.listenedResources) {
            resourceElt.eAdapters().remove((Object)this.modelChangeAdapter);
        }
        if (this.tableInstance != null) {
            this.tableInstance.eAdapters().remove((Object)this.tableInstanceAdapter);
            this.resource.eAdapters().remove((Object)this.tableInstanceAdapter);
        }
    }

    private static Object getStructuralFeatureValue(EObject eObject, EStructuralFeature structuralFeature) {
        return eObject.eGet(structuralFeature);
    }

    private static boolean hasStructuralFeature(EObject eObject, EStructuralFeature structuralFeature) {
        EClass eClass = eObject.eClass();
        return eClass.getEAllStructuralFeatures().contains((Object)structuralFeature);
    }

    @Override
    public final void tableSelectionChanged() {
        for (ISelectionChangedListener listener : new ArrayList<ISelectionChangedListener>(this.fSelectionChangedListeners)) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    public final void setSelection(ISelection selection) {
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.fSelectionChangedListeners.contains(listener)) {
            this.fSelectionChangedListeners.add(listener);
        }
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove(listener);
    }

    private static boolean isInCellEditorRegistry(AbstractModelCellEditor cellEditor) {
        List allCellEditorContainers = ICellEditorsRegistry.INSTANCE.getAllCellEditors();
        for (IModelCellEditorContainer currentEditorContainer : allCellEditorContainers) {
            if (!cellEditor.getCellId().equals(currentEditorContainer.getModelCellEditor().getCellId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void sortColumnsByType() {
        try {
            try {
                Column columnDescription;
                this.view.asComposite().setRedraw(false);
                this.listenReorderEvent = false;
                int[] order = new int[this.tableInstance.getColumns().size()];
                int i = 0;
                int j = 0;
                while (j < this.tableInstance.getColumns().size()) {
                    columnDescription = (Column)this.tableInstance.getColumns().get(j);
                    if (columnDescription instanceof SourceColumn) {
                        order[i++] = j;
                    }
                    ++j;
                }
                j = 0;
                while (j < this.tableInstance.getColumns().size()) {
                    FeatureColumn featureColumn;
                    columnDescription = (Column)this.tableInstance.getColumns().get(j);
                    if (columnDescription instanceof FeatureColumn && (featureColumn = (FeatureColumn)columnDescription).getFeature() instanceof EAttribute) {
                        order[i++] = j;
                    }
                    ++j;
                }
                ArrayList<Integer> links = new ArrayList<Integer>();
                int j2 = 0;
                while (j2 < this.tableInstance.getColumns().size()) {
                    FeatureColumn featureColumn;
                    Column columnDescription2 = (Column)this.tableInstance.getColumns().get(j2);
                    if (columnDescription2 instanceof FeatureColumn && (featureColumn = (FeatureColumn)columnDescription2).getFeature() instanceof EReference) {
                        links.add(j2);
                    }
                    ++j2;
                }
                for (Integer linkPos : links) {
                    order[i++] = linkPos;
                }
                CompoundCommand compoundCommand = new CompoundCommand();
                int index = 0;
                while (index < order.length) {
                    int pos = order[index];
                    EObject element = (EObject)this.tableInstance.getColumns().get(pos);
                    Command command = this.commandFactory.createMoveCommand(this.editingDomain, (Object)this.tableInstance, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)element, index);
                    compoundCommand.append(command);
                    ++index;
                }
                this.editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by type", (Plugin)Activator.getDefault());
                this.view.asComposite().setRedraw(true);
                this.listenReorderEvent = true;
            }
        }
        finally {
            this.view.asComposite().setRedraw(true);
            this.listenReorderEvent = true;
        }
    }

    @Override
    public final void setHideEmptyColumns(boolean hideEmptyColumns) {
        this.setWithCommand(this.tableInstance, TablePackage.eINSTANCE.getTable_HideEmptyColumns(), hideEmptyColumns);
    }

    @Override
    public final boolean isEmptyColumn(Column column) {
        FeatureColumn featureColumn;
        boolean result = false;
        if (column instanceof FeatureColumn && (featureColumn = (FeatureColumn)column).getFeature() instanceof EReference) {
            result = this.isEmpty((EStructuralFeature)((EReference)featureColumn.getFeature()));
        }
        return result;
    }

    private boolean getHiddenColumnStatus(FeatureColumn c, Set<EClass> featureOwners) throws CustomizationException {
        return (Boolean)this.customizationEngine.getCustomValueOf((EObject)c.getFeature(), this.contentPropertiesHandler.getIsVisible(), Boolean.class);
    }

    private boolean getHiddenAttributeColumnStatus(FeatureColumn c, Set<EClass> featureOwners) throws CustomizationException {
        return (Boolean)this.customizationEngine.getCustomValueOf((EObject)c.getFeature(), this.contentPropertiesHandler.getIsVisible(), Boolean.class);
    }

    private boolean getHiddenReferenceColumnStatus(FeatureColumn c, Set<EClass> featureOwner) throws CustomizationException {
        return (Boolean)this.customizationEngine.getCustomValueOf((EObject)c.getFeature(), this.contentPropertiesHandler.getIsVisible(), Boolean.class);
    }

    @Override
    public final void selectColumnsToHide() {
        this.openColumnsToHideDialog();
    }

    @Override
    public final IColumnsToHideDialog openColumnsToHideDialog() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Column) {
                    Column column = (Column)element;
                    return TableWidgetInternalUtils.getColumnName(column);
                }
                return null;
            }
        };
        boolean localCustomizatinMustBeTheTop = PreferenceConstants.isMustPutOnTheTopTheLocalCustom();
        boolean askToPutOnTheTopTheLocalCustomization = PreferenceConstants.isAskToPutOnTheTopTheLocalCustomization();
        final ColumnsToHideDialog dialog = new ColumnsToHideDialog(this.view.asComposite().getShell(), this.getTable().getColumns(), (ILabelProvider)labelProvider, this.isOneOfTheLocalCustomizationsNotOnTheTop() && askToPutOnTheTopTheLocalCustomization, localCustomizatinMustBeTheTop){

            @Override
            protected void okPressed() {
                super.okPressed();
                if (this.getResult() != null) {
                    TableWidgetController.this.showHideColumns(this.getSelectedColumns(), this.isPutOnTheTop() && TableWidgetController.this.isOneOfTheLocalCustomizationsNotOnTheTop());
                    TableWidgetController.setMustAskThUserToPutOnTheTopTheLocalCustomizationNextTime(this.isMustAskTheUserNextTime(), this.isPutOnTheTop());
                }
            }

            @Override
            public List<Column> getVisibleColumns(boolean putOnTheTop) {
                return TableWidgetController.this.getVisibleColumns(putOnTheTop);
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog;
    }

    private static void setMustAskThUserToPutOnTheTopTheLocalCustomizationNextTime(boolean mustAskTheUserNextTime, boolean putOnTheTop) {
        PreferenceConstants.setAskToPutOnTheTopTheLocalCustomization(mustAskTheUserNextTime);
        if (!mustAskTheUserNextTime) {
            PreferenceConstants.setMustPutOnTheTopTheLocalCustom(putOnTheTop);
        }
    }

    @Override
    public final void showHideColumns(List<Column> columnToShow, boolean putOnTheTop) {
        ArrayList<Column> columnsToShow = new ArrayList<Column>();
        ArrayList<Column> columnsToHide = new ArrayList<Column>();
        EList columns = this.getTable().getColumns();
        for (Column c : columns) {
            boolean mustBeHidden;
            boolean bl = mustBeHidden = !columnToShow.contains(c);
            if (mustBeHidden != this.getVisibleColumns(putOnTheTop).contains(c)) continue;
            if (mustBeHidden) {
                columnsToHide.add(c);
                continue;
            }
            columnsToShow.add(c);
        }
        this.showHideColumns(columnsToShow, columnsToHide, putOnTheTop);
    }

    @Override
    public final boolean isOneOfTheLocalCustomizationsNotOnTheTop() {
        EList view = this.tableInstance.getCustomizations();
        List<Customization> locals = this.getLocalCustomizations();
        if (view.size() < locals.size()) {
            throw new TableWidgetRuntimeException("Some local customization files are not loaded");
        }
        int i = 0;
        while (i < locals.size()) {
            if (!locals.contains(view.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final List<Customization> getLocalCustomizations() {
        return this.tableInstance.getLocalCustomizations();
    }

    private final List<Column> getNotHiddenColumns(int setAtTheTop, boolean atTheTop) throws CustomizationException {
        List<Object> notHiddenColumns = new ArrayList();
        if (atTheTop) {
            notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations(this.tableInstance, false);
        } else if (setAtTheTop == 3) {
            notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations(this.tableInstance, false);
        } else if (setAtTheTop == 2) {
            notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations(this.tableInstance, true);
        }
        return notHiddenColumns;
    }

    private void showHideColumns(List<Column> columnsToShow, List<Column> columnsToHide, boolean putOnTheTop) {
        Command showHideColumnsCommand = TableInstanceCommandFactory.createShowHideColumnCommand(this, columnsToShow, columnsToHide, putOnTheTop);
        this.executeCommand(showHideColumnsCommand);
    }

    @Override
    public void putLocalCustomizationOnTheTop() {
        this.editingDomain.getCommandStack().execute(TableInstanceCommandFactory.createPutLocalCustomizationOnTheTopCommand(this));
    }

    private final List<Column> getVisibleColumnsUsingCustomizationEngine(Table table) throws CustomizationException {
        ArrayList<Column> visibleColumns = new ArrayList<Column>();
        EList columns = table.getColumns();
        int i = 0;
        while (i < columns.size()) {
            Column column = (Column)columns.get(i);
            if (column instanceof FeatureColumn) {
                FeatureColumn featureColumn = (FeatureColumn)column;
                if (featureColumn.getFeature() instanceof EStructuralFeature) {
                    EStructuralFeature structuralFeature = (EStructuralFeature)featureColumn;
                    Set owners = EMFUtils.getAllFeatureOwner(TableWidgetUtils.getElements(table), (EStructuralFeature)structuralFeature);
                    if (!this.getHiddenColumnStatus(featureColumn, owners)) {
                        visibleColumns.add(column);
                    }
                }
            } else if (column instanceof SourceColumn) {
                SourceColumn sourceColumn = (SourceColumn)column;
                if (!sourceColumn.isIsHidden()) {
                    visibleColumns.add(column);
                }
            } else {
                throw new IllegalStateException("Unexpected column type.");
            }
            ++i;
        }
        return visibleColumns;
    }

    public final List<Column> getVisibleColumnsUsingTheLocalCustomizations(Table table, boolean setToTheTop) throws CustomizationException {
        ICustomizationManager localEngine = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.resource.getResourceSet());
        if (setToTheTop) {
            for (Customization customization : this.tableInstance.getCustomizations()) {
                localEngine.getManagedCustomizations().add(0, customization);
            }
        } else {
            for (Customization customization : this.tableInstance.getLocalCustomizations()) {
                localEngine.getManagedCustomizations().add(0, customization);
            }
        }
        ArrayList<Column> notHiddenColumns = new ArrayList<Column>();
        for (Column c : table.getColumns()) {
            boolean isVisible = true;
            if (c instanceof FeatureColumn) {
                FeatureColumn featureColumn = (FeatureColumn)c;
                ETypedElement typedElement = featureColumn.getFeature();
                isVisible = (Boolean)localEngine.getCustomValueOf((EObject)typedElement, this.contentPropertiesHandler.getIsVisible(), Boolean.class);
            } else if (c instanceof SourceColumn) {
                SourceColumn sourceColumn = (SourceColumn)c;
                isVisible = !sourceColumn.isIsHidden();
            } else {
                throw new IllegalStateException("Unknown column type");
            }
            if (!isVisible) continue;
            notHiddenColumns.add(c);
        }
        return notHiddenColumns;
    }

    @Deprecated
    public final void hideColumns() {
        this.selectColumnsToHide();
    }

    private boolean isEmpty(EStructuralFeature reference) {
        for (EObject eObject : TableWidgetUtils.getElements(this.tableInstance)) {
            List list;
            if (!TableWidgetController.hasStructuralFeature(eObject, reference)) continue;
            Object value = TableWidgetController.getStructuralFeatureValue(eObject, reference);
            if (!(reference.isMany() && value instanceof List ? !(list = (List)value).isEmpty() : value != null)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void setOnlyShowCommonColumns(boolean onlyShowCommonColumns) {
        this.setWithCommand(this.tableInstance, TablePackage.eINSTANCE.getTable_OnlyShowCommonColumns(), onlyShowCommonColumns);
    }

    @Override
    public final boolean isColumnSelected() {
        List<Column> columns = this.getSelectedColumns();
        if (columns != null) {
            return columns.size() > 0;
        }
        return false;
    }

    @Override
    public final void removeLine() {
        try {
            this.removeLine2();
        }
        catch (CoreException e) {
            throw new TableWidgetRuntimeException(e);
        }
    }

    private Collection<Row> getSelectedRow() {
        List<Integer> selectedRowIndex = this.getSelecedRowIndexes();
        ArrayList<Row> selectedEObjects = new ArrayList<Row>();
        for (Integer index : selectedRowIndex) {
            selectedEObjects.add((Row)this.tableInstance.getRows().get(index.intValue()));
        }
        return selectedEObjects;
    }

    @Override
    public List<EObject> getSelectedRowEObjects() {
        List<Integer> selectedRowIndex = this.getSelecedRowIndexes();
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        for (Integer index : selectedRowIndex) {
            selectedEObjects.add(((Row)this.tableInstance.getRows().get(index.intValue())).getElement());
        }
        return selectedEObjects;
    }

    private List<Integer> getSelecedRowIndexes() {
        IPositionCoordinate[] selectedCells;
        ArrayList<Integer> selectedRowIndex = new ArrayList<Integer>();
        IPositionCoordinate[] iPositionCoordinateArray = selectedCells = this.getSelectedCells2();
        int n = selectedCells.length;
        int n2 = 0;
        while (n2 < n) {
            IPositionCoordinate positionCoordinate = iPositionCoordinateArray[n2];
            if (!selectedRowIndex.contains(positionCoordinate.getRowPosition())) {
                selectedRowIndex.add(positionCoordinate.getRowPosition());
            }
            ++n2;
        }
        return selectedRowIndex;
    }

    private final void removeLine2() throws CoreException {
        Collection<Row> rows = this.getSelectedRow();
        Command cmd = this.tableCommandFactory.createRemoveRowsCommand(rows);
        this.executeCommand(cmd);
    }

    @Override
    public final void deleteSelection() {
        try {
            this.deleteSelectedElements();
        }
        catch (CoreException e) {
            throw new TableWidgetRuntimeException(e);
        }
    }

    private void deleteSelectedElements() throws CoreException {
        Command deleteSelectedElementsCommand = TableInstanceCommandFactory.createDeleteSelectedElementsCommand(this, this.commandFactory);
        this.editingDomain.getCommandStack().execute(deleteSelectedElementsCommand);
    }

    public void addQueryColumns(List<ETypedElement> eTypedElements) {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (ETypedElement typedElement : eTypedElements) {
            FeatureColumn queryColumn = null;
            if (typedElement instanceof EStructuralFeature) {
                EAttribute eAttribute = (EAttribute)typedElement;
                FeatureColumn attColumn = TableFactory.eINSTANCE.createFeatureColumn();
                attColumn.setFeature((ETypedElement)eAttribute);
                queryColumn = attColumn;
            } else if (typedElement instanceof EOperation) {
                EOperation cfr_ignored_0 = (EOperation)typedElement;
                throw new IllegalStateException("Not yet implemented");
            }
            Command command = this.commandFactory.createAddCommand(this.editingDomain, (Object)this.tableInstance, (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)queryColumn);
            compoundCommand.append(command);
            this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    @Override
    public final List<InstantiationMethod> getInstantiationMethodHistory() {
        return this.launchedInstMethHistory;
    }

    @Override
    public final void selectInstantiationMethodToLaunch() {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof InstantiationMethod) {
                    InstantiationMethod meth = (InstantiationMethod)element;
                    return meth.getName();
                }
                return null;
            }
        };
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            private Object[] objects;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof List) {
                    List list = (List)newInput;
                    this.objects = list.toArray();
                }
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return this.objects;
            }
        };
        ListDialog dialog = new ListDialog(this.view.asComposite().getShell());
        dialog.setContentProvider(contentProvider);
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setInput(this.launchedInstMethHistory);
        dialog.setTitle(Messages.NatTableWidget_instantiationMethodSelectionTitle);
        if (dialog.open() != 1 && dialog.getResult()[0] instanceof InstantiationMethod) {
            InstantiationMethod meth = (InstantiationMethod)dialog.getResult()[0];
            this.launchedInstMethHistory.remove(meth);
            this.launchedInstMethHistory.add(0, meth);
            this.createNewElement();
        }
    }

    @Override
    public final void createNewElement() {
        if (this.launchedInstMethHistory.get(0) == null) {
            this.selectInstantiationMethodToLaunch();
        } else {
            this.createNewElement(this.launchedInstMethHistory.get(0));
        }
    }

    @Override
    public final void createNewElement(InstantiationMethod instantiationMethod) {
        try {
            this.internalCreateNewElement(instantiationMethod);
        }
        catch (Exception e) {
            throw new TableWidgetRuntimeException(e);
        }
    }

    private final void internalCreateNewElement(InstantiationMethod instantiationMethod) throws FacetManagerException {
        EOperation eOperation = instantiationMethod.getInstantiationOperation();
        if (eOperation != null) {
            EObject context = this.getContext();
            if (context == null) {
                throw new IllegalStateException("The table context must not be null when invoking an instantiation method");
            }
            EObject queryResult = (EObject)this.facetManager.invoke(context, eOperation, EObject.class, this.editingDomain, new Object[]{this.tableInstance.getParameter(), this.getEditingDomain()});
            ArrayList<EObject> list = new ArrayList<EObject>();
            list.add(queryResult);
            this.addRows(list);
            this.launchedInstMethHistory.remove(instantiationMethod);
            this.launchedInstMethHistory.add(0, instantiationMethod);
        }
    }

    @Override
    public final boolean isNonCommonColumns(Column column) {
        FeatureColumn featureColumn;
        boolean common = true;
        if (column instanceof FeatureColumn && (featureColumn = (FeatureColumn)column).getFeature() instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)featureColumn.getFeature();
            common = this.isCommon(structuralFeature);
        }
        return !common;
    }

    private boolean isCommon(EStructuralFeature feature) {
        for (EClass metaclass : this.metaclasses) {
            if (metaclass.getEAllStructuralFeatures().contains((Object)feature)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final List<Column> getColumns() {
        return Collections.unmodifiableList(this.tableInstance.getColumns());
    }

    @Override
    @Deprecated
    public final void loadCustomizations(List<Customization> customizationsToLoad) {
        this.loadCustomizations(customizationsToLoad, true);
    }

    private final void loadCustomizationsInCustomEngine(List<Customization> customizationsToLoad) throws CustomizationException {
        List<Customization> locals = this.getLocalCustomizations();
        if (this.tableInstance.getRows().size() != 0 && locals.isEmpty()) {
            Logger.logError((String)("The local customs should always be contained by customizationsToLoad, please update the model: " + this.tableInstance.eResource().getURI()), (Plugin)Activator.getDefault());
        }
        if (!locals.isEmpty() && !customizationsToLoad.containsAll(locals)) {
            Logger.logError((String)"The local customs should always be contained by customizationsToLoad", (Plugin)Activator.getDefault());
        }
        this.customizationEngine.getManagedCustomizations().removeAll(customizationsToLoad);
        for (Customization customizationToLoad : customizationsToLoad) {
            this.customizationEngine.getManagedCustomizations().add(0, customizationToLoad);
        }
    }

    @Override
    public ICustomizationManager getCustomizationEngine() {
        return this.customizationEngine;
    }

    @Override
    public final IFacetManager getFacetContext() {
        return this.facetManager;
    }

    @Override
    public final void setFacetSets(List<? extends FacetSet> facetSets) {
        if (DEBUG_SET_FACET) {
            System.out.println(String.valueOf(this.getClass().getName()) + ".setFacets(): " + facetSets.size());
            for (FacetSet facetSet : facetSets) {
                System.out.println(String.valueOf(this.getClass().getName()) + ".setFacets(): " + facetSet.getName());
            }
        }
        this.setLoadedFacetSets(new ArrayList<FacetSet>(facetSets));
        if (DEBUG_SET_FACET) {
            int n = this.tableInstance.getColumns().size();
            int nbVisibleColumnsUsingTheLayer = this.getVisibleColumnsUsingTheLayer().size();
            int nbNonFacetColumns = 0;
            for (Column column : this.tableInstance.getColumns()) {
                if (column instanceof FeatureColumn) {
                    FeatureColumn featureColumn = (FeatureColumn)column;
                    if (featureColumn.getFeature() instanceof FacetElement) continue;
                    ++nbNonFacetColumns;
                    continue;
                }
                ++nbNonFacetColumns;
            }
            System.out.println(String.valueOf(this.getClass().getName()) + ".setFacets(): nbColumns=" + n);
            System.out.println(String.valueOf(this.getClass().getName()) + ".setFacets(): nbVisibleColumnsUsingTheLayer=" + nbVisibleColumnsUsingTheLayer);
            System.out.println(String.valueOf(this.getClass().getName()) + ".setFacets(): nbNonFacetColumns=" + nbNonFacetColumns);
        }
    }

    public final Collection<FacetSet> getLoadedFacetSets() {
        return Collections.unmodifiableCollection(this.tableInstance.getFacetSets());
    }

    public final void clearFacets() {
        try {
            this.facetManager.getManagedFacetSets().clear();
        }
        catch (Exception e) {
            Logger.logError((Throwable)e, (String)"Error clearing Facets", (Plugin)Activator.getDefault());
        }
    }

    public final Collection<EPackage> getReferencedEPackages() {
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EObject eObject : TableWidgetUtils.getElements(this.tableInstance)) {
            EPackage ePackage;
            EClass eClass = eObject.eClass();
            if (eClass == null || (ePackage = eClass.getEPackage()) == null) continue;
            ePackages.add(ePackage);
        }
        return ePackages;
    }

    @Override
    public final TableConfiguration getTableConfiguration() {
        return this.getTable().getTableConfiguration();
    }

    @Override
    public final Table getTable() {
        return this.tableInstance;
    }

    public final EObject getContext() {
        return this.getTable().getContext();
    }

    @Override
    public final void addRows(List<? extends EObject> newElements) {
        Command addRowCommand = this.tableCommandFactory.createAddRowsCommand(newElements);
        this.executeCommand(addRowCommand);
    }

    public final boolean isSelectedColumnDeletable() {
        throw new IllegalStateException("Query column does not exist anymore. So no column can be deleted.");
    }

    @Override
    public final void openLoadCustomizationDialog() {
        HashSet availableCustomsSet = new HashSet();
        availableCustomsSet.addAll(ICustomizationCatalogManagerFactory.DEFAULT.getOrCreateCustomizationCatalogManager(this.resource.getResourceSet()).getRegisteredCustomizations());
        availableCustomsSet.addAll(this.tableInstance.getCustomizations());
        ArrayList availableCustomsList = new ArrayList(availableCustomsSet);
        IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<Customization>, Boolean, IQuestionDialog>(){

            public void committed(List<Customization> result, Boolean precommitResult) {
                if (precommitResult.booleanValue()) {
                    TableWidgetController.this.loadCustomizations(result, true);
                }
            }

            public IQuestionDialog openPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
                return TableWidgetController.this.openLoadCustomizationPrecommitDialog(result, precommitCallback);
            }
        };
        ILoadCustomizationsDialog dialog = ILoadCustomizationsDialogFactory.DEFAULT.createLoadCustomizationDialog(null, availableCustomsList, (List)this.tableInstance.getCustomizations(), (List)this.tableInstance.getLocalCustomizations(), (IDialogCallbackWithPreCommit)callback, "It is used to store the hidden columns.");
        dialog.asyncOpen();
    }

    protected IQuestionDialog openLoadCustomizationPrecommitDialog(List<Customization> result, IDialogCallback<Boolean> precommitCallback) {
        ArrayList removedCustoms = new ArrayList();
        removedCustoms.addAll(this.getTable().getCustomizations());
        removedCustoms.removeAll(result);
        ArrayList<FacetSet> newFacetSets = new ArrayList<FacetSet>();
        newFacetSets.addAll((Collection<FacetSet>)this.getTable().getFacetSets());
        newFacetSets.removeAll(removedCustoms);
        return this.openFacetSetLoadPrecommitDialog(newFacetSets, precommitCallback);
    }

    @Override
    public final void openLoadFacetSetsDialog() {
        HashSet<FacetSet> availableFacetSets = new HashSet<FacetSet>();
        availableFacetSets.addAll(IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.editingDomain.getResourceSet()).getRegisteredFacetSets());
        if (this.tableInstance.getTableConfiguration() != null) {
            for (Facet facet : this.tableInstance.getTableConfiguration().getDefaultFacets()) {
                availableFacetSets.add(FacetUtils.getRootFacetSet((Facet)facet));
            }
        }
        for (FacetSet facetSet : this.tableInstance.getFacetSets()) {
            availableFacetSets.add(FacetUtils.getRootFacetSet((FacetSet)facetSet));
        }
        IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, IQuestionDialog> callback = new IDialogCallbackWithPreCommit<List<FacetSet>, Boolean, IQuestionDialog>(){

            public void committed(List<FacetSet> result, Boolean precommitResult) {
                if (precommitResult.booleanValue()) {
                    TableWidgetController.this.setLoadedFacetSets(result);
                }
            }

            public IQuestionDialog openPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
                return TableWidgetController.this.openFacetSetLoadPrecommitDialog(result, precommitCallback);
            }
        };
        IFacetSetSelectionDialog dialog = IFacetSetSelectionDialogFactory.DEFAULT.openFacetSetSelectionDialog(availableFacetSets, Integer.MAX_VALUE, true, (IDialogCallbackWithPreCommit)callback, this.view.getShell());
        dialog.setSelectedFacetSets((List)this.tableInstance.getFacetSets());
    }

    protected IQuestionDialog openFacetSetLoadPrecommitDialog(List<FacetSet> result, IDialogCallback<Boolean> precommitCallback) {
        IQuestionDialog dialog = null;
        if (!InternalTableUtils.columnsToRemove(this.getTable(), result, (List<Row>)this.getTable().getRows()).isEmpty()) {
            final IQuestionDialog finalDialog = IQuestionDialogFactory.INSTANCE.createQuestionDialog(this.getShell(), Messages.TableWidgetController_Remove_columns_after_facetSet_setting_short, Messages.TableWidgetController_Remove_columns_after_facetSet_setting_long, precommitCallback);
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    finalDialog.open();
                }
            });
            dialog = finalDialog;
        }
        return dialog;
    }

    protected Shell getShell() {
        return this.view.getShell();
    }

    @Override
    public final void saveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.view.asComposite().getShell());
        dialog.setOriginalName("My.table");
        dialog.open();
        if (dialog.getReturnCode() != 1) {
            URI uri = URI.createPlatformResourceURI((String)dialog.getResult().toString(), (boolean)true);
            if (uri != null) {
                this.resource.setURI(uri);
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("USE_FILE_BUFFER", Boolean.TRUE);
                try {
                    this.resource.save(options);
                }
                catch (IOException e) {
                    Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
            }
            if (this.editingDomain != null) {
                ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            }
        }
    }

    @Override
    public final void save() {
        final HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("USE_FILE_BUFFER", Boolean.TRUE);
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor2) {
                if (TableWidgetController.this.resource == null || TableWidgetController.this.resource.getURI().lastSegment().equals(TMP_FILE_NAME)) {
                    TableWidgetController.this.saveAs();
                }
                for (Resource resourceElt : TableWidgetController.this.editingDomain.getResourceSet().getResources()) {
                    if (!TableWidgetController.this.isPersisted(resourceElt) || resourceElt.getContents().isEmpty() || TableWidgetController.this.editingDomain.isReadOnly(resourceElt)) continue;
                    try {
                        resourceElt.save(options);
                    }
                    catch (Exception e) {
                        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (InterruptedException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
    }

    private boolean isPersisted(Resource resourceParam) {
        boolean result;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resourceParam.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            } else {
                result = false;
            }
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    @Override
    public final boolean isDataEditable() {
        return this.dataEditable;
    }

    @Override
    public final void drop(StructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        CompoundCommand compoundCommand = TableInstanceCommandFactory.createDropCommand(this, (IStructuredSelection)structuredSelection, element, feature);
        if (compoundCommand != null && !compoundCommand.isEmpty()) {
            this.editingDomain.getCommandStack().execute((Command)compoundCommand);
        }
    }

    @Override
    public void drop(StructuredSelection structuredSelection) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        for (Object selectedElement : structuredSelection) {
            if (!(selectedElement instanceof EObject)) continue;
            EObject selectedEObject = (EObject)selectedElement;
            if (!this.acceptsElement(selectedEObject)) {
                MessageDialog.openWarning((Shell)this.view.asComposite().getShell(), (String)Messages.wrongEObjectType, (String)(String.valueOf(Messages.wrongEObjectTypeLong) + EcoreUtil.getURI((EObject)selectedEObject.eClass())));
                return;
            }
            list.add(selectedEObject);
        }
        this.addRows(list);
    }

    @Override
    public final boolean canBeDropped(IStructuredSelection structuredSelection, EStructuralFeature feature, Object element) {
        CompoundCommand compoundCommand = TableInstanceCommandFactory.createDropCommand(this, structuredSelection, element, feature);
        return compoundCommand != null && compoundCommand.canExecute();
    }

    private final void setWithCommand(Object owner, Object feature, Object value) {
        Command cmd = this.commandFactory.createSetCommand(this.editingDomain, owner, feature, value);
        this.editingDomain.getCommandStack().execute(cmd);
    }

    @Override
    public final Control getComposite() {
        return this.view.asComposite();
    }

    @Override
    public final void registerActionDelegate(IActionDelegate action) {
        if (!this.actionList.contains(action)) {
            this.actionList.add(action);
        }
    }

    @Override
    public final void unregisterActionDelegate(IActionDelegate action) {
        this.actionList.remove(action);
    }

    @Override
    public final void notifyActions() {
        for (IActionDelegate action : this.actionList) {
            action.selectionChanged(null, null);
        }
    }

    @Override
    public final Collection<ISelectionChangedListener> getSelectionChangedListeners() {
        return Collections.unmodifiableCollection(new ArrayList<ISelectionChangedListener>(this.fSelectionChangedListeners));
    }

    @Override
    public final void sortColumnByNameAtoZ() {
        try {
            try {
                this.view.asComposite().setRedraw(false);
                this.listenReorderEvent = false;
                ArrayList columns = new ArrayList(this.tableInstance.getColumns());
                Collections.sort(columns, new ColumnComparator());
                Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TablePackage.eINSTANCE.getTable_Columns(), columns);
                this.editingDomain.getCommandStack().execute(command);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by name From A to Z", (Plugin)Activator.getDefault());
                this.view.asComposite().setRedraw(true);
                this.listenReorderEvent = true;
            }
        }
        finally {
            this.view.asComposite().setRedraw(true);
            this.listenReorderEvent = true;
        }
    }

    @Override
    public final void sortColumnByNameZtoA() {
        try {
            try {
                this.view.asComposite().setRedraw(false);
                this.listenReorderEvent = false;
                ArrayList columns = new ArrayList(this.tableInstance.getColumns());
                ColumnComparator comparator = new ColumnComparator();
                comparator.setInversedOrder(true);
                Collections.sort(columns, comparator);
                Command command = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TablePackage.eINSTANCE.getTable_Columns(), columns);
                this.editingDomain.getCommandStack().execute(command);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e, (String)"Error sorting columns by name from Z to A", (Plugin)Activator.getDefault());
                this.view.asComposite().setRedraw(true);
                this.listenReorderEvent = true;
            }
        }
        finally {
            this.view.asComposite().setRedraw(true);
            this.listenReorderEvent = true;
        }
    }

    private int getRowIndexByEObject(EObject eObject) {
        int rowIndex = -1;
        EList rows = this.tableInstance.getRows();
        int i = 0;
        while (i < rows.size()) {
            if (((Row)rows.get(i)).getElement().equals(eObject)) {
                rowIndex = i;
                break;
            }
            ++i;
        }
        return rowIndex;
    }

    @Override
    public final List<Column> getVisibleColumns(boolean setAtTheTop) {
        ArrayList<Column> notHiddenColumns = new ArrayList();
        try {
            notHiddenColumns = this.getVisibleColumnsUsingTheLocalCustomizations(this.tableInstance, setAtTheTop);
        }
        catch (Exception e) {
            throw new TableWidgetRuntimeException(e);
        }
        return notHiddenColumns;
    }

    @Override
    public final void putLocalCustomizationOnTheBottom() {
        this.editingDomain.getCommandStack().execute(this.getPutLocalCustomizationOnTheBottomCommand());
    }

    private Command getPutLocalCustomizationOnTheBottomCommand() {
        List<Customization> locals = this.getLocalCustomizations();
        ArrayList<Customization> customizations = new ArrayList<Customization>();
        customizations.addAll((Collection<Customization>)this.tableInstance.getCustomizations());
        customizations.removeAll(locals);
        customizations.addAll(customizations.size(), locals);
        return this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TablePackage.eINSTANCE.getTable_Customizations(), customizations);
    }

    @Override
    public final Row findRow(EObject eObject) {
        for (Row row : this.tableInstance.getRows()) {
            if (!row.getElement().equals(eObject)) continue;
            return row;
        }
        return null;
    }

    protected final void refreshDelayed() {
        DebugUtils.debug((boolean)DEBUG_RESOURCE_LISTENER);
        this.refreshJob.cancel();
        this.refreshJob.setPriority(50);
        this.refreshJob.schedule(100L);
    }

    @Override
    public final EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public final ICommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Override
    public final void waitForRefreshJob() {
        boolean wait = true;
        while (wait) {
            try {
                if (this.refreshJob != null) {
                    this.refreshJob.join();
                }
                wait = false;
            }
            catch (InterruptedException interruptedException) {
                wait = true;
            }
        }
    }

    private final void removeUselessRowsAndColumns() {
        Command command = TableInstanceCommandFactory.createRemoveUselessRowsAndColumnsCommand(this);
        this.executeCommand(command);
    }

    @Override
    public final boolean usesTmpResource() {
        String uri = URI.createFileURI((String)DEFAULT_RESOURCE_FILE.toString()).toFileString();
        String tableInstanceResourceURI = this.getTable().eResource().getURI().toFileString();
        return uri.equals(tableInstanceResourceURI);
    }

    @Override
    public final MenuManager getMenuManager() {
        return this.menuMgr;
    }

    @Override
    public ICustomizedLabelProvider getTableLabelProvider() {
        return this.tableLabelProvider;
    }

    @Override
    public void setColumnWidth(Column column, int width) {
        Command cmd = this.getCommandFactory().createSetCommand(this.getEditingDomain(), (Object)column, (Object)TablePackage.eINSTANCE.getColumn_Width(), (Object)width);
        this.getEditingDomain().getCommandStack().execute(cmd);
    }

    @Override
    public void setRowHeight(Row row, int height) {
        Command cmd = this.getCommandFactory().createSetCommand(this.getEditingDomain(), (Object)row, (Object)TablePackage.eINSTANCE.getRow_Height(), (Object)height);
        this.getEditingDomain().getCommandStack().execute(cmd);
    }

    @Override
    public void moveColumn(Column element, int newPosition) {
        Command command = this.getCommandFactory().createMoveCommand(this.getEditingDomain(), (Object)this.getTable(), (Object)TablePackage.eINSTANCE.getTable_Columns(), (Object)element, newPosition);
        this.getEditingDomain().getCommandStack().execute(command);
    }

    @Override
    public List<Column> getVisibleColumnsUsingTheLayer() {
        return this.view.getVisibleColumnsUsingTheLayer();
    }

    public List<Column> getSelectedColumns() {
        return this.view.getSelectedColumns();
    }

    public IPositionCoordinate[] getSelectedCells2() {
        return this.view.getSelectedCells2();
    }

    @Override
    public List<IPositionCoordinate> getSelectedCellsPositions() {
        return Arrays.asList(this.getSelectedCells2());
    }

    @Override
    public void copySelectionToClipboard() {
        this.view.copySelectionToClipboard();
    }

    @Override
    public void selectAll() {
        this.view.selectAll();
    }

    @Override
    public boolean isCellSelected() {
        return this.view.isCellSelected();
    }

    @Override
    public boolean isCellsDeletable() {
        return this.view.isCellsDeletable();
    }

    @Override
    public void selectDefaultLabelCell(EObject eObject) {
        this.view.selectDefaultLabelCell(eObject);
    }

    @Override
    public void selectCell(EObject eObject, EStructuralFeature structuralFeature) {
        this.view.selectCell(eObject, structuralFeature);
    }

    @Override
    public void editSelectedCell() {
        if (this.isSelectedCellEditable()) {
            this.view.editSelectedCell();
        }
    }

    @Override
    public boolean isSelectedCellEditable() {
        List<IGridElement> gridElements = this.getSelectedGridElements();
        return gridElements.size() == 1 && this.isGridElementEditable(gridElements.get(0));
    }

    protected boolean isGridElementEditable(IGridElement gridElement) {
        FeatureColumn featureColumn;
        ETypedElement feature;
        boolean editable = false;
        EObject eObject = gridElement.getRow().getElement();
        Column column = gridElement.getColumn();
        URI uri = eObject.eResource().getURI();
        if ((uri.isPlatformResource() || uri.isFile()) && column instanceof FeatureColumn && (feature = (featureColumn = (FeatureColumn)column).getFeature()) instanceof EStructuralFeature && ((EStructuralFeature)feature).isChangeable()) {
            if (feature instanceof DerivedTypedElement) {
                try {
                    DerivedTypedElement derivedTypedElement = (DerivedTypedElement)feature;
                    editable = this.getFacetContext().isConforming(eObject, (Facet)derivedTypedElement.eContainer());
                }
                catch (Exception e) {
                    Logger.logWarning((Throwable)e, (String)"Failed to check Facet conformance", (Plugin)Activator.getDefault());
                }
            } else {
                EList eStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
                editable = eStructuralFeatures.contains(feature);
            }
        }
        return editable;
    }

    @Override
    public void selectRows(List<EObject> elementsToSelect, boolean clearTheSelection) {
        this.view.selectRows(elementsToSelect, clearTheSelection);
    }

    public ISelection getSelection() {
        this.checkNotDisposed();
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> gridSelection = this.view.getGridSelection();
        StringBuffer debugBuffer = null;
        if (DEBUG_SELECTION) {
            debugBuffer = new StringBuffer();
        }
        for (Object selectedElement : gridSelection) {
            if (!(selectedElement instanceof IGridElement)) continue;
            IGridElement gridElement = (IGridElement)selectedElement;
            Collection<? extends Object> resolvedSelection = this.resolveSelection(gridElement);
            for (Object object : resolvedSelection) {
                if (object == null) continue;
                result.add(object);
                if (!DEBUG_SELECTION) continue;
                debugBuffer.append(System.getProperty("line.separator")).append("    ").append(object);
            }
        }
        if (DEBUG_SELECTION) {
            DebugUtils.debug((String)debugBuffer.toString());
        }
        return new StructuredSelection(result);
    }

    private Collection<? extends Object> resolveSelection(IGridElement gridElement) {
        Collection<Object> result = Collections.emptyList();
        EObject element = gridElement.getRow().getElement();
        if (element != null && TableWidgetUtils.isApplicable(gridElement, this.getFacetContext())) {
            try {
                result = (Collection)this.customizationEngine.getCustomValueOf(element, ((FeatureColumn)gridElement.getColumn()).getFeature(), this.selectionPropertiesHandler.getSelectionProperty(), List.class);
            }
            catch (CustomizationException e) {
                Logger.logWarning((Throwable)e, (String)"Error in table selection customization", (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    private void checkNotDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("the widget is disposed");
        }
    }

    private void fullRedraw() {
        this.checkNotDisposed();
        this.view.fullRedraw();
    }

    @Override
    public boolean getListenReorderEvent() {
        return this.listenReorderEvent;
    }

    @Override
    public Display getDisplay() {
        return this.view.asComposite().getDisplay();
    }

    @Override
    public final void loadCustomizations(List<Customization> customizationsToLoad, boolean mustLoadAdditionalFacets) {
        Command command = this.tableCommandFactory.createSetCustomizationCommand(customizationsToLoad);
        this.executeCommand(command);
    }

    private void executeCommand(Command command) {
        if (command != null) {
            DebugUtils.debug((String)EmfDebugUtils.debugCommand((Command)command));
            if (command.canExecute()) {
                this.editingDomain.getCommandStack().execute(command);
            } else {
                throw new TableWidgetRuntimeException(EmfDebugUtils.debugCommand((Command)command));
            }
        }
    }

    @Override
    public IContentPropertiesHandler getCustomPropertiesHandler() {
        return this.contentPropertiesHandler;
    }

    @Override
    public IMustRemoveNonConformingElementsDialog setCanBePresentedInTheTable(final ETypedElement presentabilityQuery) {
        SynchronizedMustRemoveNonConformingElementsPromptDialog result;
        if (this.containsOnlyPresentableElements(presentabilityQuery)) {
            this.setCanBePresentedInTheTable(presentabilityQuery, false);
            result = null;
        } else {
            final MustRemoveNonConformingElementsPromptDialog dialog = new MustRemoveNonConformingElementsPromptDialog(this.view.getShell());
            dialog.addCloseListener(new Runnable(){

                public void run() {
                    try {
                        TableWidgetController.this.setCanBePresentedInTheTable(presentabilityQuery, dialog.getMustRemoveNonConformingElements());
                    }
                    catch (Exception e) {
                        TableWidgetController.this.logAndDisplayException(e);
                    }
                }
            });
            dialog.open();
            result = new SynchronizedMustRemoveNonConformingElementsPromptDialog(dialog);
        }
        return result;
    }

    @Override
    public void setCanBePresentedInTheTable(ETypedElement presentabilityQuery, boolean removeNonConformingElements) {
        Command removeNonConformingElementsCommand;
        if (presentabilityQuery != null) {
            Facet facet;
            if (!ModelUtils.isBooleanDataType((EClassifier)presentabilityQuery.getEType())) {
                throw new IllegalArgumentException("The presentability query must return a boolean");
            }
            if (presentabilityQuery.getUpperBound() > 1 || presentabilityQuery.getUpperBound() == -1 || presentabilityQuery.getLowerBound() > 1) {
                throw new IllegalArgumentException("The presentability query must be single-valued");
            }
            if (presentabilityQuery.eContainer() instanceof Facet && (facet = (Facet)presentabilityQuery.eContainer()).getExtendedMetaclass() != EcorePackage.eINSTANCE.getEObject()) {
                throw new IllegalArgumentException("The presentability query must be contained in a Facet extending EObject");
            }
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        Command setCommand = this.commandFactory.createSetCommand(this.editingDomain, (Object)this.tableInstance, (Object)TablePackage.eINSTANCE.getTable_CanBePresentedInTheTable(), (Object)presentabilityQuery);
        compoundCommand.append(setCommand);
        if (removeNonConformingElements && (removeNonConformingElementsCommand = this.createRemoveNonConformingElementsCommand(presentabilityQuery)) != null) {
            compoundCommand.append(removeNonConformingElementsCommand);
        }
        compoundCommand.setLabel(Messages.NatTableWidget_setPresentabilityQuery);
        this.editingDomain.getCommandStack().execute((Command)compoundCommand);
    }

    private Command createRemoveNonConformingElementsCommand(ETypedElement presentabilityQuery) {
        ArrayList<Row> rowsToRemove = new ArrayList<Row>();
        for (Row row : this.tableInstance.getRows()) {
            EObject element = row.getElement();
            if (this.acceptsElement(element, presentabilityQuery)) continue;
            rowsToRemove.add(row);
        }
        return this.tableCommandFactory.createRemoveRowsCommand(rowsToRemove);
    }

    private boolean containsOnlyPresentableElements(ETypedElement presentabilityQuery) {
        boolean allPresentable = true;
        EList rows = this.tableInstance.getRows();
        for (Row row : rows) {
            EObject element = row.getElement();
            if (this.acceptsElement(element, presentabilityQuery)) continue;
            allPresentable = false;
            break;
        }
        return allPresentable;
    }

    @Override
    public ETypedElement getCanBePresentedInTheTable() {
        return TableWidgetInternalUtils.getPresentabilityQuery(this.tableInstance);
    }

    @Override
    public IAllowedContentsETypedElementSelectionDialog openCanBePresentedInTheTableDialog() {
        IAllowedContentsETypedElementSelectionDialogCallback callBack = new IAllowedContentsETypedElementSelectionDialogCallback(){

            public boolean mustAskToRemoveNonAllowedElements(ETypedElement allowedContentsTypedElement) {
                return !TableWidgetController.this.containsOnlyPresentableElements(allowedContentsTypedElement);
            }

            public void committed(ETypedElement typedElement, boolean removeNonAllowedContents) {
                TableWidgetController.this.setCanBePresentedInTheTable(typedElement, removeNonAllowedContents);
            }

            public void canceled() {
            }
        };
        final AllowedContentsETypedElementSelectionDialog dialog = new AllowedContentsETypedElementSelectionDialog(this.view.getShell(), this.getAllKnownETypedElements(), callBack, this.customizationEngine);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                dialog.open();
                dialog.select(TableWidgetController.this.getCanBePresentedInTheTable());
            }
        });
        return new SynchronizedPresentabilityETypedElementSelectionDialog(dialog, this.view.getShell().getDisplay());
    }

    private List<ETypedElement> getAllKnownETypedElements() {
        Set<EClassifier> classifiers = this.getAllKnownEClassifiers();
        ArrayList<ETypedElement> typedElements = new ArrayList<ETypedElement>();
        for (EClassifier eClassifier : classifiers) {
            typedElements.addAll(TableWidgetController.getContainedETypedElements((EObject)eClassifier));
        }
        return typedElements;
    }

    private static Collection<ETypedElement> getContainedETypedElements(EObject eObject) {
        ArrayList<ETypedElement> typedElements = new ArrayList<ETypedElement>();
        TreeIterator eAllContents = eObject.eAllContents();
        while (eAllContents.hasNext()) {
            EObject element = (EObject)eAllContents.next();
            if (!(element instanceof ETypedElement)) continue;
            ETypedElement eTypedElement = (ETypedElement)element;
            typedElements.add(eTypedElement);
        }
        return typedElements;
    }

    private Set<EClassifier> getAllKnownEClassifiers() {
        HashSet<EClassifier> eClassifiers = new HashSet<EClassifier>();
        for (FacetSet facetSet : IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.editingDomain.getResourceSet()).getRegisteredFacetSets()) {
            eClassifiers.addAll(FacetUtils.getAllFacet((FacetSet)facetSet));
        }
        for (FacetSet facetSet : this.tableInstance.getFacetSets()) {
            eClassifiers.addAll(FacetUtils.getAllFacet((FacetSet)facetSet));
        }
        for (EObject eObject : TableWidgetUtils.getElements(this.tableInstance)) {
            eClassifiers.add((EClassifier)eObject.eClass());
        }
        return eClassifiers;
    }

    protected final void logAndDisplayException(Exception e) {
        Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        MessageDialog.openError((Shell)this.view.getShell(), (String)Messages.NatTableWidget_error, (String)e.getLocalizedMessage());
    }

    @Override
    public List<ETypedElement> getApplicableCanBePresentedQueries() {
        Collection<FacetSet> knownFacetSets = this.getAllKnownFacetSets();
        ArrayList<ETypedElement> applicableQueries = new ArrayList<ETypedElement>();
        for (FacetSet facetSet : knownFacetSets) {
            for (Facet facet : FacetUtils.getFacets((FacetSet)facetSet)) {
                if (facet.getExtendedMetaclass() != EcorePackage.eINSTANCE.getEObject()) continue;
                LinkedList typeElementsToCheck = new LinkedList();
                typeElementsToCheck.addAll(facet.getFacetElements());
                typeElementsToCheck.addAll(facet.getFacetOperations());
                for (ETypedElement eTypeElement : typeElementsToCheck) {
                    if (!ModelUtils.isBooleanDataType((EClassifier)eTypeElement.getEType())) continue;
                    applicableQueries.add(eTypeElement);
                }
            }
        }
        return Collections.unmodifiableList(applicableQueries);
    }

    private Collection<FacetSet> getAllKnownFacetSets() {
        HashSet<FacetSet> result = new HashSet<FacetSet>();
        result.addAll(IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.editingDomain.getResourceSet()).getRegisteredFacetSets());
        result.addAll((Collection<FacetSet>)this.tableInstance.getFacetSets());
        return result;
    }

    @Override
    public void undo() {
        this.editingDomain.getCommandStack().undo();
    }

    @Override
    public void redo() {
        this.editingDomain.getCommandStack().redo();
    }

    private boolean acceptsElement(Object element, ETypedElement presentabilityQuery) {
        boolean result;
        if (presentabilityQuery != null) {
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                try {
                    result = (Boolean)this.facetManager.getOrInvoke(eObject, presentabilityQuery, Boolean.class);
                }
                catch (Exception e) {
                    Logger.logError((Throwable)e, (String)("Error executing presentability query: " + presentabilityQuery.getName()), (Plugin)Activator.getDefault());
                    result = false;
                }
            } else {
                result = false;
            }
        } else {
            result = true;
        }
        return result;
    }

    public boolean acceptsElement(Object element) {
        ETypedElement presentabilityQuery = TableWidgetInternalUtils.getPresentabilityQuery(this.tableInstance);
        return this.acceptsElement(element, presentabilityQuery);
    }

    @Override
    public void setLoadedFacetSets(List<FacetSet> facetSets) {
        Command cmd = this.tableCommandFactory.createSetLoadedFacetSetsCommand(facetSets);
        this.executeCommand(cmd);
    }

    @Override
    public IETypedElementSelectionDialog<Object> openAddColumnsDialog() {
        List<FacetSet> knownFacetSets = this.getKnownFacetSet();
        HashSet eTypedElements = new HashSet();
        for (FacetSet facetSet : knownFacetSets) {
            eTypedElements.addAll(FacetUtils.getETypedElements((EPackage)facetSet));
        }
        for (Row row : this.tableInstance.getRows()) {
            EObject eObject = row.getElement();
            eTypedElements.addAll(FacetUtils.getETypedElements((EClassifier)eObject.eClass()));
        }
        IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object> callback = new IDialogCallbackWithPreCommit<List<ETypedElement>, Object, Object>(){

            public void committed(List<ETypedElement> result, Object precommitResult) {
                HashSet<FacetSet> facetSets = new HashSet<FacetSet>();
                for (ETypedElement eTypedElement : result) {
                    FacetSet facetSet = FacetUtils.getFacetSet((ETypedElement)eTypedElement);
                    if (facetSet == null) continue;
                    FacetSet rootFacetSet = FacetUtils.getRootFacetSet((FacetSet)facetSet);
                    facetSets.add(rootFacetSet);
                }
                ArrayList<ETypedElement> resolvedTE = new ArrayList<ETypedElement>(result.size());
                for (ETypedElement eTypedElement : result) {
                    ETypedElement resolvedEObject = (ETypedElement)IResolverManager.DEFAULT.resolve((Object)eTypedElement, ETypedElement.class);
                    if (resolvedEObject == null) {
                        resolvedTE.add(eTypedElement);
                        continue;
                    }
                    resolvedTE.add(resolvedEObject);
                }
                TableWidgetController.this.addColumns(resolvedTE, new ArrayList<FacetSet>(facetSets));
            }

            public Object openPrecommitDialog(List<ETypedElement> result, IDialogCallback<Object> precommitCallback) {
                return null;
            }
        };
        IETypedElementSelectionDialog dialog = IETypedElementSelectionDialogFactory.DEFAULT.openETypedElementSelectionDialog(eTypedElements, Integer.MAX_VALUE, false, (IDialogCallbackWithPreCommit)callback, this.getShell(), this.getCustomizationEngine(), knownFacetSets);
        return dialog;
    }

    private List<FacetSet> getKnownFacetSet() {
        ArrayList<FacetSet> knownFacetSets = new ArrayList<FacetSet>();
        for (FacetSet facetSet : this.tableInstance.getFacetSets()) {
            if (facetSet instanceof Customization) continue;
            knownFacetSets.add(facetSet);
        }
        IFacetSetCatalogManager facetSetCatalogManager = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(this.editingDomain.getResourceSet());
        Collection registeredFacetSets = facetSetCatalogManager.getRegisteredFacetSets();
        for (FacetSet facetSet : registeredFacetSets) {
            if (facetSet instanceof Customization) continue;
            knownFacetSets.add(facetSet);
        }
        return knownFacetSets;
    }

    @Override
    public final void addColumns(List<ETypedElement> eTypedElements, List<FacetSet> facetSets) {
        Command command = this.tableCommandFactory.createAddColumnCommand(eTypedElements, facetSets);
        this.executeCommand(command);
    }

    @Override
    public void sortRows(Column column, ColumnSortDirection direction) {
        if (column instanceof FeatureColumn) {
            long begin = System.currentTimeMillis();
            FeatureColumn featureColumn = (FeatureColumn)column;
            Command command = this.tableCommandFactory.createSortRowCommand(featureColumn, direction);
            long createCmd = System.currentTimeMillis();
            this.executeCommand(command);
            long end = System.currentTimeMillis();
            if (DEBUG_SORT) {
                DebugUtils.debug((String)("sort and createCmd =" + (createCmd - begin)));
                DebugUtils.debug((String)("exec =" + (end - createCmd)));
                DebugUtils.debug((String)("total =" + (end - begin)));
            }
        }
    }

    @Override
    public List<Object> getRawSelection() {
        return this.view.getGridSelection();
    }

    protected List<IGridElement> getSelectedGridElements() {
        List<Object> selection = this.getRawSelection();
        ArrayList<IGridElement> gridElements = new ArrayList<IGridElement>();
        for (Object object : selection) {
            if (!(object instanceof IGridElement)) continue;
            gridElements.add((IGridElement)object);
        }
        return gridElements;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void removeColumns(List<ETypedElement> elements) {
        Command command = this.tableCommandFactory.createRemoveColumnsCommand(elements);
        this.executeCommand(command);
    }

    @Override
    public ITableCommandFactory getTableCommandFactory() {
        return this.tableCommandFactory;
    }
}

