/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.workbench.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyHandler
extends AbstractHandler {
    private List<ITableWidgetProvider> alreadyListenedPart = new ArrayList<ITableWidgetProvider>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITableWidgetProvider natTableWidgetPart;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null && (natTableWidgetPart = (ITableWidgetProvider)activePart.getAdapter(ITableWidgetProvider.class)) != null) {
            natTableWidgetPart.getTableWidget().copySelectionToClipboard();
        }
        return null;
    }

    public boolean isEnabled() {
        ITableWidgetProvider natTableWidgetPart;
        IWorkbenchPart activePart;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (activePart = page.getActivePart()) != null && (natTableWidgetPart = (ITableWidgetProvider)activePart.getAdapter(ITableWidgetProvider.class)) != null) {
            if (activePart instanceof ISelectionProvider && !this.alreadyListenedPart.contains(natTableWidgetPart)) {
                ISelectionProvider iWorkbenchPartProvider = (ISelectionProvider)activePart;
                iWorkbenchPartProvider.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        CopyHandler.this.setBaseEnabled(natTableWidgetPart.getTableWidget().isCellsDeletable());
                    }
                });
                this.alreadyListenedPart.add(natTableWidgetPart);
            }
            return natTableWidgetPart.getTableWidget().isCellSelected();
        }
        return false;
    }
}

