/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.core.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.efacet.core.internal.Activator;
import org.eclipse.emf.facet.efacet.core.internal.CastUtils;
import org.eclipse.emf.facet.efacet.core.internal.DerivedTypedElementUtils;
import org.eclipse.emf.facet.efacet.core.internal.EmfUtils;
import org.eclipse.emf.facet.efacet.core.internal.FacetManagerContext;
import org.eclipse.emf.facet.efacet.core.internal.exception.FacetConformanceEvaluationException;
import org.eclipse.emf.facet.efacet.core.internal.exception.NonApplicableFacetException;
import org.eclipse.emf.facet.efacet.core.internal.exception.NonConformingEObjectException;
import org.eclipse.emf.facet.efacet.core.internal.exception.UnmatchingExpectedTypeException;
import org.eclipse.emf.facet.efacet.core.internal.serialization.SerializationManager;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.RuntimeFactory;
import org.eclipse.emf.facet.util.core.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetManager
implements IFacetManager {
    private static final EClassifier EBOOLEAN = EcorePackage.eINSTANCE.getEBoolean();
    private static final EClassifier EBOOLEAN_OBJECT = EcorePackage.eINSTANCE.getEBooleanObject();
    private final FacetManagerContext context;
    private final SerializationManager serializationMgr;
    private final ResourceSet resourceSet;

    public FacetManager(Resource resource) {
        this.serializationMgr = new SerializationManager(resource);
        this.context = new FacetManagerContext(this);
        this.resourceSet = resource.getResourceSet();
    }

    public FacetManager(ResourceSet resourceSet) {
        this.serializationMgr = new SerializationManager(null);
        this.context = new FacetManagerContext(this);
        this.resourceSet = resourceSet;
    }

    @Override
    public void saveStructuralFeatureInstanceModel() throws FacetManagerException {
        this.serializationMgr.saveStructuralFeatureInstanceModel();
    }

    @Override
    public boolean isConforming(EObject eObject, Facet facet) throws FacetManagerException {
        return this.getConformanceState(eObject, facet) == ConformanceState.Conformant;
    }

    private void checkConformance(EObject eObject, Facet facet) throws FacetManagerException {
        ConformanceState conformanceState = this.getConformanceState(eObject, facet);
        if (conformanceState == ConformanceState.NonConformingMetaclass) {
            throw new FacetManagerException("NonApplicableFacetException");
        }
        if (conformanceState == ConformanceState.NonConformingElement) {
            throw new FacetManagerException("NonConformingEObjectException");
        }
    }

    protected ConformanceState getConformanceState(EObject eObject, Facet facet) throws FacetManagerException {
        Boolean isConforming;
        ETypedElement typeElement;
        if (eObject == null) {
            throw new IllegalArgumentException("eObject cannot be null");
        }
        if (facet == null) {
            throw new IllegalArgumentException("facet cannot be null");
        }
        EClass extendedMetaclass = FacetUtils.getExtendedMetaclass(facet);
        ConformanceState result = extendedMetaclass != null && (extendedMetaclass.isSuperTypeOf(eObject.eClass()) || extendedMetaclass == EcorePackage.eINSTANCE.getEObject()) ? ((typeElement = facet.getConformanceTypedElement()) == null ? ConformanceState.Conformant : ((isConforming = this.getConformanceValue(eObject, typeElement)).booleanValue() ? ConformanceState.Conformant : ConformanceState.NonConformingElement)) : ConformanceState.NonConformingMetaclass;
        if (result == ConformanceState.Conformant) {
            for (Facet extFacet : facet.getExtendedFacets()) {
                result = this.getConformanceState(eObject, extFacet);
                if (result != ConformanceState.Conformant) break;
            }
        }
        return result;
    }

    private Boolean getConformanceValue(EObject eObject, ETypedElement typeElement) throws FacetManagerException {
        Boolean result;
        block8: {
            if (typeElement.isMany()) {
                throw new FacetManagerException("The Facet's conformance typed element must not be multi-valued");
            }
            if (typeElement.getEType() != EBOOLEAN && typeElement.getEType() != EBOOLEAN_OBJECT) {
                throw new FacetManagerException("The Facet conformance typed element evaluated to a wrong type.");
            }
            try {
                if (typeElement instanceof EStructuralFeature) {
                    EStructuralFeature structuralFeature = (EStructuralFeature)typeElement;
                    result = this.internalGet(eObject, structuralFeature, Boolean.class, true);
                    break block8;
                }
                if (typeElement instanceof EOperation) {
                    EOperation operation = (EOperation)typeElement;
                    if (operation.getEParameters().size() > 0) {
                        throw new FacetConformanceEvaluationException("The Facet's conformance operation cannot have parameters");
                    }
                    result = this.internalInvoke(eObject, operation, Boolean.class, true, new Object[0]);
                    break block8;
                }
                throw new FacetConformanceEvaluationException("Unsupported conformance typed element type: " + typeElement.getClass().getName());
            }
            catch (Exception e) {
                throw new FacetManagerException(e);
            }
        }
        if (result == null) {
            throw new FacetManagerException("The Facet conformance typed element evaluated to null");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(EObject eObject, EStructuralFeature structuralFeature, Object newValue, EditingDomain editingDomain) throws FacetManagerException {
        if (structuralFeature.isMany() && !(newValue instanceof Collection)) {
            throw new IllegalArgumentException("newValue should be a Collection because eStructuralFeature is an EReference");
        }
        EObject eContainer = structuralFeature.eContainer();
        if (eContainer instanceof Facet) {
            Facet facet = (Facet)eContainer;
            this.checkConformance(eObject, facet);
            if (structuralFeature instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)structuralFeature;
                if (structuralFeature instanceof FacetAttribute) {
                    throw new UnsupportedOperationException("Setting a FacetAttribute is not yet implemented");
                }
                this.serializationMgr.setAttribute(eObject, eAttribute, newValue);
                return;
            } else {
                if (!(structuralFeature instanceof EReference)) throw new UnsupportedOperationException("Setting a structural feature of type '" + structuralFeature.getClass().getName() + "' is not implemented");
                EReference reference = (EReference)structuralFeature;
                if (reference instanceof FacetReference) {
                    throw new UnsupportedOperationException("Setting a FacetReference is not yet implemented");
                }
                this.serializationMgr.setReference(eObject, reference, newValue);
            }
            return;
        } else {
            eObject.eSet(structuralFeature, newValue);
        }
    }

    public <T> T get(EObject eObject, EStructuralFeature structuralFeature, Class<T> expectedType) throws FacetManagerException {
        return this.internalGet(eObject, structuralFeature, expectedType, false);
    }

    private <T> T internalGet(EObject eObject, EStructuralFeature structuralFeature, Class<T> expectedType, boolean basicGet) throws FacetManagerException {
        try {
            Object value;
            if (structuralFeature.eContainer() instanceof Facet) {
                EStructuralFeature baseFeature = structuralFeature;
                if (!basicGet) {
                    baseFeature = this.context.resolveOverrides(structuralFeature, eObject);
                    Facet facet = (Facet)baseFeature.eContainer();
                    this.checkConformance(eObject, facet);
                }
                if (baseFeature.isDerived()) {
                    if (!(baseFeature instanceof DerivedTypedElement)) {
                        throw new UnsupportedOperationException("Cannot evaluate a derived structural feature that is not a DerivedTypedElement : not implemented");
                    }
                    value = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)baseFeature, eObject, null, (IFacetManager)this);
                } else {
                    if (baseFeature instanceof DerivedTypedElement) {
                        throw new IllegalArgumentException("A DerivedTypedElement must always be derived");
                    }
                    value = this.serializationMgr.getNotDerivedValue(eObject, baseFeature);
                }
            } else {
                if (structuralFeature instanceof DerivedTypedElement) {
                    throw new IllegalStateException("The given DerivedTypedElement is not contained in a Facet");
                }
                value = eObject.eGet(structuralFeature, true);
            }
            return EmfUtils.checkAssignment(structuralFeature, expectedType, value);
        }
        catch (Exception e) {
            throw new FacetManagerException(e);
        }
    }

    public <T> List<T> getMultiValued(EObject eObject, EStructuralFeature structuralFeature, Class<T> expectedType) throws FacetManagerException {
        T result = this.internalGet(eObject, structuralFeature, null, false);
        try {
            return CastUtils.castToExpectedListType(result, expectedType, true);
        }
        catch (UnmatchingExpectedTypeException e) {
            throw new UnmatchingExpectedTypeException("Failed to cast the value of '" + structuralFeature.getName() + "' to a list of " + expectedType.getName(), e);
        }
    }

    @Override
    public <T> T invoke(EObject eObject, EOperation operation, Class<T> expectedType, EditingDomain editingDomain, Object ... arguments) throws FacetManagerException {
        try {
            return this.internalInvoke(eObject, operation, expectedType, false, arguments);
        }
        catch (Exception e) {
            throw new FacetManagerException("Error invoking Facet operation '" + operation.getName() + "'", e);
        }
    }

    public <T> List<T> invokeMultiValued(EObject eObject, EOperation operation, Class<T> expectedType, Object ... arguments) throws FacetManagerException {
        T result;
        try {
            result = this.internalInvoke(eObject, operation, null, false, arguments);
        }
        catch (Exception e) {
            throw new FacetManagerException("Error invoking Facet operation '" + operation.getName() + "'", e);
        }
        return CastUtils.castToExpectedListType(result, expectedType, true);
    }

    private <T> T internalInvoke(EObject eObject, EOperation operation, Class<T> expectedType, boolean basicInvoke, Object ... arguments) throws DerivedTypedElementException, InvocationTargetException, FacetConformanceEvaluationException, NonApplicableFacetException, NonConformingEObjectException, FacetManagerException {
        Object result;
        if (operation.eContainer() instanceof Facet) {
            Facet facet = (Facet)operation.eContainer();
            if (!basicInvoke) {
                this.checkConformance(eObject, facet);
            }
            if (operation instanceof FacetOperation) {
                FacetOperation facetOperation;
                FacetOperation baseOperation = facetOperation = (FacetOperation)operation;
                if (!basicInvoke) {
                    baseOperation = this.context.resolveOverrides(facetOperation, eObject);
                }
                result = DerivedTypedElementUtils.evaluate(eObject, (EOperation)baseOperation, this, arguments);
            } else {
                result = EmfUtils.ecoreInvoke(eObject, operation, null, arguments);
            }
        } else {
            if (operation instanceof FacetOperation) {
                throw new IllegalStateException("The given FacetOperation is not contained in a Facet");
            }
            result = EmfUtils.ecoreInvoke(eObject, operation, null, arguments);
        }
        return CastUtils.castToExpectedType(result, expectedType);
    }

    public List<ETypedElementResult> get(Collection<EObject> eObjects, EStructuralFeature structuralFeature) throws DerivedTypedElementException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public List<ETypedElementResult> batchInvoke(Collection<EObject> eObjects, EOperation operation, Object ... arguments) throws FacetManagerException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public List<FacetSet> getManagedFacetSets() {
        return this.context;
    }

    public void setManagedFacetSets(List<FacetSet> facetSets) {
        this.context.setManagedFacetSets(facetSets);
    }

    public void removeFacetSet(FacetSet facetSet) {
        this.context.removeFacetSet(facetSet);
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public List<ETypedElement> getAppliedFeatures() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Collection<? extends EAttribute> getAttributes(EObject eObject) throws FacetManagerException {
        return this.getEStructuralFeatures(eObject, EAttribute.class);
    }

    public <T extends ETypedElement> Collection<T> getEStructuralFeatures(EObject eObject, Class<T> classs) throws FacetManagerException {
        HashSet<T> result = new HashSet<T>();
        for (FacetSet facetSet : this.context.getManagedFacetSets()) {
            result.addAll(this.getETypedElements(eObject, facetSet, classs));
        }
        return result;
    }

    private <T extends ETypedElement> Collection<T> getETypedElements(EObject eObject, FacetSet facetSet, Class<T> classs) throws FacetManagerException {
        HashSet<Object> result = new HashSet<Object>();
        for (EClassifier eClassifier : facetSet.getEClassifiers()) {
            Facet facet;
            if (!(eClassifier instanceof Facet) || !this.isConforming(eObject, facet = (Facet)eClassifier)) continue;
            for (EStructuralFeature eStructuralFeature : this.getAllEStructuralFeatures(facet)) {
                if (!classs.isInstance(eStructuralFeature)) continue;
                EStructuralFeature typedSF = eStructuralFeature;
                result.add(typedSF);
            }
        }
        for (EPackage ePackage : facetSet.getESubpackages()) {
            if (!(ePackage instanceof FacetSet)) continue;
            FacetSet subFacetSet = (FacetSet)ePackage;
            result.addAll(this.getETypedElements(eObject, subFacetSet, classs));
        }
        for (FacetSet subFacetSet : facetSet.getFacetSets()) {
            result.addAll(this.getETypedElements(eObject, subFacetSet, classs));
        }
        return result;
    }

    private List<EStructuralFeature> getAllEStructuralFeatures(Facet facet) {
        LinkedList<EStructuralFeature> structFeatures = new LinkedList<EStructuralFeature>();
        structFeatures.addAll((Collection<EStructuralFeature>)facet.getFacetElements());
        for (Facet extFacet : facet.getExtendedFacets()) {
            structFeatures.addAll(this.getAllEStructuralFeatures(extFacet));
        }
        return structFeatures;
    }

    public Collection<? extends EReference> getReferences(EObject eObject) throws FacetManagerException {
        return this.getEStructuralFeatures(eObject, EReference.class);
    }

    @Deprecated
    public void addFacets(EList<Facet> facets) {
        for (Facet facetToLoad : facets) {
            this.context.addFrontManagedFacetSet((FacetSet)facetToLoad.getEPackage());
        }
    }

    @Deprecated
    public void unLoadAllFacets() {
        this.removeAllManagedFacetSets();
    }

    public void removeAllManagedFacetSets() {
        this.context.clear();
    }

    @Override
    public <T> List<T> getOrInvokeMultiValued(EObject eObject, ETypedElement eTypedElement, Class<T> classs) throws FacetManagerException {
        List<T> result = null;
        if (eTypedElement instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)eTypedElement;
            result = this.getMultiValued(eObject, structuralFeature, classs);
        } else if (eTypedElement instanceof EOperation) {
            EOperation eOperation = (EOperation)eTypedElement;
            result = this.invokeMultiValued(eObject, eOperation, classs, new Object[0]);
        }
        return result;
    }

    @Override
    public <T> T getOrInvoke(EObject eObject, ETypedElement eTypedElement, Class<T> classs) throws FacetManagerException {
        T result = null;
        if (eTypedElement instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)eTypedElement;
            result = this.get(eObject, structuralFeature, classs);
        } else if (eTypedElement instanceof EOperation) {
            EOperation eOperation = (EOperation)eTypedElement;
            result = this.invoke(eObject, eOperation, classs, null, new Object[0]);
        }
        return result;
    }

    public List<Facet> getManagedFacets() {
        throw new IllegalStateException("Not implemented, and never will since it's deprecated");
    }

    @Override
    public <T> List<ETypedElementResult> batchGetOrInvoke(Collection<EObject> sources, ETypedElement query, Class<T> classs) throws FacetManagerException {
        LinkedList<ETypedElementResult> results = new LinkedList<ETypedElementResult>();
        for (EObject source : sources) {
            ETypedElementEObjectListResult eObjectResultList;
            ETypedElementEObjectResult eObjectResult;
            ETypedElementEObjectResult result = null;
            Exception exception = null;
            if (query.getEType() instanceof EClass) {
                if (query.getUpperBound() == 1) {
                    eObjectResult = RuntimeFactory.eINSTANCE.createETypedElementEObjectResult();
                    try {
                        eObjectResult.setResult(this.getOrInvoke(source, query, EObject.class));
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    result = eObjectResult;
                } else {
                    eObjectResultList = RuntimeFactory.eINSTANCE.createETypedElementEObjectListResult();
                    try {
                        eObjectResultList.getResultList().addAll(this.getOrInvokeMultiValued(source, query, EObject.class));
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                    result = eObjectResultList;
                }
            } else if (query.getUpperBound() == 1) {
                eObjectResult = RuntimeFactory.eINSTANCE.createETypedElementPrimitiveTypeResult();
                try {
                    eObjectResult.setResult((Object)this.getOrInvoke(source, query, Collection.class));
                }
                catch (Exception e) {
                    exception = e;
                }
                result = eObjectResult;
            } else {
                eObjectResultList = RuntimeFactory.eINSTANCE.createETypedElementPrimitiveTypeListResult();
                eObjectResultList.getResultList().addAll(this.getOrInvokeMultiValued(source, query, Object.class));
                result = eObjectResultList;
            }
            if (exception != null) {
                result.setException((Throwable)exception);
                Logger.logWarning((Throwable)exception, (Plugin)Activator.getDefault());
            }
            result.setDerivedTypedElement(query);
            result.setSource(source);
            results.add((ETypedElementResult)result);
        }
        return results;
    }

    public void addBackManagedFacetSet(FacetSet facetSet) {
        this.context.addBackManagedFacetSet(facetSet);
    }

    public void addFrontManagedFacetSet(FacetSet facetSet) {
        this.context.addFrontManagedFacetSet(facetSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConformanceState {
        Conformant,
        NonConformingMetaclass,
        NonConformingElement;

    }
}

