/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.internal.validation;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.CommonEmfFacetActivator;
import org.eclipse.emf.facet.infra.common.core.internal.Messages;
import org.eclipse.emf.facet.infra.common.core.internal.utils.BuildPropertiesUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.PluginUtils;
import org.eclipse.emf.facet.infra.common.core.logging.Logger;
import org.eclipse.osgi.util.NLS;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static void validateRegistered(IProject project, final String extensionToCheck, String markerType, String elementType, final String extensionPoint) {
        IMarker marker;
        String message;
        IFile buildMarkersResource;
        IFile buildProperties;
        IFile markersResource;
        final ArrayList notDeclared = new ArrayList();
        final ArrayList notInBuild = new ArrayList();
        try {
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    String fileExtension = resource.getFileExtension();
                    if (resource.getType() == 1 && fileExtension != null && fileExtension.equals(extensionToCheck)) {
                        IFile file = (IFile)resource;
                        if (!PluginUtils.isRegistered(file, extensionPoint)) {
                            notDeclared.add(file);
                        }
                        try {
                            if (!BuildPropertiesUtils.isInBuild(file)) {
                                notInBuild.add(file);
                            }
                        }
                        catch (CoreException e) {
                            Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
        }
        try {
            project.deleteMarkers(markerType, true, 1);
        }
        catch (CoreException e) {
            Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
        }
        IFile pluginXML = project.getFile("plugin.xml");
        if (pluginXML.exists()) {
            markersResource = pluginXML;
            try {
                pluginXML.deleteMarkers(markerType, true, 1);
            }
            catch (CoreException e) {
                Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
            }
        } else {
            markersResource = project;
        }
        if ((buildProperties = project.getFile("build.properties")).exists()) {
            buildMarkersResource = buildProperties;
            try {
                buildProperties.deleteMarkers(markerType, true, 1);
            }
            catch (CoreException e) {
                Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
            }
        } else {
            buildMarkersResource = project;
        }
        for (IFile file : notDeclared) {
            try {
                message = NLS.bind((String)Messages.ValidationUtils_shouldBeRegistered, (Object)elementType, (Object)file.getName());
                marker = markersResource.createMarker(markerType);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 1);
            }
            catch (CoreException e) {
                Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
            }
        }
        for (IFile file : notInBuild) {
            try {
                message = NLS.bind((String)Messages.ValidationUtils_shouldBeInBin, (Object[])new Object[]{"bin.includes", elementType, file.getName()});
                marker = buildMarkersResource.createMarker(markerType);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 1);
            }
            catch (CoreException e) {
                Logger.logError(e, (Plugin)CommonEmfFacetActivator.getDefault());
            }
        }
    }
}

