/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor;

import java.util.EventObject;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.DelegatedTableEditor;
import org.eclipse.emf.facet.widgets.table.ui.workbench.internal.editor.TableEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;

public class NatTableEditorActionBarContribution
extends EditorActionBarContributor {
    private final UndoAction undoAction;
    private final RedoAction redoAction;
    private final CommandStackListener cmdStackListener;

    public NatTableEditorActionBarContribution() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.cmdStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                NatTableEditorActionBarContribution.this.getUndoAction().update();
                NatTableEditorActionBarContribution.this.getRedoAction().update();
            }
        };
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor instanceof DelegatedTableEditor || targetEditor instanceof TableEditor) {
            IEditingDomainProvider tableEditor = (IEditingDomainProvider)targetEditor;
            EditingDomain editingDomain = tableEditor.getEditingDomain();
            this.undoAction.setEditingDomain(editingDomain);
            this.redoAction.setEditingDomain(editingDomain);
            this.undoAction.update();
            this.redoAction.update();
            CommandStack commandStack = tableEditor.getEditingDomain().getCommandStack();
            commandStack.removeCommandStackListener(this.cmdStackListener);
            commandStack.addCommandStackListener(this.cmdStackListener);
        }
    }

    protected UndoAction getUndoAction() {
        return this.undoAction;
    }

    protected RedoAction getRedoAction() {
        return this.redoAction;
    }
}

