/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.editors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.facet.infra.browser.BrowserPlugin;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.emf.facet.infra.browser.editors.BrowserConfiguration;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSettingsPersistence
implements IPartListener {
    private static final String EMFFACET_BROWSER_SETTINGS = "EmfFacetModelBrowserSettings";
    private static final String LAST_APPLIED_FACETS_SETTINGS = "LastAppliedFacets";
    private static final String LAST_APPLIED_CUSTOMIZATIONS_SETTINGS = "LastAppliedCustomizations";
    private final String metamodelURI;
    private final IWorkbenchPart fPart;
    private final BrowserConfiguration browserConfiguration;

    public BrowserSettingsPersistence(String metamodelURI, IWorkbenchPart part, BrowserConfiguration browserConfiguration) {
        this.metamodelURI = metamodelURI;
        this.fPart = part;
        this.browserConfiguration = browserConfiguration;
        part.getSite().getPage().addPartListener((IPartListener)this);
    }

    public IDialogSettings loadLastSettingsForCurrentMetamodel() {
        try {
            String filename = this.getSettingsFilename();
            DialogSettings settings = new DialogSettings(EMFFACET_BROWSER_SETTINGS);
            if (new File(filename).isFile()) {
                settings.load(filename);
                if (this.metamodelURI != null) {
                    return settings.getSection(this.metamodelURI);
                }
            }
        }
        catch (Exception e) {
            BrowserPlugin.logException(e);
        }
        return null;
    }

    public List<Facet> getLastFacets(IDialogSettings settingsForCurrentMetamodel) {
        if (settingsForCurrentMetamodel == null) {
            return Collections.emptyList();
        }
        String[] lastFacetNames = settingsForCurrentMetamodel.getArray(LAST_APPLIED_FACETS_SETTINGS);
        if (lastFacetNames == null) {
            return Collections.emptyList();
        }
        ArrayList<Facet> facetsToLoad = new ArrayList<Facet>();
        Collection facetSets = FacetSetCatalog.getSingleton().getAllFacetSets();
        for (FacetSet facetSet : facetSets) {
            EList facets = facetSet.getFacets();
            block1: for (Facet facet : facets) {
                String name = String.valueOf(facetSet.getName()) + "#" + facet.getName();
                String[] stringArray = lastFacetNames;
                int n = lastFacetNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String lastFacetName = stringArray[n2];
                    if (name.equals(lastFacetName)) {
                        facetsToLoad.add(facet);
                        continue block1;
                    }
                    ++n2;
                }
            }
        }
        return facetsToLoad;
    }

    private void saveLastFacetNames(IDialogSettings sectionForCurrentMetamodel) {
        Set appliedFacets = this.browserConfiguration.getAppearanceConfiguration().getFacetContext().getAppliedFacets();
        String[] facetNames = new String[appliedFacets.size()];
        Iterator facetsIterator = appliedFacets.iterator();
        int i = 0;
        while (i < appliedFacets.size()) {
            Facet facet = (Facet)facetsIterator.next();
            FacetSet facetSet = facet.getFacetSet();
            facetNames[i] = String.valueOf(facetSet.getName()) + "#" + facet.getName();
            ++i;
        }
        sectionForCurrentMetamodel.put(LAST_APPLIED_FACETS_SETTINGS, facetNames);
    }

    public List<MetamodelView> getLastCustomizations(IDialogSettings settingsForCurrentMetamodel) {
        if (settingsForCurrentMetamodel == null) {
            return Collections.emptyList();
        }
        String[] lastCustomizationNames = settingsForCurrentMetamodel.getArray(LAST_APPLIED_CUSTOMIZATIONS_SETTINGS);
        if (lastCustomizationNames == null) {
            return Collections.emptyList();
        }
        ArrayList<MetamodelView> customizationsToLoad = new ArrayList<MetamodelView>();
        Collection allCustomizations = CustomizationsCatalog.getInstance().getAllCustomizations();
        block0: for (MetamodelView metamodelView : allCustomizations) {
            String name = metamodelView.getName();
            if (name == null) continue;
            String[] stringArray = lastCustomizationNames;
            int n = lastCustomizationNames.length;
            int n2 = 0;
            while (n2 < n) {
                String lastCustomizationName = stringArray[n2];
                if (name.equals(lastCustomizationName)) {
                    customizationsToLoad.add(metamodelView);
                    continue block0;
                }
                ++n2;
            }
        }
        return customizationsToLoad;
    }

    private void saveLastCustomizationNames(IDialogSettings sectionForCurrentMetamodel) {
        List customizations = this.browserConfiguration.getAppearanceConfiguration().getCustomizationEngine().getRegisteredCustomizations();
        String[] customizationNames = new String[customizations.size()];
        int i = 0;
        while (i < customizations.size()) {
            customizationNames[i] = ((MetamodelView)customizations.get(i)).getName();
            ++i;
        }
        sectionForCurrentMetamodel.put(LAST_APPLIED_CUSTOMIZATIONS_SETTINGS, customizationNames);
    }

    private String getSettingsFilename() {
        IPath stateLocation = BrowserPlugin.getPlugin().getStateLocation();
        String filename = stateLocation.append(EMFFACET_BROWSER_SETTINGS).toOSString();
        return filename;
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.fPart) {
            block8: {
                this.browserConfiguration.getAppearanceConfiguration().save();
                try {
                    if (this.metamodelURI != null) {
                        IDialogSettings section;
                        String filename = this.getSettingsFilename();
                        DialogSettings settings = new DialogSettings(EMFFACET_BROWSER_SETTINGS);
                        if (new File(filename).isFile()) {
                            try {
                                settings.load(filename);
                            }
                            catch (IOException e) {
                                Logger.logWarning((Throwable)e, (String)"previous browser settings couldn't be loaded", (Plugin)BrowserPlugin.getPlugin());
                            }
                        }
                        if ((section = settings.getSection(this.metamodelURI)) == null) {
                            section = settings.addNewSection(this.metamodelURI);
                        }
                        this.saveLastFacetNames(section);
                        this.saveLastCustomizationNames(section);
                        settings.save(filename);
                        break block8;
                    }
                    Logger.logError((String)"couldn't find metamodel URI; skipped saving settings", (Plugin)BrowserPlugin.getPlugin());
                }
                catch (Exception e) {
                    BrowserPlugin.logException(e);
                }
            }
            this.fPart.getSite().getPage().removePartListener((IPartListener)this);
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }
}

