/**
 * Copyright (c) 2009,2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 *     Nicolas Guyomar (Mia-Software) - Bug 341514 - EMF Facet Queries have to be able to use EditingDomain
 */
package org.eclipse.emf.facet.infra.query.core.java.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQueryParameter;
import org.eclipse.emf.facet.infra.query.QueryFactory;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.exception.EditingDomainExpectedException;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQueryWithEditingDomain;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.infra.query.runtime.RuntimeFactory;

/**
 * @author Gregoire Dupe (Mia-Software)
 */
public class JavaModelQueryAdapter extends AbstractModelQueryWithEditingDomain {

	private final IJavaModelQuery<EObject, ?> javaModelQuery;

	public JavaModelQueryAdapter(final ModelQuery modelQuery,
			final IJavaModelQuery<EObject, ?> javaModelQuery) {
		super(modelQuery);
		this.javaModelQuery = javaModelQuery;
	}

	@Override
	public Object basicEvaluate(final EObject context,
			final List<ModelQueryParameterValue> parameterValues) throws ModelQueryException {
		ParameterValueList plist = new ParameterValueList();
		if (parameterValues != null) {
			plist.addAll(parameterValues);
		}
		Object result = this.javaModelQuery.evaluate(context, plist);
		this.checkResult(result);
		return result;
	}

	@Override
	public Object basicEvaluate(final EObject context,
			final List<ModelQueryParameterValue> parameterValues, final EditingDomain editingDomain)
			throws ModelQueryException {
		if (editingDomain == null) {
			throw new EditingDomainExpectedException(
					"The editing domain parameter must not be null."); //$NON-NLS-1$
		}
		ParameterValueList plist = new ParameterValueList();
		if (parameterValues != null) {
			plist.addAll(parameterValues);
		}
		// Editing domain parameter value
		ModelQueryParameterValue editingDomainParameterValue = RuntimeFactory.eINSTANCE
				.createModelQueryParameterValue();
		ModelQueryParameter editingDomainParameter = QueryFactory.eINSTANCE
				.createModelQueryParameter();
		editingDomainParameter.setName("parameter"); //$NON-NLS-1$
		editingDomainParameter.setType(EcorePackage.eINSTANCE.getEJavaObject());
		editingDomainParameterValue.setParameter(editingDomainParameter);
		editingDomainParameterValue.setValue(editingDomain);
		
		ArrayList<ModelQueryParameterValue> parameters = new ArrayList<ModelQueryParameterValue>();
		// Add editing domain parameter to the list
		parameters.add(editingDomainParameterValue);
		if (this.javaModelQuery instanceof IJavaModelQueryWithEditingDomain<?, ?>) {
			Object result = ((IJavaModelQueryWithEditingDomain<EObject, ?>) this.javaModelQuery)
					.evaluate(context, plist, editingDomain);
			this.checkResult(result);
			return result;
		}
		throw new EditingDomainExpectedException("The query " + this.getModelQuery().getName() //$NON-NLS-1$
					+ " has to be implemented by an instance of IJavaModelQueryWithEditingDomain"); //$NON-NLS-1$
	}
}
