/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;

public final class EditingSupportUtil {

	private EditingSupportUtil() {
		// not instantiable
	}

	public static Collection<?> getNewChildDescriptors(final List<EReference> eAllReferences) {
		ArrayList<CommandParameter> parameters = new ArrayList<CommandParameter>();
		for (EReference reference : eAllReferences) {
			if (reference.isContainment()) {
				createCommandParameters(parameters, reference);
			}
		}
		return parameters;
	}

	public static void createCommandParameters(final List<CommandParameter> parameters,
			final EReference feature) {
		EClass featureClass = feature.getEReferenceType();
		if (!featureClass.isInterface() && !featureClass.isAbstract()) {
			parameters.add(new CommandParameter(null, feature, featureClass.getEPackage()
					.getEFactoryInstance().create(featureClass)));
		}
		EList<EClass> eclasses = allSubClasses(feature.getEReferenceType());
		for (EClass eclass : eclasses) {
			if (!eclass.isAbstract()) {
				parameters.add(new CommandParameter(null, feature, eclass.getEPackage()
						.getEFactoryInstance().create(eclass)));
			}
		}
	}

	public static EList<EClass> allSubClasses(final EClass context) {
		EList<EClass> result = new BasicEList<EClass>();
		EList<Resource> resources = new BasicEList<Resource>();
		if (context.eResource().getResourceSet() != null) {
			resources.addAll(context.eResource().getResourceSet().getResources());
		} else {
			resources.add(context.eResource());
		}
		for (Resource resource : resources) {
			TreeIterator<EObject> content = resource.getAllContents();
			while (content.hasNext()) {
				EObject eObject = content.next();
				if (eObject instanceof EClass) {
					EClass currentClassDeclaration = (EClass) eObject;
					if (isSuperTypeOf(context, currentClassDeclaration)) {
						result.add(currentClassDeclaration);
					}
				}
			}
		}
		return result;
	}

	public static boolean isSuperTypeOf(final EClass self, final EClass typeDeclaration) {
		return typeDeclaration.getEAllSuperTypes().contains(self);
	}
}
