/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.infra.browser.custom.core;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.EmfFacetCatalogBuilder;

/**
 * A builder that feeds and updates the {@link CustomizationsCatalog} with the
 * customization files it finds
 * 
 * @deprecated https://bugs.eclipse.org/bugs/show_bug.cgi?id=374109
 */
@Deprecated
public class CustomizationsBuilder extends EmfFacetCatalogBuilder {

	protected static final String FILE_EXTENSION = "uiCustom"; //$NON-NLS-1$
	private static final String MARKER_TYPE = "org.eclipse.emf.facet.infra.browser.custom.problem"; //$NON-NLS-1$

	@Override
	protected AbstractEmfFacetCatalog getCatalog() {
		return CustomizationsCatalog.getInstance();
	}

	@Override
	protected String getElementType() {
		return Messages.CustomizationsBuilder_customization;
	}

	@Override
	protected String getRegistrationExtensionPoint() {
		return CustomizationsCatalog.REGISTRATION_EXTENSION_POINT_ID;
	}

	@Override
	protected String getMarkerType() {
		return CustomizationsBuilder.MARKER_TYPE;
	}

	@Override
	protected String getFileExtension() {
		return CustomizationsBuilder.FILE_EXTENSION;
	}

	@Override
	protected Plugin getActivator() {
		return Activator.getDefault();
	}
}
