/**
 * Copyright (c) 2010 CEA LIST
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - design and implementation
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 */
package org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.SamplemmFactory
 * @model kind="package"
 * @generated
 */
public interface SamplemmPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "samplemm";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/EMF_Facet/SampleMM/0.0.1/samplemm";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "samplemm";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	SamplemmPackage eINSTANCE = org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl <em>Class1</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getClass1()
	 * @generated
	 */
	int CLASS1 = 0;

	/**
	 * The feature id for the '<em><b>EInt Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EINT_ATTR = 0;

	/**
	 * The feature id for the '<em><b>EIn Object Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EIN_OBJECT_ATT = 1;

	/**
	 * The feature id for the '<em><b>EString Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ESTRING_ATTR = 2;

	/**
	 * The feature id for the '<em><b>Enum1 Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ENUM1_ATT = 3;

	/**
	 * The feature id for the '<em><b>Multi Ref</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__MULTI_REF = 4;

	/**
	 * The feature id for the '<em><b>EFloat Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EFLOAT_ATT = 5;

	/**
	 * The feature id for the '<em><b>EFloat Object Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EFLOAT_OBJECT_ATT = 6;

	/**
	 * The feature id for the '<em><b>EBoolean Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EBOOLEAN_ATTR = 7;

	/**
	 * The feature id for the '<em><b>EBoolean Object Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EBOOLEAN_OBJECT_ATTR = 8;

	/**
	 * The feature id for the '<em><b>EChar Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ECHAR_ATTR = 9;

	/**
	 * The feature id for the '<em><b>Echar Object Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ECHAR_OBJECT_ATTR = 10;

	/**
	 * The feature id for the '<em><b>EDouble Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EDOUBLE_ATTR = 11;

	/**
	 * The feature id for the '<em><b>Edouble Object Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EDOUBLE_OBJECT_ATTR = 12;

	/**
	 * The feature id for the '<em><b>EBig Decimal Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EBIG_DECIMAL_ATT = 13;

	/**
	 * The feature id for the '<em><b>EBig Integer Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EBIG_INTEGER_ATT = 14;

	/**
	 * The feature id for the '<em><b>ELong Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ELONG_ATT = 15;

	/**
	 * The feature id for the '<em><b>ELong Object Att</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ELONG_OBJECT_ATT = 16;

	/**
	 * The feature id for the '<em><b>EShort Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ESHORT_ATTR = 17;

	/**
	 * The feature id for the '<em><b>EShort Object Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__ESHORT_OBJECT_ATTR = 18;

	/**
	 * The feature id for the '<em><b>EByte Attr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EBYTE_ATTR = 19;

	/**
	 * The feature id for the '<em><b>EByte Attr Object</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EBYTE_ATTR_OBJECT = 20;

	/**
	 * The feature id for the '<em><b>Unary Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__UNARY_REFERENCE = 21;

	/**
	 * The feature id for the '<em><b>Nary Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__NARY_REFERENCE = 22;

	/**
	 * The feature id for the '<em><b>Nary Reference not Unique</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__NARY_REFERENCE_NOT_UNIQUE = 23;

	/**
	 * The feature id for the '<em><b>Unary Containment Reference</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__UNARY_CONTAINMENT_REFERENCE = 24;

	/**
	 * The feature id for the '<em><b>Nary Containment Reference</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__NARY_CONTAINMENT_REFERENCE = 25;

	/**
	 * The feature id for the '<em><b>EInt Multi Attr</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__EINT_MULTI_ATTR = 26;

	/**
	 * The feature id for the '<em><b>Strings</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1__STRINGS = 27;

	/**
	 * The number of structural features of the '<em>Class1</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS1_FEATURE_COUNT = 28;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class2Impl <em>Class2</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class2Impl
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getClass2()
	 * @generated
	 */
	int CLASS2 = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS2__NAME = 0;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS2__CHILDREN = 1;

	/**
	 * The number of structural features of the '<em>Class2</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS2_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class3Impl <em>Class3</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class3Impl
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getClass3()
	 * @generated
	 */
	int CLASS3 = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS3__NAME = CLASS2__NAME;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS3__CHILDREN = CLASS2__CHILDREN;

	/**
	 * The number of structural features of the '<em>Class3</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS3_FEATURE_COUNT = CLASS2_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1 <em>Enum1</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getEnum1()
	 * @generated
	 */
	int ENUM1 = 3;


	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1 <em>Class1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class1</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1
	 * @generated
	 */
	EClass getClass1();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEIntAttr <em>EInt Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EInt Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEIntAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EIntAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEInObjectAtt <em>EIn Object Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EIn Object Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEInObjectAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EInObjectAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEStringAttr <em>EString Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EString Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEStringAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EStringAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEnum1Att <em>Enum1 Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Enum1 Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEnum1Att()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_Enum1Att();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getMultiRef <em>Multi Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Multi Ref</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getMultiRef()
	 * @see #getClass1()
	 * @generated
	 */
	EReference getClass1_MultiRef();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEFloatAtt <em>EFloat Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EFloat Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEFloatAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EFloatAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEFloatObjectAtt <em>EFloat Object Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EFloat Object Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEFloatObjectAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EFloatObjectAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#isEBooleanAttr <em>EBoolean Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EBoolean Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#isEBooleanAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EBooleanAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEBooleanObjectAttr <em>EBoolean Object Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EBoolean Object Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEBooleanObjectAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EBooleanObjectAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getECharAttr <em>EChar Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EChar Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getECharAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_ECharAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEcharObjectAttr <em>Echar Object Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Echar Object Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEcharObjectAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EcharObjectAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEDoubleAttr <em>EDouble Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EDouble Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEDoubleAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EDoubleAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEdoubleObjectAttr <em>Edouble Object Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Edouble Object Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEdoubleObjectAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EdoubleObjectAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEBigDecimalAtt <em>EBig Decimal Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EBig Decimal Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEBigDecimalAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EBigDecimalAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEBigIntegerAtt <em>EBig Integer Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EBig Integer Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEBigIntegerAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EBigIntegerAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getELongAtt <em>ELong Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>ELong Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getELongAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_ELongAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getELongObjectAtt <em>ELong Object Att</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>ELong Object Att</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getELongObjectAtt()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_ELongObjectAtt();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEShortAttr <em>EShort Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EShort Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEShortAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EShortAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEShortObjectAttr <em>EShort Object Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EShort Object Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEShortObjectAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EShortObjectAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEByteAttr <em>EByte Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EByte Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEByteAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EByteAttr();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEByteAttrObject <em>EByte Attr Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>EByte Attr Object</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEByteAttrObject()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EByteAttrObject();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getUnaryReference <em>Unary Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Unary Reference</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getUnaryReference()
	 * @see #getClass1()
	 * @generated
	 */
	EReference getClass1_UnaryReference();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getNaryReference <em>Nary Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Nary Reference</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getNaryReference()
	 * @see #getClass1()
	 * @generated
	 */
	EReference getClass1_NaryReference();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getNaryReference_notUnique <em>Nary Reference not Unique</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Nary Reference not Unique</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getNaryReference_notUnique()
	 * @see #getClass1()
	 * @generated
	 */
	EReference getClass1_NaryReference_notUnique();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getUnaryContainmentReference <em>Unary Containment Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Unary Containment Reference</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getUnaryContainmentReference()
	 * @see #getClass1()
	 * @generated
	 */
	EReference getClass1_UnaryContainmentReference();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getNaryContainmentReference <em>Nary Containment Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Nary Containment Reference</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getNaryContainmentReference()
	 * @see #getClass1()
	 * @generated
	 */
	EReference getClass1_NaryContainmentReference();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEIntMultiAttr <em>EInt Multi Attr</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>EInt Multi Attr</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getEIntMultiAttr()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_EIntMultiAttr();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getStrings <em>Strings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Strings</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class1#getStrings()
	 * @see #getClass1()
	 * @generated
	 */
	EAttribute getClass1_Strings();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2 <em>Class2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class2</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2
	 * @generated
	 */
	EClass getClass2();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2#getName()
	 * @see #getClass2()
	 * @generated
	 */
	EAttribute getClass2_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class2#getChildren()
	 * @see #getClass2()
	 * @generated
	 */
	EReference getClass2_Children();

	/**
	 * Returns the meta object for class '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class3 <em>Class3</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class3</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Class3
	 * @generated
	 */
	EClass getClass3();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1 <em>Enum1</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Enum1</em>'.
	 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1
	 * @generated
	 */
	EEnum getEnum1();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	SamplemmFactory getSamplemmFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl <em>Class1</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class1Impl
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getClass1()
		 * @generated
		 */
		EClass CLASS1 = eINSTANCE.getClass1();

		/**
		 * The meta object literal for the '<em><b>EInt Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EINT_ATTR = eINSTANCE.getClass1_EIntAttr();

		/**
		 * The meta object literal for the '<em><b>EIn Object Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EIN_OBJECT_ATT = eINSTANCE.getClass1_EInObjectAtt();

		/**
		 * The meta object literal for the '<em><b>EString Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ESTRING_ATTR = eINSTANCE.getClass1_EStringAttr();

		/**
		 * The meta object literal for the '<em><b>Enum1 Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ENUM1_ATT = eINSTANCE.getClass1_Enum1Att();

		/**
		 * The meta object literal for the '<em><b>Multi Ref</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS1__MULTI_REF = eINSTANCE.getClass1_MultiRef();

		/**
		 * The meta object literal for the '<em><b>EFloat Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EFLOAT_ATT = eINSTANCE.getClass1_EFloatAtt();

		/**
		 * The meta object literal for the '<em><b>EFloat Object Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EFLOAT_OBJECT_ATT = eINSTANCE.getClass1_EFloatObjectAtt();

		/**
		 * The meta object literal for the '<em><b>EBoolean Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EBOOLEAN_ATTR = eINSTANCE.getClass1_EBooleanAttr();

		/**
		 * The meta object literal for the '<em><b>EBoolean Object Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EBOOLEAN_OBJECT_ATTR = eINSTANCE.getClass1_EBooleanObjectAttr();

		/**
		 * The meta object literal for the '<em><b>EChar Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ECHAR_ATTR = eINSTANCE.getClass1_ECharAttr();

		/**
		 * The meta object literal for the '<em><b>Echar Object Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ECHAR_OBJECT_ATTR = eINSTANCE.getClass1_EcharObjectAttr();

		/**
		 * The meta object literal for the '<em><b>EDouble Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EDOUBLE_ATTR = eINSTANCE.getClass1_EDoubleAttr();

		/**
		 * The meta object literal for the '<em><b>Edouble Object Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EDOUBLE_OBJECT_ATTR = eINSTANCE.getClass1_EdoubleObjectAttr();

		/**
		 * The meta object literal for the '<em><b>EBig Decimal Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EBIG_DECIMAL_ATT = eINSTANCE.getClass1_EBigDecimalAtt();

		/**
		 * The meta object literal for the '<em><b>EBig Integer Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EBIG_INTEGER_ATT = eINSTANCE.getClass1_EBigIntegerAtt();

		/**
		 * The meta object literal for the '<em><b>ELong Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ELONG_ATT = eINSTANCE.getClass1_ELongAtt();

		/**
		 * The meta object literal for the '<em><b>ELong Object Att</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ELONG_OBJECT_ATT = eINSTANCE.getClass1_ELongObjectAtt();

		/**
		 * The meta object literal for the '<em><b>EShort Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ESHORT_ATTR = eINSTANCE.getClass1_EShortAttr();

		/**
		 * The meta object literal for the '<em><b>EShort Object Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__ESHORT_OBJECT_ATTR = eINSTANCE.getClass1_EShortObjectAttr();

		/**
		 * The meta object literal for the '<em><b>EByte Attr</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EBYTE_ATTR = eINSTANCE.getClass1_EByteAttr();

		/**
		 * The meta object literal for the '<em><b>EByte Attr Object</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EBYTE_ATTR_OBJECT = eINSTANCE.getClass1_EByteAttrObject();

		/**
		 * The meta object literal for the '<em><b>Unary Reference</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS1__UNARY_REFERENCE = eINSTANCE.getClass1_UnaryReference();

		/**
		 * The meta object literal for the '<em><b>Nary Reference</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS1__NARY_REFERENCE = eINSTANCE.getClass1_NaryReference();

		/**
		 * The meta object literal for the '<em><b>Nary Reference not Unique</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS1__NARY_REFERENCE_NOT_UNIQUE = eINSTANCE.getClass1_NaryReference_notUnique();

		/**
		 * The meta object literal for the '<em><b>Unary Containment Reference</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS1__UNARY_CONTAINMENT_REFERENCE = eINSTANCE.getClass1_UnaryContainmentReference();

		/**
		 * The meta object literal for the '<em><b>Nary Containment Reference</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS1__NARY_CONTAINMENT_REFERENCE = eINSTANCE.getClass1_NaryContainmentReference();

		/**
		 * The meta object literal for the '<em><b>EInt Multi Attr</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__EINT_MULTI_ATTR = eINSTANCE.getClass1_EIntMultiAttr();

		/**
		 * The meta object literal for the '<em><b>Strings</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS1__STRINGS = eINSTANCE.getClass1_Strings();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class2Impl <em>Class2</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class2Impl
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getClass2()
		 * @generated
		 */
		EClass CLASS2 = eINSTANCE.getClass2();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CLASS2__NAME = eINSTANCE.getClass2_Name();

		/**
		 * The meta object literal for the '<em><b>Children</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS2__CHILDREN = eINSTANCE.getClass2_Children();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class3Impl <em>Class3</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.Class3Impl
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getClass3()
		 * @generated
		 */
		EClass CLASS3 = eINSTANCE.getClass3();

		/**
		 * The meta object literal for the '{@link org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1 <em>Enum1</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.Enum1
		 * @see org.eclipse.emf.facet.widgets.celleditors.ecore.tests.samplemm.impl.SamplemmPackageImpl#getEnum1()
		 * @generated
		 */
		EEnum ENUM1 = eINSTANCE.getEnum1();

	}

} //SamplemmPackage
