/*******************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	  Gregoire Dupe (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework
 *    Nicolas Guyomar (Mia-Software) - Bug 337454 - We can't delete a query Column
 *    Nicolas Guyomar (Mia-Software) - Bug 339922 - INatTableWidget method isCellSelected should use the plural
 *    Vincent Lorenzo (CEA-LIST) - bug 337408 - Add an action to sort columns by name - Adapted code from INatTableWidget						  Adapted Code from INatTableWidget
 *    Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 336482 - KeyBinding to edit element in Table : F2 
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Vincent Lorenzo (CEA-LIST) - Bug 344125 - The API should provide a method selectRows(List<EObject> elementsToSelect)
 *    Nicolas Guyomar (Mia-Software) - Bug 344475 - To be able to select a cell by EStructuralFeature in the table
 *    Nicolas Guyomar (Mia-Software) - Bug 342028 - Field can be edited even if they are marked as N/A
 *******************************************************************************/

package org.eclipse.emf.facet.widgets.nattable;

import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetAttribute;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

/**
 * This interface defines every public action a user can perform on the EMF
 * Facet table widget
 * 
 * @deprecated cf. https://bugs.eclipse.org/bugs/show_bug.cgi?id=374120
 */
@Deprecated
public interface INatTableWidget2 extends ISelectionProvider {

	/**
	 * This method calls the last launched {@link InstantiationMethod} and adds
	 * the result to the table if any.
	 * 
	 * If no {@link InstantiationMethod} is saved, then a selection popup is
	 * opened for the user to choose one via
	 * {@link INatTableWidget#selectInstantiationMethodToLaunch()}
	 */
	public void createNewElement();

	/**
	 * This method calls the given {@link InstantiationMethod} and adds the
	 * result to the table if any.
	 * 
	 * @param instantiationMethod
	 *            an {@link InstantiationMethod}
	 */
	public void createNewElement(final InstantiationMethod instantiationMethod);

	/**
	 * Open a dialog to choose the default instantiationMethod to perform when
	 * clicking on the "Create" button.
	 */
	public void selectInstantiationMethodToLaunch();

	/**
	 * Performs the usual save action.
	 */
	public void save();

	/**
	 * Open a "Save As" dialog to serialize the table.
	 */
	public void saveAs();

	/**
	 * Open the query selection dialog. Add a column which contains the result
	 * of the selected query.
	 */
	public void addQueryColumn();

	/**
	 * This method performs to usual "copy to clipboard" action.
	 */
	public void copySelectionToClipboard();

	/**
	 * Delete the selected elements from their respective models and remove the
	 * corresponding line in the table.
	 */
	public void deleteSelection();

	/**
	 * Open a selection popup to select which columns to show/hide.
	 */
	public void selectColumnsToHide();

	/**
	 * Whether to hide columns which don't contain any elements.
	 * 
	 * @param hideEmptyColumns
	 *            <code>true</code> to hide columns which don't contain any
	 *            elements.
	 */
	public void setHideEmptyColumns(boolean hideEmptyColumns);

	/**
	 * Whether to show columns which are specific to a few elements (false), or
	 * only columns which are common to all the elements (true).
	 * 
	 * @param onlyShowCommonColumns
	 *            Whether to show columns which are specific to a few elements
	 *            (false), or only columns which are common to all the elements
	 *            (true)
	 */
	public void setOnlyShowCommonColumns(boolean onlyShowCommonColumns);

	/**
	 * Whether to sort columns by type of link (attributes first, then
	 * references, then derived references, ...).
	 * 
	 * @param sortColumnsByType
	 *            {@link Boolean} to sort columns by type of link
	 */
	public void sortColumnsByType();

	/**
	 * Allow the opening of an existing saved .table file within the current
	 * table widget.
	 */
	public void openSavedTable();

	/**
	 * Remove the selected lines from the table. The actual elements are not
	 * deleted. See {@link INatTableWidget#deleteSelection()} for that case.
	 */
	public void removeLine();

	/**
	 * Perform the usual "Select All" action on the table's cells
	 */
	public void selectAll();

	/**
	 * This method returns the {@link TableConfiguration} attached to the table.
	 * 
	 * @return the {@link TableConfiguration} attached to the table.
	 */
	public TableConfiguration getTableConfiguration();

	/**
	 * @return The history of launched instantiation methods.
	 */
	public List<InstantiationMethod> getInstantionMethodHistory();

	/**
	 * This method returns the {@link TableInstance} attached to the table.
	 * 
	 * @return returns the {@link TableInstance} attached to the table.
	 */
	public TableInstance getTableInstance();

	/**
	 * Return whether there is at least a cell selected in the table
	 * 
	 * @return Whether there is at least a cell selected in the table
	 */
	public boolean isCellSelected();

	/**
	 * Return whether there is at least a column selected in the table
	 * 
	 * @return whether there is at least a column selected in the table
	 */
	public boolean isColumnSelected();

	/**
	 * Return whether the selection of cells can be deleted.
	 * 
	 * @return Whether the selection of cells can be deleted.
	 */
	public boolean isCellsDeletable();

	/**
	 * Return whether the selected column can be deleted.
	 * 
	 * @return whether the selected column can be deleted.
	 */
	public boolean isSelectedColumnDeletable();

	/**
	 * @return the widget composite itself.
	 */
	public Control getComposite();

	/**
	 * Add a new row in the table for each given element.
	 * 
	 * @param newElements
	 *            the list of elements to add to the table
	 */
	public void addRows(List<EObject> newElements);

	/**
	 * Register an {@link ActionDelegate}. It will be notified after the opening
	 * of a saved table in a view.
	 * 
	 * @param action
	 *            the action to be registered
	 */
	public void registerActionDelegate(IActionDelegate action);

	/**
	 * Unregister an {@link ActionDelegate}
	 * 
	 * @param action
	 *            the action to be unregistered
	 */
	public void unregisterActionDelegate(IActionDelegate action);

	public Collection<ISelectionChangedListener> getSelectionChangedListeners();

	public void openLoadCustomizationDialog();

	public void openLoadFacetsDialog();

	/**
	 * Sort the Columns by alphabetic order.
	 */
	public void sortColumnByNameAtoZ();

	/**
	 * Sort the Columns by reverse alphabetical order.
	 */
	public void sortColumnByNameZtoA();

	/**
	 * Set the facets in order to apply them on the table. If
	 * {@link FacetReference} or {@link FacetAttribute} are contained by those
	 * facets, new columns {@link FacetReferenceColumn} and
	 * {@link FacetAttributeColumn} are added to the table.
	 * 
	 * @param facets the list of facets to be applied on the table.
	 */
	public void setFacets(Collection<Facet> facets) throws CoreException;
	
	/**
	 * This method selects the cell corresponding to the given {@link EObject} in
	 * the {@link DefaultLabelColumn}.
	 * 
	 * @param eObject
	 *            the {@link EObject} we want to select the
	 *            {@link DefaultLabelColumn}'s cell.
	 */
	public void selectDefaultLabelCell(final EObject eObject);
	
	/**
	 * This method selects the cell corresponding to the given {@link EObject} at
	 * the column representing the given {@link EStructuralFeature}
	 */
	public void selectCell(EObject eObject, EStructuralFeature eStructuralFeature);
	
	/**
	 * Edit the selected cell.
	 */
	public void editSelectedCell();
	
	/**
	 * 
	 * @param selectedColumns
	 *            the columns to hide
	 * @param putOnTheTop
	 *            indicates if the localCustom files should be put on the top of
	 *            the stack
	 */
	public void showHideColumns(final List<Column> selectedColumns,
			final boolean putOnTheTop);

	/**
	 * Indicates if one of the local customization is not at the top of the
	 * stack
	 * 
	 * @return
	 */
	public boolean isOneOfTheLocalCustomizationsNotOnTheTop();

	/**
	 * This method does not change the state of the widget.
	 * @param setAtTheTop
	 *            indicates if we need to set the local customization at the top
	 *            of the stack to get the visibility
	 * @return the visible columns
	 */
	public List<Column> getVisibleColumns(boolean setAtTheTop);
	
	/**
	 * The method to put the local customization on the top
	 */
	public void putLocalCustomizationOnTheTop();
	
	/**
	 * The method to put the local customization on the bottom
	 */
	public void putLocalCustomizationOnTheBottom();
	
	/**
	 * Return true if the selected cell is editable
	 * Return false if several cells are selected
	 */
	public boolean isSelectedCellEditable();
	
	/**
	 * This method allows to select the rows representing the EObjcet in the table
	 * 
	 * @param elementsToSelect
	 *            the elementToSelect
	 * @param clearTheSelection
	 *          indicates if the current selection should be cleared
	 */
	public void selectRows(List<EObject> elementsToSelect, boolean clearTheSelection);
	
}
