/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.common.core.tests.internal;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.MetaclassInstances;
import org.eclipse.emf.facet.infra.common.core.internal.adapters.instances.MetaclassInstancesAdapterFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetaclassInstancesTest {
    private static final int INT_3 = 3;
    private MetaclassInstances metaclassInstances;
    private Resource resource;

    @Before
    public void setUp() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.resource = resourceSet.createResource(URI.createURI((String)"http://org.eclipse.gmt.modisco.infra.common.core.internal.tests/test.ecore"));
        this.metaclassInstances = (MetaclassInstances)MetaclassInstancesAdapterFactory.getInstance().adapt((Notifier)this.resource, MetaclassInstances.class);
    }

    @Test
    public void testNonExisting() {
        Assert.assertNotNull((Object)this.metaclassInstances);
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.EENUM, true);
        Assert.assertTrue((boolean)instances.isEmpty());
    }

    @Test
    public void testCreateClass() {
        EClass someClass = EcoreFactory.eINSTANCE.createEClass();
        someClass.setName("MyClass");
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASS, true);
        Assert.assertTrue((boolean)instances.isEmpty());
        this.resource.getContents().add((Object)someClass);
        this.assertContainsMyClass();
    }

    @Test
    public void testCreateAttribute() {
        EClass someClass = EcoreFactory.eINSTANCE.createEClass();
        this.resource.getContents().add((Object)someClass);
        EAttribute companyName = EcoreFactory.eINSTANCE.createEAttribute();
        companyName.setName("myAttribute");
        someClass.getEStructuralFeatures().add((Object)companyName);
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.EATTRIBUTE, false);
        Assert.assertTrue((instances.size() == 1 ? 1 : 0) != 0);
        EObject eObject = (EObject)instances.iterator().next();
        Assert.assertTrue((boolean)(eObject instanceof EAttribute));
        EAttribute eAttribute = (EAttribute)eObject;
        Assert.assertTrue((boolean)eAttribute.getName().equals("myAttribute"));
    }

    @Test
    public void testWithPackageAndClasses() {
        EPackage aPackage = EcoreFactory.eINSTANCE.createEPackage();
        this.resource.getContents().add((Object)aPackage);
        aPackage.setName("aPackage");
        aPackage.setNsPrefix("aPackage");
        aPackage.setNsURI("http:///aPackage");
        EClass class1 = EcoreFactory.eINSTANCE.createEClass();
        EClass class2 = EcoreFactory.eINSTANCE.createEClass();
        EClass class3 = EcoreFactory.eINSTANCE.createEClass();
        aPackage.getEClassifiers().add((Object)class1);
        aPackage.getEClassifiers().add((Object)class2);
        aPackage.getEClassifiers().add((Object)class3);
        this.assertionsForPackageAndClasses();
        this.metaclassInstances.clearCache();
        this.assertionsForPackageAndClasses();
    }

    @Test
    public void testWithPackageAndClasses2() {
        EPackage aPackage = EcoreFactory.eINSTANCE.createEPackage();
        aPackage.setName("aPackage");
        aPackage.setNsPrefix("aPackage");
        aPackage.setNsURI("http:///aPackage");
        EClass class1 = EcoreFactory.eINSTANCE.createEClass();
        EClass class2 = EcoreFactory.eINSTANCE.createEClass();
        EClass class3 = EcoreFactory.eINSTANCE.createEClass();
        EReference ePackageEClassifiers = EcorePackage.eINSTANCE.getEPackage_EClassifiers();
        EList classifiers = (EList)aPackage.eGet((EStructuralFeature)ePackageEClassifiers);
        classifiers.add((Object)class1);
        aPackage.getEClassifiers().add((Object)class2);
        classifiers.add((Object)class3);
        this.resource.getContents().add((Object)aPackage);
        this.assertionsForPackageAndClasses();
        this.metaclassInstances.clearCache();
        this.assertionsForPackageAndClasses();
    }

    private void assertionsForPackageAndClasses() {
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.EPACKAGE, false);
        Assert.assertTrue((instances.size() == 1 ? 1 : 0) != 0);
        instances = this.metaclassInstances.getInstances(EcorePackage.Literals.EPACKAGE, true);
        Assert.assertTrue((instances.size() == 1 ? 1 : 0) != 0);
        instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASS, true);
        Assert.assertTrue((instances.size() == 3 ? 1 : 0) != 0);
        instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASS, false);
        Assert.assertTrue((instances.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveClassAtRoot() {
        EClass someClass = EcoreFactory.eINSTANCE.createEClass();
        someClass.setName("MyClass");
        this.resource.getContents().add((Object)someClass);
        this.assertContainsMyClass();
        this.resource.getContents().remove((Object)someClass);
        this.assertNoClass();
    }

    @Test
    public void testRemoveClassUnderPackage() {
        EPackage aPackage = EcoreFactory.eINSTANCE.createEPackage();
        this.resource.getContents().add((Object)aPackage);
        EClass myClass = EcoreFactory.eINSTANCE.createEClass();
        myClass.setName("MyClass");
        aPackage.getEClassifiers().add((Object)myClass);
        this.assertContainsMyClass();
        EcoreUtil.remove((EObject)myClass);
        this.assertNoClass();
        aPackage.getEClassifiers().add((Object)myClass);
        this.assertContainsMyClass();
        aPackage.getEClassifiers().remove((Object)myClass);
        this.assertNoClass();
    }

    private void assertNoClass() {
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASS, false);
        Assert.assertTrue((instances.size() == 0 ? 1 : 0) != 0);
    }

    private void assertContainsMyClass() {
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASS, false);
        Assert.assertTrue((instances.size() == 1 ? 1 : 0) != 0);
        EObject eObject = (EObject)instances.iterator().next();
        Assert.assertTrue((boolean)(eObject instanceof EClass));
        EClass eClass = (EClass)eObject;
        Assert.assertTrue((boolean)eClass.getName().equals("MyClass"));
    }

    @Test
    public void testSubInstances() {
        EPackage aPackage = EcoreFactory.eINSTANCE.createEPackage();
        this.resource.getContents().add((Object)aPackage);
        EClass myClass = EcoreFactory.eINSTANCE.createEClass();
        myClass.setName("MyClass");
        aPackage.getEClassifiers().add((Object)myClass);
        EDataType myDataType = EcoreFactory.eINSTANCE.createEDataType();
        myDataType.setName("MyDataType");
        aPackage.getEClassifiers().add((Object)myDataType);
        Set instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASSIFIER, false);
        Assert.assertTrue((instances.size() == 0 ? 1 : 0) != 0);
        instances = this.metaclassInstances.getInstances(EcorePackage.Literals.ECLASSIFIER, true);
        Assert.assertTrue((instances.size() == 2 ? 1 : 0) != 0);
        Iterator iterator = instances.iterator();
        EObject eObject = (EObject)iterator.next();
        Assert.assertTrue((boolean)(eObject instanceof EClass));
        EClass eClass = (EClass)eObject;
        Assert.assertTrue((boolean)eClass.getName().equals("MyClass"));
        eObject = (EObject)iterator.next();
        Assert.assertTrue((boolean)(eObject instanceof EDataType));
        EDataType eDataType = (EDataType)eObject;
        Assert.assertTrue((boolean)eDataType.getName().equals("MyDataType"));
    }
}

