/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.efacet.core.FacetUtils;
import org.eclipse.emf.facet.efacet.core.IDerivedTypedElementManager;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementEObjectResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeListResult;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.runtime.ETypedElementPrimitiveTypeResult;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.DummyCollectionQueryImplementation;
import org.eclipse.emf.facet.efacet.tests.internal.v0_2.FacetTestUtils;
import org.eclipse.emf.facet.efacet.tests.metamodel.internal.dummyQuery.ReturnMode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDerivedTypedElementEvaluationTests {
    private static final String BUG376941 = "Bug376941";
    private static final String BUG376941_FACET = "Bug376941Facet";
    private static final String BUG376941_OPERATION = "compute";
    private static final String BUG376941_LIST_OPERATION = "computeList";
    private static final int BUG376941_EXPECTED_VALUE = 37;
    private static final List<String> BUG376941_EXPECTED_LIST_VALUE = Arrays.asList("first", "second", "third");
    private static final String PRIMITIVE_TEST_VALUE = "test value";
    private static final List<String> PRIMITIVE_TEST_VALUES = new ArrayList<String>();
    private static final EClass REFERENCE_TEST_VALUE = EcoreFactory.eINSTANCE.createEClass();
    private static final List<EClass> REFERENCE_TEST_VALUES = new ArrayList<EClass>();

    static {
        PRIMITIVE_TEST_VALUES.add("first test value");
        PRIMITIVE_TEST_VALUES.add("second test value");
        REFERENCE_TEST_VALUE.setName("testEClass");
        EClass testEClass1 = EcoreFactory.eINSTANCE.createEClass();
        testEClass1.setName("testEClass1");
        EClass testEClass2 = EcoreFactory.eINSTANCE.createEClass();
        testEClass1.setName("testEClass2");
        REFERENCE_TEST_VALUES.add(testEClass1);
        REFERENCE_TEST_VALUES.add(testEClass2);
    }

    protected abstract void setQueryMode(Query var1, ReturnMode var2);

    protected abstract Query createDummyQuery();

    protected abstract Query createDummyQueryForCollectionEvaluator();

    protected abstract void setQueryValue(Query var1, Object var2);

    protected abstract Class<? extends Throwable> getExpectedDummyException();

    @Test
    public void test01EvaluateSingleValuedOperation() throws Exception {
        FacetOperation operation = this.createOperation(false, false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        String result = (String)IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)operation, eObject, null, String.class, null);
        Assert.assertEquals((Object)PRIMITIVE_TEST_VALUE, (Object)result);
    }

    private List<ETypedElementPrimitiveTypeResult> testEvaluateSingleValuedFacetElementCollection(DerivedTypedElement derivedTypedElement) throws Exception {
        Query query = derivedTypedElement.getQuery();
        this.setQueryMode(query, ReturnMode.RETURN_ECLASS_NAME);
        List<EClass> sourceCollection = this.createSourceCollection();
        List result = IDerivedTypedElementManager.INSTANCE.batchEvaluate(derivedTypedElement, sourceCollection, null, ETypedElementPrimitiveTypeResult.class, null);
        Assert.assertEquals((long)sourceCollection.size(), (long)result.size());
        Assert.assertEquals((Object)derivedTypedElement, (Object)((ETypedElementPrimitiveTypeResult)result.get(0)).getDerivedTypedElement());
        Assert.assertEquals((Object)derivedTypedElement, (Object)((ETypedElementPrimitiveTypeResult)result.get(1)).getDerivedTypedElement());
        Assert.assertEquals((Object)derivedTypedElement, (Object)((ETypedElementPrimitiveTypeResult)result.get(2)).getDerivedTypedElement());
        Assert.assertTrue((boolean)((ETypedElementPrimitiveTypeResult)result.get(0)).getParameterValues().isEmpty());
        Assert.assertTrue((boolean)((ETypedElementPrimitiveTypeResult)result.get(1)).getParameterValues().isEmpty());
        Assert.assertTrue((boolean)((ETypedElementPrimitiveTypeResult)result.get(2)).getParameterValues().isEmpty());
        Assert.assertEquals((Object)sourceCollection.get(0), (Object)((ETypedElementPrimitiveTypeResult)result.get(0)).getSource());
        Assert.assertEquals((Object)sourceCollection.get(1), (Object)((ETypedElementPrimitiveTypeResult)result.get(1)).getSource());
        Assert.assertEquals((Object)sourceCollection.get(2), (Object)((ETypedElementPrimitiveTypeResult)result.get(2)).getSource());
        Assert.assertEquals((Object)sourceCollection.get(0).getName(), (Object)((ETypedElementPrimitiveTypeResult)result.get(0)).getResult());
        Assert.assertEquals((Object)sourceCollection.get(1).getName(), (Object)((ETypedElementPrimitiveTypeResult)result.get(1)).getResult());
        Assert.assertEquals((Object)sourceCollection.get(2).getName(), (Object)((ETypedElementPrimitiveTypeResult)result.get(2)).getResult());
        return result;
    }

    @Ignore
    @Test
    public void test02EvaluateSingleValuedOperationCollection() throws Exception {
        FacetOperation operation = this.createOperation(false, false);
        List<ETypedElementPrimitiveTypeResult> result = this.testEvaluateSingleValuedFacetElementCollection((DerivedTypedElement)operation);
        Assert.assertNull((Object)result.get(0).getException());
        Assert.assertNull((Object)result.get(1).getException());
        Assert.assertNull((Object)result.get(2).getException());
    }

    @Ignore
    @Test
    public void test03EvaluateSingleValuedOperationCollectionWithCollectionEvaluator() throws Exception {
        FacetOperation operation = this.createOperation(false, true);
        List<ETypedElementPrimitiveTypeResult> result = this.testEvaluateSingleValuedFacetElementCollection((DerivedTypedElement)operation);
        Assert.assertEquals((Object)DummyCollectionQueryImplementation.EXCEPTION, (Object)result.get(0).getException());
        Assert.assertEquals((Object)DummyCollectionQueryImplementation.EXCEPTION, (Object)result.get(1).getException());
        Assert.assertEquals((Object)DummyCollectionQueryImplementation.EXCEPTION, (Object)result.get(2).getException());
    }

    private List<EClass> createSourceCollection() {
        ArrayList<EClass> sourceCollection = new ArrayList<EClass>();
        EClass eClass1 = EcoreFactory.eINSTANCE.createEClass();
        eClass1.setName("first");
        sourceCollection.add(eClass1);
        EClass eClass2 = EcoreFactory.eINSTANCE.createEClass();
        eClass2.setName("second");
        sourceCollection.add(eClass2);
        EClass eClass3 = EcoreFactory.eINSTANCE.createEClass();
        eClass3.setName("third");
        sourceCollection.add(eClass3);
        return sourceCollection;
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test04EvaluateSingleValuedOperationWithWrongExpectedType() throws Exception {
        FacetOperation operation = this.createOperation(false, false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)operation, eObject, null, Integer.class, null);
    }

    @Test
    public void test05EvaluateSingleValuedOperationUntyped() throws Exception {
        FacetOperation operation = this.createOperation(false, false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)operation, eObject, null, null);
        Assert.assertEquals((Object)PRIMITIVE_TEST_VALUE, (Object)result);
    }

    @Test
    public void test06EvaluateMultiValuedOperation() throws Exception {
        FacetOperation operation = this.createOperation(true, false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        List result = IDerivedTypedElementManager.INSTANCE.evaluateMultiValued((DerivedTypedElement)operation, eObject, null, String.class, null);
        Assert.assertEquals(PRIMITIVE_TEST_VALUES, (Object)result);
    }

    @Ignore
    @Test
    public void test07EvaluateMultiValuedOperationCollection() throws Exception {
        FacetOperation operation = this.createOperation(true, false);
        this.setQueryMode(operation.getQuery(), ReturnMode.RETURN_ECLASS_NAME_CHARACTERS);
        List<EClass> sourceCollection = this.createSourceCollection();
        List result = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)operation, sourceCollection, null, ETypedElementPrimitiveTypeListResult.class, null);
        this.checkEClassNameCharacters((FacetElement)operation, sourceCollection, result);
    }

    private void checkEClassNameCharacters(FacetElement facetElement, List<EClass> sourceCollection, List<ETypedElementPrimitiveTypeListResult> result) {
        Assert.assertEquals((long)sourceCollection.size(), (long)result.size());
        int index = 0;
        for (ETypedElementPrimitiveTypeListResult resultElement : result) {
            Assert.assertEquals((Object)facetElement, (Object)result.get(index).getDerivedTypedElement());
            Assert.assertNull((Object)result.get(index).getException());
            Assert.assertTrue((boolean)result.get(index).getParameterValues().isEmpty());
            Assert.assertEquals((Object)sourceCollection.get(index), (Object)resultElement.getSource());
            EList resultList = resultElement.getResultList();
            AbstractDerivedTypedElementEvaluationTests.checkCharacters(((EClass)resultElement.getSource()).getName(), (EList<String>)resultList);
            ++index;
        }
    }

    private static void checkCharacters(String name, EList<String> nameCharacters) {
        Assert.assertEquals((long)name.length(), (long)nameCharacters.size());
        int index = 0;
        for (String character : nameCharacters) {
            Assert.assertEquals((Object)("" + name.charAt(index)), (Object)character);
            ++index;
        }
    }

    @Test
    public void test08EvaluateMultiValuedOperationUntyped() throws Exception {
        FacetOperation operation = this.createOperation(true, false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)operation, eObject, null, null);
        Assert.assertEquals(PRIMITIVE_TEST_VALUES, (Object)result);
    }

    private FacetOperation createOperation(boolean multiValued, boolean collectionEvaluator) throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateOperation");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEObject());
        facet.setName("testEvaluateOperation");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        if (multiValued) {
            operation.setUpperBound(-1);
        }
        facet.getFacetOperations().add((Object)operation);
        Query dummyQuery = collectionEvaluator ? this.createDummyQueryForCollectionEvaluator() : this.createDummyQuery();
        if (multiValued) {
            this.setQueryValue(dummyQuery, PRIMITIVE_TEST_VALUES);
        } else {
            this.setQueryValue(dummyQuery, PRIMITIVE_TEST_VALUE);
        }
        operation.setQuery(dummyQuery);
        return operation;
    }

    @Test
    public void test09EvaluateSingleValuedOperationWithParameters() throws Exception {
        FacetOperation operationWithParameters = this.createOperationWithParametersAndNoSource();
        this.setQueryMode(operationWithParameters.getQuery(), ReturnMode.ADD_PARAMETERS);
        ParameterValue param1 = EFacetFactory.eINSTANCE.createParameterValue();
        ParameterValue param2 = EFacetFactory.eINSTANCE.createParameterValue();
        param1.setParameter((EParameter)operationWithParameters.getEParameters().get(0));
        param2.setParameter((EParameter)operationWithParameters.getEParameters().get(1));
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        parameterValues.add(param1);
        parameterValues.add(param2);
        param1.setValue((Object)123);
        param2.setValue((Object)456);
        Integer result = (Integer)IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)operationWithParameters, null, parameterValues, Integer.class, null);
        Assert.assertEquals((long)579L, (long)result.intValue());
    }

    private FacetOperation createOperationWithParametersAndNoSource() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("operationWithParameters");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(null);
        facet.setName("operationWithParameters");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        EParameter param1 = EcoreFactory.eINSTANCE.createEParameter();
        EParameter param2 = EcoreFactory.eINSTANCE.createEParameter();
        param1.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        param1.setName("param1");
        param2.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        param2.setName("param2");
        operation.getEParameters().add((Object)param1);
        operation.getEParameters().add((Object)param2);
        facet.getFacetOperations().add((Object)operation);
        Query dummyQuery = this.createDummyQuery();
        operation.setQuery(dummyQuery);
        return operation;
    }

    @Test
    public void test10EvaluateMultiValuedOperationWithParameters() throws Exception {
        FacetOperation operation = this.createMultiValuedOperationWithParameters();
        ParameterValue param = EFacetFactory.eINSTANCE.createParameterValue();
        param.setParameter((EParameter)operation.getEParameters().get(0));
        param.setValue((Object)EcorePackage.eINSTANCE.getEClass_EAllAttributes());
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        parameterValues.add(param);
        EClass source = EcorePackage.eINSTANCE.getETypedElement();
        List result = IDerivedTypedElementManager.INSTANCE.evaluateMultiValued((DerivedTypedElement)operation, (EObject)source, parameterValues, EObject.class, null);
        Assert.assertEquals((Object)EcorePackage.eINSTANCE.getETypedElement().getEAllAttributes(), (Object)result);
    }

    private FacetOperation createMultiValuedOperationWithParameters() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("operationWithParameters");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEClass());
        facet.setName("operationWithParameters");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEObject());
        operation.setUpperBound(-1);
        EParameter param = EcoreFactory.eINSTANCE.createEParameter();
        param.setEType((EClassifier)EcorePackage.eINSTANCE.getEStructuralFeature());
        param.setName("feature");
        operation.getEParameters().add((Object)param);
        facet.getFacetOperations().add((Object)operation);
        Query dummyQuery = this.createDummyQuery();
        this.setQueryMode(dummyQuery, ReturnMode.RETURN_FEATURE_VALUES);
        operation.setQuery(dummyQuery);
        return operation;
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test11EvaluateOperationWithNoSourceType() throws Exception {
        Query dummyQuery = this.createDummyQuery();
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        facetOperation.setQuery(dummyQuery);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)facetOperation, eObject, null, null);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test12EvaluateOperationWithWrongSourceType() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateOperationWithWrongSourceType");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEOperation());
        facet.setName("testEvaluateOperationWithWrongSourceType");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetOperations().add((Object)operation);
        Query dummyQuery = this.createDummyQuery();
        this.setQueryValue(dummyQuery, "test value for testEvaluateQuery");
        operation.setQuery(dummyQuery);
        EReference source = EcoreFactory.eINSTANCE.createEReference();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)operation, (EObject)source, null, null);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test13EvaluateOperationWithWrongReturnType() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateOperationWithWrongReturnType");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEOperation());
        facet.setName("testEvaluateOperationWithWrongReturnType");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetOperations().add((Object)operation);
        Query dummyQuery = this.createDummyQuery();
        this.setQueryValue(dummyQuery, Boolean.FALSE);
        operation.setQuery(dummyQuery);
        EOperation source = EcoreFactory.eINSTANCE.createEOperation();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)operation, (EObject)source, null, null);
    }

    @Ignore
    @Test
    public void test34EvaluateSingleValuedOperationWithParametersCollection() throws Exception {
        FacetOperation operation = this.createOperationWithParametersAndSource();
        ParameterValue param = EFacetFactory.eINSTANCE.createParameterValue();
        param.setParameter((EParameter)operation.getEParameters().get(0));
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        parameterValues.add(param);
        param.setValue((Object)Character.valueOf('s'));
        List<EClass> sourceCollection = this.createSourceCollection();
        List resultList = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)operation, sourceCollection, parameterValues, ETypedElementPrimitiveTypeResult.class, null);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((ETypedElementPrimitiveTypeResult)resultList.get(0)).getResult());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((ETypedElementPrimitiveTypeResult)resultList.get(1)).getResult());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((ETypedElementPrimitiveTypeResult)resultList.get(2)).getResult());
        int index = 0;
        for (ETypedElementPrimitiveTypeResult result : resultList) {
            Assert.assertEquals((Object)operation, (Object)result.getDerivedTypedElement());
            Assert.assertNull((Object)result.getException());
            Assert.assertEquals((Object)sourceCollection.get(index), (Object)result.getSource());
            Assert.assertEquals((long)1L, (long)result.getParameterValues().size());
            Assert.assertEquals((Object)operation.getEParameters().get(0), (Object)((ParameterValue)result.getParameterValues().get(0)).getParameter());
            Assert.assertEquals((Object)param.getValue(), (Object)((ParameterValue)result.getParameterValues().get(0)).getValue());
            ++index;
        }
    }

    private FacetOperation createOperationWithParametersAndSource() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("operationWithParameters");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEClass());
        facet.setName("operationWithParameters");
        facetSet.getEClassifiers().add((Object)facet);
        FacetOperation operation = EFacetFactory.eINSTANCE.createFacetOperation();
        operation.setName("testOperation");
        operation.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        EParameter param = EcoreFactory.eINSTANCE.createEParameter();
        param.setEType((EClassifier)EcorePackage.eINSTANCE.getEChar());
        param.setName("startingCharacter");
        operation.getEParameters().add((Object)param);
        facet.getFacetOperations().add((Object)operation);
        Query dummyQuery = this.createDummyQuery();
        this.setQueryMode(dummyQuery, ReturnMode.NAME_STARTS_WITH);
        operation.setQuery(dummyQuery);
        return operation;
    }

    @Ignore
    @Test
    public void test35EvaluateMultiValuedOperationWithParametersCollection() throws Exception {
        FacetOperation operation = this.createMultiValuedOperationWithParameters();
        ParameterValue param = EFacetFactory.eINSTANCE.createParameterValue();
        param.setParameter((EParameter)operation.getEParameters().get(0));
        param.setValue((Object)EcorePackage.eINSTANCE.getEClass_EAllAttributes());
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        parameterValues.add(param);
        ArrayList<EClass> sourceCollection = new ArrayList<EClass>();
        sourceCollection.add(EcorePackage.eINSTANCE.getETypedElement());
        sourceCollection.add(EcorePackage.eINSTANCE.getEAnnotation());
        sourceCollection.add(EcorePackage.eINSTANCE.getENamedElement());
        List listResultList = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)operation, sourceCollection, parameterValues, ETypedElementEObjectListResult.class, null);
        int index = 0;
        for (ETypedElementEObjectListResult listResult : listResultList) {
            Assert.assertEquals((Object)((EClass)sourceCollection.get(index)).getEAllAttributes(), (Object)listResult.getResultList());
            Assert.assertEquals((Object)operation, (Object)listResult.getDerivedTypedElement());
            Assert.assertNull((Object)listResult.getException());
            Assert.assertEquals((long)1L, (long)listResult.getParameterValues().size());
            Assert.assertEquals((Object)operation.getEParameters().get(0), (Object)((ParameterValue)listResult.getParameterValues().get(0)).getParameter());
            Assert.assertEquals((Object)param.getValue(), (Object)((ParameterValue)listResult.getParameterValues().get(0)).getValue());
            ++index;
        }
    }

    @Test
    public void test36EvaluateSingleValuedOperationException() throws Exception {
        FacetOperation operation = this.createOperation(false, false);
        this.setQueryMode(operation.getQuery(), ReturnMode.THROW_EVALUATION_EXCEPTION);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        boolean gotException = false;
        try {
            IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)operation, eObject, null, String.class, null);
        }
        catch (DerivedTypedElementException e) {
            Assert.assertTrue((boolean)this.getExpectedDummyException().isInstance(e.getCause()));
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
    }

    @Test
    public void test37EvaluateSingleValuedOperationWithParametersException() throws Exception {
        FacetOperation operation = this.createOperationWithParametersAndSource();
        ParameterValue param = EFacetFactory.eINSTANCE.createParameterValue();
        param.setParameter((EParameter)operation.getEParameters().get(0));
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        parameterValues.add(param);
        param.setValue((Object)Character.valueOf('s'));
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(null);
        try {
            IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)operation, (EObject)eClass, null, Boolean.class, null);
        }
        catch (DerivedTypedElementException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof NullPointerException));
        }
    }

    @Ignore
    @Test
    public void test39EvaluateSingleValuedOperationWithParametersCollectionException() throws Exception {
        FacetOperation operation = this.createOperationWithParametersAndSource();
        ParameterValue param = EFacetFactory.eINSTANCE.createParameterValue();
        param.setParameter((EParameter)operation.getEParameters().get(0));
        ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
        parameterValues.add(param);
        param.setValue((Object)Character.valueOf('s'));
        List<EClass> sourceCollection = this.createSourceCollectionForNPE();
        List singleResultList = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)operation, sourceCollection, parameterValues, ETypedElementPrimitiveTypeResult.class, null);
        Assert.assertEquals((long)sourceCollection.size(), (long)singleResultList.size());
        int index = 0;
        for (ETypedElementPrimitiveTypeResult singleResult : singleResultList) {
            Assert.assertEquals((Object)sourceCollection.get(index), (Object)singleResult.getSource());
            Assert.assertEquals((Object)operation, (Object)singleResult.getDerivedTypedElement());
            Assert.assertEquals((long)1L, (long)singleResult.getParameterValues().size());
            Assert.assertEquals((Object)operation.getEParameters().get(0), (Object)((ParameterValue)singleResult.getParameterValues().get(0)).getParameter());
            Assert.assertEquals((Object)param.getValue(), (Object)((ParameterValue)singleResult.getParameterValues().get(0)).getValue());
            ++index;
        }
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((ETypedElementPrimitiveTypeResult)singleResultList.get(0)).getResult());
        Assert.assertNull((Object)((ETypedElementPrimitiveTypeResult)singleResultList.get(1)).getResult());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((ETypedElementPrimitiveTypeResult)singleResultList.get(2)).getResult());
        Assert.assertNull((Object)((ETypedElementPrimitiveTypeResult)singleResultList.get(0)).getException());
        Assert.assertTrue((boolean)(((ETypedElementPrimitiveTypeResult)singleResultList.get(1)).getException() instanceof NullPointerException));
        Assert.assertNull((Object)((ETypedElementPrimitiveTypeResult)singleResultList.get(2)).getException());
    }

    private List<EClass> createSourceCollectionForNPE() {
        ArrayList<EClass> sourceCollection = new ArrayList<EClass>();
        EClass eClass1 = EcoreFactory.eINSTANCE.createEClass();
        eClass1.setName("s1");
        sourceCollection.add(eClass1);
        EClass eClass2 = EcoreFactory.eINSTANCE.createEClass();
        eClass2.setName(null);
        sourceCollection.add(eClass2);
        EClass eClass3 = EcoreFactory.eINSTANCE.createEClass();
        eClass3.setName("c3");
        sourceCollection.add(eClass3);
        return sourceCollection;
    }

    @Test
    public void test14EvaluateSingleValuedAttribute() throws Exception {
        FacetAttribute attribute = this.createAttribute(false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        String result = (String)IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)attribute, eObject, null, String.class, null);
        Assert.assertEquals((Object)PRIMITIVE_TEST_VALUE, (Object)result);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test15EvaluateSingleValuedAttributeWithWrongExpectedType() throws Exception {
        FacetAttribute attribute = this.createAttribute(false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)attribute, eObject, null, Integer.class, null);
    }

    @Test
    public void test16EvaluateSingleValuedAttributeUntyped() throws Exception {
        FacetAttribute attribute = this.createAttribute(false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)attribute, eObject, null, null);
        Assert.assertEquals((Object)PRIMITIVE_TEST_VALUE, (Object)result);
    }

    @Test
    public void test17EvaluateMultiValuedAttribute() throws Exception {
        FacetAttribute attribute = this.createAttribute(true);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        List result = IDerivedTypedElementManager.INSTANCE.evaluateMultiValued((DerivedTypedElement)attribute, eObject, null, String.class, null);
        Assert.assertEquals(PRIMITIVE_TEST_VALUES, (Object)result);
    }

    @Test
    public void test18EvaluateMultiValuedAttributeUntyped() throws Exception {
        FacetAttribute attribute = this.createAttribute(true);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)attribute, eObject, null, null);
        Assert.assertEquals(PRIMITIVE_TEST_VALUES, (Object)result);
    }

    private FacetAttribute createAttribute(boolean multiValued) throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateAttribute");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEObject());
        facet.setName("testEvaluateAttribute");
        facetSet.getEClassifiers().add((Object)facet);
        FacetAttribute attribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        if (multiValued) {
            attribute.setUpperBound(-1);
        }
        facet.getFacetElements().add((Object)attribute);
        Query dummyQuery = this.createDummyQuery();
        if (multiValued) {
            this.setQueryValue(dummyQuery, PRIMITIVE_TEST_VALUES);
        } else {
            this.setQueryValue(dummyQuery, PRIMITIVE_TEST_VALUE);
        }
        attribute.setQuery(dummyQuery);
        return attribute;
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test19EvaluateAttributeWithNoSourceType() throws Exception {
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        Query dummyQuery = this.createDummyQuery();
        facetAttribute.setQuery(dummyQuery);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)facetAttribute, eObject, null, null);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test20EvaluateAttributeWithWrongSourceType() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateAttributeWithWrongSourceType");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEOperation());
        facet.setName("testEvaluateAttributeWithWrongSourceType");
        facetSet.getEClassifiers().add((Object)facet);
        FacetAttribute attribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        Query dummyQuery = this.createDummyQuery();
        this.setQueryValue(dummyQuery, PRIMITIVE_TEST_VALUE);
        attribute.setQuery(dummyQuery);
        EReference source = EcoreFactory.eINSTANCE.createEReference();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)attribute, (EObject)source, null, null);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test21EvaluateAttributeWithWrongReturnType() throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateAttributeWithWrongReturnType");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEOperation());
        facet.setName("testEvaluateAttributeWithWrongReturnType");
        facetSet.getEClassifiers().add((Object)facet);
        FacetAttribute attribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        attribute.setName("testAttribute");
        attribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        facet.getFacetElements().add((Object)attribute);
        Query dummyQuery = this.createDummyQuery();
        this.setQueryValue(dummyQuery, Boolean.FALSE);
        attribute.setQuery(dummyQuery);
        EOperation source = EcoreFactory.eINSTANCE.createEOperation();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)attribute, (EObject)source, null, null);
    }

    @Ignore
    @Test
    public void test30EvaluateSingleValuedAttributeCollection() throws Exception {
        FacetAttribute attribute = this.createAttribute(false);
        List<ETypedElementPrimitiveTypeResult> result = this.testEvaluateSingleValuedFacetElementCollection((DerivedTypedElement)attribute);
        Assert.assertNull((Object)result.get(0).getException());
        Assert.assertNull((Object)result.get(1).getException());
        Assert.assertNull((Object)result.get(2).getException());
    }

    @Ignore
    @Test
    public void test31EvaluateMultiValuedAttributeCollection() throws Exception {
        FacetAttribute attribute = this.createAttribute(true);
        this.setQueryMode(attribute.getQuery(), ReturnMode.RETURN_ECLASS_NAME_CHARACTERS);
        List<EClass> sourceCollection = this.createSourceCollection();
        List result = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)attribute, sourceCollection, null, ETypedElementPrimitiveTypeListResult.class, null);
        this.checkEClassNameCharacters((FacetElement)attribute, sourceCollection, result);
    }

    @Test
    public void test38EvaluateMultiValuedAttributeException() throws Exception {
        FacetAttribute attribute = this.createAttribute(true);
        this.setQueryMode(attribute.getQuery(), ReturnMode.RETURN_ECLASS_NAME_CHARACTERS);
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName(null);
        try {
            IDerivedTypedElementManager.INSTANCE.evaluateMultiValued((DerivedTypedElement)attribute, (EObject)eClass, null, String.class, null);
        }
        catch (DerivedTypedElementException e) {
            Throwable cause = e.getCause();
            Assert.assertNotNull((String)"The derivedTypedElementException must have a cause.", (Object)cause);
            Class<?> causeClass = cause.getClass();
            Assert.assertEquals((String)"The cause of the DerivedTypedElementException must be a NullPointerException", NullPointerException.class, causeClass);
        }
    }

    @Ignore
    @Test
    public void test40EvaluateMultiValuedAttributeCollectionException() throws Exception {
        FacetAttribute attribute = this.createAttribute(true);
        this.setQueryMode(attribute.getQuery(), ReturnMode.RETURN_ECLASS_NAME_CHARACTERS);
        List<EClass> sourceCollection = this.createSourceCollectionForNPE();
        List listResultList = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)attribute, sourceCollection, null, ETypedElementPrimitiveTypeListResult.class, null);
        Assert.assertEquals((long)sourceCollection.size(), (long)listResultList.size());
        int index = 0;
        for (ETypedElementPrimitiveTypeListResult listResult : listResultList) {
            Assert.assertEquals((Object)sourceCollection.get(index), (Object)listResult.getSource());
            Assert.assertEquals((Object)attribute, (Object)listResult.getDerivedTypedElement());
            Assert.assertEquals((long)0L, (long)listResult.getParameterValues().size());
            ++index;
        }
        Assert.assertNull((Object)((ETypedElementPrimitiveTypeListResult)listResultList.get(0)).getException());
        Assert.assertTrue((boolean)(((ETypedElementPrimitiveTypeListResult)listResultList.get(1)).getException() instanceof NullPointerException));
        Assert.assertNull((Object)((ETypedElementPrimitiveTypeListResult)listResultList.get(2)).getException());
        AbstractDerivedTypedElementEvaluationTests.checkCharacters(((EClass)((ETypedElementPrimitiveTypeListResult)listResultList.get(0)).getSource()).getName(), (EList<String>)((ETypedElementPrimitiveTypeListResult)listResultList.get(0)).getResultList());
        Assert.assertTrue((boolean)((ETypedElementPrimitiveTypeListResult)listResultList.get(1)).getResultList().isEmpty());
        AbstractDerivedTypedElementEvaluationTests.checkCharacters(((EClass)((ETypedElementPrimitiveTypeListResult)listResultList.get(2)).getSource()).getName(), (EList<String>)((ETypedElementPrimitiveTypeListResult)listResultList.get(2)).getResultList());
    }

    @Test
    public void test22EvaluateSingleValuedReference() throws Exception {
        FacetReference reference = this.createReference(false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        EClass result = (EClass)IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)reference, eObject, null, EClass.class, null);
        Assert.assertEquals((Object)REFERENCE_TEST_VALUE, (Object)result);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test23EvaluateSingleValuedReferenceWithWrongExpectedType() throws Exception {
        FacetReference reference = this.createReference(false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluateSingleValued((DerivedTypedElement)reference, eObject, null, EPackage.class, null);
    }

    @Test
    public void test24EvaluateSingleValuedReferenceUntyped() throws Exception {
        FacetReference reference = this.createReference(false);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)reference, eObject, null, null);
        Assert.assertEquals((Object)REFERENCE_TEST_VALUE, (Object)result);
    }

    @Test
    public void test25EvaluateMultiValuedReference() throws Exception {
        FacetReference reference = this.createReference(true);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        List result = IDerivedTypedElementManager.INSTANCE.evaluateMultiValued((DerivedTypedElement)reference, eObject, null, EClass.class, null);
        Assert.assertEquals(REFERENCE_TEST_VALUES, (Object)result);
    }

    @Test
    public void test26EvaluateMultiValuedReferenceUntyped() throws Exception {
        FacetReference reference = this.createReference(true);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        Object result = IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)reference, eObject, null, null);
        Assert.assertEquals(REFERENCE_TEST_VALUES, (Object)result);
    }

    private FacetReference createReference(boolean multiValued) throws Exception {
        FacetSet facetSet = FacetTestUtils.createFacetSet("testEvaluateAttribute");
        Facet facet = EFacetFactory.eINSTANCE.createFacet();
        facet.setExtendedMetaclass(EcorePackage.eINSTANCE.getEObject());
        facet.setName("testEvaluateAttribute");
        facetSet.getEClassifiers().add((Object)facet);
        FacetReference reference = EFacetFactory.eINSTANCE.createFacetReference();
        reference.setName("testReference");
        reference.setEType((EClassifier)EcorePackage.eINSTANCE.getEClass());
        if (multiValued) {
            reference.setUpperBound(-1);
        }
        facet.getFacetElements().add((Object)reference);
        Query dummyQuery = this.createDummyQuery();
        if (multiValued) {
            this.setQueryValue(dummyQuery, REFERENCE_TEST_VALUES);
        } else {
            this.setQueryValue(dummyQuery, REFERENCE_TEST_VALUE);
        }
        reference.setQuery(dummyQuery);
        return reference;
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test27EvaluateReferenceWithNoSourceType() throws Exception {
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        facetReference.setQuery(this.createDummyQuery());
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)facetReference, eObject, null, null);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test28EvaluateReferenceWithWrongSourceType() throws Exception {
        FacetReference reference = this.createReference(true);
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        ((Facet)reference.eContainer()).setExtendedMetaclass(eClass);
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)reference, (EObject)ePackage, null, null);
    }

    @Test(expected=DerivedTypedElementException.class)
    public void test29EvaluateReferenceWithWrongReturnType() throws Exception {
        FacetReference reference = this.createReference(false);
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.setQueryValue(reference.getQuery(), ePackage);
        EObject source = EcoreFactory.eINSTANCE.createEObject();
        IDerivedTypedElementManager.INSTANCE.evaluate((DerivedTypedElement)reference, source, null, null);
    }

    @Ignore
    @Test
    public void test32EvaluateSingleValuedReferenceCollection() throws Exception {
        FacetReference reference = this.createReference(false);
        this.setQueryMode(reference.getQuery(), ReturnMode.RETURN_SOURCE);
        List<EClass> sourceCollection = this.createSourceCollection();
        List resultList = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)reference, sourceCollection, null, ETypedElementEObjectResult.class, null);
        Assert.assertEquals((long)sourceCollection.size(), (long)resultList.size());
        int index = 0;
        for (ETypedElementEObjectResult result : resultList) {
            Assert.assertEquals((Object)sourceCollection.get(index), (Object)result.getSource());
            Assert.assertEquals((Object)result.getSource(), (Object)result.getResult());
            Assert.assertEquals((Object)reference, (Object)result.getDerivedTypedElement());
            Assert.assertNull((Object)result.getException());
            Assert.assertTrue((boolean)result.getParameterValues().isEmpty());
            ++index;
        }
    }

    @Ignore
    @Test
    public void test33EvaluateMultiValuedReferenceCollection() throws Exception {
        FacetReference reference = this.createReference(true);
        List<EClass> sourceCollection = this.createSourceCollection();
        List listResultList = IDerivedTypedElementManager.INSTANCE.batchEvaluate((DerivedTypedElement)reference, sourceCollection, null, ETypedElementEObjectListResult.class, null);
        Assert.assertEquals((long)sourceCollection.size(), (long)listResultList.size());
        for (ETypedElementEObjectListResult listResult : listResultList) {
            Assert.assertEquals(REFERENCE_TEST_VALUES, (Object)listResult.getResultList());
            Assert.assertEquals((Object)reference, (Object)listResult.getDerivedTypedElement());
            Assert.assertNull((Object)listResult.getException());
            Assert.assertTrue((boolean)listResult.getParameterValues().isEmpty());
        }
    }

    @Test
    public void test41EvaluateSingleValuedOperationWithLiteralParameters() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFacetSetCatalogManager catalog = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)resourceSet);
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)catalog.getRegisteredFacetSets(), (String)BUG376941);
        Facet facet = FacetUtils.getFacet((FacetSet)facetSet, (String)BUG376941_FACET);
        FacetOperation operation = (FacetOperation)FacetUtils.getETypedElement((Facet)facet, (String)BUG376941_OPERATION, FacetOperation.class);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IFacetManager manager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        Integer result = (Integer)manager.invoke(eObject, (EOperation)operation, Integer.class, null, new Object[0]);
        Assert.assertEquals((long)37L, (long)result.intValue());
    }

    @Test
    public void test42EvaluateMultiValuedOperationWithLiteralParameters() throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IFacetSetCatalogManager catalog = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager((ResourceSet)resourceSet);
        FacetSet facetSet = FacetUtils.getFacetSet((Collection)catalog.getRegisteredFacetSets(), (String)BUG376941);
        Facet facet = FacetUtils.getFacet((FacetSet)facetSet, (String)BUG376941_FACET);
        FacetOperation operation = (FacetOperation)FacetUtils.getETypedElement((Facet)facet, (String)BUG376941_LIST_OPERATION, FacetOperation.class);
        EObject eObject = EcoreFactory.eINSTANCE.createEObject();
        IFacetManager manager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager((ResourceSet)resourceSet);
        List result = (List)manager.invoke(eObject, (EOperation)operation, List.class, null, new Object[0]);
        Assert.assertEquals(BUG376941_EXPECTED_LIST_VALUE, (Object)result);
    }
}

