/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.internal.comparator;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.FacetManagerException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Row;
import org.eclipse.emf.facet.widgets.table.ui.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ColumnSortDirection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowComparator
implements Comparator<Row> {
    private final ETypedElement eTypedElement;
    private final ColumnSortDirection direction;
    private final IFacetManager facetManager;
    private long duration = 0L;
    private final Map<EObject, Object> map = new HashMap<EObject, Object>();

    public RowComparator(ETypedElement eTypedElement, ColumnSortDirection direction, IFacetManager facetManager) {
        this.eTypedElement = eTypedElement;
        this.direction = direction;
        this.facetManager = facetManager;
    }

    @Override
    public int compare(Row row1, Row row2) {
        long begin = System.currentTimeMillis();
        Object value1 = this.getValue(row1);
        Object value2 = this.getValue(row2);
        int result = this.compareValues(value1, value2);
        long end = System.currentTimeMillis();
        this.duration += end - begin;
        return result;
    }

    private Object getValue(Row row) {
        EObject eObject = row.getElement();
        Object value = this.map.get(eObject);
        if (value == null) {
            try {
                value = this.facetManager.getOrInvoke(eObject, this.eTypedElement, Object.class);
                this.map.put(eObject, value);
            }
            catch (FacetManagerException e) {
                Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return value;
    }

    protected final int compareValues(Object element1, Object element2) {
        int result;
        if (element1 == null) {
            result = -1;
        } else if (element1 instanceof Comparable) {
            Comparable comparable = (Comparable)element1;
            result = comparable.compareTo(element2);
        } else {
            result = element2 == null ? 1 : element1.toString().compareTo(element2.toString());
        }
        if (this.direction == ColumnSortDirection.DESCENDING) {
            result = -result;
        }
        return result;
    }

    public long getDuration() {
        return this.duration;
    }
}

