/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.browser.custom.examples.uml.tests.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.infra.browser.custom.examples.uml.tests.internal.Activator;
import org.eclipse.emf.facet.infra.common.core.internal.utils.FileUtils;
import org.eclipse.emf.facet.infra.common.core.internal.utils.IFilter;
import org.eclipse.emf.facet.infra.common.core.internal.utils.ProjectUtils;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.infra.facet.FacetReference;
import org.eclipse.emf.facet.infra.facet.FacetSet;
import org.eclipse.emf.facet.infra.facet.core.FacetContext;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;
import org.eclipse.emf.facet.infra.facet.core.exception.EmfFacetFacetException;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.ModelQuerySet;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Property;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.osgi.framework.Bundle;

@Deprecated
public class Tests {
    private static final String PLUGIN_URI = "platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml";
    private final ResourceSet resourceSet = new ResourceSetImpl();
    public static final String QUERY_SET_NAME = "_example_uml";

    @BeforeClass
    public static void beforeClass() throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            project.delete(true, (IProgressMonitor)new NullProgressMonitor());
            ++n2;
        }
    }

    @Test
    public void subClassifiers() throws ModelQueryException, EmfFacetFacetException {
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        Assert.assertNotNull((Object)querySet);
        ModelQuery modelQuery = querySet.getQuery("subClassifiers");
        Assert.assertNotNull((Object)modelQuery);
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        TreeIterator treeIterator = umlModel.getAllContents();
        while (treeIterator.hasNext()) {
            Class classs;
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof Class) || !(classs = (Class)eObject).getName().equals("Query")) continue;
            AbstractModelQuery modelQueryImpl = catalog.getModelQueryImpl(modelQuery);
            Object queryResult = modelQueryImpl.basicEvaluate((EObject)classs);
            if (!(queryResult instanceof List)) {
                Assert.fail((String)"Query result is expected to be a List");
            }
            List eClassifiers = (List)queryResult;
            Assert.assertEquals((long)2L, (long)eClassifiers.size());
            Class class1 = null;
            Class class2 = null;
            TreeIterator treeIterator1 = umlModel.getAllContents();
            while (treeIterator1.hasNext()) {
                EObject eObject1 = (EObject)treeIterator1.next();
                if (!(eObject1 instanceof Class)) continue;
                Class classs1 = (Class)eObject1;
                if (classs1.getName().equals("OCLQuery")) {
                    class1 = classs1;
                }
                if (!classs1.getName().equals("JavaQuery")) continue;
                class2 = classs1;
            }
            Assert.assertTrue((boolean)eClassifiers.contains(class1));
            Assert.assertTrue((boolean)eClassifiers.contains(class2));
            FacetSetCatalog facetSetCatalog = FacetSetCatalog.getSingleton();
            FacetSet facetSet = facetSetCatalog.getFacetSet("_example_umlFacets");
            Facet facet = facetSet.getFacet("ClassifierExtension");
            FacetReference facetReference = (FacetReference)facet.getEStructuralFeature("subClassifiers");
            FacetContext facetContext = new FacetContext();
            facetContext.addFacet(facet);
            List eClassifiers2 = (List)facetContext.get((EObject)classs, (EStructuralFeature)facetReference);
            Assert.assertEquals((long)2L, (long)eClassifiers2.size());
            Assert.assertTrue((boolean)eClassifiers2.contains(class1));
            Assert.assertTrue((boolean)eClassifiers2.contains(class2));
        }
    }

    @Test
    public void umlQuerySet() throws Exception {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/_example_uml.querySet");
        FileUtils.checkEMFResource((URI)uri, (int)1);
    }

    @Test
    public void umlUiCustom() throws Exception {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/_example_uml.uiCustom");
        FileUtils.checkEMFResource((URI)uri, (int)1);
    }

    @Test
    public void umlFacets() throws Exception {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/_example_umlFacets.facetSet");
        FileUtils.checkEMFResource((URI)uri, (int)1);
    }

    @Test
    public void umlFacets2() throws Exception {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/_example_umlFacets2.facetSet");
        FileUtils.checkEMFResource((URI)uri, (int)1);
    }

    @Test
    public void umlFacetsUiCustom() throws Exception {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/_example_umlFacetSet.uiCustom");
        FileUtils.checkEMFResource((URI)uri, (int)1);
    }

    @Test
    public void umlFacets2UiCustom() throws Exception {
        URI uri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/_example_umlFacetSet2.uiCustom");
        FileUtils.checkEMFResource((URI)uri, (int)1);
    }

    public void isMetaClass() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("isMetaClass");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)));
        Class cQuery = (Class)model.getMember("Query");
        Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cQuery)));
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cOclQuery)));
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cJavaQuery)));
    }

    public void allAttributes() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("allAttributes");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cQuery = (Class)model.getMember("Query");
        Assert.assertEquals((long)2L, (long)((List)queryImpl.basicEvaluate((EObject)cQuery)).size());
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertEquals((long)2L, (long)((List)queryImpl.basicEvaluate((EObject)cOclQuery)).size());
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertEquals((long)1L, (long)((List)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)).size());
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Assert.assertEquals((long)2L, (long)((List)queryImpl.basicEvaluate((EObject)cJavaQuery)).size());
    }

    public void allParents() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("allParents");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cQuery = (Class)model.getMember("Query");
        Assert.assertEquals((long)0L, (long)((List)queryImpl.basicEvaluate((EObject)cQuery)).size());
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertEquals((long)1L, (long)((List)queryImpl.basicEvaluate((EObject)cOclQuery)).size());
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertEquals((long)0L, (long)((List)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)).size());
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Assert.assertEquals((long)1L, (long)((List)queryImpl.basicEvaluate((EObject)cJavaQuery)).size());
    }

    public void isAssociationEnd() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("isAssociationEnd");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cQuery = (Class)model.getMember("Query");
        for (Property property : cQuery.getAttributes()) {
            if (property.getName().equals("class_1")) {
                Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)property)));
                continue;
            }
            if (property.getName().equals("Property_0")) {
                Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)property)));
                continue;
            }
            Assert.fail((String)"Unexpected attribute");
        }
    }

    public void parents() throws Exception {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("parents");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cQuery = (Class)model.getMember("Query");
        Assert.assertEquals((long)0L, (long)((List)queryImpl.basicEvaluate((EObject)cQuery)).size());
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertEquals((long)1L, (long)((List)queryImpl.basicEvaluate((EObject)cOclQuery)).size());
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertEquals((long)0L, (long)((List)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)).size());
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Object result = queryImpl.basicEvaluate((EObject)cJavaQuery);
        if (!(result instanceof List)) {
            throw new Exception("A list is expected as result.");
        }
        Assert.assertEquals((long)1L, (long)((List)result).size());
    }

    public void isStringProperty() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("isStringProperty");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cQuery = (Class)model.getMember("Query");
        for (Property property : cQuery.getAttributes()) {
            if (property.getName().equals("class_1")) {
                Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)property)));
                continue;
            }
            if (property.getName().equals("Property_0")) {
                Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)property)));
                continue;
            }
            Assert.fail((String)"Unexpected attribute");
        }
    }

    public void subClassifiers2() throws Exception {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("subClassifiers");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cQuery = (Class)model.getMember("Query");
        Assert.assertEquals((long)2L, (long)((List)queryImpl.basicEvaluate((EObject)cQuery)).size());
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertEquals((long)0L, (long)((List)queryImpl.basicEvaluate((EObject)cOclQuery)).size());
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertEquals((long)0L, (long)((List)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)).size());
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Object result = queryImpl.basicEvaluate((EObject)cJavaQuery);
        if (!(result instanceof List)) {
            throw new Exception("A list is expected as result.");
        }
        Assert.assertEquals((long)0L, (long)((List)result).size());
    }

    public void isUtility() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("isUtility");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)));
        Class cQueryManager = (Class)model.getMember("QueryManager");
        Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cQueryManager)));
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cJavaQuery)));
        Class cModelBrowser = (Class)model.getMember("ModelBrowser");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cModelBrowser)));
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cOclQuery)));
    }

    public void isQuery() throws ModelQueryException {
        URI umlModelUri = URI.createURI((String)"platform:/plugin/org.eclipse.emf.facet.infra.browser.custom.examples.uml/umlModels/umlExample1.uml");
        Resource umlModel = this.resourceSet.getResource(umlModelUri, true);
        ModelQuerySetCatalog.getSingleton().waitUntilBuilt();
        ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
        ModelQuerySet querySet = catalog.getModelQuerySet(QUERY_SET_NAME);
        ModelQuery modelQuery = querySet.getQuery("isQuery");
        AbstractModelQuery queryImpl = catalog.getModelQueryImpl(modelQuery);
        Model model = (Model)umlModel.getContents().get(0);
        Class cOclQuery = (Class)model.getMember("OCLQuery");
        Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cOclQuery)));
        Class cUtilityAndMetaClass = (Class)model.getMember("UtilityAndMetaClass");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cUtilityAndMetaClass)));
        Class cJavaQuery = (Class)model.getMember("JavaQuery");
        Assert.assertTrue((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cJavaQuery)));
        Class cModelBrowser = (Class)model.getMember("ModelBrowser");
        Assert.assertFalse((boolean)((Boolean)queryImpl.basicEvaluate((EObject)cModelBrowser)));
    }

    @Test
    public void bug308991() throws CoreException, IOException, InterruptedException {
        final ArrayList statusList = new ArrayList();
        ILogListener listener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                statusList.add(status);
            }
        };
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.emf.facet.infra.common.core"));
        log.addLogListener(listener);
        ProjectUtils.importPlugin((Bundle)Platform.getBundle((String)"org.eclipse.emf.facet.infra.browser.custom.examples.uml"), (IFilter)new IFilter(){

            public boolean filter(Object object) {
                boolean result = true;
                if (object instanceof File) {
                    File file = (File)object;
                    result = !file.getName().equals(".checkstyle");
                } else if (object instanceof String) {
                    String str = (String)object;
                    result = !str.equals(".checkstyle");
                }
                return result;
            }
        });
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.emf.facet.infra.browser.custom.examples.uml");
        ProjectUtils.refresh((IProject)project);
        log.removeLogListener(listener);
        if (!statusList.isEmpty()) {
            MultiStatus status = new MultiStatus(Activator.getDefault().getBundle().getSymbolicName(), 4, statusList.toArray(new IStatus[0]), "Test failed.", (Throwable)new Exception());
            CoreException e = new CoreException((IStatus)status);
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
            throw e;
        }
    }
}

