/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.aggregate.tests.internal;

import org.eclipse.emf.facet.common.ui.internal.views.ElementsView;
import org.eclipse.emf.facet.custom.ui.internal.exported.CustomizationUIConstants;
import org.eclipse.emf.facet.util.swt.internal.exported.SWTTestUtils;
import org.eclipse.emf.facet.util.tests.swtbot.internal.exported.SWTBotUtils;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class CustomizationsCatalogViewTests {
    private ElementsView elementsView;

    protected void setElementsView(ElementsView elementsView) {
        this.elementsView = elementsView;
    }

    public ElementsView getElementsView() {
        return this.elementsView;
    }

    private void openView() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    CustomizationsCatalogViewTests.this.setElementsView((ElementsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(CustomizationUIConstants.getCustomizationCatalogViewId()));
                }
                catch (PartInitException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Test
    public void testCustomizationsView() throws Exception {
        SWTBotUtils.closeWelcomeAndEditorsAndShells();
        this.openView();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                CustomizationsCatalogViewTests.this.testView();
            }
        });
    }

    protected void testView() {
        TreeViewer treeViewer = this.getElementsView().getViewer();
        treeViewer.expandAll();
        TreeItem[] items = treeViewer.getTree().getItems();
        TreeItem aggregate = SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_aggregate", (TreeItem[])items);
        SWTBotUtils.captureScreenShot((String)"customizations catalog view with aggregates");
        Assert.assertNotNull((String)"The aggregate must be in the view", (Object)aggregate);
        Assert.assertNotNull((String)"The custom must be in the view", (Object)SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_custom", (TreeItem[])items));
        Assert.assertNull((String)"The FacetSet must not be in the view", (Object)SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_facetSet", (TreeItem[])items));
        Assert.assertNotNull((String)"The custom must appear under the aggregate", (Object)SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_custom", (TreeItem[])aggregate.getItems()));
        Assert.assertNull((String)"The FacetSet must not appear under the aggregate", (Object)SWTTestUtils.findTreeItem((String)"Bug372626_Aggregates_facetSet", (TreeItem[])aggregate.getItems()));
    }
}

