/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.tests.internal;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.infra.query.runtime.RuntimeFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableUtils;
import org.eclipse.emf.facet.widgets.nattable.NatTableWidgetUtils;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.EObjectQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.PrimitiveTypeQueryRow;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tests.internal.Activator;
import org.junit.Assert;
import org.junit.Test;

public class NatTableUtilsTest {
    private static final int TIMEOUT = 30000;
    private static final String TABLE_CONFIGURATION_FILE_PATH = "/resources/_test_EcoreTableConfiguration.tableconfiguration";

    @Test(timeout=30000L)
    public void createTableInstanceTest() {
        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + "/" + TABLE_CONFIGURATION_FILE_PATH), (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        TableConfiguration tableConfiguration = (TableConfiguration)resource.getContents().get(0);
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(EcoreFactory.eINSTANCE.createEClass());
        elements.add(EcoreFactory.eINSTANCE.createEClass());
        elements.add(EcoreFactory.eINSTANCE.createEClass());
        EPackage context = EcoreFactory.eINSTANCE.createEPackage();
        EClass parameter = EcoreFactory.eINSTANCE.createEClass();
        TableInstance2 tableInstance = NatTableWidgetUtils.createTableInstance(elements, (String)"", (TableConfiguration)tableConfiguration, (EObject)context, (Object)parameter);
        Assert.assertNotNull((Object)tableInstance);
        Assert.assertEquals((Object)context, (Object)tableInstance.getContext());
        Assert.assertEquals((Object)parameter, (Object)tableInstance.getParameter());
        Assert.assertEquals(elements, (Object)tableInstance.getElements());
        Assert.assertEquals((Object)tableConfiguration, (Object)tableInstance.getTableConfiguration());
        Assert.assertTrue((boolean)INatTableUtils.INSTANCE.checkInput((TableInstance)tableInstance));
        elements.add(EcoreFactory.eINSTANCE.createEPackage());
        tableInstance = NatTableWidgetUtils.createTableInstance(elements, (String)"", (TableConfiguration)tableConfiguration, null, null);
        Assert.assertFalse((String)"EPackage should not be accepted by this tableConfiguration", (boolean)INatTableUtils.INSTANCE.checkInput((TableInstance)tableInstance));
        Assert.assertEquals((long)33L, (long)tableInstance.getColumns().size());
        Assert.assertEquals((long)4L, (long)tableInstance.getRows().size());
    }

    @Test(timeout=30000L)
    public void createQueryTableInstanceTest() {
        URI uri = URI.createPlatformPluginURI((String)(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + "/" + TABLE_CONFIGURATION_FILE_PATH), (boolean)false);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(uri, true);
        TableConfiguration tableConfiguration = (TableConfiguration)resource.getContents().get(0);
        ArrayList<ModelQueryResult> modelQueryResults = new ArrayList<ModelQueryResult>();
        ModelQueryResult modelQueryResult = RuntimeFactory.eINSTANCE.createModelQueryResult();
        ArrayList<Object> resultList = new ArrayList<Object>();
        resultList.add(EcoreFactory.eINSTANCE.createEObject());
        resultList.add(EcoreFactory.eINSTANCE.createEObject());
        resultList.add(0);
        modelQueryResult.setValue(resultList);
        modelQueryResults.add(modelQueryResult);
        modelQueryResults.add(RuntimeFactory.eINSTANCE.createModelQueryResult());
        modelQueryResults.add(RuntimeFactory.eINSTANCE.createModelQueryResult());
        EPackage context = EcoreFactory.eINSTANCE.createEPackage();
        EClass parameter = EcoreFactory.eINSTANCE.createEClass();
        QueryTableInstance queryTableInstance = NatTableWidgetUtils.createQueryTableInstance(modelQueryResults, (TableConfiguration)tableConfiguration, (EObject)context, (Object)parameter);
        Assert.assertNotNull((Object)queryTableInstance);
        Assert.assertEquals((Object)context, (Object)queryTableInstance.getContext());
        Assert.assertEquals((long)2L, (long)queryTableInstance.getColumns().size());
        Assert.assertEquals((long)5L, (long)queryTableInstance.getRows().size());
        Assert.assertTrue((boolean)(queryTableInstance.getRows().get(0) instanceof EObjectQueryRow));
        Assert.assertTrue((boolean)(queryTableInstance.getRows().get(1) instanceof EObjectQueryRow));
        Assert.assertTrue((boolean)(queryTableInstance.getRows().get(2) instanceof PrimitiveTypeQueryRow));
    }
}

