/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.style;

import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.style.CellStyleAttributes;
import net.sourceforge.nattable.style.CellStyleProxy;
import net.sourceforge.nattable.style.HorizontalAlignmentEnum;
import net.sourceforge.nattable.style.IStyle;
import net.sourceforge.nattable.style.VerticalAlignmentEnum;
import org.eclipse.swt.graphics.Rectangle;

public class CellStyleUtil {
    public static IStyle getCellStyle(LayerCell cell, IConfigRegistry configRegistry) {
        return new CellStyleProxy(configRegistry, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
    }

    public static int getHorizontalAlignmentPadding(IStyle cellStyle, Rectangle rectangle, int contentWidth) {
        HorizontalAlignmentEnum horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        return CellStyleUtil.getHorizontalAlignmentPadding(horizontalAlignment, rectangle, contentWidth);
    }

    public static int getHorizontalAlignmentPadding(HorizontalAlignmentEnum horizontalAlignment, Rectangle rectangle, int contentWidth) {
        if (horizontalAlignment == null) {
            horizontalAlignment = HorizontalAlignmentEnum.CENTER;
        }
        int padding = 0;
        switch (horizontalAlignment) {
            case CENTER: {
                padding = (rectangle.width - contentWidth) / 2;
                break;
            }
            case RIGHT: {
                padding = rectangle.width - contentWidth;
            }
        }
        if (padding < 0) {
            padding = 0;
        }
        return padding;
    }

    public static int getVerticalAlignmentPadding(IStyle cellStyle, Rectangle rectangle, int contentHeight) {
        VerticalAlignmentEnum verticalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        return CellStyleUtil.getVerticalAlignmentPadding(verticalAlignment, rectangle, contentHeight);
    }

    public static int getVerticalAlignmentPadding(VerticalAlignmentEnum verticalAlignment, Rectangle rectangle, int contentHeight) {
        if (verticalAlignment == null) {
            verticalAlignment = VerticalAlignmentEnum.MIDDLE;
        }
        int padding = 0;
        switch (verticalAlignment) {
            case MIDDLE: {
                padding = (rectangle.height - contentHeight) / 2;
                break;
            }
            case BOTTOM: {
                padding = rectangle.height - contentHeight;
            }
        }
        if (padding < 0) {
            padding = 0;
        }
        return padding;
    }
}

