/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.emf.core.tests.internal;

import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.facet.util.emf.core.IBrowserRegistry;
import org.eclipse.emf.facet.util.emf.core.IEObjectBrowserOpener;
import org.eclipse.emf.facet.util.emf.core.IEPackageBrowserOpener;
import org.eclipse.emf.facet.util.emf.core.IResourceBrowserOpener;
import org.eclipse.emf.facet.util.emf.core.tests.internal.TestBrowserImpl;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UtilEMFCoreTests {
    @BeforeClass
    public static void initialize() {
        IEclipsePreferences preferenceNode = new InstanceScope().getNode("org.eclipse.emf.facet.util.emf.core");
        preferenceNode.put("emf_facet_default_eobject_viewer", TestBrowserImpl.class.getName());
        preferenceNode.put("emf_facet_default_epackage_viewer", TestBrowserImpl.class.getName());
        preferenceNode.put("emf_facet_default_resource_viewer", TestBrowserImpl.class.getName());
    }

    @Test
    public void testBrowserRegistrationEObject() {
        IEObjectBrowserOpener eObjectBrowser = this.getEObjectBrowser();
        EClass anEObject = EcoreFactory.eINSTANCE.createEClass();
        eObjectBrowser.openEObject((EObject)anEObject);
        EObject openedEObject = TestBrowserImpl.getOpenedOnEObject();
        Assert.assertEquals((Object)anEObject, (Object)openedEObject);
    }

    private IEObjectBrowserOpener getEObjectBrowser() {
        List allRegisteredEObjectBrowsers = IBrowserRegistry.INSTANCE.getAllRegisteredEObjectBrowsers();
        Assert.assertTrue((allRegisteredEObjectBrowsers.size() > 0 ? 1 : 0) != 0);
        for (IEObjectBrowserOpener eObjectBrowserOpener : allRegisteredEObjectBrowsers) {
            if (!"dummy browser impl for testing".equals(eObjectBrowserOpener.getBrowserName())) continue;
            return eObjectBrowserOpener;
        }
        Assert.assertTrue((String)"browser not found in the list", (boolean)false);
        return null;
    }

    @Test
    public void testBrowserRegistrationEPackage() {
        IEPackageBrowserOpener browser = this.getEPackageBrowser();
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        browser.openEPackage(ePackage);
        EPackage openedEPackage = TestBrowserImpl.getOpenedOnEPackage();
        Assert.assertEquals((Object)ePackage, (Object)openedEPackage);
    }

    private IEPackageBrowserOpener getEPackageBrowser() {
        List allRegisteredEPackageBrowsers = IBrowserRegistry.INSTANCE.getAllRegisteredEPackageBrowsers();
        Assert.assertTrue((allRegisteredEPackageBrowsers.size() > 0 ? 1 : 0) != 0);
        for (IEPackageBrowserOpener ePackageBrowserOpener : allRegisteredEPackageBrowsers) {
            if (!"dummy browser impl for testing".equals(ePackageBrowserOpener.getBrowserName())) continue;
            return ePackageBrowserOpener;
        }
        Assert.assertTrue((String)"browser not found in the list", (boolean)false);
        return null;
    }

    @Test
    public void testBrowserRegistrationResource() {
        IResourceBrowserOpener browser = this.getResourceBrowser();
        ResourceImpl resourceImpl = new ResourceImpl();
        browser.openResource((Resource)resourceImpl);
        Resource openedResource = TestBrowserImpl.getOpenedOnResource();
        Assert.assertEquals((Object)resourceImpl, (Object)openedResource);
    }

    private IResourceBrowserOpener getResourceBrowser() {
        List allRegisteredResourceBrowsers = IBrowserRegistry.INSTANCE.getAllRegisteredResourceBrowsers();
        Assert.assertTrue((allRegisteredResourceBrowsers.size() > 0 ? 1 : 0) != 0);
        for (IResourceBrowserOpener resourceBrowserOpener : allRegisteredResourceBrowsers) {
            if (!"dummy browser impl for testing".equals(resourceBrowserOpener.getBrowserName())) continue;
            return resourceBrowserOpener;
        }
        Assert.assertTrue((String)"browser not found in the list", (boolean)false);
        return null;
    }

    @Test
    public void testBrowserOpenOnEObject() {
        EClass anEObject = EcoreFactory.eINSTANCE.createEClass();
        IBrowserRegistry.INSTANCE.browseEObject((EObject)anEObject);
        EObject openedEObject = TestBrowserImpl.getOpenedOnEObject();
        Assert.assertEquals((Object)anEObject, (Object)openedEObject);
    }

    @Test
    public void testBrowserOpenOnEPackage() {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        IBrowserRegistry.INSTANCE.browseEPackage(ePackage);
        EPackage openedEPackage = TestBrowserImpl.getOpenedOnEPackage();
        Assert.assertEquals((Object)ePackage, (Object)openedEPackage);
    }

    @Test
    public void testBrowserOpenOnResource() {
        ResourceImpl resourceImpl = new ResourceImpl();
        IBrowserRegistry.INSTANCE.browseResource((Resource)resourceImpl);
        Resource openedResource = TestBrowserImpl.getOpenedOnResource();
        Assert.assertEquals((Object)resourceImpl, (Object)openedResource);
    }
}

