/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.efacet.tests.internal.v0_1;

import java.io.IOException;
import java.util.HashMap;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.efacet.EFacetFactory;
import org.eclipse.emf.facet.efacet.Facet;
import org.eclipse.emf.facet.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.FacetOperation;
import org.eclipse.emf.facet.efacet.FacetReference;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.emf.facet.efacet.core.IFacetAction;
import org.eclipse.emf.facet.util.pde.core.internal.exported.PluginUtils;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class OldFacetActionTests {
    private static final String RESOURCES_TEST = "/resources/v0_1/facetSetTest.efacet";
    private FacetSet facetSet = null;
    private AdapterFactoryEditingDomain editingDomain;
    private Facet facet;

    public void initResource() throws CoreException, IOException {
        IProject oldProject = ResourcesPlugin.getWorkspace().getRoot().getProject("org.eclipse.emf.facet.efacet.tests");
        if (oldProject.exists()) {
            oldProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.emf.facet.efacet.tests");
        IProject project = null;
        project = PluginUtils.importPlugin((Bundle)bundle);
        if (project == null) {
            throw new NullPointerException();
        }
        IFile tableFile = project.getFile(RESOURCES_TEST);
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource facetSetResource = rSet.getResource(URI.createPlatformResourceURI((String)tableFile.getFullPath().toString(), (boolean)true), true);
        EObject eObject = (EObject)facetSetResource.getContents().get(0);
        Assert.assertNotNull((Object)eObject);
        Assert.assertTrue((boolean)(eObject instanceof FacetSet));
        this.facetSet = (FacetSet)eObject;
        Assert.assertNotNull((Object)this.facetSet);
        this.facet = (Facet)this.facetSet.getFacets().get(0);
        Assert.assertNotNull((Object)this.facet);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        Assert.assertNotNull((Object)this.editingDomain);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateFacetInFacetSet1() {
        IFacetAction.INSTANCE.createFacetInFacetSet(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateFacetInFacetSet2() {
        FacetSet localFacetSet = EFacetFactory.eINSTANCE.createFacetSet();
        IFacetAction.INSTANCE.createFacetInFacetSet(localFacetSet, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateFacetInFacetSet3() {
        FacetSet localFacetSet = EFacetFactory.eINSTANCE.createFacetSet();
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        IFacetAction.INSTANCE.createFacetInFacetSet(localFacetSet, localFacet, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateFacetInFacetSet4() {
        FacetSet localFacetSet = EFacetFactory.eINSTANCE.createFacetSet();
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource facetSetResource = rSet.getResource(URI.createPlatformResourceURI((String)"test", (boolean)true), true);
        facetSetResource.getContents().add((Object)localFacet);
        IFacetAction.INSTANCE.createFacetInFacetSet(localFacetSet, localFacet, null);
    }

    @Test
    public void testCreateFacetInFacetSet5() throws CoreException, IOException {
        this.initResource();
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        IFacetAction.INSTANCE.createFacetInFacetSet(this.facetSet, localFacet, (EditingDomain)this.editingDomain);
        Assert.assertTrue((boolean)this.facetSet.getFacets().contains((Object)localFacet));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAttributeInFacet1() {
        IFacetAction.INSTANCE.addAttributeInFacet(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAttributeInFacet2() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        IFacetAction.INSTANCE.addAttributeInFacet(localFacet, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAttributeInFacet3() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        IFacetAction.INSTANCE.addAttributeInFacet(localFacet, facetAttribute, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddAttributeInFacet4() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource facetSetResource = rSet.getResource(URI.createPlatformResourceURI((String)"test", (boolean)true), true);
        facetSetResource.getContents().add((Object)facetAttribute);
        IFacetAction.INSTANCE.addAttributeInFacet(localFacet, facetAttribute, null);
    }

    @Test
    public void testAddAttributeInFacet5() throws CoreException, IOException {
        this.initResource();
        FacetAttribute facetAttribute = EFacetFactory.eINSTANCE.createFacetAttribute();
        IFacetAction.INSTANCE.addAttributeInFacet(this.facet, facetAttribute, (EditingDomain)this.editingDomain);
        Assert.assertTrue((boolean)(this.facet.getFacetElements().get(0) instanceof FacetAttribute));
        FacetAttribute resultFacetAttribute = (FacetAttribute)this.facet.getFacetElements().get(0);
        Assert.assertNotNull((Object)resultFacetAttribute);
        Assert.assertTrue((resultFacetAttribute == facetAttribute ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddReferenceInFacet1() {
        IFacetAction.INSTANCE.addReferenceInFacet(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddReferenceInFacet2() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        IFacetAction.INSTANCE.addReferenceInFacet(localFacet, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddReferenceInFacet3() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        IFacetAction.INSTANCE.addReferenceInFacet(localFacet, facetReference, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddReferenceInFacet4() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource facetSetResource = rSet.getResource(URI.createPlatformResourceURI((String)"test", (boolean)true), true);
        facetSetResource.getContents().add((Object)facetReference);
        IFacetAction.INSTANCE.addReferenceInFacet(localFacet, facetReference, null);
    }

    @Test
    public void testAddReferenceInFacet5() throws CoreException, IOException {
        this.initResource();
        FacetReference facetReference = EFacetFactory.eINSTANCE.createFacetReference();
        IFacetAction.INSTANCE.addReferenceInFacet(this.facet, facetReference, (EditingDomain)this.editingDomain);
        Assert.assertTrue((boolean)(this.facet.getFacetElements().get(0) instanceof FacetReference));
        FacetReference resultFacetReference = (FacetReference)this.facet.getFacetElements().get(0);
        Assert.assertNotNull((Object)resultFacetReference);
        Assert.assertTrue((resultFacetReference == facetReference ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddOperationInFacet1() {
        IFacetAction.INSTANCE.addOperationInFacet(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddOperationInFacet2() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        IFacetAction.INSTANCE.addOperationInFacet(localFacet, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddOperationInFacet3() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        IFacetAction.INSTANCE.addOperationInFacet(localFacet, facetOperation, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddOperationInFacet4() {
        Facet localFacet = EFacetFactory.eINSTANCE.createFacet();
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource facetSetResource = rSet.getResource(URI.createPlatformResourceURI((String)"test", (boolean)true), true);
        facetSetResource.getContents().add((Object)facetOperation);
        IFacetAction.INSTANCE.addOperationInFacet(localFacet, facetOperation, null);
    }

    @Test
    public void testAddOperationInFacet5() throws CoreException, IOException {
        this.initResource();
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        IFacetAction.INSTANCE.addOperationInFacet(this.facet, facetOperation, (EditingDomain)this.editingDomain);
        Assert.assertTrue((boolean)(this.facet.getFacetElements().get(0) instanceof FacetOperation));
        FacetOperation resultFacetOperation = (FacetOperation)this.facet.getFacetElements().get(0);
        Assert.assertNotNull((Object)resultFacetOperation);
        Assert.assertTrue((resultFacetOperation == facetOperation ? 1 : 0) != 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFacetSetNsUri1() {
        IFacetAction.INSTANCE.setFacetSetNsUri(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFacetSetNsUri2() {
        FacetSet localFacetSet = EFacetFactory.eINSTANCE.createFacetSet();
        IFacetAction.INSTANCE.setFacetSetNsUri(localFacetSet, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFacetSetNsUri3() {
        FacetSet localFacetSet = EFacetFactory.eINSTANCE.createFacetSet();
        IFacetAction.INSTANCE.setFacetSetNsUri(localFacetSet, "nsUri", null);
    }

    @Test
    public void testSetFacetSetNsUri4() throws CoreException, IOException {
        this.initResource();
        String nsUri = "nsURi";
        IFacetAction.INSTANCE.setFacetSetNsUri(this.facetSet, nsUri, (EditingDomain)this.editingDomain);
        Assert.assertTrue((boolean)this.facetSet.getNsURI().equals(nsUri));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddParameterInOperation1() {
        IFacetAction.INSTANCE.addParameterInOperation(null, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddParameterInOperation2() {
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        IFacetAction.INSTANCE.addParameterInOperation(facetOperation, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddParameterInOperation3() {
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        IFacetAction.INSTANCE.addParameterInOperation(facetOperation, parameter, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddParameterInOperation4() {
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource facetSetResource = rSet.getResource(URI.createPlatformResourceURI((String)"test", (boolean)true), true);
        facetSetResource.getContents().add((Object)parameter);
        IFacetAction.INSTANCE.addParameterInOperation(facetOperation, null, null);
    }

    @Test
    public void testAddParameterInOperation5() throws CoreException, IOException {
        this.initResource();
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        IFacetAction.INSTANCE.addOperationInFacet(this.facet, facetOperation, (EditingDomain)this.editingDomain);
        Assert.assertTrue((boolean)(this.facet.getFacetElements().get(0) instanceof FacetOperation));
        FacetOperation resultFacetOperation = (FacetOperation)this.facet.getFacetElements().get(0);
        Assert.assertNotNull((Object)resultFacetOperation);
        Assert.assertTrue((resultFacetOperation == facetOperation ? 1 : 0) != 0);
        EParameter parameter = EcoreFactory.eINSTANCE.createEParameter();
        IFacetAction.INSTANCE.addParameterInOperation(resultFacetOperation, parameter, (EditingDomain)this.editingDomain);
        Assert.assertTrue((!resultFacetOperation.getEParameters().isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((EParameter)resultFacetOperation.getEParameters().get(0)).equals(parameter));
    }
}

