/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.facet.query.java.ui.internal.wizard.page;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.facet.efacet.FacetSet;
import org.eclipse.jface.wizard.IWizardPage;

public interface IQueryAttributesWizardPage extends IWizardPage {

	// This interface has been copied from
	// org.eclipse.emf.facet.infra.query.ui.extensions.IQueryAttributesWizardPage

	/**
	 * Initialize the wizard page
	 *
	 * @param facetSet
	 *            an existing facet set, in which the query will be added
	 * @param facetName
	 *            the name of the facet being managed
	 * @param eType
	 *            the eType of the facet
	 */
	void init(FacetSet facetSet, String facetName, EClassifier eType);

	/**
	 * Called when the wizard is finished to apply the attributes defined in the wizard page to create the corresponding
	 * Java class.
	 *
	 * @param returnType
	 *            the query's return type
	 * @param upperBound
	 *            the query's upper bound
	 * @param scope
	 *            the query's scope
	 */
	void apply(final EClassifier returnType, final int upperBound, final EClassifier scope);
}
